/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice.mq;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.ORM;
import kd.bos.util.ExceptionUtils;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeBufferPoolManager;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeManager;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeMsgInfo;
import kd.fi.cal.business.calculate.out.calintime.CalInTimeMutexManager;
import kd.fi.cal.business.calculate.out.calintime.CalLogManager;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.CalLogTypeEnum;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class CalInTimeConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(CalInTimeConsumer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object paramObject, String paramString, boolean paramBoolean, MessageAcker paramMessageAcker) {
        CalLogManager logManager = new CalLogManager();
        CalInTimeMsgInfo msg = (CalInTimeMsgInfo)paramObject;
        logger.info("\u5b9a\u65f6\u6838\u7b97\u63a5\u6536\u5230\u6d88\u606f\uff1a" + msg.getTraceId());
        Set matIds = msg.getMatIds();
        try (TXHandle t = TX.requiresNew();){
            try {
                CalInTimeBufferPoolManager manager = new CalInTimeBufferPoolManager();
                manager.clearCalInTimes(msg.getClearErrorMatIds());
                boolean isExistRevData = manager.isExistRevData(matIds);
                manager.setFilterTimes(!isExistRevData);
                DataSet bufferDs = manager.getOrderBufferDs(matIds);
                this.doCalculate(bufferDs, msg, logManager);
                logManager.info("", (Object)msg, CalLogTypeEnum.CAL_INTIME_CAL.getValue());
            }
            catch (Throwable e) {
                t.markRollback();
                logger.error("\u5b9a\u65f6\u5373\u65f6\u6838\u7b97\u5931\u8d25" + matIds, e);
                String info = ExceptionUtils.getExceptionStackTraceMessage((Exception)new Exception(e));
                logManager.error(info, (Object)msg, CalLogTypeEnum.CAL_INTIME_CAL.getValue());
            }
        }
        finally {
            CalInTimeMutexManager manager = new CalInTimeMutexManager();
            manager.deleteMutex(matIds);
            paramMessageAcker.ack(paramString);
        }
    }

    private void doCalculate(DataSet bufferDs, CalInTimeMsgInfo msg, CalLogManager logManager) {
        Object bufferDycs = ORM.create().toPlainDynamicObjectCollection(bufferDs);
        CalInTimeBufferPoolManager bufferPoolManager = new CalInTimeBufferPoolManager();
        Map noCalEidBillIdMap = bufferPoolManager.markCancel((List)bufferDycs);
        this.removeOverTimesBufferDycs((List<DynamicObject>)bufferDycs, noCalEidBillIdMap);
        bufferDycs = bufferDycs.subList(0, (int)Math.ceil((double)(bufferDycs.size() * msg.getPercent()) / 100.0));
        String preAcctType = null;
        String preEntity = null;
        HashSet<Long> curMatIds = new HashSet<Long>(16);
        HashSet<Long> ids = new HashSet<Long>(16);
        HashSet<Long> entryIdSet = new HashSet<Long>(16);
        HashSet<Long> srcGroupIds = new HashSet<Long>(16);
        HashSet allErrorMatIds = new HashSet(16);
        boolean matTrans = msg.isMatTrans();
        this.doCalculateNoCalBill(noCalEidBillIdMap, msg.getMatIds(), matTrans, logManager);
        HashMap<Long, Long> eIdGroupIdMap = new HashMap<Long, Long>(16);
        HashSet errorGroupId = new HashSet(16);
        Iterator iterator = bufferDycs.iterator();
        while (iterator.hasNext()) {
            long materialId;
            boolean isGroupTypeDiff;
            DynamicObject row = (DynamicObject)iterator.next();
            String accountType = row.getString("accounttype");
            String entity = row.getString("entity");
            Long groupId = row.getLong("groupid");
            boolean groupIdNotEmpty = groupId != null && !groupId.equals(0L);
            boolean isSrcBill = "0".equals(row.getString("grouptype"));
            boolean isAcctTypeDiff = preAcctType != null && !accountType.equals(preAcctType);
            boolean isEntityDiff = preEntity != null && !entity.equals(preEntity);
            boolean bl = isGroupTypeDiff = groupIdNotEmpty && srcGroupIds.contains(groupId) && !isSrcBill;
            if (groupIdNotEmpty) {
                eIdGroupIdMap.put(row.getLong("entryid"), groupId);
            }
            preAcctType = accountType;
            preEntity = entity;
            if (isAcctTypeDiff || isEntityDiff || isGroupTypeDiff) {
                CalInTimeManager manager = new CalInTimeManager(curMatIds, matTrans);
                manager.setIds(ids);
                manager.setEntryIds(entryIdSet);
                manager.setLogManager(logManager);
                manager.setNoCalEidBillIdMap(noCalEidBillIdMap);
                logManager.appenInfo((Object)String.format("isAcctTypeDiff=%s,isEntityDiff=%s,isGroupTypeDiff=%s", isAcctTypeDiff, isEntityDiff, isGroupTypeDiff));
                logManager.appenInfo((Object)String.format("ids(%s),eids(%s)", ids.size(), entryIdSet.size()));
                manager.calculate();
                Set errorMatIds = manager.getAllErrorMatIds();
                allErrorMatIds.addAll(errorMatIds);
                for (Long allErroEid : manager.getAllErroEids()) {
                    errorGroupId.add(eIdGroupIdMap.get(allErroEid));
                }
                if (matTrans && allErrorMatIds.size() > 0) {
                    logManager.appenInfo((Object)"matTrans && allErrorMatIds.size() > 0");
                    return;
                }
                curMatIds = new HashSet(16);
                ids.clear();
                entryIdSet = new HashSet(16);
                preAcctType = null;
                preEntity = null;
                srcGroupIds.clear();
            }
            if (allErrorMatIds.contains(materialId = row.getLong("material")) || errorGroupId.contains(groupId)) continue;
            curMatIds.add(materialId);
            ids.add(row.getLong("billid"));
            entryIdSet.add(row.getLong("entryid"));
            if (!groupIdNotEmpty || !isSrcBill) continue;
            srcGroupIds.add(groupId);
        }
        if (ids.size() > 0) {
            CalInTimeManager manager = new CalInTimeManager(curMatIds, matTrans);
            manager.setIds(ids);
            manager.setEntryIds(entryIdSet);
            manager.setLogManager(logManager);
            manager.setNoCalEidBillIdMap(noCalEidBillIdMap);
            logManager.appenInfo((Object)String.format("ids(%s),eids(%s)", ids.size(), entryIdSet.size()));
            manager.calculate();
        }
    }

    private void doCalculateNoCalBill(Map<Long, Long> noCalEidBillIdMap, Set<Long> curMatIds, boolean matTrans, CalLogManager logManager) {
        if (noCalEidBillIdMap.isEmpty()) {
            return;
        }
        CalInTimeManager notCalManager = new CalInTimeManager(curMatIds, matTrans);
        notCalManager.setIds(new HashSet<Long>(noCalEidBillIdMap.values()));
        notCalManager.setEntryIds(noCalEidBillIdMap.keySet());
        notCalManager.setLogManager(logManager);
        notCalManager.calculate();
        logManager.appenInfo((Object)String.format("doCalculateNoCalBill:%s", noCalEidBillIdMap));
    }

    private void removeOverTimesBufferDycs(List<DynamicObject> bufferDycs, Map<Long, Long> noCalEidBillIdMap) {
        Integer calInTimes = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.CALINTIME_NOCALTIMES);
        Iterator<DynamicObject> bufferIter = bufferDycs.iterator();
        while (bufferIter.hasNext()) {
            int calTimes;
            DynamicObject bufferDyc = bufferIter.next();
            if (noCalEidBillIdMap.containsKey(bufferDyc.getLong("entryid")) || (calTimes = bufferDyc.getInt("caltimes")) < calInTimes) continue;
            bufferIter.remove();
        }
    }
}

