/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice.mq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.mservice.mq.AbstractMqStrategy;

public class HashMqStrategy
extends AbstractMqStrategy {
    private Map<String, List<DynamicObject>> queueNameBizBillDycsMap = new HashMap<String, List<DynamicObject>>(16);
    private Boolean randomOrg = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.PROCESS_MQ_RANDOM);

    @Override
    public void execute() {
        for (Map.Entry<String, List<DynamicObject>> queueNameBizBillDycEntry : this.queueNameBizBillDycsMap.entrySet()) {
            List<DynamicObject> bizBillDycs = queueNameBizBillDycEntry.getValue();
            if (bizBillDycs.isEmpty()) continue;
            this.publish(queueNameBizBillDycEntry.getKey(), bizBillDycs.toArray(new DynamicObject[0]));
        }
    }

    @Override
    public boolean isExecuteStrategy(DynamicObject bizBillDyc) {
        if (bizBillDyc == null) {
            return false;
        }
        int hashCode = 0;
        if (this.randomOrg.booleanValue()) {
            hashCode = this.hashCode();
        } else {
            Long orgId = this.getOrgId(bizBillDyc);
            if (orgId == null || orgId.equals(0L)) {
                return false;
            }
            hashCode = orgId.hashCode();
        }
        HashSet<String> appointMqSuffixes = new HashSet<String>(this.getKeyOrgMqOffsetValueMap().values());
        int freeMqCount = this.getProcessMqCount() - appointMqSuffixes.size();
        int processMqSuffix = Math.abs(hashCode % freeMqCount);
        String queueName = this.getQueueBySuffix(processMqSuffix);
        List bizBillDycs = this.queueNameBizBillDycsMap.computeIfAbsent(queueName, k -> new ArrayList(16));
        bizBillDycs.add(bizBillDyc);
        return true;
    }
}

