/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice.mq;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.CalBillRuleHelper;
import kd.fi.cal.common.model.CalBillRule;

public class MqSplitInfoHelper {
    private final String actionName;
    private final DynamicObject[] billArr;

    public MqSplitInfoHelper(String actionName, DynamicObject[] billArr) {
        this.actionName = actionName;
        this.billArr = billArr;
    }

    public Map<Long, Long> getDycIdOwnerIdMap() {
        HashMap<Long, Long> dycIdOwnerIdMap = new HashMap<Long, Long>(16);
        if (this.billArr == null || this.billArr.length < 1) {
            return dycIdOwnerIdMap;
        }
        HashSet<Long> billIds = new HashSet<Long>(16);
        for (DynamicObject billDyc : this.billArr) {
            long billId = billDyc.getLong("id");
            billIds.add(billId);
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)this.billArr[0].getDataEntityType().getName());
        String billEntity = entityType.getName();
        this.dealAudit(dycIdOwnerIdMap, billIds, billEntity);
        this.dealAuAudit(dycIdOwnerIdMap, billIds, billEntity);
        this.dealWf(dycIdOwnerIdMap);
        this.dealMatWf(dycIdOwnerIdMap);
        this.dealReEst(dycIdOwnerIdMap);
        return dycIdOwnerIdMap;
    }

    private void dealReEst(Map<Long, Long> dycIdOwnerIdMap) {
        if (ActionEnum.REESTIMATE.getValue().equals(this.actionName)) {
            for (DynamicObject billDyc : this.billArr) {
                long billId = billDyc.getLong("id");
                Long orgId = this.getBaseId(billDyc, "org");
                dycIdOwnerIdMap.put(billId, orgId);
            }
        }
    }

    private void dealMatWf(Map<Long, Long> dycIdOwnerIdMap) {
        if (ActionEnum.MATERIALWRITEOFF.getValue().equals(this.actionName)) {
            HashMap<String, Map> entityWfIdBillIdMap = new HashMap<String, Map>(16);
            for (DynamicObject bizBill : this.billArr) {
                HashSet<Long> billIdSet = new HashSet<Long>(16);
                long matWfId = bizBill.getLong("id");
                DynamicObjectCollection entryDycs = bizBill.getDynamicObjectCollection("entry");
                for (DynamicObject recordEntry : entryDycs) {
                    boolean isOmInEntity;
                    billIdSet.add(recordEntry.getLong("billid"));
                    String entity = recordEntry.getString("billtype_id");
                    boolean bl = isOmInEntity = "im_mdc_ominbill".equals(entity) || "im_ospurinbill".equals(entity);
                    if (!isOmInEntity) continue;
                    Map wfIdBillIdMap = entityWfIdBillIdMap.computeIfAbsent(entity, k -> new HashMap(16));
                    wfIdBillIdMap.put(matWfId, recordEntry.getLong("billid"));
                }
            }
            for (Map.Entry entry : entityWfIdBillIdMap.entrySet()) {
                String entity = (String)entry.getKey();
                Map wfIdBillIdMap = (Map)entry.getValue();
                Collection omInBillIds = wfIdBillIdMap.values();
                Map<Long, Long> omInBillIdOwnerIdMap = this.getBizBillIdOwnerIdMapByCalRule(new HashSet<Long>(omInBillIds), entity);
                for (Map.Entry wfIdBillIdEnt : wfIdBillIdMap.entrySet()) {
                    Long wfId = (Long)wfIdBillIdEnt.getKey();
                    Long billId = (Long)wfIdBillIdEnt.getValue();
                    Long ownerId = omInBillIdOwnerIdMap.get(billId);
                    if (ownerId == null || ownerId.equals(0L)) continue;
                    dycIdOwnerIdMap.put(wfId, ownerId);
                }
            }
        }
    }

    private void dealWf(Map<Long, Long> dycIdOwnerIdMap) {
        boolean isWF;
        boolean purWf = this.actionName.equals(ActionEnum.PUR_WRITEOFF.getValue());
        boolean salWf = this.actionName.equals(ActionEnum.SALE_WRITEOFF.getValue());
        boolean bl = isWF = purWf || salWf;
        if (isWF) {
            HashMap<Long, Long> wfIdMainBillIdMap = new HashMap<Long, Long>(16);
            String wfMainBillEntity = "im_purinbill";
            HashSet<Long> mainBillIds = new HashSet<Long>(16);
            for (DynamicObject billDyc : this.billArr) {
                long wfId = billDyc.getLong("id");
                long mainBillId = billDyc.getLong("billid");
                wfIdMainBillIdMap.put(wfId, mainBillId);
                wfMainBillEntity = billDyc.getString("billtype");
                mainBillIds.add(mainBillId);
            }
            Map<Long, Long> mainBillIdOwnerIdMap = this.getBizBillIdOwnerIdMapByCalRule(mainBillIds, wfMainBillEntity);
            for (Map.Entry ent : wfIdMainBillIdMap.entrySet()) {
                Long wfId = (Long)ent.getKey();
                Long mainBillId = (Long)ent.getValue();
                Long ownerId = mainBillIdOwnerIdMap.get(mainBillId);
                if (ownerId == null || ownerId.equals(0L)) continue;
                dycIdOwnerIdMap.put(wfId, ownerId);
            }
        }
    }

    private void dealAuAudit(Map<Long, Long> dycIdOwnerIdMap, Set<Long> billIds, String billEntity) {
        boolean isUnAudit = ActionEnum.UN_AUDIT.getValue().equals(this.actionName);
        if (isUnAudit) {
            Map<Long, Long> bizBillIdOwnerIdMap = this.getBizBillIdOwnerIdMapByCalRule(billIds, billEntity);
            dycIdOwnerIdMap.putAll(bizBillIdOwnerIdMap);
            Map<Long, Long> recBizBillIdOwnerIdMap = this.getBizBillIdOwnerIdMapByCostRec(billIds);
            dycIdOwnerIdMap.putAll(recBizBillIdOwnerIdMap);
        }
    }

    private void dealAudit(Map<Long, Long> dycIdOwnerIdMap, Set<Long> billIds, String billEntity) {
        boolean isAudit = ActionEnum.AUDIT.getValue().equals(this.actionName);
        if (isAudit) {
            Map<Long, Long> bizBillIdOwnerIdMap = this.getBizBillIdOwnerIdMapByCalRule(billIds, billEntity);
            dycIdOwnerIdMap.putAll(bizBillIdOwnerIdMap);
        }
    }

    private Map<Long, Long> getBizBillIdOwnerIdMapByCostRec(Set<Long> billIds) {
        HashMap<Long, Long> dycIdOwnerIdMap = new HashMap<Long, Long>(16);
        String sels = "case when calbilltype='IN' then 1 else 2 end as type,bizbillid as id,entry.owner as owner";
        QFilter bizBillIdF = new QFilter("bizbillid", "in", billIds);
        DataSet costRecDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)sels, (QFilter[])bizBillIdF.toArray(), null).orderBy(new String[]{"type"});
        for (Row row : costRecDs) {
            Long ownerId = row.getLong("owner");
            Long billId = row.getLong("id");
            dycIdOwnerIdMap.put(billId, ownerId);
        }
        return dycIdOwnerIdMap;
    }

    private Map<Long, Long> getBizBillIdOwnerIdMapByCalRule(Set<Long> billIds, String entity) {
        HashMap<Long, Long> dycIdOwnerIdMap = new HashMap<Long, Long>(16);
        CalBillRuleHelper calBillRuleHelper = new CalBillRuleHelper();
        calBillRuleHelper.loadRulesByBills(new HashSet<String>(Collections.singletonList(entity)));
        Map inCalBillRuleMap = calBillRuleHelper.getInCalBillRuleMap();
        List inCalBillRules = (List)inCalBillRuleMap.get(entity);
        inCalBillRules = inCalBillRules == null ? new ArrayList(0) : inCalBillRules;
        Map outCalBillRuleMap = calBillRuleHelper.getOutCalBillRuleMap();
        List outCalBillRules = (List)outCalBillRuleMap.get(entity);
        outCalBillRules = outCalBillRules == null ? new ArrayList(0) : outCalBillRules;
        QFilter billIdsF = new QFilter("id", "in", billIds);
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(16);
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("type", (DataType)DataType.IntegerType), new Field("id", (DataType)DataType.LongType), new Field("owner", (DataType)DataType.LongType)});
        String inSelFormat = "1 as type,id, %s as owner";
        for (Object inCalBillRule : inCalBillRules) {
            List inBizFilters = inCalBillRule.getBillFilters();
            inBizFilters.add(billIdsF);
            Map inBillFielsMap = inCalBillRule.getCalBizFieldMap();
            if (inBillFielsMap == null) continue;
            String ownerField = (String)inBillFielsMap.get("owner");
            String selectFields = String.format(inSelFormat, ownerField);
            OrmInput inOI = new OrmInput(this.getClass().getName(), entity, selectFields, inBizFilters.toArray(new QFilter[0]), rowMeta);
            inputs.add(inOI);
        }
        String outSelFormat = "2 as type,id, %s as owner";
        for (CalBillRule outCalBillRule : outCalBillRules) {
            List outBizFilters = outCalBillRule.getBillFilters();
            outBizFilters.add(billIdsF);
            Map outBillFielsMap = outCalBillRule.getCalBizFieldMap();
            if (outBillFielsMap == null) continue;
            String ownerField = (String)outBillFielsMap.get("owner");
            String selectFields = String.format(outSelFormat, ownerField);
            OrmInput outOI = new OrmInput(this.getClass().getName(), entity, selectFields, outBizFilters.toArray(new QFilter[0]), rowMeta);
            inputs.add(outOI);
        }
        if (inputs.size() > 0) {
            try (DataSet unionDataSet = Algo.create((String)this.getClass().getName()).createDataSet((Input[])inputs.toArray(new OrmInput[inputs.size()])).orderBy(new String[]{"type"});){
                for (Row row : unionDataSet) {
                    Long ownerId = row.getLong("owner");
                    if (ownerId == null || ownerId.equals(0L)) continue;
                    Long billId = row.getLong("id");
                    dycIdOwnerIdMap.put(billId, ownerId);
                }
            }
        }
        return dycIdOwnerIdMap;
    }

    private Long getBaseId(DynamicObject info, String baseIdKey) {
        Long baseId = info.getLong(baseIdKey + "_id");
        Object baseIdObj = info.get(baseIdKey);
        if (baseIdObj instanceof Long && !baseIdObj.equals(0L)) {
            baseId = (Long)baseIdObj;
        }
        return baseId;
    }
}

