/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice.mq;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;

public class OpenMulFactoryMsgConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(OpenMulFactoryMsgConsumer.class);
    private static final String UPDATE_SQL = "update t_cal_costtypeorg set finvaliddate=? where fcostaccountid=? and fcalorgid=? and feffectdate=? and finvaliddate=? and fstorageorgunitid=?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object paramObject, String paramString, boolean paramBoolean, MessageAcker paramMessageAcker) {
        logger.info("OpenMulFactoryMsgConsumer-\u5f00\u59cb\u6d88\u8d39\u6d88\u606f");
        try {
            Map paramMap = (Map)paramObject;
            if (null == paramMap) {
                return;
            }
            Object orgId = paramMap.get("orgId");
            if (null == orgId) {
                return;
            }
            Object data = paramMap.get("data");
            if (null == data) {
                return;
            }
            Map dataMap = (Map)JSONObject.parseObject((String)String.valueOf(data), Map.class);
            if (null == dataMap || !dataMap.containsKey("multifactoryaccount")) {
                return;
            }
            boolean multifactoryaccount = (Boolean)dataMap.get("multifactoryaccount");
            if (multifactoryaccount) {
                QFilter costAccountFilter = new QFilter("calorg", "=", orgId);
                DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,calorg,costtype", (QFilter[])costAccountFilter.toArray());
                boolean errorFlag = false;
                for (DynamicObject dynamicObject : costAccounts) {
                    List orgList;
                    Long calorgid = dynamicObject.getLong("calorg");
                    boolean storageorgflag = OrgUnitServiceHelper.checkOrgFunction((Long)calorgid, (String)"05");
                    if (storageorgflag || null != (orgList = OrgHelper.getStorageOrgUnitByCalOrg((Long)calorgid)) && orgList.size() != 0) continue;
                    DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)calorgid, (String)"bos_org");
                    String name = null;
                    if (org != null) {
                        name = org.getString("name");
                    }
                    String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6838\u7b97\u7ec4\u7ec7\u201c\u591a\u5de5\u5382\u6838\u7b97\u201d\u4fee\u6539\u5931\u8d25\uff0c\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"CalCosttypeOrgRelationSynMultifactoryOp_0", (String)"fi-cal-mservice", (Object[])new Object[0]), name);
                    WriteLogHelper.writeInfoLog((Log)logger, (String)("OpenMulFactoryMsgConsumer\uff1a" + msg), (Object[])new Object[0]);
                    errorFlag = true;
                }
                if (errorFlag) {
                    return;
                }
                ArrayList<Object[]> updateList = new ArrayList<Object[]>(16);
                ArrayList<DynamicObject> insertList = new ArrayList<DynamicObject>(16);
                Date nowTime = TimeServiceHelper.now();
                for (DynamicObject dynamicObject : costAccounts) {
                    Long costaccountId = dynamicObject.getLong("id");
                    Long calorgid = dynamicObject.getLong("calorg");
                    QFilter filter = new QFilter("costaccount", "=", (Object)costaccountId);
                    filter.and("calorg", "=", (Object)calorgid);
                    DynamicObject[] infos = BusinessDataServiceHelper.load((String)"cal_bd_costtypeorg", (String)"costtype", (QFilter[])filter.toArray());
                    if (null == infos || infos.length == 0) continue;
                    updateList.add(new Object[]{nowTime, costaccountId, calorgid, DateUtils.getDateByInt((int)2000, (int)0, (int)1, (int)0, (int)0, (int)0), DateUtils.getDateByInt((int)2999, (int)11, (int)31, (int)23, (int)59, (int)59), 0L});
                    List orgList = OrgHelper.getStorageOrgUnitByCalOrg((Long)calorgid);
                    for (Long storageorgid : orgList) {
                        QFilter qFilter = new QFilter("costaccount", "=", (Object)costaccountId);
                        qFilter.and("calorg", "=", (Object)calorgid);
                        qFilter.and("storageorgunit", "=", (Object)storageorgid);
                        DynamicObject[] reInfo = BusinessDataServiceHelper.load((String)"cal_bd_costtypeorg", (String)"id", (QFilter[])qFilter.toArray());
                        if (reInfo != null && reInfo.length > 0) continue;
                        DynamicObject info = BusinessDataServiceHelper.newDynamicObject((String)"cal_bd_costtypeorg");
                        info.set("costaccount", (Object)costaccountId);
                        info.set("calorg", (Object)calorgid);
                        info.set("storageorgunit", (Object)storageorgid);
                        info.set("costtype", infos[0].getDynamicObject("costtype").getPkValue());
                        info.set("bizstatus", (Object)"1");
                        info.set("confirmdate", (Object)nowTime);
                        info.set("effectdate", (Object)DateUtils.getDateByInt((int)2000, (int)0, (int)1, (int)0, (int)0, (int)0));
                        info.set("invaliddate", (Object)DateUtils.getDateByInt((int)2999, (int)11, (int)31, (int)23, (int)59, (int)59));
                        insertList.add(info);
                    }
                }
                if (updateList.size() > 0) {
                    DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)UPDATE_SQL, updateList);
                }
                if (insertList.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])insertList.toArray(new DynamicObject[insertList.size()]));
                }
            }
        }
        catch (Exception e) {
            logger.error("OpenMulFactoryMsgConsumer\uff1a" + CommonUtils.getLogMessage((Throwable)e, (int)1000));
        }
        finally {
            paramMessageAcker.ack(paramString);
        }
    }
}

