/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice.mq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.mservice.mq.AbstractMqStrategy;
import kd.fi.cal.mservice.mq.AppointMqStrategy;
import kd.fi.cal.mservice.mq.DefaultMqStrategy;
import kd.fi.cal.mservice.mq.HashMqStrategy;
import kd.fi.cal.mservice.mq.IMqPublisherStrategy;
import kd.fi.cal.mservice.mq.MqSplitInfoHelper;
import kd.fi.cal.mservice.mq.SalWfMqStrategy;

public class PublishMqContext {
    private final String actionName;
    private final Map params;
    private final DynamicObject[] billArr;
    private final String serviceType;
    private List<IMqPublisherStrategy> mqPublisherStrategies = new ArrayList<IMqPublisherStrategy>(16);
    private Map<Long, Long> dycIdSplitOwnerIdMap = new HashMap<Long, Long>(16);

    public PublishMqContext(String actionName, Map params, DynamicObject[] billArr, String serviceType) {
        Boolean mqSplit = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.PROCESS_MQ_SPLIT);
        String mqSplitField = CalDbParamServiceHelper.getString((String)CalDbParamConstant.PROCESS_MQ_SPLIT_FIELD, null);
        Boolean splitSalWf = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.PROCESS_MQ_SPLIT_SALWF);
        boolean isSalWf = ActionEnum.SALE_WRITEOFF.getValue().equals(actionName);
        if (splitSalWf.booleanValue() && isSalWf) {
            this.mqPublisherStrategies.add(new SalWfMqStrategy());
        }
        if (mqSplit.booleanValue()) {
            this.mqPublisherStrategies.add(new AppointMqStrategy());
            this.mqPublisherStrategies.add(new HashMqStrategy());
            if (!"org".equals(mqSplitField)) {
                this.dycIdSplitOwnerIdMap = new MqSplitInfoHelper(actionName, billArr).getDycIdOwnerIdMap();
            }
        }
        this.mqPublisherStrategies.add(new DefaultMqStrategy());
        this.actionName = actionName;
        this.params = params;
        this.billArr = billArr;
        this.serviceType = serviceType;
    }

    public void publish() {
        DynamicObject[] bizBillDycs = this.billArr;
        MainEntityType entityType = null;
        if (bizBillDycs != null && bizBillDycs.length > 0) {
            entityType = MetadataServiceHelper.getDataEntityType((String)bizBillDycs[0].getDataEntityType().getName());
        }
        for (IMqPublisherStrategy mqPublisherStrategy : this.mqPublisherStrategies) {
            AbstractMqStrategy curStrategy = (AbstractMqStrategy)mqPublisherStrategy;
            curStrategy.setActionName(this.actionName);
            curStrategy.setParams(this.params);
            curStrategy.setServiceType(this.serviceType);
            curStrategy.setEntityType(entityType);
            curStrategy.setDycIdSplitOwnerIdMap(this.dycIdSplitOwnerIdMap);
            mqPublisherStrategy.collectData(bizBillDycs);
            mqPublisherStrategy.execute();
            bizBillDycs = mqPublisherStrategy.getNextMqStrategyBizBillDycs();
            if (mqPublisherStrategy.isHasNextStrategyBizBillDyc()) continue;
            break;
        }
    }
}

