/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice.mq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.mservice.mq.AbstractMqStrategy;

public class SalWfMqStrategy
extends AbstractMqStrategy {
    private static final int MAX_MQ_COUNT = 20;
    private static final int LIMIT_COUNT = 5;
    private Map<String, List<DynamicObject>> queueNameBizBillDycsMap = new HashMap<String, List<DynamicObject>>(16);

    @Override
    public void execute() {
        for (Map.Entry<String, List<DynamicObject>> queueNameBizBillDycEntry : this.queueNameBizBillDycsMap.entrySet()) {
            List<DynamicObject> bizBillDycs = queueNameBizBillDycEntry.getValue();
            if (bizBillDycs.isEmpty()) continue;
            this.publish(queueNameBizBillDycEntry.getKey(), bizBillDycs.toArray(new DynamicObject[0]));
        }
    }

    @Override
    public boolean isExecuteStrategy(DynamicObject bizBillDyc) {
        int freeMqCount = 20 - this.getProcessMqCount();
        String actionName = this.getActionName();
        boolean isSalWf = ActionEnum.SALE_WRITEOFF.getValue().equals(actionName);
        if (freeMqCount <= 0 || !isSalWf) {
            return false;
        }
        freeMqCount = freeMqCount > 5 ? 5 : freeMqCount;
        int hashCode = this.hashCode();
        int wfMqSuffix = Math.abs(hashCode % freeMqCount) + this.getProcessMqCount();
        String queueName = this.getQueueBySuffix(wfMqSuffix);
        List bizBillDycs = this.queueNameBizBillDycsMap.computeIfAbsent(queueName, k -> new ArrayList(16));
        bizBillDycs.add(bizBillDyc);
        return true;
    }
}

