/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice.mq;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.fi.cal.business.service.CalProcessHandle;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DynamicObjectUtils;
import kd.fi.cal.mservice.mq.ServiceMessageInfo;

public class ServiceMsgConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(ServiceMsgConsumer.class);
    private static final String DLOCK_KEY = "fi-cal-billsynclock";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object paramObject, String paramString, boolean paramBoolean, MessageAcker paramMessageAcker) {
        long startTime = System.currentTimeMillis();
        logger.info("ServiceMsgConsumer-\u5f00\u59cb\u6d88\u8d39\u6d88\u606f");
        ServiceMessageInfo msgInfo = (ServiceMessageInfo)paramObject;
        String actionName = msgInfo.getActionName();
        logger.info("ServiceMsgConsumer-actionName\u4e3a\uff1a" + actionName);
        DynamicObject[] bizBills = msgInfo.getBizBills();
        HashMap<String, Integer> params = msgInfo.getParams();
        bizBills = this.repalceBizBillDycs(bizBills, params);
        try {
            CalProcessHandle handle = new CalProcessHandle(actionName, (Map)params, bizBills);
            handle.handle();
        }
        catch (Throwable e) {
            if (e instanceof KDBizException) {
                return;
            }
            logger.error("ServiceMsgConsumer-\u6d88\u8d39\u6d88\u606f\u65f6\u7cfb\u7edf\u62a5\u9519\uff1a" + CommonUtils.getLogMessage((Throwable)e, (int)1000));
            int errorTimes = 0;
            String errorTimesKey = "errorTimes";
            if (params == null) {
                params = new HashMap<String, Integer>(16);
            }
            if (params.get(errorTimesKey) != null) {
                errorTimes = (Integer)params.get(errorTimesKey);
            }
            params.put(errorTimesKey, ++errorTimes);
            if (errorTimes <= 5) {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{actionName, params, bizBills});
            }
        }
        finally {
            logger.info("ServiceMsgConsumer-\u7ed3\u675f\u6d88\u8d39\u6d88\u606f,\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
            paramMessageAcker.ack(paramString);
        }
    }

    public String getRouteKey() {
        return "cal";
    }

    private DynamicObject[] repalceBizBillDycs(DynamicObject[] bizBills, Map params) {
        if (bizBills == null || bizBills.length == 0) {
            return bizBills;
        }
        String billsString = (String)params.get("bills");
        ArrayList<DynamicObject> newBizDycs = new ArrayList<DynamicObject>(16);
        DynamicObjectType entityType = bizBills[0].getDynamicObjectType();
        if (params.containsKey("dyctomap")) {
            String wfRecordFields = "id,billid,verifyseq,billentryid,billtype,billno,verifyqty,billstatus,createtime,auditor,modifytime,auditdate,org,e_billid,e_billentryid,e_billno,e_billtype";
            HashSet<String> noEntryFieldKeys = new HashSet<String>(Arrays.asList(wfRecordFields.split(",")));
            List billFieldValueMaps = (List)SerializationUtils.fromJsonString((String)billsString, List.class);
            DynamicObject[] billDycs = DynamicObjectUtils.mapsToDycs((List)billFieldValueMaps, (String)entityType.getName(), noEntryFieldKeys, (String[])new String[]{"entry"});
            newBizDycs.addAll(Arrays.asList(billDycs));
        } else if (params != null && bizBills != null && bizBills.length > 0 && billsString != null) {
            Object[] bills = DynamicObjectSerializeUtil.deserialize((String)billsString, (DynamicObjectType)entityType);
            for (int i = 0; i < bills.length; ++i) {
                DynamicObject bill = (DynamicObject)bills[i];
                newBizDycs.add(bill);
            }
        }
        bizBills = newBizDycs.toArray(new DynamicObject[0]);
        params.remove("bills");
        return bizBills;
    }
}

