/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice.mq;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.SyncSimpleDycHelper;
import kd.fi.cal.common.util.DynamicObjectUtils;
import kd.fi.cal.mservice.mq.ServiceMessageInfo;

public class ServiceMsgPublisher {
    private static final Log logger = LogFactory.getLog(ServiceMsgPublisher.class);

    public void publish(String queueName, Object o) {
        ServiceMessageInfo msg = (ServiceMessageInfo)o;
        String actionName = msg.getActionName();
        boolean submitOrUnSubmit = ActionEnum.SUBMIT.getValue().equals(actionName) || ActionEnum.UN_SUBMIT.getValue().equals(actionName);
        String billno = "no_bill";
        if (msg.getBizBills() != null && msg.getBizBills().length > 0) {
            billno = ActionEnum.MATERIALWRITEOFF.getValue().equals(actionName) ? msg.getBizBills()[0].getString("wfnumber") : msg.getBizBills()[0].getString("billno");
            DynamicObjectType type = msg.getBizBills()[0].getDynamicObjectType();
            if ("im_initbill".equals(type.getName()) && submitOrUnSubmit) {
                return;
            }
            DynamicObject[] billArr = msg.getBizBills();
            if (ActionEnum.AUDIT.getValue().equals(actionName) || ActionEnum.UN_AUDIT.getValue().equals(actionName) || ActionEnum.SUBMIT.getValue().equals(actionName) || ActionEnum.UN_SUBMIT.getValue().equals(actionName) || ActionEnum.RESYNC.getValue().equals(actionName)) {
                billArr = new SyncSimpleDycHelper().parse(billArr);
            } else if (this.isEstimateAdjust(actionName)) {
                billArr = new SyncSimpleDycHelper().parseParseEstimate(billArr);
            } else if (this.isWriteOff(actionName)) {
                billArr = new SyncSimpleDycHelper().parseWriteOffDyc(billArr);
            }
            this.setBillSerStr(msg, actionName, type, billArr);
            msg.setBizBills(billArr);
        }
        logger.info("ServiceMsgPublisher-\u5f00\u59cbpush\u961f\u5217\uff1a" + billno + queueName);
        MessagePublisher pub = MQFactory.get().createSimplePublisher("fi", queueName);
        try {
            pub.publish(o);
        }
        catch (Exception e) {
            logger.info("ServiceMsgPublisher-push\u961f\u5217\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getClass().getName());
            logger.error("ServiceMsgPublisher-push\u961f\u5217\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
        finally {
            logger.info("ServiceMsgPublisher-\u7ed3\u675fpush\u961f\u5217");
            pub.close();
        }
    }

    private void setBillSerStr(ServiceMessageInfo msg, String actionName, DynamicObjectType entityType, DynamicObject[] billArr) {
        if (msg.getParams() == null) {
            HashMap map = new HashMap(16);
            msg.setParams(map);
        }
        String billSerStr = "";
        boolean isWF = this.isWriteOff(actionName);
        if (isWF) {
            String wfRecordFields = "id,billid,verifyseq,billentryid,billtype,billno,verifyqty,billstatus,createtime,auditor,modifytime,auditdate,org,e_billid,e_billentryid,e_billno,e_billtype";
            HashSet<String> noEntryFieldKeys = new HashSet<String>(Arrays.asList(wfRecordFields.split(",")));
            List billFieldValueMaps = DynamicObjectUtils.dycsToMaps((DynamicObject[])billArr, noEntryFieldKeys, (String[])new String[]{"entry"});
            billSerStr = SerializationUtils.toJsonString((Object)billFieldValueMaps);
            msg.getParams().put("dyctomap", "true");
            msg.setBizBills(null);
        } else {
            billSerStr = DynamicObjectSerializeUtil.serialize((Object[])billArr, (DynamicObjectType)entityType);
        }
        msg.getParams().put("bills", billSerStr);
    }

    private boolean isWriteOff(String actionName) {
        boolean purWf = actionName.equals(ActionEnum.PUR_WRITEOFF.getValue());
        boolean salWf = actionName.equals(ActionEnum.SALE_WRITEOFF.getValue());
        boolean isWF = purWf || salWf;
        return isWF;
    }

    private boolean isEstimateAdjust(String actionName) {
        boolean estimateAdjust = actionName.equals(ActionEnum.REESTIMATE.getValue());
        boolean un_estimateAdjust = actionName.equals(ActionEnum.UN_REESTIMATE.getValue());
        return estimateAdjust || un_estimateAdjust;
    }
}

