/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice.mq;

import java.util.Map;
import java.util.Set;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.cal.business.calculate.billgroup.AutoSortServic;
import kd.fi.cal.business.calculate.billgroup.CostDomainGroupHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class SortMsgConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(SortMsgConsumer.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMessage(Object paramObject, String paramString, boolean paramBoolean, MessageAcker paramMessageAcker) {
        try {
            block93: {
                logger.info("SortMsgConsumer-\u5f00\u59cb\u6d88\u8d39\u6d88\u606f");
                Boolean isSort = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.DAILY_SORT);
                if (isSort.booleanValue()) {
                    AutoSortServic sortService = new AutoSortServic();
                    if (paramObject instanceof Map) {
                        Map keyIdsMap = (Map)paramObject;
                        Set acctIds = (Set)keyIdsMap.get("sortacctids");
                        logger.info("\u6309\u8d26\u7c3f\u91cd\u5efa\u6210\u672c\u57df\u548c\u6392\u5e8f\u7ed3\u679c-\u5f00\u59cb\u6d88\u8d39->{}", (Object)acctIds);
                        try (TraceSpan span = Tracer.create((String)"rebuildCostDomainGroupByAcctIds", (String)"rebuildCostDomainGroupByAcctIds");){
                            CostDomainGroupHelper costDomainGroupHelper = new CostDomainGroupHelper();
                            costDomainGroupHelper.rebuildCostDomainGroupByAcctIds(acctIds);
                        }
                        span = Tracer.create((String)"sortByAcctIds", (String)"sortByAcctIds");
                        var10_19 = null;
                        try {
                            sortService.sortByAcctIds(acctIds);
                        }
                        catch (Throwable costDomainGroupHelper) {
                            var10_19 = costDomainGroupHelper;
                            throw costDomainGroupHelper;
                        }
                        finally {
                            if (span != null) {
                                if (var10_19 != null) {
                                    try {
                                        span.close();
                                    }
                                    catch (Throwable costDomainGroupHelper) {
                                        var10_19.addSuppressed(costDomainGroupHelper);
                                    }
                                } else {
                                    span.close();
                                }
                            }
                        }
                        logger.info("\u6309\u8d26\u7c3f\u91cd\u5efa\u6210\u672c\u57df\u548c\u6392\u5e8f\u7ed3\u679c-\u7ed3\u675f\u6d88\u8d39");
                    } else {
                        if (paramObject == null) {
                            try (DLock dlock0 = DLock.create((String)("calRebuildSortConsummer_0" + CacheKeyUtil.getAcctId()), (String)(this.getClass().getName() + "calRebuildSortConsummer"));){
                                if (!dlock0.tryLock()) break block93;
                                try (DLock dlock1 = DLock.create((String)("calRebuildSortConsummer_1" + CacheKeyUtil.getAcctId()), (String)(this.getClass().getName() + "calRebuildSortConsummer"));){
                                    dlock1.lock();
                                    dlock0.unlock();
                                    logger.info("\u5168\u91cf\u91cd\u5efa\u6210\u672c\u57df\u548c\u6392\u5e8f\u7ed3\u679c-\u5f00\u59cb\u6d88\u8d39");
                                    try (TraceSpan span = Tracer.create((String)"rebuildCostDomainGroup-all", (String)"rebuildCostDomainGroup-all");){
                                        new CostDomainGroupHelper().rebuildCostDomainGroup();
                                    }
                                    span = Tracer.create((String)"sort-all", (String)"sort-all");
                                    var12_32 = null;
                                    try {
                                        sortService.sort();
                                    }
                                    catch (Throwable throwable) {
                                        var12_32 = throwable;
                                        throw throwable;
                                    }
                                    finally {
                                        if (span != null) {
                                            if (var12_32 != null) {
                                                try {
                                                    span.close();
                                                }
                                                catch (Throwable throwable) {
                                                    var12_32.addSuppressed(throwable);
                                                }
                                            } else {
                                                span.close();
                                            }
                                        }
                                    }
                                    logger.info("\u5168\u91cf\u91cd\u5efa\u6210\u672c\u57df\u548c\u6392\u5e8f\u7ed3\u679c-\u7ed3\u675f\u6d88\u8d39");
                                    break block93;
                                }
                            }
                        }
                        if (paramObject instanceof Set) {
                            Set sortDmKeys = (Set)paramObject;
                            try (TraceSpan span = Tracer.create((String)"sort-sortDmKeys", (String)"sort-sortDmKeys");){
                                sortService.sort(sortDmKeys);
                            }
                        }
                    }
                }
            }
            paramMessageAcker.ack(paramString);
            return;
        }
        catch (Throwable e) {
            logger.error("SortMsgConsumer onMessage", e);
            paramMessageAcker.deny(paramString);
        }
    }
}

