/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.mservice.writeoff;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.process.ErrorMsg;
import kd.fi.cal.business.service.SyncLockHelper;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.mservice.api.writeoff.CalUnWriteOffCheckService;

public class CalUnWriteOffCheckServiceImpl
implements CalUnWriteOffCheckService {
    private static final Log logger = LogFactory.getLog(CalUnWriteOffCheckServiceImpl.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doCheck(DynamicObject[] writeoffRecords, String action) {
        logger.info("\u6267\u884c\u53cd\u6838\u9500\u6821\u9a8c\u5f00\u59cb:" + action);
        if (writeoffRecords == null) return true;
        if (writeoffRecords.length < 1) {
            return true;
        }
        boolean isPurUnWriteOff = ActionEnum.PUR_UN_WRITEOFF.getValue().equals(action);
        try (SyncLockHelper syncLockHelper = new SyncLockHelper(action, writeoffRecords);){
            syncLockHelper.setNoRetry(true);
            List mutErrors = syncLockHelper.lock();
            StringBuilder sb = new StringBuilder();
            HashSet<String> errMsgs = new HashSet<String>(16);
            for (ErrorMsg err : mutErrors) {
                errMsgs.add(err.getErrorMsg());
            }
            for (String errMsg : errMsgs) {
                sb.append(errMsg);
            }
            if (sb.length() > 0) {
                throw new KDBizException(sb.toString());
            }
            int cSize = writeoffRecords.length;
            HashSet<Long> writeOffIDSet = new HashSet<Long>(cSize);
            HashSet<Long> bizbillIds = new HashSet<Long>(16);
            for (DynamicObject info : writeoffRecords) {
                writeOffIDSet.add(info.getLong("id"));
                bizbillIds.add(info.getLong("billid"));
                DynamicObjectCollection writeEntryColl = info.getDynamicObjectCollection("entry");
                for (DynamicObject writeOffEntry : writeEntryColl) {
                    bizbillIds.add(writeOffEntry.getLong("e_billid"));
                }
            }
            DynamicObject[] costRecords = this.checkMoreReocrd(writeOffIDSet, bizbillIds, isPurUnWriteOff);
            if (costRecords.length == 0) {
                int n = 1;
                return n != 0;
            }
            ArrayList<Long> childIds = new ArrayList<Long>(8);
            ArrayList<Long> childEntryIds = new ArrayList<Long>(1024);
            this.checkUnWriteOff(costRecords, childIds, childEntryIds, bizbillIds);
            this.checkWriteBackRecordB(childIds, bizbillIds);
            logger.info("\u53cd\u6838\u9500\u8c03\u7528\u6838\u7b97\u63a5\u53e3\uff1a\u6210\u672c\u8bb0\u5f55\u5b50\u5355id:" + (childIds.isEmpty() ? "" : (Serializable)childIds.get(0)));
            if (isPurUnWriteOff) {
                this.checkDeleteCostAdjustBill(childIds, CostAdjustBilCreateTypeEnum.PUR_WIRTEOFF.getValue());
                this.checkDeleteCostAdjustBill(childIds, CostAdjustBilCreateTypeEnum.OM_WRITEOFF.getValue());
                return true;
            }
            this.checkDeleteCostAdjustBill(childIds, CostAdjustBilCreateTypeEnum.SALE_WF.getValue());
            return true;
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u53cd\u6838\u9500\u6821\u9a8c\u5931\u8d25\uff1a", (Throwable)e);
            throw e;
        }
    }

    private void checkDeleteCostAdjustBill(ArrayList<Long> childIds, String createType) {
        if (childIds.isEmpty()) {
            return;
        }
        QFilter q = new QFilter("entryentity.invbillid", "in", childIds).and("createtype", "=", (Object)createType);
        HashSet<Long> costaccountids = new HashSet<Long>(16);
        HashSet<Long> billIds = new HashSet<Long>(16);
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"cal_costadjustbill", (String)"id,costaccount,billno,period", (QFilter[])q.toArray());
        if (bills.isEmpty()) {
            return;
        }
        for (DynamicObject bill : bills) {
            Long id = bill.getLong("id");
            costaccountids.add(bill.getLong("costaccount"));
            billIds.add(id);
        }
        if (CostAdjustBilCreateTypeEnum.PUR_WIRTEOFF.getValue().equals(createType)) {
            QFilter outQ = new QFilter("entryentity.srcbillid", "in", billIds).and("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.CAL_OUT_BEFORE_PERIOD.getValue());
            DynamicObjectCollection prebills = QueryServiceHelper.query((String)"cal_costadjustbill", (String)"id,costaccount,billno,period", (QFilter[])outQ.toArray());
            bills.addAll((Collection)prebills);
        }
        Map costaccountPeriodMap = PeriodHelper.getCurrentPeriods(costaccountids);
        HashSet<String> errBillno = new HashSet<String>(16);
        HashMap<Long, String> id2BillnoMap = new HashMap<Long, String>(16);
        for (DynamicObject bill : bills) {
            Long id = bill.getLong("id");
            billIds.add(id);
            Long costaccountid = bill.getLong("costaccount");
            String billno = bill.getString("billno");
            Long period = bill.getLong("period");
            Long currentPeriod = ((DynamicObject)costaccountPeriodMap.get(costaccountid)).getLong("id");
            if (period.compareTo(currentPeriod) < 0) {
                errBillno.add(billno);
            }
            id2BillnoMap.put(id, billno);
        }
        if (!errBillno.isEmpty()) {
            String content;
            String msg = content = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u201c%1$s\u201d\u4e3a\u5f80\u671f\u6570\u636e\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"CalUnWriteOffCheckServiceImpl_0", (String)"fi-cal-mservice", (Object[])new Object[0]), String.join((CharSequence)",", errBillno));
            throw new KDBizException(msg);
        }
        QFilter filter = new QFilter("sourcebillid", "in", billIds);
        DynamicObjectCollection daptrackers = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid", (QFilter[])new QFilter[]{filter});
        HashSet voucherBillnoSet = new HashSet(16);
        if (daptrackers != null && daptrackers.size() > 0) {
            for (DynamicObject info : daptrackers) {
                Long id = info.getLong("sourcebillid");
                voucherBillnoSet.add(id2BillnoMap.get(id));
            }
        }
        if (!voucherBillnoSet.isEmpty()) {
            String content;
            String msg = content = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u201c%1$s\u201d\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\uff0c\u8bf7\u5148\u5220\u9664\u6210\u672c\u8c03\u6574\u5355\u7684\u51ed\u8bc1\u3002", (String)"CalUnWriteOffCheckServiceImpl_1", (String)"fi-cal-mservice", (Object[])new Object[0]), String.join((CharSequence)",", voucherBillnoSet));
            throw new KDBizException(msg);
        }
    }

    private void checkWriteBackRecordB(ArrayList<Long> childIds, Set<Long> bizbillIds) {
        HashMap<Long, String> updateIdsMap = new HashMap<Long, String>(16);
        QFilter qa = new QFilter("id", "in", childIds);
        HashSet<Long> ancestorIds = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"entry.ancestorbillid", (QFilter[])qa.toArray(), null);){
            for (Row row : dataSet) {
                ancestorIds.add(row.getLong("entry.ancestorbillid"));
            }
        }
        QFilter qb = new QFilter("entry.ancestorbillid", "in", ancestorIds);
        qb.and("writeoffstatus", "=", (Object)"B");
        qb.and("bizbillid", "in", bizbillIds);
        DataSet dataSetA = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,entry.id,entry.ancestorentryid,writeoffperiod", (QFilter[])qa.toArray(), null);
        Object object = null;
        try (DataSet dataSetB = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,billno,entry.id,entry.ancestorentryid,writeoffperiod", (QFilter[])qb.toArray(), null);
             DataSet joinSet = dataSetB.join(dataSetA).on("entry.ancestorentryid", "entry.ancestorentryid").select(new String[]{"id as bid", "billno", "entry.id as bentryid", "writeoffperiod as bwriteoffperiod"}, new String[]{"id as aid", "entry.id as aentryid", "writeoffperiod as awriteoffperiod"}).finish();){
            for (Row row : joinSet) {
                Long aWriteoffperiod = row.getLong("awriteoffperiod");
                Long bWriteoffperiod = row.getLong("bwriteoffperiod");
                if (aWriteoffperiod > bWriteoffperiod) continue;
                updateIdsMap.put(row.getLong("bid"), row.getString("billno"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSetA != null) {
                if (object != null) {
                    try {
                        dataSetA.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSetA.close();
                }
            }
        }
        if (!updateIdsMap.isEmpty()) {
            this.checkVoucher(updateIdsMap);
        }
    }

    private void checkVoucher(Map<Long, String> updateIdsMap) {
        Map<Long, List<String>> vouSourceMap = this.getVouSourceMap(updateIdsMap.keySet());
        for (Map.Entry<Long, String> entry : updateIdsMap.entrySet()) {
            String content;
            Long recordID = entry.getKey();
            String billNo = entry.getValue();
            if (!this.hasVoucher(recordID, vouSourceMap)) continue;
            String msg = content = String.format(ResManager.loadKDString((String)"\u6838\u9500\u62c6\u5355\u751f\u6210\u7684\u6210\u672c\u8bb0\u5f55\u5df2\u751f\u6210\u51ed\u8bc1\u3002\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%1$s", (String)"PurUnWriteOffServiceProcess_8", (String)"fi-cal-business", (Object[])new Object[0]), billNo);
            throw new KDBizException(msg);
        }
    }

    protected void checkUnWriteOff(DynamicObject[] costRecords, ArrayList<Long> childIds, ArrayList<Long> childEntryIds, Set<Long> bizbillIds) {
        StringBuffer msg;
        boolean hasVoucher = false;
        boolean lessCurrentPeriod = false;
        if (costRecords == null) {
            return;
        }
        int cSize = costRecords.length;
        HashSet<String> voucherbillNumber = new HashSet<String>(cSize);
        HashSet<String> periodbillNumber = new HashSet<String>(cSize);
        HashSet<Long> idSet = new HashSet<Long>(cSize);
        HashSet<Long> costAccountIdSet = new HashSet<Long>(16);
        for (DynamicObject record : costRecords) {
            idSet.add(record.getLong("id"));
            costAccountIdSet.add(record.getLong("costaccount.id"));
        }
        Map curPeriodMap = PeriodHelper.getCurrentPeriods(costAccountIdSet);
        Map<Long, List<String>> vouSourceMap = this.getVouSourceMap(idSet);
        for (DynamicObject record : costRecords) {
            childIds.add(record.getLong("id"));
            bizbillIds.add(record.getLong("bizbillid"));
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                childEntryIds.add(entry.getLong("id"));
            }
            if (!hasVoucher) {
                hasVoucher = this.hasVoucher(record, vouSourceMap);
            }
            if (!lessCurrentPeriod) {
                lessCurrentPeriod = this.lessCurrentPeriod(record, curPeriodMap);
            }
            if (hasVoucher) {
                voucherbillNumber.add(record.getString("billno"));
            }
            if (!lessCurrentPeriod) continue;
            periodbillNumber.add(record.getString("billno"));
        }
        if (hasVoucher) {
            msg = new StringBuffer();
            msg.append(ResManager.loadKDString((String)"\u6838\u9500\u62c6\u5355\u751f\u6210\u7684\u6210\u672c\u8bb0\u5f55\u5df2\u751f\u6210\u51ed\u8bc1\u3002\u5355\u636e\u7f16\u53f7\u4e3a\uff1a", (String)"PurUnWriteOffServiceProcess_1", (String)"fi-cal-mservice", (Object[])new Object[0])).append(voucherbillNumber);
            throw new KDBizException(msg.toString());
        }
        if (lessCurrentPeriod) {
            msg = new StringBuffer();
            msg.append(ResManager.loadKDString((String)"\u53cd\u6838\u9500\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a\uff1a\u6838\u9500\u62c6\u5355\u751f\u6210\u7684\u6210\u672c\u8bb0\u5f55\u7684\u671f\u95f4\u6216\u6838\u9500\u65e5\u671f\u4e3a\u5f80\u671f\u3002\u5355\u636e\u7f16\u53f7", (String)"PurUnWriteOffServiceProcess_2", (String)"fi-cal-business", (Object[])new Object[0])).append(periodbillNumber);
            throw new KDBizException(msg.toString());
        }
    }

    protected boolean hasVoucher(DynamicObject record, Map<Long, List<String>> vouSourceMap) {
        long recordID = record.getLong("id");
        return this.hasVoucher(recordID, vouSourceMap);
    }

    protected boolean hasVoucher(Long recordID, Map<Long, List<String>> vouSourceMap) {
        List<String> voucherSources = vouSourceMap.get(recordID);
        if (voucherSources == null) {
            return false;
        }
        for (String vouchersource : voucherSources) {
            if (!"A".equals(vouchersource) && !"B".equals(vouchersource)) continue;
            return true;
        }
        return false;
    }

    protected boolean lessCurrentPeriod(DynamicObject record, Map<Long, DynamicObject> curPeriodMap) {
        long costAccountID = record.getLong("costaccount.id");
        Date witeOffDate = record.getDate("writeoffdate");
        DynamicObject curPeriod = curPeriodMap.get(costAccountID);
        if (curPeriod == null) {
            return false;
        }
        Date currentPeriodDate = curPeriod.getDate("begindate");
        return witeOffDate.compareTo(currentPeriodDate) < 0;
    }

    protected Map<Long, List<String>> getVouSourceMap(Set<Long> idSet) {
        HashMap<Long, List<String>> vouSourceMap = new HashMap<Long, List<String>>(idSet.size());
        QFilter filter = new QFilter("costrecordid", "in", idSet);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_voucher", (String)"costrecordid,vouchersource", (QFilter[])new QFilter[]{filter});
        for (DynamicObject info : coll) {
            ArrayList<String> list = (ArrayList<String>)vouSourceMap.get(info.getLong("costrecordid"));
            if (list == null) {
                list = new ArrayList<String>(16);
                vouSourceMap.put(info.getLong("costrecordid"), list);
            }
            list.add(info.getString("vouchersource"));
        }
        return vouSourceMap;
    }

    private DynamicObject[] checkMoreReocrd(Set<Long> writeOffIDSet, Set<Long> bizbillIds, boolean isPurUnWriteOff) {
        int cSize = writeOffIDSet.size();
        HashSet<Long> costRecordAidSet = new HashSet<Long>(cSize);
        if (this.hasMoreRecord(writeOffIDSet, costRecordAidSet, bizbillIds, isPurUnWriteOff) && costRecordAidSet.isEmpty()) {
            return new DynamicObject[0];
        }
        QFilter q = new QFilter("id", "in", costRecordAidSet);
        String field = this.getCostReorcdField(isPurUnWriteOff);
        DynamicObject[] costRecords = BusinessDataServiceHelper.load((String)"cal_costrecord_subentity", (String)field, (QFilter[])q.toArray());
        return costRecords;
    }

    private boolean hasMoreRecord(Set<Long> writeOffIDSet, Set<Long> costRecordAidSet, Set<Long> bizbillIds, boolean isPurUnWriteOff) {
        HashSet<Long> copySet = new HashSet<Long>(writeOffIDSet);
        HashSet<Long> runningSet = new HashSet<Long>();
        QFilter q = new QFilter("bizbillid", "in", writeOffIDSet);
        q.and("success", "=", (Object)Character.valueOf('2'));
        try (DataSet rs = QueryServiceHelper.queryDataSet((String)(this.getClass() + "hasMoreRecord"), (String)"cal_businesslog", (String)"success,bizbillid", (QFilter[])q.toArray(), null);){
            for (Row row : rs) {
                runningSet.add(row.getLong("bizbillid"));
            }
        }
        q = new QFilter("entry.writeoffid", "in", writeOffIDSet);
        q.and("bizbillid", "in", bizbillIds);
        rs = QueryServiceHelper.queryDataSet((String)(this.getClass() + "hasMoreRecord"), (String)"cal_costrecord", (String)"id,billno,costaccount,entry.id,entry.fatherentryid,entry.writeoffid", (QFilter[])q.toArray(), null);
        var9_9 = null;
        try {
            while (rs.hasNext()) {
                Row row = rs.next();
                costRecordAidSet.add(row.getLong("id"));
                copySet.remove(row.getLong("entry.writeoffid"));
            }
        }
        catch (Throwable row) {
            var9_9 = row;
            throw row;
        }
        finally {
            if (rs != null) {
                if (var9_9 != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable row) {
                        var9_9.addSuppressed(row);
                    }
                } else {
                    rs.close();
                }
            }
        }
        if (!copySet.isEmpty()) {
            boolean isRedBlueWrite;
            HashSet<Long> hasRedBillWriteOffSet;
            HashSet<Long> hasBillWriteOffSet;
            block95: {
                hasBillWriteOffSet = new HashSet<Long>(128);
                hasRedBillWriteOffSet = new HashSet<Long>(128);
                QFilter q1 = new QFilter("id", "in", writeOffIDSet);
                isRedBlueWrite = false;
                String verifyRecordEntity = isPurUnWriteOff ? "ap_verifyrecord" : "ar_verifyrecord";
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)verifyRecordEntity, (String)"id,billid,verifyrelation,entry.e_billid", (QFilter[])q1.toArray(), null);){
                    Throwable throwable;
                    DataSet joinSet;
                    HashSet<Long> billIdSet = new HashSet<Long>(writeOffIDSet.size());
                    HashSet<Long> redBillIdSet = new HashSet<Long>(writeOffIDSet.size());
                    for (Row row : dataSet.copy()) {
                        billIdSet.add(row.getLong("billid"));
                        String verifyRelation = row.getString("verifyrelation");
                        if (isPurUnWriteOff && ("purself".equals(verifyRelation) || "apfinself".equals(verifyRelation))) {
                            isRedBlueWrite = true;
                            redBillIdSet.add(row.getLong("entry.e_billid"));
                            continue;
                        }
                        if (isPurUnWriteOff || !"salself".equals(verifyRelation) && !"arfinself".equals(verifyRelation)) continue;
                        isRedBlueWrite = true;
                        redBillIdSet.add(row.getLong("entry.e_billid"));
                    }
                    QFilter q2 = new QFilter("bizbillid", "in", billIdSet);
                    try (DataSet dataSet1 = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,bizbillid", (QFilter[])q2.toArray(), null);){
                        joinSet = dataSet.copy().join(dataSet1).on("billid", "bizbillid").select(new String[]{"id as writeoffid"}, new String[]{"id as billid"}).finish();
                        throwable = null;
                        try {
                            for (Row row : joinSet) {
                                hasBillWriteOffSet.add(row.getLong("writeoffid"));
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (joinSet != null) {
                                if (throwable != null) {
                                    try {
                                        joinSet.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    joinSet.close();
                                }
                            }
                        }
                    }
                    if (!isRedBlueWrite) break block95;
                    q2 = new QFilter("bizbillid", "in", redBillIdSet);
                    dataSet1 = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,bizbillid", (QFilter[])q2.toArray(), null);
                    var19_31 = null;
                    try {
                        joinSet = dataSet.join(dataSet1).on("entry.e_billid", "bizbillid").select(new String[]{"id as writeoffid"}, new String[]{"id as billid"}).finish();
                        throwable = null;
                        try {
                            for (Row row : joinSet) {
                                hasRedBillWriteOffSet.add(row.getLong("writeoffid"));
                            }
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (joinSet != null) {
                                if (throwable != null) {
                                    try {
                                        joinSet.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    joinSet.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable6) {
                        var19_31 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (dataSet1 != null) {
                            if (var19_31 != null) {
                                try {
                                    dataSet1.close();
                                }
                                catch (Throwable throwable7) {
                                    var19_31.addSuppressed(throwable7);
                                }
                            } else {
                                dataSet1.close();
                            }
                        }
                    }
                }
            }
            Iterator iterator = copySet.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                if (!runningSet.contains(id) || !(isRedBlueWrite ? hasBillWriteOffSet.contains(id) && hasRedBillWriteOffSet.contains(id) : hasBillWriteOffSet.contains(id))) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u540e\u7684\u5b58\u8d27\u6838\u7b97\u670d\u52a1\u672a\u6267\u884c\u5b8c\u6210\u6216\u8005\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u8fdb\u5165\u201c\u5b58\u8d27\u6838\u7b97>\u6838\u7b97\u5355\u636e>\u670d\u52a1\u6267\u884c\u65e5\u5fd7\u201d\u786e\u8ba4\uff0c\u5982\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u3002", (String)"PurUnWriteOffServiceProcess_7", (String)"fi-cal-business", (Object[])new Object[0]));
            }
            return true;
        }
        return false;
    }

    protected String getCostReorcdField(boolean hasCostDetail) {
        String costRecordEntity = "cal_costrecord";
        if (hasCostDetail) {
            costRecordEntity = "cal_costrecord_subentity";
        }
        StringBuilder fields = new StringBuilder();
        MainEntityType calEntityType = EntityMetadataCache.getDataEntityType((String)costRecordEntity);
        Set selectorsSet = calEntityType.getAllFields().keySet();
        for (String o : selectorsSet) {
            fields.append(o).append(',');
        }
        fields.append("costaccount.calpolicy.convertmode,");
        fields.append("entry.seq,");
        fields.append("costaccount.calpolicy.exratetable,");
        fields.append("entry.subentryentity.id,entry.subentryentityest.id");
        return fields.toString();
    }
}

