/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.business.calculate.out.MoveAddAverageCalculate;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.AccountTypeHelperNew;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.opplugin.validator.BalanceImportValidator;
import kd.fi.cal.opplugin.validator.BalanceSaveValidator;

public class BalanceSave
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(BalanceSave.class);
    private Map<Long, DynamicObject> curPeriodMap = new HashMap<Long, DynamicObject>();
    private Map<Long, DynamicObject> startPeriodMap = new HashMap<Long, DynamicObject>();
    private Map<String, DynamicObject> baseUnitMap = new HashMap<String, DynamicObject>();
    private static String[] decimalFields = new String[]{"periodendqty", "periodendstandardcost", "periodendcostdiff", "periodendactualcost", "yearinqty", "yearinstandradcost", "yearincostdiff", "yearinactualcost", "yearissueqty", "yearissuestandradcost", "yearissuecostdiff", "yearissueactualcost", "periodbeginqty", "beginstandardcost", "periodbeginactualcost", "periodbegincostdiff"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("material.id");
        e.getFieldKeys().add("material.name");
        e.getFieldKeys().add("material.number");
        e.getFieldKeys().add("material.enablelot");
        e.getFieldKeys().add("material.isuseauxpty");
        e.getFieldKeys().add("costaccount.id");
        e.getFieldKeys().add("costaccount.name");
        e.getFieldKeys().add("costaccount.number");
        e.getFieldKeys().add("costaccount.costtype");
        e.getFieldKeys().add("costaccount.calorg");
        e.getFieldKeys().add("storageorgunit.id");
        e.getFieldKeys().add("storageorgunit.name");
        e.getFieldKeys().add("storageorgunit.number");
        e.getFieldKeys().add("warehouse.id");
        e.getFieldKeys().add("warehouse.name");
        e.getFieldKeys().add("warehouse.number");
        e.getFieldKeys().add("calorg.id");
        e.getFieldKeys().add("calorg.name");
        e.getFieldKeys().add("calorg.number");
        e.getFieldKeys().add("assist");
        e.getFieldKeys().add("lot");
        e.getFieldKeys().add("periodbeginqty");
        e.getFieldKeys().add("beginstandardcost");
        e.getFieldKeys().add("periodbegincostdiff");
        e.getFieldKeys().add("periodbeginactualcost");
        e.getFieldKeys().add("periodendqty");
        e.getFieldKeys().add("periodendstandardcost");
        e.getFieldKeys().add("periodendcostdiff");
        e.getFieldKeys().add("periodendactualcost");
        e.getFieldKeys().add("calpolicy.currency");
        e.getFieldKeys().add("currency");
        for (String field : decimalFields) {
            e.getFieldKeys().add(field);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new BalanceSaveValidator());
        if (!this.getOption().getVariables().containsKey("billtype")) {
            e.addValidator((AbstractValidator)new BalanceImportValidator());
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntrys;
        for (DynamicObject info : dataEntrys = e.getDataEntities()) {
            long costAccountID = info.getDynamicObject("costaccount").getLong("id");
            boolean isInitPeriod = this.isInitPeriod(costAccountID);
            info.set("period", (Object)0);
            if (isInitPeriod) {
                DynamicObject startPeriod = this.startPeriodMap.get(costAccountID);
                info.set("year", (Object)startPeriod.getInt("periodyear"));
                info.set("month", (Object)startPeriod.getInt("periodnumber"));
                info.set("periodid_id", startPeriod.get("id"));
            } else {
                DynamicObject curPeriod = this.curPeriodMap.get(costAccountID);
                info.set("year", (Object)curPeriod.getInt("periodyear"));
                info.set("month", (Object)curPeriod.getInt("periodnumber"));
                info.set("periodid_id", curPeriod.get("id"));
            }
            info.set("endperiod", (Object)999999);
            info.set("baseunit", (Object)this.getBaseUnit(info));
            info.set("periodendqty", info.get("periodbeginqty"));
            info.set("periodendstandardcost", info.get("beginstandardcost"));
            info.set("periodendcostdiff", info.get("periodbegincostdiff"));
            info.set("periodendactualcost", info.get("periodbeginactualcost"));
            info.set("currency_id", (Object)info.getDynamicObject("calpolicy").getLong("currency.id"));
        }
        new AccountTypeHelperNew(dataEntrys, Boolean.TRUE).handleCalRangeAccountType4InitBalance();
        Map<String, Long[]> materialCostElementMap = this.getMaterialCostElement(dataEntrys);
        HashMap<Long, Boolean> calByCostElementMap = new HashMap<Long, Boolean>();
        for (DynamicObject info : dataEntrys) {
            long costAccountId = info.getDynamicObject("costaccount").getLong("id");
            if (calByCostElementMap.containsKey(costAccountId)) continue;
            boolean calByCostElement = ParamsHelper.getCostElementByCostAccount((long)costAccountId);
            calByCostElementMap.put(costAccountId, calByCostElement);
        }
        this.handleStandardCost(dataEntrys, materialCostElementMap, calByCostElementMap);
        this.insertCostElements(dataEntrys, materialCostElementMap, calByCostElementMap);
    }

    private DynamicObject getBaseUnit(DynamicObject info) {
        String materialNumber = info.getString("material.number");
        DynamicObject baseUnit = this.baseUnitMap.get(materialNumber);
        if (baseUnit == null) {
            DynamicObject materialInfo = BusinessDataServiceHelper.loadSingle((String)"bd_material", (String)"baseunit", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)materialNumber)});
            baseUnit = materialInfo.getDynamicObject("baseunit");
            this.baseUnitMap.put(materialNumber, baseUnit);
        }
        return baseUnit;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] infos = e.getDataEntities();
        BalanceCalculator calculator = new BalanceCalculator();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DynamicObject info : infos) {
            ids.add(info.getLong("id"));
        }
        calculator.updateBalance4InitBal(ids.toArray(new Object[ids.size()]));
        new MoveAddAverageCalculate(ids.toArray(new Long[0]), "cal_balance", "1").calculate();
    }

    private boolean isInitPeriod(Long costAccountID) {
        DynamicObject curPeriod = null;
        DynamicObject startPeriod = null;
        if (this.curPeriodMap.get(costAccountID) != null) {
            curPeriod = this.curPeriodMap.get(costAccountID);
        } else {
            curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountID);
            this.curPeriodMap.put(costAccountID, curPeriod);
        }
        if (this.startPeriodMap.get(costAccountID) != null) {
            startPeriod = this.startPeriodMap.get(costAccountID);
        } else {
            startPeriod = PeriodHelper.getStartPeriod((Long)costAccountID);
            this.startPeriodMap.put(costAccountID, startPeriod);
        }
        return curPeriod == null || curPeriod.getLong("id") == startPeriod.getLong("id");
    }

    public void insertCostElements(DynamicObject[] infos, Map<String, Long[]> materialCostElementMap, Map<Long, Boolean> calByCostElementMap) {
        HashSet<DynamicObject> detailSet = new HashSet<DynamicObject>();
        Map<Long, List<Long[]>> entryCostSubElementMap = this.cacheMaterialCostElements(infos, materialCostElementMap, calByCostElementMap);
        for (DynamicObject info : infos) {
            long balId = info.getLong("id");
            List<Long[]> costElementSet = entryCostSubElementMap.get(balId);
            for (Long[] costElements : costElementSet) {
                long costSubElement = costElements[0];
                long costElement = costElements[1];
                DynamicObject detail = BusinessDataServiceHelper.newDynamicObject((String)"cal_balance_detail");
                detail.set("balid", (Object)balId);
                detail.set("costsubelement", (Object)costSubElement);
                detail.set("costelement", (Object)costElement);
                for (String field : decimalFields) {
                    detail.set(field, info.get(field));
                }
                detailSet.add(detail);
            }
        }
        SaveServiceHelper.save((DynamicObject[])detailSet.toArray(new DynamicObject[0]));
    }

    public Map<String, Long[]> getMaterialCostElement(DynamicObject[] infos) {
        HashSet<Long> materialIds = new HashSet<Long>(16);
        HashSet<Long> costTypes = new HashSet<Long>(16);
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        HashMap<String, Long[]> materialCostElementMap = new HashMap<String, Long[]>();
        Long calOrgId = 0L;
        for (DynamicObject info : infos) {
            costAccountIds.add(info.getLong("costaccount_id"));
            materialIds.add(info.getLong("material_id"));
            calOrgId = info.getLong("calorg_id");
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cal_bd_costaccount", (String)"id,costtype", (QFilter[])new QFilter("id", "in", costAccountIds).toArray(), null);){
            for (Row row : dataSet) {
                costTypes.add(row.getLong("costtype"));
            }
        }
        materialCostElementMap.putAll(CostElementHelper.getCostElementsByMaterial((long)calOrgId, (Long[])costTypes.toArray(new Long[0]), (Long[])materialIds.toArray(new Long[0])));
        return materialCostElementMap;
    }

    private Map<Long, List<Long[]>> cacheMaterialCostElements(DynamicObject[] infos, Map<String, Long[]> materialCostElementMap, Map<Long, Boolean> calByCostElementMap) {
        HashMap<Long, List<Long[]>> entryCostSubElementMap = new HashMap<Long, List<Long[]>>(16);
        Long[] materialDefaultElements = CostElementHelper.getDefaultMaterialElements();
        for (DynamicObject info : infos) {
            long costAccountId = info.getDynamicObject("costaccount").getLong("id");
            boolean calByCostElement = calByCostElementMap.get(costAccountId);
            long costTypeId = info.getDynamicObject("costaccount").getLong("costtype_id");
            long materialId = info.getLong("material_id");
            ArrayList<Long[]> costSubElements = new ArrayList<Long[]>();
            if (calByCostElement) {
                costSubElements.add(materialCostElementMap.get(costTypeId + "|" + materialId));
            } else {
                costSubElements.add(materialDefaultElements);
            }
            entryCostSubElementMap.put(info.getLong("id"), costSubElements);
        }
        return entryCostSubElementMap;
    }

    private void handleStandardCost(DynamicObject[] infos, Map<String, Long[]> materialElementMap, Map<Long, Boolean> calByCostElementMap) {
        HashSet<Long> costAccountSet = new HashSet<Long>(10);
        HashSet<Long> costTypeSet = new HashSet<Long>();
        HashSet<Long> balIdSet = new HashSet<Long>(10000);
        for (DynamicObject info : infos) {
            costAccountSet.add(info.getLong("costaccount_id"));
            balIdSet.add(info.getLong("id"));
        }
        HashMap<Object, DynamicObject> costAccountMap = new HashMap<Object, DynamicObject>();
        DynamicObjectCollection costAccountColl = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,costtype,enablestandardcost,calpolicy.id,calpolicy.currency,calpolicy.currency.amtprecision,calpolicy.exratetable,calpolicy.convertmode", (QFilter[])new QFilter("id", "in", costAccountSet).toArray(), null);
        for (DynamicObject info : costAccountColl) {
            costTypeSet.add(info.getLong("costtype"));
            costAccountMap.put(info.get("id"), info);
        }
        Map balMap = BusinessDataServiceHelper.loadFromCache((String)"cal_balance_calrange", (QFilter[])new QFilter("id", "in", balIdSet).toArray());
        HashSet<Long> costElementSet = new HashSet<Long>(16);
        HashSet<Long> costSubElementSet = new HashSet<Long>(16);
        for (Map.Entry<String, Long[]> entry : materialElementMap.entrySet()) {
            Long[] elements = entry.getValue();
            if (elements == null || elements.length == 0) continue;
            costElementSet.add(elements[1]);
            costSubElementSet.add(elements[0]);
        }
        HashSet<DynamicObject> calByCostElementInfos = new HashSet<DynamicObject>();
        HashSet<DynamicObject> unCalByCostElementInfos = new HashSet<DynamicObject>();
        for (DynamicObject info : infos) {
            long costAccountId = info.getLong("costaccount_id");
            boolean calByCostElement = calByCostElementMap.get(costAccountId);
            if (calByCostElement) {
                calByCostElementInfos.add(info);
                continue;
            }
            unCalByCostElementInfos.add(info);
        }
        if (!calByCostElementInfos.isEmpty()) {
            this.handleStandardCost(calByCostElementInfos.toArray(new DynamicObject[0]), costTypeSet, costElementSet, costSubElementSet, true, materialElementMap, costAccountMap, balMap);
        }
        if (!unCalByCostElementInfos.isEmpty()) {
            this.handleStandardCost(unCalByCostElementInfos.toArray(new DynamicObject[0]), costTypeSet, costElementSet, costSubElementSet, false, materialElementMap, costAccountMap, balMap);
        }
    }

    private void handleStandardCost(DynamicObject[] infos, Set<Long> costTypeSet, Set<Long> costElementSet, Set<Long> costSubElementSet, boolean calByCostElement, Map<String, Long[]> materialElementMap, Map<Object, DynamicObject> costAccountMap, Map<Object, DynamicObject> balMap) {
        String key;
        BigDecimal unitStandardcost;
        long currencyId;
        long costSubElementId;
        long costElementId;
        long materialId;
        long costTypeId;
        Throwable throwable;
        DataSet dataSet;
        HashSet<Long> materialSet = new HashSet<Long>(500);
        HashMap<String, Object[]> standardCostMap = new HashMap<String, Object[]>();
        for (DynamicObject info : infos) {
            materialSet.add(info.getLong("material_id"));
        }
        Long[] materialDefaultElements = CostElementHelper.getDefaultMaterialElements();
        QFilter q = new QFilter("costtype", "in", costTypeSet);
        q.and("material", "in", materialSet);
        q.and("status", "=", (Object)"C");
        q.and("enable", "=", (Object)"1");
        if (calByCostElement) {
            q.and("entryentity.element", "in", costElementSet);
            q.and("entryentity.subelement", "in", costSubElementSet);
            try {
                dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cad_matcostinfo", (String)"id,material,costtype,currency,entryentity.element,entryentity.subelement,entryentity.standardcost", (QFilter[])q.toArray(), null);
                throwable = null;
                try {
                    for (Row row : dataSet) {
                        costTypeId = row.getLong("costtype");
                        materialId = row.getLong("material");
                        costElementId = row.getLong("entryentity.element");
                        costSubElementId = row.getLong("entryentity.subelement");
                        currencyId = row.getLong("currency");
                        unitStandardcost = row.getBigDecimal("entryentity.standardcost");
                        if (unitStandardcost == null) {
                            unitStandardcost = BigDecimal.ZERO;
                        }
                        key = costTypeId + "|" + materialId + "|" + costElementId + "|" + costSubElementId;
                        standardCostMap.put(key, new Object[]{currencyId, unitStandardcost});
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dataSet != null) {
                        if (throwable != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        } else {
            try {
                dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cad_matcostinfo", (String)"id,material,costtype,currency,entryentity.standardcost", (QFilter[])q.toArray(), null).groupBy(new String[]{"id", "material", "costtype", "currency"}).sum("entryentity.standardcost").finish();
                throwable = null;
                try {
                    for (Row row : dataSet) {
                        costTypeId = row.getLong("costtype");
                        materialId = row.getLong("material");
                        costElementId = materialDefaultElements[1];
                        costSubElementId = materialDefaultElements[0];
                        currencyId = row.getLong("currency");
                        unitStandardcost = row.getBigDecimal("entryentity.standardcost");
                        if (unitStandardcost == null) {
                            unitStandardcost = BigDecimal.ZERO;
                        }
                        key = costTypeId + "|" + materialId + "|" + costElementId + "|" + costSubElementId;
                        standardCostMap.put(key, new Object[]{currencyId, unitStandardcost});
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (dataSet != null) {
                        if (throwable != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        for (DynamicObject info : infos) {
            long costAccountId = info.getLong("costaccount_id");
            long balId = info.getLong("id");
            DynamicObject balAccountInfo = balMap.get(balId);
            String accountType = balAccountInfo.getString("accounttype");
            DynamicObject costAccountInfo = costAccountMap.get(costAccountId);
            boolean enableStandardCost = costAccountInfo.getBoolean("enablestandardcost");
            int amtPrecision = costAccountInfo.getInt("calpolicy.currency.amtprecision");
            if (!enableStandardCost && !AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) continue;
            long costTypeId2 = costAccountInfo.getLong("costtype");
            long materialId2 = info.getLong("material_id");
            BigDecimal periodBeginQty = info.getBigDecimal("periodbeginqty");
            long costElementId2 = materialElementMap.get(costTypeId2 + "|" + materialId2)[1];
            long costSubElementId2 = materialElementMap.get(costTypeId2 + "|" + materialId2)[0];
            if (!calByCostElement) {
                costElementId2 = materialDefaultElements[1];
                costSubElementId2 = materialDefaultElements[0];
            }
            String key2 = costTypeId2 + "|" + materialId2 + "|" + costElementId2 + "|" + costSubElementId2;
            BigDecimal standardcost = BigDecimal.ZERO;
            BigDecimal unitStandardCost = BigDecimal.ZERO;
            Object[] value = (Object[])standardCostMap.get(key2);
            if (value != null && value.length != 0) {
                unitStandardCost = (BigDecimal)value[1];
                if (unitStandardCost == null) {
                    unitStandardCost = BigDecimal.ZERO;
                }
                standardcost = unitStandardCost.multiply(periodBeginQty).setScale(amtPrecision, 4);
            }
            if (standardcost.compareTo(BigDecimal.ZERO) == 0) continue;
            info.set("beginstandardcost", (Object)standardcost);
            info.set("periodendstandardcost", (Object)standardcost);
        }
    }
}

