/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.balance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.cal.common.helper.CalDLockHelper;
import kd.fi.cal.common.helper.CostElementHelper;

public class BalanceDetailRepairOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(BalanceDetailRepairOp.class);
    public static final int BATCH_SIZE = 10000;
    private static final String DLOCK_KEY = "fi-cal-billsynclock";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("costaccount");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] balance = e.getDataEntities();
        if (balance == null || balance.length <= 0) {
            return;
        }
        DynamicObject info = balance[0];
        DynamicObject costAccount = info.getDynamicObject("costaccount");
        Long costAccountId = costAccount.getLong("id");
        String balancetype = info.getDataEntityType().getName();
        DLock dlock = DLock.createReentrant((String)DLOCK_KEY, (String)ResManager.loadKDString((String)"\u5b58\u8d27\u6838\u7b97\u5355\u636e\u540c\u6b65\u5206\u5e03\u5f0f\u9501", (String)"StopSyncSettingModifyHelper_10", (String)"fi-cal-common", (Object[])new Object[0]));
        CalDLockHelper.releaseLockAfterTxEnd(Collections.singletonList(dlock));
        try (TraceSpan span = Tracer.create((String)"BalanceDetailRepairOp-bal", (String)"BalanceDetailRepairOp-bal");){
            dlock.lock();
            if ("cal_balance".equals(balancetype)) {
                this.repairCalBalanceDetail(costAccountId);
            } else if ("cal_purpricediff".equals(balancetype)) {
                this.repairDiffBalanceDetail();
            }
        }
    }

    private void repairDiffBalanceDetail() {
        List elements = CostElementHelper.getAllCostEle4InitBill();
        int size = elements.size();
        ArrayList<List<DynamicObject>> list = new ArrayList<List<DynamicObject>>(10);
        ArrayList<DynamicObject> subList = null;
        QFilter filter = new QFilter("balid", "!=", (Object)0);
        try (DataSet detailDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_purpricediff_detail", (String)"balid,costsubelement", (QFilter[])filter.toArray(), (String)"balid");){
            Long preBalid = 0L;
            HashSet<Long> exitSubElements = new HashSet<Long>(16);
            for (Row row : detailDS) {
                Long balid = row.getLong("balid");
                Long costsubelement = row.getLong("costsubelement");
                if (preBalid.compareTo(balid) == 0 || preBalid == 0L) {
                    preBalid = balid;
                    exitSubElements.add(costsubelement);
                    continue;
                }
                if (exitSubElements.size() < size) {
                    for (Long[] element : elements) {
                        if (exitSubElements.contains(element[0])) continue;
                        DynamicObject detail = BusinessDataServiceHelper.newDynamicObject((String)"cal_purpricediff_detail");
                        detail.set("balid", (Object)preBalid);
                        detail.set("costelement", (Object)element[1]);
                        detail.set("costsubelement", (Object)element[0]);
                        if (subList == null || subList.size() >= 10000) {
                            subList = new ArrayList<DynamicObject>(10000);
                            list.add(subList);
                        }
                        subList.add(detail);
                    }
                }
                exitSubElements.clear();
                preBalid = balid;
                exitSubElements.add(costsubelement);
            }
            this.batchSave(list);
        }
    }

    private void repairCalBalanceDetail(Long costAccountId) {
        QFilter filter = new QFilter("costaccount", "=", (Object)costAccountId);
        DynamicObject[] calBalances = BusinessDataServiceHelper.load((String)"cal_balance_subentity", (String)"id,periodbeginqty,periodinqty,periodissueqty,periodendqty,entryentity.costsubelement", (QFilter[])filter.toArray());
        List elements = CostElementHelper.getAllCostEle4InitBill();
        int size = elements.size();
        ArrayList<List<DynamicObject>> list = new ArrayList<List<DynamicObject>>(10);
        ArrayList<DynamicObject> subList = null;
        for (DynamicObject calBalance : calBalances) {
            DynamicObjectCollection entryentity = calBalance.getDynamicObjectCollection("entryentity");
            if (entryentity.size() == size) continue;
            Long balId = calBalance.getLong("id");
            BigDecimal periodbeginqty = calBalance.getBigDecimal("periodbeginqty");
            BigDecimal periodinqty = calBalance.getBigDecimal("periodinqty");
            BigDecimal periodissueqty = calBalance.getBigDecimal("periodissueqty");
            BigDecimal periodendqty = calBalance.getBigDecimal("periodendqty");
            HashSet<Long> exitSubElements = new HashSet<Long>(16);
            for (DynamicObject detailRow : entryentity) {
                exitSubElements.add(detailRow.getLong("costsubelement_id"));
            }
            for (Long[] element : elements) {
                if (exitSubElements.contains(element[0])) continue;
                DynamicObject detail = BusinessDataServiceHelper.newDynamicObject((String)"cal_balance_detail");
                detail.set("balid", (Object)balId);
                detail.set("costelement", (Object)element[1]);
                detail.set("costsubelement", (Object)element[0]);
                detail.set("periodbeginqty", (Object)periodbeginqty);
                detail.set("periodinqty", (Object)periodinqty);
                detail.set("periodissueqty", (Object)periodissueqty);
                detail.set("periodendqty", (Object)periodendqty);
                if (subList == null || subList.size() >= 10000) {
                    subList = new ArrayList<DynamicObject>(10000);
                    list.add(subList);
                }
                subList.add(detail);
            }
        }
        this.batchSave(list);
    }

    private void batchSave(List<List<DynamicObject>> list) {
        if (list.isEmpty()) {
            return;
        }
        final CountDownLatch latch = new CountDownLatch(list.size());
        for (final List<DynamicObject> sub : list) {
            ThreadPools.executeOnce((String)((Object)((Object)this)).getClass().getName(), (Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try (TXHandle h = TX.requiresNew();){
                        SaveServiceHelper.save((DynamicObject[])sub.toArray(new DynamicObject[sub.size()]));
                    }
                    catch (Throwable e) {
                        logger.error("\u63d2\u5165\u6838\u7b97\u4f59\u989d\u660e\u7ec6\u5931\u8d25\uff1a", e);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            logger.error("BalanceDetailRepairOp batchSave", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }
}

