/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.balance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.common.helper.BalanceReCalParams;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.util.CommonUtils;

public class BalanceReCalOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(BalanceReCalOp.class);
    private static final String ALGOKEY = "kd.fi.cal.opplugin.balance.BalanceReCalOp";
    private DynamicObjectCollection filter_materialFrom;
    private DynamicObject filter_materialTo;
    private DynamicObjectCollection filter_owner;
    private DynamicObjectCollection filter_storageOrg;
    private DynamicObjectCollection filter_warehouse;
    private static final String DLOCK_KEY = "balancerecal";
    private Map<Long, DynamicObject> periodMap = new HashMap<Long, DynamicObject>(16);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] billInfos = this.getDataEntities();
                DynamicObject info = billInfos[0].getDataEntity();
                DynamicObjectCollection costAccountColl = info.getDynamicObjectCollection("costaccount");
                DynamicObjectCollection matForm = info.getDynamicObjectCollection("materialfrom");
                DynamicObject matTo = info.getDynamicObject("materialto");
                if (costAccountColl == null) {
                    return;
                }
                int costAccSize = costAccountColl.size();
                if (costAccSize == 1) {
                    DynamicObject period = info.getDynamicObject("period");
                    if (period == null) {
                        this.addErrorMessage(billInfos[0], ResManager.loadKDString((String)"\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"BalanceReCalOp_1", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)((DynamicObject)costAccountColl.get(0)).getDynamicObject("fbasedataid").getLong("id"));
                    if (curPeriod == null) {
                        this.addErrorMessage(billInfos[0], ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"BalanceReCalOp_3", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    }
                }
                if (matTo != null && (matForm == null || matForm.isEmpty())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7269\u6599\u4ece\u201d\u3002", (String)"BalanceReCalOp_5", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        final DynamicObject recalDyn = args.getDataEntities()[0];
        if (Boolean.TRUE.equals(recalDyn.getBoolean("isconcurrency"))) {
            BalanceReCalParams params = this.buildBalReCalParam(recalDyn);
            Long timestamp = TimeServiceHelper.now().getTime();
            HashMap<String, Object> jobParams = new HashMap<String, Object>();
            jobParams.put("params", SerializationUtils.toJsonString((Object)params));
            jobParams.put("timestamp", timestamp);
            JobInfo job = new JobInfo();
            String OpName = String.format(ResManager.loadKDString((String)"\u4f59\u989d\u91cd\u7b97\u3010%1$s\u3011\uff0c\u64cd\u4f5c\u4eba\uff1a\u3010%2$s\u3011", (String)"BalanceReCalOp_8", (String)"fi-cal-opplugin", (Object[])new Object[0]), RequestContext.get().getTraceId() + "/" + timestamp, RequestContext.get().getUserName());
            job.setName(OpName);
            job.setTaskDefineId("2TEF27NJEF/N");
            job.setJobType(JobType.REALTIME);
            job.setParams(jobParams);
            job.setAppId("cal");
            job.setRunByLang(Lang.get());
            job.setTaskClassname("kd.fi.cal.formplugin.calculate.in.BalanceReCalPartitionTask");
            job.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
            JobClient.dispatch((JobInfo)job);
        } else {
            boolean costAccMul;
            DynamicObjectCollection costAccColl = recalDyn.getDynamicObjectCollection("costaccount");
            int costAccSize = costAccColl.size();
            boolean bl = costAccMul = costAccSize > 1;
            if (costAccMul) {
                HashSet<Long> costAccIds = new HashSet<Long>(costAccSize);
                for (DynamicObject costAcc : costAccColl) {
                    costAccIds.add(costAcc.getDynamicObject("fbasedataid").getLong("id"));
                }
                this.periodMap = PeriodHelper.getCurrentPeriods(costAccIds);
            }
            this.init(recalDyn);
            final BalanceCalculator cal = new BalanceCalculator();
            int accountnum = recalDyn.getInt("accountnum");
            try (ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"balrecal", (int)accountnum);){
                for (final DynamicObject costAcc : costAccColl) {
                    threadPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            DynamicObject costAccount = costAcc.getDynamicObject("fbasedataid");
                            String key = BalanceReCalOp.DLOCK_KEY + costAccount.getLong("id");
                            MessageInfo msgInfo = new MessageInfo();
                            ArrayList<Long> userList = new ArrayList<Long>();
                            userList.add(Long.valueOf(RequestContext.get().getUserId()));
                            msgInfo.setUserIds(userList);
                            msgInfo.setNotifyType(MessageChannels.MC.getNumber());
                            msgInfo.setTitle(ResManager.loadKDString((String)"\u4f59\u989d\u91cd\u7b97", (String)"BalanceReCalPartitionTask_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                            String content = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u4f59\u989d\u91cd\u7b97\u8ba1\u7b97\u6210\u529f\u3002", (String)"BalanceReCalOp_7", (String)"fi-cal-opplugin", (Object[])new Object[0]), costAccount.getString("name"));
                            msgInfo.setContent(content);
                            try (DLock lock = DLock.create((String)key, (String)"fi-cal-balancerecal-dlock");){
                                boolean isLockSuccess = lock.tryLock();
                                if (!isLockSuccess) {
                                    logger.info(costAccount.getString("name") + ResManager.loadKDString((String)"\u6b63\u5728\u4f59\u989d\u91cd\u7b97\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BalanceReCalOp_21", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                                    return;
                                }
                                try (AlgoContext context = Algo.newContext();){
                                    BalanceReCalOp.this.doRecal(recalDyn, costAccount, costAccMul, cal);
                                }
                            }
                            catch (Throwable e) {
                                String error = CommonUtils.getLogMessage((Throwable)e, (int)2000);
                                if (error != null && error.length() > 2000) {
                                    msgInfo.setContent(error.substring(1, 2000));
                                } else {
                                    msgInfo.setContent(error);
                                }
                                logger.error("\u4f59\u989d\u91cd\u7b97\u51fa\u73b0\u5f02\u5e38", e);
                                throw new KDBizException(error);
                            }
                            finally {
                                MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
                            }
                        }
                    });
                }
            }
        }
    }

    private void doRecal(DynamicObject recalDyn, DynamicObject costAccount, boolean costAccMul, BalanceCalculator cal) {
        DynamicObject filter_period = costAccMul ? this.periodMap.get(costAccount.getLong("id")) : (DynamicObject)recalDyn.get("period");
        int filter_periodNumber = filter_period.getInt("periodyear") * 100 + filter_period.getInt("periodnumber");
        HashSet<Long> costRecordEntrySet = new HashSet<Long>(4096);
        HashSet<Long> costRecordIdSet = new HashSet<Long>(4096);
        DataSet costRecordDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord", (String)"id,entry.id,period", (QFilter[])this.getCostRecordFilter(filter_period, costAccount).toArray(), null);
        for (Row row : costRecordDataSet.copy()) {
            costRecordEntrySet.add(row.getLong("entry.id"));
            costRecordIdSet.add(row.getLong("id"));
        }
        HashSet<Long> detailIdSet = new HashSet<Long>(4096);
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, costRecordIdSet)});){
            ctx.set();
            DataSet costRecordElementDetail = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord_detail", (String)"id", (QFilter[])new QFilter("entryid", "in", costRecordEntrySet).toArray(), null);
            while (costRecordElementDetail.hasNext()) {
                detailIdSet.add(costRecordElementDetail.next().getLong("id"));
            }
        }
        detailIdSet.remove(null);
        DeleteServiceHelper.delete((String)"cal_balance_snapshoot", (QFilter[])new QFilter("mainid", "in", detailIdSet).toArray());
        HashSet<Long> balSet = new HashSet<Long>(4096);
        DataSet balDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_balance", (String)"id", (QFilter[])this.getBalFilter(false, filter_periodNumber, costAccount).toArray(), null);
        for (Row row : balDataSet) {
            balSet.add(row.getLong("id"));
        }
        DeleteServiceHelper.delete((String)"cal_balance", (QFilter[])new QFilter("id", "in", balSet).toArray());
        DeleteServiceHelper.delete((String)"cal_balance_detail", (QFilter[])new QFilter("balid", "in", balSet).toArray());
        ArrayList<Object[]> endPeriodUpdateObjList = new ArrayList<Object[]>(4096);
        DataSet previousBalDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_balance", (String)"id", (QFilter[])this.getBalFilter(true, filter_periodNumber, costAccount).toArray(), null);
        for (Object row : previousBalDataSet) {
            endPeriodUpdateObjList.add(new Object[]{row.getLong("id")});
        }
        if (!endPeriodUpdateObjList.isEmpty()) {
            String endPeriodUpdateSql = "update t_cal_balance set fendperiod = 999999 where fid = ?";
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)endPeriodUpdateSql, endPeriodUpdateObjList);
        }
        DataSet copyCostRecordDataSet = costRecordDataSet.copy().groupBy(new String[]{"period"}).finish().orderBy(new String[]{"period asc"});
        for (Row row : copyCostRecordDataSet) {
            long periodid = row.getLong("period");
            DataSet recordDataSet = costRecordDataSet.copy().filter("period = " + periodid);
            ArrayList list = new ArrayList(32);
            ArrayList idlist = new ArrayList(32);
            int i = 0;
            int max = 50000;
            HashSet<Long> set = new HashSet<Long>(1024);
            HashSet<Long> idset = new HashSet<Long>(1024);
            list.add(set);
            idlist.add(idset);
            for (Row row1 : recordDataSet) {
                if (i >= max) {
                    i = 0;
                    set = new HashSet(1024);
                    idset = new HashSet(1024);
                    list.add(set);
                    idlist.add(idset);
                }
                set.add(row1.getLong("entry.id"));
                idset.add(row1.getLong("id"));
                ++i;
            }
            if (list.isEmpty()) continue;
            for (int j = 0; j < list.size(); ++j) {
                cal.updateBalance4CostRecordReCal((Set)list.get(j), (Set)idlist.get(j));
            }
        }
        DataSet costAdjustDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costadjustbill", (String)"entryentity.id,period", (QFilter[])this.getCostAdjustFilter(filter_period, costAccount).toArray(), null);
        DataSet copyCostAdjustDataSet = costAdjustDataSet.copy().groupBy(new String[]{"period"}).finish().orderBy(new String[]{"period asc"});
        HashSet<Long> set = new HashSet<Long>(1024);
        for (Row row : copyCostAdjustDataSet) {
            long periodid = row.getLong("period");
            DataSet adjustDataSet = costAdjustDataSet.copy().filter("period = " + periodid);
            for (Row row1 : adjustDataSet) {
                set.add(row1.getLong("entryentity.id"));
            }
            cal.updateBalance4CostAdjustReCal(set.toArray());
            set.clear();
        }
    }

    private void init(DynamicObject info) {
        this.filter_owner = info.getDynamicObjectCollection("owner");
        this.filter_storageOrg = info.getDynamicObjectCollection("storageorgunit");
        this.filter_materialFrom = (DynamicObjectCollection)info.get("materialfrom");
        this.filter_materialTo = (DynamicObject)info.get("materialto");
        this.filter_warehouse = info.getDynamicObjectCollection("warehouse");
    }

    private QFilter getCostRecordFilter(DynamicObject filter_period, DynamicObject costAccount) {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", costAccount.getPkValue());
        q.and("period", ">=", filter_period.getPkValue());
        q.and("issplitcreate", "=", (Object)Character.valueOf('0'));
        q.and("isinitbill", "=", (Object)Character.valueOf('0'));
        if (this.filter_materialFrom != null && !this.filter_materialFrom.isEmpty()) {
            if (this.filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : this.filter_materialFrom) {
                    materialSet.add(materialFrom.getDynamicObject("fbasedataid").getLong("id"));
                }
                q.and("entry.material.id", "in", materialSet);
            } else if (this.filter_materialFrom.size() == 1) {
                q.and("entry.material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getDynamicObject("fbasedataid").getString("number"));
            }
        }
        if (this.filter_materialTo != null) {
            q.and("entry.material.number", "<=", (Object)this.filter_materialTo.getString("number"));
        }
        if (this.filter_owner != null && !this.filter_owner.isEmpty()) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_owner) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("entry.owner", "in", set);
        }
        if (this.filter_storageOrg != null && !this.filter_storageOrg.isEmpty()) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (this.filter_warehouse != null && !this.filter_warehouse.isEmpty()) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("entry.warehouse", "in", set);
        }
        q.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        return q;
    }

    private QFilter getCostAdjustFilter(DynamicObject filter_period, DynamicObject costAccount) {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", costAccount.getPkValue());
        q.and("period", ">=", filter_period.getPkValue());
        q.and("billstatus", "=", (Object)"C");
        if (this.filter_materialFrom != null && !this.filter_materialFrom.isEmpty()) {
            if (this.filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : this.filter_materialFrom) {
                    materialSet.add(materialFrom.getDynamicObject("fbasedataid").getLong("id"));
                }
                q.and("entryentity.material.id", "in", materialSet);
            } else if (this.filter_materialFrom.size() == 1) {
                q.and("entryentity.material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getDynamicObject("fbasedataid").getString("number"));
            }
        }
        if (this.filter_materialTo != null) {
            q.and("entryentity.material.number", "<=", (Object)this.filter_materialTo.getString("number"));
        }
        if (this.filter_owner != null && !this.filter_owner.isEmpty()) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_owner) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("entryentity.owner", "in", set);
        }
        if (this.filter_storageOrg != null && !this.filter_storageOrg.isEmpty()) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("entryentity.storageorgunit", "in", set);
        }
        if (this.filter_warehouse != null && !this.filter_warehouse.isEmpty()) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("entryentity.warehouse", "in", set);
        }
        return q;
    }

    private QFilter getBalFilter(boolean filterEndPeriod, int filter_periodNumber, DynamicObject costAccount) {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", costAccount.getPkValue());
        if (filterEndPeriod) {
            q.and("endperiod", ">=", (Object)filter_periodNumber);
        } else {
            q.and("period", ">=", (Object)filter_periodNumber);
        }
        if (this.filter_materialFrom != null && !this.filter_materialFrom.isEmpty()) {
            if (this.filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : this.filter_materialFrom) {
                    materialSet.add(materialFrom.getDynamicObject("fbasedataid").getLong("id"));
                }
                q.and("material.id", "in", materialSet);
            } else if (this.filter_materialFrom.size() == 1) {
                q.and("material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getDynamicObject("fbasedataid").getString("number"));
            }
        }
        if (this.filter_materialTo != null) {
            q.and("material.number", "<=", (Object)this.filter_materialTo.getString("number"));
        }
        if (this.filter_owner != null && !this.filter_owner.isEmpty()) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_owner) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("owner", "in", set);
        }
        if (this.filter_storageOrg != null && !this.filter_storageOrg.isEmpty()) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (this.filter_warehouse != null && !this.filter_warehouse.isEmpty()) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("warehouse", "in", set);
        }
        return q;
    }

    private BalanceReCalParams buildBalReCalParam(DynamicObject recalDyn) {
        DynamicObject materialto;
        BalanceReCalParams params = new BalanceReCalParams();
        HashSet<Long> costAccountIdSet = new HashSet<Long>(16);
        for (Object costAccount : recalDyn.getDynamicObjectCollection("costaccount")) {
            costAccountIdSet.add((Long)costAccount.getDynamicObject("fbasedataid").getPkValue());
        }
        HashSet<Long> ownerIdSet = new HashSet<Long>(16);
        for (Object owner : recalDyn.getDynamicObjectCollection("owner")) {
            ownerIdSet.add((Long)owner.getDynamicObject("fbasedataid").getPkValue());
        }
        HashSet<Long> storageIdSet = new HashSet<Long>(16);
        for (Object storageorgunit : recalDyn.getDynamicObjectCollection("storageorgunit")) {
            storageIdSet.add((Long)storageorgunit.getDynamicObject("fbasedataid").getPkValue());
        }
        HashSet<Long> warehouseIdSet = new HashSet<Long>(16);
        for (Object warehouse : recalDyn.getDynamicObjectCollection("warehouse")) {
            warehouseIdSet.add((Long)warehouse.getDynamicObject("fbasedataid").getPkValue());
        }
        HashSet<Long> materialfromIdSet = new HashSet<Long>(16);
        for (DynamicObject materialfrom : recalDyn.getDynamicObjectCollection("materialfrom")) {
            materialfromIdSet.add((Long)materialfrom.getDynamicObject("fbasedataid").getPkValue());
        }
        params.setCostAccColl(costAccountIdSet);
        params.setOwner(ownerIdSet);
        params.setStorageOrg(storageIdSet);
        params.setWarehouse(warehouseIdSet);
        params.setMaterialFrom(materialfromIdSet);
        DynamicObject period = recalDyn.getDynamicObject("period");
        if (period != null) {
            params.setPeriod((Long)period.getPkValue());
        }
        if ((materialto = recalDyn.getDynamicObject("materialto")) != null) {
            params.setMaterialTo((Long)materialto.getPkValue());
        }
        params.setBatchmatsize(recalDyn.getInt("batchmatsize"));
        params.setConcurrency(recalDyn.getInt("concurrency"));
        params.setAccountnum(recalDyn.getInt("accountnum"));
        return params;
    }
}

