/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.balance;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.util.ArrayUtils;
import kd.fi.cal.common.util.CommonUtils;

public class BalanceRebuild4EndPeriodOp
extends AbstractOperationServicePlugIn {
    private static final String ALGOKEY = "kd.fi.cal.opplugin.balance.BalanceRebuild4EndPeriodOp";
    private String BALANCEFIELD = "id,period,periodid,endperiod,costaccount,storageorgunit,ownertype,owner,material,assist,lot,warehouse,location,invtype,invstatus,project,mversion,st_productcategory";
    private String[] DIMFIELDS = new String[]{"costaccount", "storageorgunit", "ownertype", "owner", "material", "assist", "lot", "warehouse", "location", "invtype", "invstatus", "project", "mversion", "st_productcategory"};
    private char keysplit = (char)95;
    private String endPeriodUpdateSql = "update t_cal_balance set fendperiod = ? where fid = ?";

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        try (DataSet balanceDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_balance", (String)this.BALANCEFIELD, null, null);
             DataSet groupBalanceDataSet = balanceDataSet.orderBy((String[])ArrayUtils.concatAll((Object[])this.DIMFIELDS, (Object[][])new String[][]{{"period asc"}}));){
            StringBuffer sBuffer = null;
            for (Row row : groupBalanceDataSet) {
                sBuffer = new StringBuffer(32);
                for (String field : this.DIMFIELDS) {
                    sBuffer.append(row.get(field));
                    sBuffer.append(this.keysplit);
                }
                String dimKey = sBuffer.toString();
                int endperiod = row.getInteger("endperiod");
                int period = row.getInteger("period");
                long id = row.getLong("id");
                String mapValue = (String)map.get(dimKey);
                if (StringUtils.isNotBlank((CharSequence)mapValue)) {
                    int lastEndPeriod = Integer.parseInt(mapValue.split(",")[0]);
                    if (period != lastEndPeriod) {
                        list.add(new Object[]{period, ((String)map.get(dimKey)).split(",")[1]});
                    }
                    map.put(dimKey, endperiod + "," + id);
                    continue;
                }
                map.clear();
                map.put(dimKey, endperiod + "," + id);
            }
        }
        if (list.size() > 0) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.endPeriodUpdateSql, list);
        }
    }
}

