/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.balance;

import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.cal.business.balance.BalanceCalculator;

public class BalanceRebuildOp
extends AbstractOperationServicePlugIn {
    private static final String ALGOKEY = "kd.fi.cal.opplugin.balance.BalanceRebuildOp";
    private static final String COSTRECORDFIELD = "entry.id as id,period as periodid,costaccount as costaccount,storageorgunit as storageorgunit,entry.ownertype as ownertype,entry.owner as owner,entry.material as material,entry.assist as assist,entry.lot as lot,entry.warehouse as warehouse,entry.location as location,entry.invtype as invtype,entry.invstatus as invstatus,entry.project as project,entry.mversion as mversion,entry.st_productcategory as st_productcategory";
    private static final String COSTADJUSTFIELD = "entryentity.id as id,period as periodid,costaccount as costaccount,entryentity.storageorgunit as storageorgunit,entryentity.ownertype as ownertype,entryentity.owner as owner,entryentity.material as material,entryentity.assist as assist,entryentity.lot as lot,entryentity.warehouse as warehouse,entryentity.location as location,entryentity.invtype as invtype,entryentity.invstatus as invstatus,entryentity.project as project,entryentity.mversion as mversion,entryentity.st_productcategory as st_productcategory";
    private static final String BALANCEFIELD = "id,period,periodid,costaccount,storageorgunit,ownertype,owner,material,assist,lot,warehouse,location,invtype,invstatus,project,mversion,st_productcategory";

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DataSet balanceDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_balance", (String)BALANCEFIELD, (QFilter[])new QFilter("period", "!=", (Object)0).toArray(), null);
        DataSet groupBalanceDataSet = balanceDataSet.copy().groupBy(new String[]{"period", "periodid", "costaccount", "storageorgunit", "ownertype", "owner", "material", "assist", "lot", "warehouse", "location", "invtype", "invstatus", "project", "mversion", "st_productcategory"}).count("id").finish();
        groupBalanceDataSet = groupBalanceDataSet.filter("id > 1");
        DataSet duplicatedBalanceSet = groupBalanceDataSet.copy().leftJoin(balanceDataSet).on("period", "period").on("periodid", "periodid").on("costaccount", "costaccount").on("storageorgunit", "storageorgunit").on("ownertype", "ownertype").on("owner", "owner").on("material", "material").on("assist", "assist").on("lot", "lot").on("warehouse", "warehouse").on("location", "location").on("invtype", "invtype").on("invstatus", "invstatus").on("project", "project").on("mversion", "mversion").on("st_productcategory", "st_productcategory").select(new String[]{"id count"}, new String[]{"id"}).finish();
        HashSet<Long> balanceIdSet = new HashSet<Long>(32);
        while (duplicatedBalanceSet.hasNext()) {
            balanceIdSet.add(duplicatedBalanceSet.next().getLong("id"));
        }
        balanceIdSet.remove(null);
        if (balanceIdSet.isEmpty()) {
            return;
        }
        DeleteServiceHelper.delete((String)"cal_balance", (QFilter[])new QFilter("id", "in", balanceIdSet).toArray());
        DeleteServiceHelper.delete((String)"cal_balance_detail", (QFilter[])new QFilter("balid", "in", balanceIdSet).toArray());
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        DataSet costRecordSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord", (String)COSTRECORDFIELD, (QFilter[])new QFilter("isinitbill", "=", (Object)Character.valueOf('0')).and("issplitcreate", "=", (Object)Character.valueOf('0')).and(billStatusf).toArray(), null);
        DataSet duplicatedRecordSet = groupBalanceDataSet.copy().leftJoin(costRecordSet).on("periodid", "periodid").on("costaccount", "costaccount").on("storageorgunit", "storageorgunit").on("ownertype", "ownertype").on("owner", "owner").on("material", "material").on("assist", "assist").on("lot", "lot").on("warehouse", "warehouse").on("location", "location").on("invtype", "invtype").on("invstatus", "invstatus").on("project", "project").on("mversion", "mversion").on("st_productcategory", "st_productcategory").select(new String[]{"id count"}, new String[]{"id"}).finish();
        HashSet<Long> costRecordEntryIdSet = new HashSet<Long>(32);
        while (duplicatedRecordSet.hasNext()) {
            costRecordEntryIdSet.add(duplicatedRecordSet.next().getLong("id"));
        }
        costRecordEntryIdSet.remove(null);
        DataSet costRecordElementDetail = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord_detail", (String)"id", (QFilter[])new QFilter("entryid", "in", costRecordEntryIdSet).toArray(), null);
        HashSet<Long> detailIdSet = new HashSet<Long>(32);
        while (costRecordElementDetail.hasNext()) {
            detailIdSet.add(costRecordElementDetail.next().getLong("id"));
        }
        detailIdSet.remove(null);
        DeleteServiceHelper.delete((String)"cal_balance_snapshoot", (QFilter[])new QFilter("mainid", "in", detailIdSet).toArray());
        BalanceCalculator calculator = new BalanceCalculator();
        calculator.updateBalance4CostRecordReCal(costRecordEntryIdSet);
        DataSet costAdjustSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costadjustbill", (String)COSTADJUSTFIELD, null, null);
        DataSet duplicatedAdjustSet = groupBalanceDataSet.leftJoin(costAdjustSet).on("periodid", "periodid").on("costaccount", "costaccount").on("storageorgunit", "storageorgunit").on("ownertype", "ownertype").on("owner", "owner").on("material", "material").on("assist", "assist").on("lot", "lot").on("warehouse", "warehouse").on("location", "location").on("invtype", "invtype").on("invstatus", "invstatus").on("project", "project").on("mversion", "mversion").on("st_productcategory", "st_productcategory").select(new String[]{"id count"}, new String[]{"id"}).finish();
        HashSet<Long> costAdjustEntryIdSet = new HashSet<Long>(32);
        while (duplicatedAdjustSet.hasNext()) {
            costAdjustEntryIdSet.add(duplicatedAdjustSet.next().getLong("id"));
        }
        costAdjustEntryIdSet.remove(null);
        calculator.updateBalance4CostAdjustReCal(costAdjustEntryIdSet.toArray());
    }
}

