/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.balance;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BalanceResolvePrecision
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("costaccount");
        e.getFieldKeys().add("currency");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] balanceDetails;
        super.beginOperationTransaction(e);
        DynamicObject[] selectValues = e.getDataEntities();
        if (selectValues == null || selectValues.length == 0) {
            return;
        }
        DynamicObject costaccount = selectValues[0].getDynamicObject("costaccount");
        int amtPrecision = selectValues[0].getInt("currency.amtprecision");
        if (amtPrecision == 0) {
            QFilter qFilter = new QFilter("id", "=", costaccount.getPkValue());
            DynamicObject queryCalpolicy = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.currency.amtprecision", (QFilter[])qFilter.toArray());
            amtPrecision = queryCalpolicy.getInt("calpolicy.currency.amtprecision");
        }
        QFilter balanceFilter = new QFilter("costaccount", "=", costaccount.getPkValue());
        balanceFilter.and(new QFilter("periodbeginactualcost", "!=", (Object)0).or("periodendactualcost", "!=", (Object)0).or("periodbeginqty", "!=", (Object)0).or("periodendqty", "!=", (Object)0));
        DynamicObject[] balances = BusinessDataServiceHelper.load((String)"cal_balance", (String)"id,baseunit.precision,periodbeginactualcost,periodbeginqty,periodendqty,periodendactualcost", (QFilter[])balanceFilter.toArray());
        if (balances == null || balances.length == 0) {
            return;
        }
        HashSet<Object> balanceIds = new HashSet<Object>(balances.length);
        HashMap<Long, Integer> qtyPrccisonMap = new HashMap<Long, Integer>(balances.length);
        for (DynamicObject dynamicObject : balances) {
            Long balid = dynamicObject.getLong("id");
            int qtyPrecision = dynamicObject.getInt("baseunit.precision");
            qtyPrccisonMap.put(balid, qtyPrecision);
            BigDecimal periodbeginactualcost = dynamicObject.getBigDecimal("periodbeginactualcost").setScale(amtPrecision, RoundingMode.DOWN);
            BigDecimal periodendactualcost = dynamicObject.getBigDecimal("periodendactualcost").setScale(amtPrecision, RoundingMode.DOWN);
            BigDecimal periodbeginqty = dynamicObject.getBigDecimal("periodbeginqty").setScale(qtyPrecision, RoundingMode.DOWN);
            BigDecimal periodendqty = dynamicObject.getBigDecimal("periodendqty").setScale(qtyPrecision, RoundingMode.DOWN);
            dynamicObject.set("periodbeginactualcost", (Object)periodbeginactualcost);
            dynamicObject.set("periodendactualcost", (Object)periodendactualcost);
            dynamicObject.set("periodbeginqty", (Object)periodbeginqty);
            dynamicObject.set("periodendqty", (Object)periodendqty);
            balanceIds.add(dynamicObject.getPkValue());
        }
        QFilter balanceDetailFilter = new QFilter("balid", "in", balanceIds);
        balanceDetailFilter.and(new QFilter("periodbeginactualcost", "!=", (Object)0).or("periodendactualcost", "!=", (Object)0).or("periodbeginqty", "!=", (Object)0).or("periodendqty", "!=", (Object)0));
        for (DynamicObject dynamicObject : balanceDetails = BusinessDataServiceHelper.load((String)"cal_balance_detail", (String)"id,balid,periodbeginactualcost,periodbeginqty,periodendqty,periodendactualcost", (QFilter[])balanceDetailFilter.toArray())) {
            Long balid = dynamicObject.getLong("balid");
            int qtyPrecision = (Integer)qtyPrccisonMap.get(balid);
            BigDecimal periodbeginactualcost = dynamicObject.getBigDecimal("periodbeginactualcost").setScale(amtPrecision, RoundingMode.DOWN);
            BigDecimal periodendactualcost = dynamicObject.getBigDecimal("periodendactualcost").setScale(amtPrecision, RoundingMode.DOWN);
            BigDecimal periodbeginqty = dynamicObject.getBigDecimal("periodbeginqty").setScale(qtyPrecision, RoundingMode.DOWN);
            BigDecimal periodendqty = dynamicObject.getBigDecimal("periodendqty").setScale(qtyPrecision, RoundingMode.DOWN);
            dynamicObject.set("periodbeginactualcost", (Object)periodbeginactualcost);
            dynamicObject.set("periodendactualcost", (Object)periodendactualcost);
            dynamicObject.set("periodbeginqty", (Object)periodbeginqty);
            dynamicObject.set("periodendqty", (Object)periodendqty);
        }
        SaveServiceHelper.save((DynamicObject[])balances);
        SaveServiceHelper.save((DynamicObject[])balanceDetails);
    }
}

