/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.balance;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.calculate.out.FIFOPeriodDataCalculate;

public class FIFOBalanceReCalOP
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject recalDyn = e.getDataEntities()[0];
        DynamicObjectCollection costAccColl = recalDyn.getDynamicObjectCollection("costaccount");
        DynamicObjectCollection filter_materialFrom = (DynamicObjectCollection)recalDyn.get("materialfrom");
        DynamicObject filter_materialTo = (DynamicObject)recalDyn.get("materialto");
        QFilter q = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        boolean hasMaterial = false;
        if (filter_materialFrom != null && !filter_materialFrom.isEmpty()) {
            if (filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (Object materialFrom : filter_materialFrom) {
                    materialSet.add(materialFrom.getDynamicObject("fbasedataid").getLong("id"));
                }
                q.and("id", "in", materialSet);
            } else if (filter_materialFrom.size() == 1) {
                q.and("number", ">=", (Object)((DynamicObject)filter_materialFrom.get(0)).getDynamicObject("fbasedataid").getString("number"));
            }
            hasMaterial = true;
        }
        if (filter_materialTo != null) {
            q.and("number", "<=", (Object)filter_materialTo.getString("number"));
            hasMaterial = true;
        }
        HashSet<Long> matIds = new HashSet<Long>(16);
        if (hasMaterial) {
            Object materialFrom;
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id", (QFilter[])q.toArray(), null);
            materialFrom = null;
            try {
                for (Row row : dataSet) {
                    matIds.add(row.getLong("id"));
                }
            }
            catch (Throwable throwable) {
                materialFrom = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (materialFrom != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)materialFrom).addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        for (DynamicObject costAcc : costAccColl) {
            if (hasMaterial) {
                Lists.partition(new ArrayList(matIds), (int)10000).forEach(list -> new FIFOPeriodDataCalculate(costAcc.getDynamicObject("fbasedataid").getLong("id"), new HashSet(list)).reCalBeginData());
                continue;
            }
            new FIFOPeriodDataCalculate(costAcc.getDynamicObject("fbasedataid").getLong("id"), matIds).reCalBeginData();
        }
    }
}

