/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.balance;

import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.helper.RepairStandardCostHelper;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.PeriodHelper;

public class RepairStandardCostOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] billInfos = this.getDataEntities();
                DynamicObject info = billInfos[0].getDataEntity();
                DynamicObject costAccount = info.getDynamicObject("costaccount");
                DynamicObject period = info.getDynamicObject("period");
                if (period == null) {
                    this.addErrorMessage(billInfos[0], ResManager.loadKDString((String)"\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"BalanceReCalOp_1", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
                if (period.getLong("id") != curPeriod.getLong("id")) {
                    this.addErrorMessage(billInfos[0], ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u5df2\u6709\u53d8\u52a8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u5237\u65b0\u671f\u95f4\u3002", (String)"BalanceReCalOp_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject info = e.getDataEntities()[0];
        DynamicObject filter_costAccount = (DynamicObject)info.get("costaccount");
        Long costaccountId = Long.valueOf(filter_costAccount.getPkValue().toString());
        DynamicObject filter_period = (DynamicObject)info.get("period");
        int filter_periodNumber = filter_period.getInt("periodyear") * 100 + filter_period.getInt("periodnumber");
        HashSet<Long> calrangeIds = new HashSet<Long>(16);
        DynamicObjectCollection filter_calrange = info.getDynamicObjectCollection("calrange");
        if (filter_calrange != null && !filter_calrange.isEmpty()) {
            for (DynamicObject dynamicObject : filter_calrange) {
                Long calrangeId = Long.valueOf(dynamicObject.getDynamicObject("fbasedataid").getPkValue().toString());
                calrangeIds.add(calrangeId);
            }
        }
        HashSet<Long> storageOrgIds = new HashSet<Long>(16);
        DynamicObjectCollection filter_storageOrg = info.getDynamicObjectCollection("storageorgunit");
        if (filter_storageOrg != null && !filter_storageOrg.isEmpty()) {
            for (DynamicObject dynamicObject : filter_storageOrg) {
                Long storageOrgId = Long.valueOf(dynamicObject.getDynamicObject("fbasedataid").getPkValue().toString());
                storageOrgIds.add(storageOrgId);
            }
        }
        DynamicObjectCollection filter_materialFrom = (DynamicObjectCollection)info.get("materialfrom");
        DynamicObject filter_materialTo = (DynamicObject)info.get("materialto");
        Set<Object> materialIdsSet = new HashSet();
        materialIdsSet = this.getMaterialIdsSet(filter_costAccount, calrangeIds, storageOrgIds, filter_periodNumber, filter_materialFrom, filter_materialTo);
        Long calorgid = filter_costAccount.getLong("calorg_id");
        String calType = info.getString("caltype");
        try (AlgoContext context = Algo.newContext();){
            String[] balanceFields;
            RepairStandardCostHelper repairStandardCostHelper = new RepairStandardCostHelper(calorgid);
            DataSet balanceDS = repairStandardCostHelper.getBalanceDataSet(costaccountId, filter_period, calrangeIds, materialIdsSet, storageOrgIds, calorgid, calType, null, null);
            if (balanceDS == null) {
                return;
            }
            balanceDS = balanceDS.filter("costsubelement != 0");
            StringBuilder newFieldsb = new StringBuilder();
            StringBuilder newFieldGsb = new StringBuilder();
            for (String field : balanceFields = balanceDS.getRowMeta().getFieldNames()) {
                if ("periodendstandardcost".equals(field) || "unitstandardcost".equals(field) || "periodendqty".equals(field)) continue;
                newFieldsb.append(field);
                newFieldsb.append(",");
                if ("costelement".equals(field) || "costsubelement".equals(field) || "id".equals(field)) continue;
                newFieldGsb.append(field);
                newFieldGsb.append(",");
            }
            String newFieldStr = newFieldsb.substring(0, newFieldsb.length() - 1);
            String newFieldGStr = newFieldGsb.substring(0, newFieldGsb.length() - 1);
            DataSet materialCostInfoDS = repairStandardCostHelper.getMatCostInfoDataSet(calorgid, materialIdsSet, filter_period, costaccountId, storageOrgIds, calType, balanceDS.copy(), newFieldGStr);
            if (materialCostInfoDS == null) {
                return;
            }
            DataSet balanceDataSetCopy = balanceDS.copy();
            materialCostInfoDS = materialCostInfoDS.select(balanceDS.getRowMeta().getFieldNames());
            String groupSts = newFieldStr.replace(",id,", ",") + ",periodendstandardcost,unitstandardcost,periodendqty";
            materialCostInfoDS = materialCostInfoDS.groupBy(groupSts.split(",")).finish();
            DataSet allDataSet = balanceDS.select(materialCostInfoDS.getRowMeta().getFieldNames()).union(materialCostInfoDS).groupBy(newFieldStr.replace(",id,", ",").split(",")).sum("periodendstandardcost").sum("unitstandardcost").sum("periodendqty").finish();
            repairStandardCostHelper.createDiffBill(balanceDataSetCopy, allDataSet, calorgid, (Object)costaccountId, filter_period.getDate("begindate"), newFieldGStr);
        }
    }

    private Set<Long> getMaterialIdsSet(DynamicObject filter_costAccount, Set<Long> calrangeIds, Set<Long> storageOrgIds, int filter_periodNumber, DynamicObjectCollection filter_materialFrom, DynamicObject filter_materialTo) {
        HashSet<Long> materialIdsSet = new HashSet<Long>();
        QFilter filter = new QFilter("costaccount", "=", filter_costAccount.getPkValue());
        filter.and("endperiod", ">", (Object)filter_periodNumber);
        filter.and("period", "<=", (Object)filter_periodNumber);
        filter.and("accounttype", "=", (Object)AccountTypeEnum.STANDARDCOST.getValue());
        if (calrangeIds != null && calrangeIds.size() > 0) {
            filter.and("calrange", "in", calrangeIds);
        }
        if (storageOrgIds != null && storageOrgIds.size() > 0) {
            filter.and("storageorgunit", "in", storageOrgIds);
        }
        if (filter_materialFrom != null && !filter_materialFrom.isEmpty()) {
            if (filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : filter_materialFrom) {
                    materialSet.add(materialFrom.getDynamicObject("fbasedataid").getLong("id"));
                }
                filter.and("material.id", "in", materialSet);
            } else if (filter_materialFrom.size() == 1) {
                filter.and("material.number", ">=", (Object)((DynamicObject)filter_materialFrom.get(0)).getDynamicObject("fbasedataid").getString("number"));
            }
        }
        if (filter_materialTo != null) {
            filter.and("material.number", "<=", (Object)filter_materialTo.getString("number"));
        }
        DataSet balanceDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)"material", (QFilter[])filter.toArray(), null);
        for (Row row : balanceDS) {
            materialIdsSet.add(row.getLong("material"));
        }
        return materialIdsSet;
    }
}

