/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.balance;

import java.util.Collections;
import java.util.HashSet;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.cal.business.balance.PurPriceDiffCalculator;
import kd.fi.cal.common.helper.CalDLockHelper;
import kd.fi.cal.common.helper.PeriodHelper;

public class StdCostDiffRecalOp
extends AbstractOperationServicePlugIn {
    private static final String ALGOKEY = "kd.fi.cal.opplugin.balance.StdCostDiffRecalOp";
    private int filter_periodNumber;
    private DynamicObject costAccount;
    private DynamicObject filter_period;
    private DynamicObjectCollection filter_materialFrom;
    private DynamicObject filter_materialTo;
    private DynamicObjectCollection filter_owner;
    private DynamicObjectCollection filter_storageOrg;
    private DynamicObjectCollection filter_warehouse;
    private static final String DLOCK_KEY = "stdcostdiffrecal";

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] billInfos = this.getDataEntities();
                DynamicObject info = billInfos[0].getDataEntity();
                DynamicObject costAccount = info.getDynamicObject("costaccount");
                DynamicObject period = info.getDynamicObject("period");
                if (period == null) {
                    this.addErrorMessage(billInfos[0], ResManager.loadKDString((String)"\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"BalanceReCalOp_1", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
                if (period.getLong("id") != curPeriod.getLong("id")) {
                    this.addErrorMessage(billInfos[0], ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u5df2\u6709\u53d8\u52a8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u5237\u65b0\u671f\u95f4\u3002", (String)"BalanceReCalOp_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.init(e.getDataEntities()[0]);
        String key = DLOCK_KEY + this.costAccount.getLong("id");
        DLock lock = DLock.createReentrant((String)key, (String)"fi-cal-stdcostdiffrecal-dlock");
        CalDLockHelper.releaseLockAfterTxEnd(Collections.singletonList(lock));
        try (TraceSpan span = Tracer.create((String)"StdCostDiffRecalOp-begin", (String)"StdCostDiffRecalOp-begin");
             AlgoContext context = Algo.newContext();){
            boolean isLockSuccess = lock.tryLock();
            if (!isLockSuccess) {
                String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6b63\u5728\u6807\u51c6\u6210\u672c\u5dee\u5f02\u4f59\u989d\u91cd\u7b97\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BalanceReCalOp_2", (String)"fi-cal-opplugin", (Object[])new Object[0]), this.costAccount.getString("name"));
                throw new KDBizException(msg);
            }
            HashSet<Long> balSet = new HashSet<Long>();
            DataSet balDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_purpricediff", (String)"id", (QFilter[])this.getBalFilter(false).toArray(), null);
            for (Row row : balDataSet) {
                balSet.add(row.getLong("id"));
            }
            DeleteServiceHelper.delete((String)"cal_purpricediff", (QFilter[])new QFilter("id", "in", balSet).toArray());
            DeleteServiceHelper.delete((String)"cal_purpricediff_detail", (QFilter[])new QFilter("balid", "in", balSet).toArray());
            DataSet costAdjustDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costadjustbill", (String)"entryentity.id,period", (QFilter[])this.getCostAdjustFilter().toArray(), null);
            DataSet copyCostAdjustDataSet = costAdjustDataSet.copy().groupBy(new String[]{"period"}).finish().orderBy(new String[]{"period asc"});
            HashSet<Long> entryIdSet = new HashSet<Long>();
            for (Row row : copyCostAdjustDataSet) {
                long periodid = row.getLong("period");
                DataSet adjustDataSet = costAdjustDataSet.copy().filter("period = " + periodid);
                for (Row row1 : adjustDataSet) {
                    entryIdSet.add(row1.getLong("entryentity.id"));
                }
                if (entryIdSet.isEmpty()) continue;
                new PurPriceDiffCalculator().updatePurPriceDiff4CostAdjust(entryIdSet.toArray());
                entryIdSet.clear();
            }
        }
    }

    private void init(DynamicObject info) {
        this.costAccount = (DynamicObject)info.get("costaccount");
        this.filter_period = (DynamicObject)info.get("period");
        this.filter_periodNumber = this.filter_period.getInt("periodyear") * 100 + this.filter_period.getInt("periodnumber");
        this.filter_materialFrom = (DynamicObjectCollection)info.get("materialfrom");
        this.filter_materialTo = (DynamicObject)info.get("materialto");
        this.filter_owner = info.getDynamicObjectCollection("owner");
        this.filter_storageOrg = info.getDynamicObjectCollection("storageorgunit");
        this.filter_warehouse = info.getDynamicObjectCollection("warehouse");
    }

    private QFilter getCostAdjustFilter() {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.costAccount.getPkValue());
        q.and("period", ">=", this.filter_period.getPkValue());
        q.and("billstatus", "=", (Object)"C");
        q.and("difftype", "<>", (Object)"B");
        if (this.filter_materialFrom != null && !this.filter_materialFrom.isEmpty()) {
            if (this.filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : this.filter_materialFrom) {
                    materialSet.add(materialFrom.getDynamicObject("fbasedataid").getLong("id"));
                }
                q.and("entryentity.material.id", "in", materialSet);
            } else if (this.filter_materialFrom.size() == 1) {
                q.and("entryentity.material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getDynamicObject("fbasedataid").getString("number"));
            }
        }
        if (this.filter_materialTo != null) {
            q.and("entryentity.material.number", "<=", (Object)this.filter_materialTo.getString("number"));
        }
        if (this.filter_owner != null && !this.filter_owner.isEmpty()) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_owner) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("entryentity.owner", "in", set);
        }
        if (this.filter_storageOrg != null && !this.filter_storageOrg.isEmpty()) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("entryentity.storageorgunit", "in", set);
        }
        if (this.filter_warehouse != null && !this.filter_warehouse.isEmpty()) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("entryentity.warehouse", "in", set);
        }
        return q;
    }

    private QFilter getBalFilter(boolean filterEndPeriod) {
        HashSet<Object> set;
        QFilter q = new QFilter("costaccount", "=", this.costAccount.getPkValue());
        if (filterEndPeriod) {
            q.and("endperiod", ">=", (Object)this.filter_periodNumber);
        } else {
            q.and("period", ">=", (Object)this.filter_periodNumber);
        }
        if (this.filter_materialFrom != null && !this.filter_materialFrom.isEmpty()) {
            if (this.filter_materialFrom.size() > 1) {
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject materialFrom : this.filter_materialFrom) {
                    materialSet.add(materialFrom.getDynamicObject("fbasedataid").getLong("id"));
                }
                q.and("material.id", "in", materialSet);
            } else if (this.filter_materialFrom.size() == 1) {
                q.and("material.number", ">=", (Object)((DynamicObject)this.filter_materialFrom.get(0)).getDynamicObject("fbasedataid").getString("number"));
            }
        }
        if (this.filter_materialTo != null) {
            q.and("material.number", "<=", (Object)this.filter_materialTo.getString("number"));
        }
        if (this.filter_owner != null && !this.filter_owner.isEmpty()) {
            set = new HashSet<Object>();
            for (DynamicObject info : this.filter_owner) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("owner", "in", set);
        }
        if (this.filter_storageOrg != null && !this.filter_storageOrg.isEmpty()) {
            set = new HashSet();
            for (DynamicObject info : this.filter_storageOrg) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("storageorgunit", "in", set);
        }
        if (this.filter_warehouse != null && !this.filter_warehouse.isEmpty()) {
            set = new HashSet();
            for (DynamicObject info : this.filter_warehouse) {
                set.add(info.getDynamicObject("fbasedataid").getPkValue());
            }
            q.and("warehouse", "in", set);
        }
        return q;
    }
}

