/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.base;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.cal.business.autosort.AutoSortHelperNew;
import kd.fi.cal.business.calculate.billgroup.AutoSortServic;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.MaterialHelper;
import kd.fi.cal.common.helper.StopSyncSettingModifyHelper;
import kd.fi.cal.opplugin.base.CalBaseAuditOrUnAuditOP;
import kd.fi.cal.opplugin.base.WriteBackCostRecordAccTypeHelper;
import kd.fi.cal.opplugin.validator.MatAccountAndDimValidator;

public class AccountTypeAuditOrUnAuditOP
extends CalBaseAuditOrUnAuditOP {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        String key = (String)this.operateMeta.get("type");
        if ("audit".equals(key) || "unaudit".equals(key)) {
            e.addValidator((AbstractValidator)new MatAccountAndDimValidator());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] infos;
        String key = e.getOperationKey();
        for (DynamicObject info : infos = e.getDataEntities()) {
            if ("unaudit".equals(key)) {
                this.doUnAudit(info);
                continue;
            }
            if (!"audit".equals(key)) continue;
            this.doAudit(info);
        }
        super.endOperationTransaction(e);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doAudit(DynamicObject info) {
        DynamicObject calRange = info.getDynamicObject("calrange");
        DynamicObject costAccount = calRange.getDynamicObject("costaccount");
        costAccount = BusinessDataServiceHelper.loadSingleFromCache((Object)costAccount.getPkValue(), (String)"cal_bd_costaccount");
        DynamicObjectCollection coll = info.getDynamicObjectCollection("entry");
        HashSet<Long> calOrgIdSet = new HashSet<Long>(1);
        calOrgIdSet.add(costAccount.getDynamicObject("calorg").getLong("id"));
        new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, null, null, new HashSet(), true, TimeServiceHelper.now());
        boolean needNewTx = false;
        try {
            HashSet<Long> totalMaterialSet = new HashSet<Long>(16);
            for (DynamicObject entry : coll) {
                DynamicObject material = entry.getDynamicObject("material");
                HashSet<Long> materialSet = new HashSet<Long>();
                if (material != null) {
                    materialSet.add(material.getLong("id"));
                } else {
                    DynamicObject materialGroup = entry.getDynamicObject("materialgroup");
                    String groupLongNumber = materialGroup.getString("longnumber");
                    materialSet.addAll(MaterialHelper.getAllMaterialByMaterialGroup((String)groupLongNumber));
                }
                totalMaterialSet.addAll(materialSet);
                this.writeBackBill(costAccount.getLong("id"), calRange.getLong("id"), materialSet, this.getMainValueByEntry(entry));
            }
            if (AcctGroupModelHelper.isNewGroupModel()) {
                AutoSortServic sortService = new AutoSortServic();
                Set<Long> acctIds = Collections.singleton(costAccount.getLong("id"));
                try (TraceSpan span = Tracer.create((String)"sortByAcctIds", (String)"sortByAcctIds");){
                    sortService.sortByAsyncByAccountId(acctIds);
                    return;
                }
            }
            QFilter sortFilter = new QFilter("calrange", "=", (Object)calRange.getLong("id"));
            if (!QueryServiceHelper.exists((String)"cal_sortresult", (QFilter[])(sortFilter = sortFilter.and("material", "in", totalMaterialSet)).toArray())) return;
            String desc = ResManager.loadKDString((String)"\u7269\u6599\u8ba1\u4ef7\u65b9\u6cd5\u8bbe\u7f6e\u5ba1\u6838", (String)"AccountTypeAuditOrUnAuditOP_1", (String)"fi-cal-opplugin", (Object[])new Object[0]);
            new AutoSortHelperNew().rebuildAllSortResultByCostAccounts(Collections.singleton(costAccount.getLong("id")), desc);
            return;
        }
        catch (Throwable e) {
            needNewTx = true;
            throw e;
        }
        finally {
            if (needNewTx) {
                TXHandle tx = TX.requiresNew();
                Object object = null;
                try {
                    new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, null, null, new HashSet(), false, TimeServiceHelper.now());
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (tx != null) {
                        if (object != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            } else {
                new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, null, null, new HashSet(), false, TimeServiceHelper.now());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doUnAudit(DynamicObject info) {
        DynamicObject calRange = info.getDynamicObject("calrange");
        DynamicObject costAccount = calRange.getDynamicObject("costaccount");
        costAccount = BusinessDataServiceHelper.loadSingleFromCache((Object)costAccount.getPkValue(), (String)"cal_bd_costaccount");
        DynamicObjectCollection coll = info.getDynamicObjectCollection("entry");
        HashSet<Long> materialSet = new HashSet<Long>();
        for (DynamicObject entry : coll) {
            DynamicObject material = entry.getDynamicObject("material");
            if (material != null) {
                materialSet.add(material.getLong("id"));
                continue;
            }
            DynamicObject materialGroup = entry.getDynamicObject("materialgroup");
            String groupLongNumber = materialGroup.getString("longnumber");
            materialSet.addAll(MaterialHelper.getAllMaterialByMaterialGroup((String)groupLongNumber));
        }
        HashSet<Long> calOrgIdSet = new HashSet<Long>(1);
        calOrgIdSet.add(costAccount.getDynamicObject("calorg").getLong("id"));
        new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, null, null, new HashSet(), true, TimeServiceHelper.now());
        boolean needNewTx = false;
        try {
            this.writeBackBill(costAccount.getLong("id"), calRange.getLong("id"), materialSet, this.getMainValueByCalrange(calRange));
            QFilter sortFilter = new QFilter("calrange", "=", (Object)calRange.getLong("id"));
            sortFilter = sortFilter.and("material", "in", materialSet);
            if (!QueryServiceHelper.exists((String)"cal_sortresult", (QFilter[])sortFilter.toArray())) return;
            String desc = ResManager.loadKDString((String)"\u7269\u6599\u8ba1\u4ef7\u65b9\u6cd5\u8bbe\u7f6e\u53cd\u5ba1\u6838", (String)"AccountTypeAuditOrUnAuditOP_0", (String)"fi-cal-opplugin", (Object[])new Object[0]);
            new AutoSortHelperNew().rebuildAllSortResultByCostAccounts(Collections.singleton(costAccount.getLong("id")), desc);
            return;
        }
        catch (Throwable e) {
            needNewTx = true;
            throw e;
        }
        finally {
            if (needNewTx) {
                try (TXHandle tx = TX.requiresNew();){
                    new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, null, null, new HashSet(), false, TimeServiceHelper.now());
                }
            } else {
                new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, null, null, new HashSet(), false, TimeServiceHelper.now());
            }
        }
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("calrange");
        e.getFieldKeys().add("calrange.costaccount");
        e.getFieldKeys().add("calrange.costaccount.calorg");
        e.getFieldKeys().add("calrange.accounttype");
        e.getFieldKeys().add("calrange.caldimension");
        e.getFieldKeys().add("entry.id");
        e.getFieldKeys().add("entry.material");
        e.getFieldKeys().add("entry.materialgroup");
        e.getFieldKeys().add("entry.materialgroup.longnumber");
        e.getFieldKeys().add("entry.accounttype");
        super.onPreparePropertys(e);
    }

    protected Object getMainValueByEntry(DynamicObject entry) {
        return entry.getString("accounttype");
    }

    protected Object getMainValueByCalrange(DynamicObject calRange) {
        return calRange.getString("accounttype");
    }

    protected void writeBackBill(long costAccountId, long calRangeId, Set<Long> materialSet, Object mainValue) {
        WriteBackCostRecordAccTypeHelper.writeBack4AccountTypeChanged(costAccountId, calRangeId, materialSet, (String)mainValue);
    }
}

