/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.base;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.cal.business.autosort.AutoSortHelperNew;
import kd.fi.cal.common.helper.MaterialHelper;
import kd.fi.cal.common.helper.StopSyncSettingModifyHelper;
import kd.fi.cal.opplugin.base.WriteBackCostRecordAccTypeHelper;

public class AccountTypeDisableOP
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("calorg");
        e.getFieldKeys().add("calrange");
        e.getFieldKeys().add("calrange.costaccount");
        e.getFieldKeys().add("calrange.accounttype");
        e.getFieldKeys().add("calrange.caldimension");
        e.getFieldKeys().add("entry.id");
        e.getFieldKeys().add("entry.material");
        e.getFieldKeys().add("entry.materialgroup");
        e.getFieldKeys().add("entry.materialgroup.longnumber");
        e.getFieldKeys().add("entry.accounttype");
    }

    public String getMainEntityName() {
        return "cal_bd_accounttype";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] infos = e.getDataEntities();
        HashSet<Long> calOrgIdSet = new HashSet<Long>(1);
        HashSet<Long> costaccountIds = new HashSet<Long>(4);
        for (DynamicObject info : infos) {
            calOrgIdSet.add(info.getDynamicObject("calorg").getLong("id"));
            costaccountIds.add(info.getDynamicObject("calrange").getLong("costaccount.id"));
        }
        try {
            new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, null, null, new HashSet(1), true, TimeServiceHelper.now());
            boolean isExistSort = false;
            for (DynamicObject info : infos) {
                DynamicObject calRange = info.getDynamicObject("calrange");
                DynamicObject costAccount = calRange.getDynamicObject("costaccount");
                DynamicObjectCollection coll = info.getDynamicObjectCollection("entry");
                HashSet<Long> materialSet = new HashSet<Long>();
                for (DynamicObject entry : coll) {
                    DynamicObject material = entry.getDynamicObject("material");
                    if (material != null) {
                        materialSet.add(material.getLong("id"));
                        continue;
                    }
                    DynamicObject materialGroup = entry.getDynamicObject("materialgroup");
                    String groupLongNumber = materialGroup.getString("longnumber");
                    materialSet.addAll(MaterialHelper.getAllMaterialByMaterialGroup((String)groupLongNumber));
                }
                this.writeBackBill(costAccount.getLong("id"), calRange.getLong("id"), materialSet, this.getMainValueByCalrange(calRange));
                if (isExistSort) continue;
                QFilter sortFilter = new QFilter("calrange", "=", (Object)calRange.getLong("id"));
                sortFilter = sortFilter.and("material", "in", materialSet);
                isExistSort = QueryServiceHelper.exists((String)"cal_sortresult", (QFilter[])sortFilter.toArray());
            }
            if (isExistSort) {
                String desc = ResManager.loadKDString((String)"\u7269\u6599\u8ba1\u4ef7\u65b9\u6cd5\u8bbe\u7f6e\u7981\u7528", (String)"AccountTypeDisableOP_0", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                new AutoSortHelperNew().rebuildAllSortResultByCostAccounts(costaccountIds, desc);
            }
        }
        finally {
            new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, null, null, new HashSet(1), false, TimeServiceHelper.now());
        }
    }

    protected Object getMainValueByCalrange(DynamicObject calRange) {
        return calRange.getString("accounttype");
    }

    protected void writeBackBill(long costAccountId, long calRangeId, Set<Long> materialSet, Object mainValue) {
        WriteBackCostRecordAccTypeHelper.writeBack4AccountTypeChanged(costAccountId, calRangeId, materialSet, (String)mainValue);
    }
}

