/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.base;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cal.opplugin.validator.AccountTypeDuplicateValidator;

public class AccountTypeSaveOrSubmitOP
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("calrange");
        e.getFieldKeys().add("entry.material");
        e.getFieldKeys().add("entry.materialgroup");
        e.getFieldKeys().add("entry.seq");
        e.getFieldKeys().add(this.getMainKey());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        String key;
        Map map = this.getOption().getVariables();
        boolean importFlag = false;
        if (map != null && map.containsKey("importtype")) {
            importFlag = true;
        }
        if ("save".equals(key = (String)this.operateMeta.get("type")) && !importFlag) {
            return;
        }
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    this.doCheck(dataEntity);
                }
            }

            private void doCheck(ExtendedDataEntity dataEntity) {
                DynamicObject dynamicObject = dataEntity.getDataEntity();
                DynamicObjectCollection coll = dynamicObject.getDynamicObjectCollection("entry");
                int i = 0;
                HashSet<String> materialNumbers = new HashSet<String>();
                for (DynamicObject entry : coll) {
                    String materialNumber;
                    String msg;
                    DynamicObject material = entry.getDynamicObject("material");
                    DynamicObject materialGroup = entry.getDynamicObject("materialgroup");
                    if (material == null && materialGroup == null) {
                        msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c\u7269\u6599\u548c\u7269\u6599\u5206\u7c7b\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"AccountTypeSaveOrSubmitOP_1", (String)"fi-cal-opplugin", (Object[])new Object[0]), i + 1);
                        this.addErrorMessage(dataEntity, msg);
                    }
                    if (material != null && materialGroup != null) {
                        msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c\u7269\u6599\u548c\u7269\u6599\u5206\u7c7b\u53ea\u80fd\u7ef4\u62a4\u4e00\u4e2a\u3002", (String)"AccountTypeSaveOrSubmitOP_3", (String)"fi-cal-opplugin", (Object[])new Object[0]), i + 1);
                        this.addErrorMessage(dataEntity, msg);
                    }
                    if (material != null && !materialNumbers.add(materialNumber = material.getString("number"))) {
                        String msg2 = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c\u6709\u91cd\u590d\u7684\u7269\u6599\u7f16\u7801: ", (String)"AccountTypeSaveOrSubmitOP_2", (String)"fi-cal-opplugin", (Object[])new Object[0]), i + 1);
                        this.addErrorMessage(dataEntity, msg2);
                    }
                    ++i;
                }
            }
        });
        AccountTypeDuplicateValidator v = new AccountTypeDuplicateValidator();
        v.setEntity(this.getMainEntityName());
        e.addValidator((AbstractValidator)v);
    }

    public String getMainKey() {
        return "entry.accounttype";
    }

    public String getMainEntityName() {
        return "cal_bd_accounttype";
    }
}

