/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.base;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.util.CommonUtils;

public class CalCosttypeOrgRelationConfirmOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CalCosttypeOrgRelationConfirmOp.class);
    private static final String ID = "id";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String CONFIRM_IDS = "contirmids";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add(CONFIRM_IDS);
        e.getFieldKeys().add(ID);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String contirmIds = null;
        DynamicObject[] infos = e.getDataEntities();
        Date date = TimeServiceHelper.now();
        if (infos != null && infos.length > 0) {
            ArrayList<Object[]> confirmList = new ArrayList<Object[]>();
            contirmIds = infos[0].getString(CONFIRM_IDS);
            DynamicObjectCollection coll = infos[0].getDynamicObjectCollection(ENTRY_ENTITY);
            if (!StringUtils.isBlank((String)contirmIds)) {
                logger.info("-------beginOperationTransaction-------contirmIds=" + contirmIds);
                for (DynamicObject data : coll) {
                    String id = data.getString(ID);
                    if (!contirmIds.contains(id)) continue;
                    confirmList.add(new Object[]{"1", date, Long.parseLong(id)});
                }
            }
            if (confirmList.size() > 0) {
                String sql = "update t_cal_costtypeorg set fbizstatus = ?,fconfirmdate = ? where fid = ?";
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, confirmList);
            }
        }
    }
}

