/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.base;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.StopSyncSettingModifyHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;

public class CalCosttypeOrgRelationCosttypeUpdateOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CalCosttypeOrgRelationCosttypeUpdateOp.class);
    private static final String ID = "id";
    private static final String COST_TYPE = "costtype";
    private static final String COST_ACCOUNT = "costaccount";
    private static final String CAL_ORG = "calorg";
    private static final String STORAGE_ORG = "storageorgunit";
    private static final String BIZ_STATUS = "bizstatus";
    private static final String CONFIRM_DATE = "confirmdate";
    private static final String EFFECK_DATE = "effectdate";
    private static final String INVALID_DATE = "invaliddate";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String COSTTYPE_UPDATE_ID = "costtypeupdateid";
    private static final String TARGET_COSTTYPE_ID = "targetcosttypeid";
    private static final String EFFECT_TIME = "effectime";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add(ID);
        e.getFieldKeys().add(COST_TYPE);
        e.getFieldKeys().add(COST_ACCOUNT);
        e.getFieldKeys().add(CAL_ORG);
        e.getFieldKeys().add(STORAGE_ORG);
        e.getFieldKeys().add(BIZ_STATUS);
        e.getFieldKeys().add(EFFECK_DATE);
        e.getFieldKeys().add(INVALID_DATE);
        e.getFieldKeys().add(CONFIRM_DATE);
        e.getFieldKeys().add(COSTTYPE_UPDATE_ID);
        e.getFieldKeys().add(TARGET_COSTTYPE_ID);
        e.getFieldKeys().add(EFFECT_TIME);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String costtypeupdateId = null;
        String targetcosttypeid = null;
        String effectime = null;
        DynamicObject[] infos = e.getDataEntities();
        if (infos != null && infos.length > 0) {
            costtypeupdateId = infos[0].getString(COSTTYPE_UPDATE_ID);
            targetcosttypeid = infos[0].getString(TARGET_COSTTYPE_ID);
            effectime = infos[0].getString(EFFECT_TIME);
            logger.info("-----costtypeupdateId=" + costtypeupdateId);
            logger.info("-----targetcosttypeid=" + targetcosttypeid);
            logger.info("-----effectime=" + effectime);
            if (!StringUtils.isBlank((String)costtypeupdateId)) {
                DynamicObjectCollection coll = infos[0].getDynamicObjectCollection(ENTRY_ENTITY);
                Date nowTime = null;
                if (!StringUtils.isBlank((String)effectime)) {
                    Calendar c = Calendar.getInstance();
                    c.setTimeInMillis(Long.parseLong(effectime));
                    nowTime = c.getTime();
                }
                for (DynamicObject data : coll) {
                    String id = data.getString(ID);
                    if (!costtypeupdateId.equals(id)) continue;
                    DynamicObject costaccount = data.getDynamicObject(COST_ACCOUNT);
                    DynamicObject calorg = data.getDynamicObject(CAL_ORG);
                    DynamicObject storageorg = data.getDynamicObject(STORAGE_ORG);
                    String bizstatus = data.getString(BIZ_STATUS);
                    String sql = "update t_cal_costtypeorg set finvaliddate=? where fid = ?";
                    Object[] obj = new Object[]{nowTime, Long.parseLong(id)};
                    DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, (Object[])obj);
                    DynamicObject info = BusinessDataServiceHelper.newDynamicObject((String)"cal_bd_costtypeorg");
                    info.set(COST_ACCOUNT, costaccount.getPkValue());
                    info.set(CAL_ORG, calorg.getPkValue());
                    if (storageorg != null) {
                        info.set(STORAGE_ORG, storageorg.getPkValue());
                    }
                    info.set(COST_TYPE, (Object)targetcosttypeid);
                    info.set(BIZ_STATUS, (Object)bizstatus);
                    info.set(CONFIRM_DATE, (Object)nowTime);
                    info.set(EFFECK_DATE, (Object)nowTime);
                    info.set(INVALID_DATE, (Object)DateUtils.getDateByInt((int)2999, (int)11, (int)31, (int)23, (int)59, (int)59));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
                    Long calorgid = calorg.getLong(ID);
                    if (storageorg == null) break;
                    Long storageorgid = storageorg.getLong(ID);
                    this.startSyncBizBill(calorgid, storageorgid);
                    break;
                }
            }
        }
    }

    private void startSyncBizBill(Long calorgid, Long storageorgid) {
        Date nowTime = TimeServiceHelper.now();
        HashSet<Long> calorgIdSet = new HashSet<Long>();
        calorgIdSet.add(calorgid);
        new StopSyncSettingModifyHelper().modifySetting(calorgIdSet, storageorgid, "D", null, null, false, nowTime);
    }
}

