/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.base;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.util.CommonUtils;

public class CalCosttypeOrgRelationSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CalCosttypeOrgRelationSaveOp.class);
    private static final String ID = "id";
    private static final String COST_TYPE = "costtype";
    private static final String COST_ACCOUNT = "costaccount";
    private static final String CAL_ORG = "calorg";
    private static final String STORAGE_ORG = "storageorgunit";
    private static final String BIZ_STATUS = "bizstatus";
    private static final String CONFIRM_DATE = "confirmdate";
    private static final String EFFECK_DATE = "effectdate";
    private static final String INVALID_DATE = "invaliddate";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String UPDATE_IDS = "updateids";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add(ID);
        e.getFieldKeys().add(COST_TYPE);
        e.getFieldKeys().add(COST_ACCOUNT);
        e.getFieldKeys().add(CAL_ORG);
        e.getFieldKeys().add(STORAGE_ORG);
        e.getFieldKeys().add(BIZ_STATUS);
        e.getFieldKeys().add(EFFECK_DATE);
        e.getFieldKeys().add(INVALID_DATE);
        e.getFieldKeys().add(CONFIRM_DATE);
        e.getFieldKeys().add(UPDATE_IDS);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String updateIds = this.dataEntities[0].getDataEntity().getString(CalCosttypeOrgRelationSaveOp.UPDATE_IDS);
                DynamicObjectCollection coll = this.dataEntities[0].getDataEntity().getDynamicObjectCollection(CalCosttypeOrgRelationSaveOp.ENTRY_ENTITY);
                HashSet unionSet = new HashSet();
                for (DynamicObject data : coll) {
                    String id = data.getString(CalCosttypeOrgRelationSaveOp.ID);
                    if (StringUtils.isBlank((String)id) || "0".equals(id)) {
                        if (!CalCosttypeOrgRelationSaveOp.this.checkCostaccountEnable(data)) {
                            this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8d26\u7c3f\u5df2\u7981\u7528\u3002", (String)"CalCosttypeOrgRelationSaveOp_2", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                            return;
                        }
                        if (!CalCosttypeOrgRelationSaveOp.this.checkMultifactoryaccount(data)) {
                            this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5df2\u7ecf\u542f\u7528\u591a\u5de5\u5382\u6838\u7b97\uff0c\u5fc5\u987b\u5f55\u5165\u5bf9\u5e94\u7684\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"CalCosttypeOrgRelationSaveOp_1", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                            return;
                        }
                        if (CalCosttypeOrgRelationSaveOp.this.checkOrgCostaccountUnique(data, unionSet)) continue;
                        this.showOrgCostaccountUniqueMsg(data);
                        return;
                    }
                    logger.info("-----onAddValidators-------updateIds=" + updateIds);
                    if (StringUtils.isBlank((String)updateIds) || !updateIds.contains(id)) continue;
                    if (!CalCosttypeOrgRelationSaveOp.this.checkCostaccountEnable(data)) {
                        this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8d26\u7c3f\u5df2\u7981\u7528\u3002", (String)"CalCosttypeOrgRelationSaveOp_2", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (!CalCosttypeOrgRelationSaveOp.this.checkMultifactoryaccount(data)) {
                        this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5df2\u7ecf\u542f\u7528\u591a\u5de5\u5382\u6838\u7b97\uff0c\u5fc5\u987b\u5f55\u5165\u5bf9\u5e94\u7684\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"CalCosttypeOrgRelationSaveOp_1", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (!CalCosttypeOrgRelationSaveOp.this.checkValueChanged(data) || CalCosttypeOrgRelationSaveOp.this.checkOrgCostaccountUnique(data, unionSet)) continue;
                    this.showOrgCostaccountUniqueMsg(data);
                    return;
                }
                unionSet.clear();
            }

            private void showOrgCostaccountUniqueMsg(DynamicObject data) {
                DynamicObject calorg = data.getDynamicObject(CalCosttypeOrgRelationSaveOp.CAL_ORG);
                Long calorgid = calorg.getLong(CalCosttypeOrgRelationSaveOp.ID);
                DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)calorgid, (String)"bos_org");
                DynamicObject costAccount = data.getDynamicObject(CalCosttypeOrgRelationSaveOp.COST_ACCOUNT);
                Long costAccountid = costAccount.getLong(CalCosttypeOrgRelationSaveOp.ID);
                DynamicObject costAccountDB = BusinessDataServiceHelper.loadSingle((Object)costAccountid, (String)"cal_bd_costaccount");
                if (CalCosttypeOrgRelationSaveOp.this.checkOpenMultifactory(data)) {
                    DynamicObject storageorg = data.getDynamicObject(CalCosttypeOrgRelationSaveOp.STORAGE_ORG);
                    Long storageorgid = storageorg.getLong(CalCosttypeOrgRelationSaveOp.ID);
                    DynamicObject sorg = BusinessDataServiceHelper.loadSingle((Object)storageorgid, (String)"bos_org");
                    String content = String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\u5e93\u5b58\u7ec4\u7ec7\u201c%3$s\u201d\u7684\u6210\u672c\u7c7b\u578b\u5bf9\u5e94\u5173\u7cfb\u3002", (String)"CalCosttypeOrgRelationSaveOp_4", (String)"fi-cal-opplugin", (Object[])new Object[0]), org.getString("name"), costAccountDB.getString("name"), sorg.getString("name"));
                    this.addErrorMessage(this.dataEntities[0], content);
                } else {
                    String content = String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\u7684\u6210\u672c\u7c7b\u578b\u5bf9\u5e94\u5173\u7cfb\u3002", (String)"CalCosttypeOrgRelationSaveOp_5", (String)"fi-cal-opplugin", (Object[])new Object[0]), org.getString("name"), costAccountDB.getString("name"));
                    this.addErrorMessage(this.dataEntities[0], content);
                }
            }
        });
    }

    private boolean checkOpenMultifactory(DynamicObject data) {
        DynamicObject calorg = data.getDynamicObject(CAL_ORG);
        if (calorg != null) {
            return ParamsHelper.getMultifactoryaccountByCalOrg((Long)calorg.getLong(ID));
        }
        return false;
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] infos = e.getDataEntities();
        if (infos != null && infos.length > 0) {
            String updateSql = "update t_cal_costtypeorg set fcostaccountid=?,fcosttypeid=?,fcalorgid=?,fstorageorgunitid=? where fid = ?";
            ArrayList<Object[]> updateList = new ArrayList<Object[]>();
            ArrayList<DynamicObject> insertList = new ArrayList<DynamicObject>();
            DynamicObjectCollection coll = infos[0].getDynamicObjectCollection(ENTRY_ENTITY);
            String updateIds = infos[0].getString(UPDATE_IDS);
            for (DynamicObject data : coll) {
                String id = data.getString(ID);
                DynamicObject info = this.setCalCosttypeorgRelation(data);
                if (id == null || "0".equals(id)) {
                    insertList.add(info);
                    continue;
                }
                if (StringUtils.isBlank((String)updateIds) || !updateIds.contains(id)) continue;
                if (null == info.get(STORAGE_ORG)) {
                    updateList.add(new Object[]{info.get(COST_ACCOUNT), info.get(COST_TYPE), info.get(CAL_ORG), 0L, Long.parseLong(id)});
                    continue;
                }
                updateList.add(new Object[]{info.get(COST_ACCOUNT), info.get(COST_TYPE), info.get(CAL_ORG), info.get(STORAGE_ORG), Long.parseLong(id)});
            }
            if (updateList.size() > 0) {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateSql, updateList);
            }
            if (insertList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])insertList.toArray(new DynamicObject[insertList.size()]));
            }
        }
    }

    private DynamicObject setCalCosttypeorgRelation(DynamicObject dynamic) {
        DynamicObject info = BusinessDataServiceHelper.newDynamicObject((String)"cal_bd_costtypeorg");
        info.set(COST_ACCOUNT, dynamic.getDynamicObject(COST_ACCOUNT).getPkValue());
        info.set(CAL_ORG, dynamic.getDynamicObject(CAL_ORG).getPkValue());
        if (dynamic.getDynamicObject(STORAGE_ORG) != null) {
            info.set(STORAGE_ORG, dynamic.getDynamicObject(STORAGE_ORG).getPkValue());
        }
        info.set(COST_TYPE, dynamic.getDynamicObject(COST_TYPE).getPkValue());
        info.set(BIZ_STATUS, (Object)dynamic.getString(BIZ_STATUS));
        info.set(CONFIRM_DATE, (Object)dynamic.getDate(CONFIRM_DATE));
        info.set(EFFECK_DATE, (Object)dynamic.getDate(EFFECK_DATE));
        info.set(INVALID_DATE, (Object)dynamic.getDate(INVALID_DATE));
        return info;
    }

    private boolean checkOrgCostaccountUnique(DynamicObject dynamic, Set<String> unionSet) {
        if (dynamic.getDynamicObject(COST_ACCOUNT) != null && dynamic.getDynamicObject(CAL_ORG) != null) {
            DynamicObject[] infos;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(dynamic.getDynamicObject(COST_ACCOUNT).getPkValue().toString());
            stringBuilder.append("_");
            stringBuilder.append(dynamic.getDynamicObject(CAL_ORG).getPkValue().toString());
            QFilter filter = new QFilter(COST_ACCOUNT, "=", dynamic.getDynamicObject(COST_ACCOUNT).getPkValue());
            filter.and(new QFilter(CAL_ORG, "=", dynamic.getDynamicObject(CAL_ORG).getPkValue()));
            if (dynamic.getDynamicObject(STORAGE_ORG) != null) {
                stringBuilder.append("_");
                stringBuilder.append(dynamic.getDynamicObject(STORAGE_ORG).getPkValue().toString());
                filter.and(new QFilter(STORAGE_ORG, "=", dynamic.getDynamicObject(STORAGE_ORG).getPkValue()));
            }
            if ((infos = BusinessDataServiceHelper.load((String)"cal_bd_costtypeorg", (String)ID, (QFilter[])new QFilter[]{filter})) != null && infos.length > 0) {
                return false;
            }
            if (unionSet.contains(stringBuilder.toString())) {
                return false;
            }
            unionSet.add(stringBuilder.toString());
        }
        return true;
    }

    private boolean checkMultifactoryaccount(DynamicObject data) {
        DynamicObject storageorg;
        Date invaliddate = data.getDate(INVALID_DATE);
        Date nowTime = TimeServiceHelper.now();
        if (nowTime.compareTo(invaliddate) > 0) {
            return true;
        }
        return !this.checkOpenMultifactory(data) || null != (storageorg = data.getDynamicObject(STORAGE_ORG));
    }

    private boolean checkCostaccountEnable(DynamicObject data) {
        String enable;
        DynamicObject costaccountDy;
        DynamicObject costaccount = data.getDynamicObject(COST_ACCOUNT);
        return costaccount == null || (costaccountDy = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"enable", (QFilter[])new QFilter(ID, "=", costaccount.getPkValue()).toArray())) == null || StringUtils.isBlank((String)(enable = costaccountDy.getString("enable"))) || "1".equals(enable);
    }

    private boolean checkValueChanged(DynamicObject data) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)data.getString(ID), (String)"cal_bd_costtypeorg");
        DynamicObject costaccountdb = dynamicObject.getDynamicObject(COST_ACCOUNT);
        DynamicObject calorgdb = dynamicObject.getDynamicObject(CAL_ORG);
        DynamicObject storageorgdb = dynamicObject.getDynamicObject(STORAGE_ORG);
        DynamicObject costaccount = data.getDynamicObject(COST_ACCOUNT);
        DynamicObject calorg = data.getDynamicObject(CAL_ORG);
        DynamicObject storageorg = data.getDynamicObject(STORAGE_ORG);
        if (!(costaccountdb == null || calorgdb == null || costaccount == null || calorg == null || costaccountdb.getPkValue().equals(costaccount.getPkValue()) && calorgdb.getPkValue().equals(calorg.getPkValue()))) {
            return true;
        }
        if (storageorg != null) {
            return storageorgdb == null ? true : !storageorg.getPkValue().equals(storageorgdb.getPkValue());
        }
        return storageorgdb != null;
    }
}

