/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.base;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;

public class CalCosttypeOrgRelationSynMultifactoryOp
extends AbstractOperationServicePlugIn {
    private static final String TARGET_CALORG_ID = "targetcalorgid";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add(TARGET_CALORG_ID);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String targetcalorgid = this.dataEntities[0].getDataEntity().getString(CalCosttypeOrgRelationSynMultifactoryOp.TARGET_CALORG_ID);
                if (!StringUtils.isBlank((CharSequence)targetcalorgid)) {
                    QFilter costAccountFilter = new QFilter("calorg", "=", (Object)Long.valueOf(targetcalorgid));
                    DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,calorg,costtype", (QFilter[])costAccountFilter.toArray());
                    boolean errorFlag = false;
                    for (DynamicObject dynamicObject : costAccounts) {
                        List orgList;
                        Long calorgid = dynamicObject.getLong("calorg");
                        boolean storageorgflag = OrgUnitServiceHelper.checkOrgFunction((Long)calorgid, (String)"05");
                        if (storageorgflag || null != (orgList = OrgHelper.getStorageOrgUnitByCalOrg((Long)calorgid)) && orgList.size() != 0) continue;
                        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)calorgid, (String)"bos_org");
                        String name = null;
                        if (org != null) {
                            name = org.getString("name");
                        }
                        String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6838\u7b97\u7ec4\u7ec7\u201c\u591a\u5de5\u5382\u6838\u7b97\u201d\u4fee\u6539\u5931\u8d25\uff0c\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"CalCosttypeOrgRelationSynMultifactoryOp_0", (String)"fi-cal-opplugin", (Object[])new Object[0]), name);
                        this.addErrorMessage(this.dataEntities[0], msg);
                        errorFlag = true;
                    }
                    if (errorFlag) {
                        return;
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String targetcalorgid = null;
        DynamicObject[] allDatas = e.getDataEntities();
        Date nowTime = TimeServiceHelper.now();
        if (allDatas != null && allDatas.length > 0 && !StringUtils.isBlank((CharSequence)(targetcalorgid = allDatas[0].getString(TARGET_CALORG_ID)))) {
            String updateSql = "update t_cal_costtypeorg set finvaliddate=? where fcostaccountid=? and fcalorgid=? and feffectdate=? and finvaliddate=? and fstorageorgunitid=?";
            QFilter costAccountFilter = new QFilter("calorg", "=", (Object)Long.valueOf(targetcalorgid));
            DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,calorg,costtype", (QFilter[])costAccountFilter.toArray());
            ArrayList<Object[]> updateList = new ArrayList<Object[]>(16);
            ArrayList<DynamicObject> insertList = new ArrayList<DynamicObject>(16);
            for (DynamicObject dynamicObject : costAccounts) {
                Long costaccountId = dynamicObject.getLong("id");
                Long calorgid = dynamicObject.getLong("calorg");
                QFilter filter = new QFilter("costaccount", "=", (Object)costaccountId);
                filter.and("calorg", "=", (Object)calorgid);
                DynamicObject[] infos = BusinessDataServiceHelper.load((String)"cal_bd_costtypeorg", (String)"costtype", (QFilter[])filter.toArray());
                if (null == infos || infos.length == 0) continue;
                updateList.add(new Object[]{nowTime, costaccountId, calorgid, DateUtils.getDateByInt((int)2000, (int)0, (int)1, (int)0, (int)0, (int)0), DateUtils.getDateByInt((int)2999, (int)11, (int)31, (int)23, (int)59, (int)59), 0L});
                List orgList = OrgHelper.getStorageOrgUnitByCalOrg((Long)calorgid);
                for (Long storageorgid : orgList) {
                    QFilter qFilter = new QFilter("costaccount", "=", (Object)costaccountId);
                    qFilter.and("calorg", "=", (Object)calorgid);
                    qFilter.and("storageorgunit", "=", (Object)storageorgid);
                    DynamicObject[] reInfo = BusinessDataServiceHelper.load((String)"cal_bd_costtypeorg", (String)"id", (QFilter[])qFilter.toArray());
                    if (reInfo != null && reInfo.length > 0) continue;
                    DynamicObject info = BusinessDataServiceHelper.newDynamicObject((String)"cal_bd_costtypeorg");
                    info.set("costaccount", (Object)costaccountId);
                    info.set("calorg", (Object)calorgid);
                    info.set("storageorgunit", (Object)storageorgid);
                    info.set("costtype", infos[0].getDynamicObject("costtype").getPkValue());
                    info.set("bizstatus", (Object)"1");
                    info.set("confirmdate", (Object)nowTime);
                    info.set("effectdate", (Object)DateUtils.getDateByInt((int)2000, (int)0, (int)1, (int)0, (int)0, (int)0));
                    info.set("invaliddate", (Object)DateUtils.getDateByInt((int)2999, (int)11, (int)31, (int)23, (int)59, (int)59));
                    insertList.add(info);
                }
            }
            if (updateList.size() > 0) {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateSql, updateList);
            }
            if (insertList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])insertList.toArray(new DynamicObject[insertList.size()]));
            }
        }
    }
}

