/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DbInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.opplugin.validator.BaseDataModifyValidator;

public class CalDimensionSaveOrSubmitOP
extends AbstractOperationServicePlugIn {
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        if ("save".equals(key) || "submit".equals(key)) {
            this.doBefore(e);
        }
    }

    private void doBefore(BeginOperationTransactionArgs e) {
        DynamicObject[] dynamicObjects = e.getDataEntities();
        DynamicObject dynamicObject = null;
        String caldimension = null;
        for (int i = 0; i < dynamicObjects.length; ++i) {
            dynamicObject = dynamicObjects[i];
            caldimension = dynamicObject.getString("caldimension");
            caldimension = this.trimComma(caldimension);
            dynamicObject.set("caldimension", (Object)caldimension);
            dynamicObject.set("displayname", (Object)this.getDisplayName(caldimension));
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                DynamicObjectCollection calDims = QueryServiceHelper.query((String)"cal_bd_caldimension", (String)"id,number,caldimension", (QFilter[])new QFilter("id", "!=", (Object)0L).toArray());
                HashMap<Long, Set<String>> calDimMap = new HashMap<Long, Set<String>>(calDims.size());
                HashMap<Long, String> calDimNumberMap = new HashMap<Long, String>(calDims.size());
                for (DynamicObject calDim : calDims) {
                    Long id = calDim.getLong("id");
                    String number = calDim.getString("number");
                    String calDimStr = calDim.getString("caldimension");
                    calDimNumberMap.put(id, number);
                    HashSet<String> set = new HashSet<String>(8);
                    for (String field : calDimStr.split(",")) {
                        set.add(field);
                    }
                    calDimMap.put(id, set);
                }
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    this.doCheck(dataEntity, calDimNumberMap, calDimMap);
                }
                CalDbParamServiceHelper dbParamHelper = new CalDbParamServiceHelper();
                Map dbParams = CalDbParamServiceHelper.getKeyOrgValueMap((String)"ischeckexistdata");
                if (dbParams.isEmpty()) {
                    this.doCheckExistBizData();
                }
            }

            /*
             * WARNING - void declaration
             */
            private void doCheckExistBizData() {
                void var8_10;
                HashMap<Long, ExtendedDataEntity> calDimIdAndDataMap = new HashMap<Long, ExtendedDataEntity>(16);
                DBRoute route = new DBRoute("cal");
                RowMeta rowMeta = new RowMeta(new String[]{"fcaldimensionid"}, new DataType[]{DataType.LongType});
                ArrayList batchInputList = new ArrayList(16);
                ArrayList<DbInput> dbInputlist = null;
                ExtendedDataEntity[] extendedDataEntityArray = this.dataEntities;
                int n = extendedDataEntityArray.length;
                boolean bl = false;
                while (var8_10 < n) {
                    ExtendedDataEntity dataEntity = extendedDataEntityArray[var8_10];
                    Long calrangeId = dataEntity.getDataEntity().getLong("id");
                    if (calrangeId != null && calrangeId != 0L) {
                        calDimIdAndDataMap.put(calrangeId, dataEntity);
                        if (dbInputlist == null || dbInputlist.size() % 12 == 0) {
                            dbInputlist = new ArrayList<DbInput>(16);
                            batchInputList.add(dbInputlist);
                        }
                        DbInput recordDBInput = new DbInput(((Object)((Object)this)).getClass().getName(), route.getRouteKey(), "select top 1 fcaldimensionid from t_cal_calcostrecordentry where fcaldimensionid = " + calrangeId, null, rowMeta);
                        DbInput adjustDBInput = new DbInput(((Object)((Object)this)).getClass().getName(), route.getRouteKey(), "select top 1 fcaldimensionid from t_cal_costadjustbillentry where fcaldimensionid = " + calrangeId, null, rowMeta);
                        DbInput initBillDBInput = new DbInput(((Object)((Object)this)).getClass().getName(), route.getRouteKey(), "select top 1 fcaldimensionid from t_cal_initbillentry where fcaldimensionid = " + calrangeId, null, rowMeta);
                        dbInputlist.add(recordDBInput);
                        dbInputlist.add(adjustDBInput);
                        dbInputlist.add(initBillDBInput);
                    }
                    ++var8_10;
                }
                DataSet allDataSet = null;
                for (List list : batchInputList) {
                    Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
                    DataSet dateSet = algo.createDataSet((Input[])list.toArray(new DbInput[list.size()]));
                    if (allDataSet == null) {
                        allDataSet = dateSet;
                        continue;
                    }
                    allDataSet = allDataSet.union(dateSet);
                }
                if (allDataSet != null) {
                    allDataSet = allDataSet.groupBy(new String[]{"fcaldimensionid"}).finish();
                    for (Row row : allDataSet) {
                        Long calDimId = row.getLong("fcaldimensionid");
                        ExtendedDataEntity dataEntity = (ExtendedDataEntity)calDimIdAndDataMap.get(calDimId);
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6b64\u6838\u7b97\u7ef4\u5ea6\u5df2\u53d1\u751f\u4e1a\u52a1\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"DivideBasisSaveOrSubmitOP_3", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    }
                }
            }

            private void doCheck(ExtendedDataEntity dataEntity, Map<Long, String> calDimNumberMap, Map<Long, Set<String>> calDimMap) {
                DynamicObject dynamicObject = dataEntity.getDataEntity();
                String caldimension = dynamicObject.getString("caldimension");
                String name = dynamicObject.getString("name");
                String number = dynamicObject.getString("number");
                if (caldimension == null || name == null || number == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u68c0\u67e5\u5fc5\u5f55\u9879\u3002", (String)"DivideBasisSaveOrSubmitOP_2", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                }
                Long currentId = dynamicObject.getLong("id");
                String[] fields = CalDimensionSaveOrSubmitOP.this.trimComma(caldimension).split(",");
                for (Map.Entry<Long, Set<String>> mapEntry : calDimMap.entrySet()) {
                    Long existId = mapEntry.getKey();
                    Set<String> set = mapEntry.getValue();
                    if (existId.equals(currentId) || set.size() != fields.length) continue;
                    boolean exist = true;
                    for (String field : fields) {
                        if (set.contains(field)) continue;
                        exist = false;
                        break;
                    }
                    if (!exist) continue;
                    String msg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7684\u6838\u7b97\u7ef4\u5ea6,\u7f16\u7801\u4e3a%1$s", (String)"CalDimensionSaveOrSubmitOP_0", (String)"fi-cal-opplugin", (Object[])new Object[0]), calDimNumberMap.get(existId) + "");
                    this.addErrorMessage(dataEntity, msg);
                    return;
                }
            }
        });
        if (QueryServiceHelper.exists((String)"cal_bd_caldimension", (Object)e.getDataEntities()[0].getPkValue()) && !this.canModify(e.getDataEntities()[0])) {
            BaseDataModifyValidator validator = new BaseDataModifyValidator();
            String entityKey = this.billEntityType.getName();
            validator.setOption(this.getOption());
            validator.setEntityType((BasedataEntityType)this.billEntityType);
            validator.setEntityKey(entityKey);
            validator.setOperationName(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"CalDimensionSaveOrSubmitOP_1", (String)"fi-cal-opplugin", (Object[])new Object[0]));
            validator.setOperateKey("save");
            validator.setOperateType("save");
            e.addValidator((AbstractValidator)validator);
        }
    }

    private boolean canModify(DynamicObject info) {
        DynamicObject oldInfo = BusinessDataServiceHelper.loadSingle((Object)info.getPkValue(), (String)"cal_bd_caldimension", (String)"id,caldimension");
        if (oldInfo != null) {
            String caldimension = this.trimComma(info.getString("caldimension"));
            String oldcaldimension = this.trimComma(oldInfo.getString("caldimension"));
            if (caldimension == null && oldcaldimension == null || caldimension != null && caldimension.equals(oldcaldimension)) {
                return true;
            }
        }
        return false;
    }

    private String getDisplayName(String caldimension) {
        String[] caldimensionArr;
        if (caldimension == null) {
            return "";
        }
        StringBuilder displayname = new StringBuilder();
        String balanceEntity = CalBalanceModelHelper.isNewBalance() ? "cal_bal" : "cal_balance";
        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)balanceEntity);
        for (String s : caldimensionArr = caldimension.split(",")) {
            if (StringUtils.isEmpty((String)s)) continue;
            IDataEntityProperty pro = entitytype.findProperty(s);
            displayname.append(pro.getDisplayName()).append('+');
        }
        return displayname.substring(0, displayname.length() - 1);
    }

    private String trimComma(String caldimension) {
        if (caldimension == null) {
            return null;
        }
        if (caldimension.startsWith(",")) {
            caldimension = caldimension.substring(1, caldimension.length());
        }
        if (caldimension.endsWith(",")) {
            caldimension = caldimension.substring(0, caldimension.length() - 1);
        }
        return caldimension;
    }
}

