/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DbInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.cal.business.autosort.AutoSortHelperNew;
import kd.fi.cal.business.calculate.billgroup.AutoSortServic;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.PreparePropertysHelper;
import kd.fi.cal.common.helper.StopSyncSettingModifyHelper;
import kd.fi.cal.opplugin.base.CalBaseAuditOrUnAuditOP;
import kd.fi.cal.opplugin.base.WriteBackCostRecordAccTypeHelper;

public class CalRangeAuditOrUnAuditOP
extends CalBaseAuditOrUnAuditOP {
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] infos;
        String key = e.getOperationKey();
        for (DynamicObject info : infos = e.getDataEntities()) {
            if ("unaudit".equals(key)) {
                this.doUnAudit(info);
                continue;
            }
            if (!"audit".equals(key)) continue;
            this.doAudit(info);
        }
        super.endOperationTransaction(e);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doAudit(DynamicObject info) {
        HashSet<Long> calOrgIdSet = new HashSet<Long>(1);
        calOrgIdSet.add(info.getDynamicObject("costaccount").getDynamicObject("calorg").getLong("id"));
        new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, null, null, new HashSet(), true, TimeServiceHelper.now());
        boolean needNewTx = false;
        try {
            WriteBackCostRecordAccTypeHelper.writeBackByCalRangeBasisField(info);
            if (AcctGroupModelHelper.isNewGroupModel()) {
                AutoSortServic sortService = new AutoSortServic();
                Set<Long> acctIds = Collections.singleton(info.getDynamicObject("costaccount").getLong("id"));
                try (TraceSpan span = Tracer.create((String)"sortByAcctIds", (String)"sortByAcctIds");){
                    sortService.sortByAsyncByAccountId(acctIds);
                    return;
                }
            }
            String desc = ResManager.loadKDString((String)"\u6838\u7b97\u8303\u56f4\u5ba1\u6838", (String)"CalRangeAuditOrUnAuditOP_2", (String)"fi-cal-opplugin", (Object[])new Object[0]);
            new AutoSortHelperNew().rebuildAllSortResultByCostAccounts(Collections.singleton(info.getDynamicObject("costaccount").getLong("id")), desc);
            return;
        }
        catch (Throwable e) {
            needNewTx = true;
            throw e;
        }
        finally {
            if (needNewTx) {
                try (TXHandle tx = TX.requiresNew();){
                    new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, null, null, new HashSet(), false, TimeServiceHelper.now());
                }
            } else {
                new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, null, null, new HashSet(), false, TimeServiceHelper.now());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doUnAudit(DynamicObject info) {
        HashSet<Long> calOrgIdSet = new HashSet<Long>(1);
        calOrgIdSet.add(info.getDynamicObject("costaccount").getDynamicObject("calorg").getLong("id"));
        new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, null, null, new HashSet(), true, TimeServiceHelper.now());
        boolean needNewTx = false;
        try {
            WriteBackCostRecordAccTypeHelper.writeBack4CalRangeId(info);
            if (AcctGroupModelHelper.isNewGroupModel()) {
                AutoSortServic sortService = new AutoSortServic();
                Set<Long> acctIds = Collections.singleton(info.getDynamicObject("costaccount").getLong("id"));
                try (TraceSpan span = Tracer.create((String)"sortByAcctIds", (String)"sortByAcctIds");){
                    sortService.sortByAsyncByAccountId(acctIds);
                    return;
                }
            }
            String desc = ResManager.loadKDString((String)"\u6838\u7b97\u8303\u56f4\u53cd\u5ba1\u6838", (String)"CalRangeAuditOrUnAuditOP_3", (String)"fi-cal-opplugin", (Object[])new Object[0]);
            new AutoSortHelperNew().rebuildAllSortResultByCostAccounts(Collections.singleton(info.getDynamicObject("costaccount").getLong("id")), desc);
            return;
        }
        catch (Throwable e) {
            needNewTx = true;
            throw e;
        }
        finally {
            if (needNewTx) {
                try (TXHandle tx = TX.requiresNew();){
                    new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, null, null, new HashSet(), false, TimeServiceHelper.now());
                }
            } else {
                new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, null, null, new HashSet(), false, TimeServiceHelper.now());
            }
        }
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        PreparePropertysHelper.setPreparePropertys((PreparePropertysEventArgs)e, (String)"cal_bd_calrange");
        super.onPreparePropertys(e);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        String key = (String)this.operateMeta.get("type");
        if ("audit".equals(key)) {
            e.addValidator(new AbstractValidator(){

                public void validate() {
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        DynamicObject info = dataEntity.getDataEntity();
                        DynamicObject divideBasis = info.getDynamicObject("dividebasis");
                        DynamicObject costAccount = info.getDynamicObject("costaccount");
                        if (divideBasis.getLong("id") == costAccount.getLong("dividebasis.id")) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u7b97\u8303\u56f4\u7684\u5212\u5206\u4f9d\u636e\u4e0e\u6210\u672c\u8d26\u7c3f\u7684\u5212\u5206\u4f9d\u636e\u4e0d\u4e00\u81f4\u3002", (String)"CalRangeAuditOrUnAuditOP_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    }
                }
            });
        } else if ("unaudit".equals(key)) {
            e.addValidator(new AbstractValidator(){

                /*
                 * WARNING - void declaration
                 */
                public void validate() {
                    void var10_12;
                    CalDbParamServiceHelper dbParamHelper = new CalDbParamServiceHelper();
                    Map dbParams = CalDbParamServiceHelper.getKeyOrgValueMap((String)"ischeckexistdata");
                    if (!dbParams.isEmpty()) {
                        return;
                    }
                    HashMap<Long, ExtendedDataEntity> calrangeIdAndDataMap = new HashMap<Long, ExtendedDataEntity>(16);
                    DBRoute route = new DBRoute("cal");
                    RowMeta rowMeta = new RowMeta(new String[]{"fcalrangeid"}, new DataType[]{DataType.LongType});
                    ArrayList batchInputList = new ArrayList(16);
                    ArrayList<DbInput> dbInputlist = null;
                    ExtendedDataEntity[] extendedDataEntityArray = this.dataEntities;
                    int n = extendedDataEntityArray.length;
                    boolean bl = false;
                    while (var10_12 < n) {
                        ExtendedDataEntity dataEntity = extendedDataEntityArray[var10_12];
                        Long calrangeId = dataEntity.getDataEntity().getLong("id");
                        calrangeIdAndDataMap.put(calrangeId, dataEntity);
                        if (dbInputlist == null || dbInputlist.size() % 12 == 0) {
                            dbInputlist = new ArrayList<DbInput>(16);
                            batchInputList.add(dbInputlist);
                        }
                        DbInput recordDBInput = new DbInput(((Object)((Object)this)).getClass().getName(), route.getRouteKey(), "select top 1 fcalrangeid from t_cal_calcostrecordentry where fcalrangeid = " + calrangeId, null, rowMeta);
                        DbInput adjustDBInput = new DbInput(((Object)((Object)this)).getClass().getName(), route.getRouteKey(), "select top 1 a.fcalrangeid from t_cal_costadjustbillentry a join t_cal_costadjustbill b on a.fid = b.fid where b.fbillstatus != 'A' and a.fcalrangeid = " + calrangeId, null, rowMeta);
                        DbInput initBillDBInput = new DbInput(((Object)((Object)this)).getClass().getName(), route.getRouteKey(), "select top 1 a.fcalrangeid from t_cal_initbillentry a join t_cal_initbill b on a.fid = b.fid where b.fbillstatus != 'A' and a.fcalrangeid = " + calrangeId, null, rowMeta);
                        dbInputlist.add(recordDBInput);
                        dbInputlist.add(adjustDBInput);
                        dbInputlist.add(initBillDBInput);
                        ++var10_12;
                    }
                    DataSet allDataSet = null;
                    for (List list : batchInputList) {
                        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
                        DataSet dateSet = algo.createDataSet((Input[])list.toArray(new DbInput[list.size()]));
                        if (allDataSet == null) {
                            allDataSet = dateSet;
                            continue;
                        }
                        allDataSet = allDataSet.union(dateSet);
                    }
                    if (allDataSet != null) {
                        allDataSet = allDataSet.groupBy(new String[]{"fcalrangeid"}).finish();
                        for (Row row : allDataSet) {
                            Long calrangeId = row.getLong("fcalrangeid");
                            ExtendedDataEntity dataEntity = (ExtendedDataEntity)calrangeIdAndDataMap.get(calrangeId);
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6b64\u6838\u7b97\u8303\u56f4\u5df2\u53d1\u751f\u4e1a\u52a1\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"CalRangeAuditOrUnAuditOP_1", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                        }
                    }
                }
            });
        }
    }

    @Override
    public String getApproverName() {
        return "auditor";
    }

    @Override
    public String getApprovetimeName() {
        return "auditdate";
    }
}

