/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.base;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.cal.business.autosort.AutoSortHelperNew;
import kd.fi.cal.business.calculate.billgroup.AutoSortServic;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.PreparePropertysHelper;
import kd.fi.cal.common.helper.StopSyncSettingModifyHelper;
import kd.fi.cal.opplugin.base.WriteBackCostRecordAccTypeHelper;
import kd.fi.cal.opplugin.validator.CalRangeDuplicateValidator;

public class CalRangeEnableOP
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        PreparePropertysHelper.setPreparePropertys((PreparePropertysEventArgs)e, (String)"cal_bd_calrange");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CalRangeDuplicateValidator());
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject info = dataEntity.getDataEntity();
                    DynamicObject divideBasis = info.getDynamicObject("dividebasis");
                    DynamicObject costAccount = info.getDynamicObject("costaccount");
                    if (divideBasis.getLong("id") == costAccount.getLong("dividebasis.id")) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u7b97\u8303\u56f4\u7684\u5212\u5206\u4f9d\u636e\u4e0e\u6210\u672c\u8d26\u7c3f\u7684\u5212\u5206\u4f9d\u636e\u4e0d\u4e00\u81f4\u3002", (String)"CalRangeEnableOP_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        block18: {
            DynamicObject[] infos = e.getDataEntities();
            HashSet<Long> calOrgIdSet = new HashSet<Long>(1);
            HashSet<Long> costaccountIds = new HashSet<Long>(4);
            for (DynamicObject info : infos) {
                calOrgIdSet.add(info.getDynamicObject("costaccount").getDynamicObject("calorg").getLong("id"));
                costaccountIds.add(info.getLong("costaccount.id"));
            }
            try {
                new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, null, null, new HashSet(1), true, TimeServiceHelper.now());
                for (DynamicObject info : infos) {
                    WriteBackCostRecordAccTypeHelper.writeBackByCalRangeBasisField(info);
                }
                if (AcctGroupModelHelper.isNewGroupModel()) {
                    AutoSortServic sortService = new AutoSortServic();
                    try (TraceSpan span = Tracer.create((String)"sortByAcctIds", (String)"sortByAcctIds");){
                        sortService.sortByAsyncByAccountId(costaccountIds);
                        break block18;
                    }
                }
                String desc = ResManager.loadKDString((String)"\u6838\u7b97\u8303\u56f4\u542f\u7528", (String)"CalRangeEnableOP_1", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                new AutoSortHelperNew().rebuildAllSortResultByCostAccounts(costaccountIds, desc);
            }
            finally {
                new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, null, null, new HashSet(1), false, TimeServiceHelper.now());
            }
        }
        super.endOperationTransaction(e);
    }
}

