/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.base;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.SCMHelper;

public class CalRangeImportOp
extends BatchImportPlugin {
    private Map<String, Long> calorgNumberIdMap = new HashMap<String, Long>(16);
    private Map<String, Long> dividebasisIdMap = new HashMap<String, Long>(16);
    private Map<String, Long> costaccountIdMap = new HashMap<String, Long>(16);

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        this.beforeImportBill(rowdatas, logger);
        if (rowdatas == null || rowdatas.isEmpty()) {
            return null;
        }
        return super.save(rowdatas, logger);
    }

    protected void beforeSave(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        HashSet<String> costAccountNumberSet = new HashSet<String>(16);
        while (iterator.hasNext()) {
            ImportBillData rowdata = iterator.next();
            JSONObject data = rowdata.getData();
            Map costaccountMap = (Map)data.get((Object)"costaccount");
            if (costaccountMap == null || costaccountMap.isEmpty()) continue;
            String costaccountNumber = (String)costaccountMap.get("number");
            costAccountNumberSet.add(costaccountNumber);
        }
        QFilter filter = new QFilter("number", "in", costAccountNumberSet);
        DynamicObjectCollection costaccountColl = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,number,calorg,dividebasis", (QFilter[])filter.toArray());
        for (DynamicObject costaccount : costaccountColl) {
            String number = costaccount.getString("number");
            Long calorgid = costaccount.getLong("calorg");
            this.calorgNumberIdMap.put(number, calorgid);
            Long dividebasisid = costaccount.getLong("dividebasis");
            this.dividebasisIdMap.put(number, dividebasisid);
            Long costaccountId = costaccount.getLong("id");
            this.costaccountIdMap.put(number, costaccountId);
        }
        super.beforeSave(rowdatas, logger);
    }

    protected void beforeImportBill(List<ImportBillData> billdatas, ImportLogger logger) {
        Iterator<ImportBillData> iterator = billdatas.iterator();
        while (iterator.hasNext()) {
            Long dividebasisid;
            ImportBillData rowdata = iterator.next();
            JSONObject data = rowdata.getData();
            int index = rowdata.getStartIndex();
            Map costaccountMap = (Map)data.get((Object)"costaccount");
            String costaccountNumber = (String)costaccountMap.get("number");
            Long calorgId = this.calorgNumberIdMap.get(costaccountNumber);
            if (calorgId != null) {
                data.put("headcalorg_id", (Object)calorgId);
            }
            if ((dividebasisid = this.dividebasisIdMap.get(costaccountNumber)) != null) {
                data.put("dividebasis_id", (Object)dividebasisid);
            }
            Long costaccountId = this.costaccountIdMap.get(costaccountNumber);
            List listData = (List)data.get((Object)"entry");
            if (null == listData) {
                return;
            }
            for (Map row : listData) {
                QFilter filter;
                Object warehouse = row.get("warehouse");
                Object location = row.get("location");
                Object storageorgunit = row.get("storageorgunit");
                if (warehouse != null && null == storageorgunit) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u4ed3\u5e93\u5b58\u5728\u6570\u636e\u65f6\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"CalRangeImportOp_2", (String)"fi-cal-opplugin", (Object[])new Object[0])).fail();
                    iterator.remove();
                    return;
                }
                if (location != null && (null == warehouse || null == storageorgunit)) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u4ed3\u4f4d\u5b58\u5728\u6570\u636e\u65f6\u5e93\u5b58\u7ec4\u7ec7\u548c\u4ed3\u5e93\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"CalRangeImportOp_3", (String)"fi-cal-opplugin", (Object[])new Object[0])).fail();
                    iterator.remove();
                    return;
                }
                if (storageorgunit != null) {
                    List orgList = OrgHelper.getStorageOrgUnitByCalOrg((Long)calorgId);
                    if (null == orgList || orgList.isEmpty()) {
                        logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u5fc5\u987b\u662f\u6838\u7b97\u7ec4\u7ec7\u88ab\u59d4\u6258\u7684\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"CalRangeImportOp_1", (String)"fi-cal-opplugin", (Object[])new Object[0])).fail();
                        iterator.remove();
                        return;
                    }
                    Map storageorgunitMap = (Map)storageorgunit;
                    QFilter filter2 = new QFilter("id", "in", (Object)orgList);
                    filter2.and("number", "=", storageorgunitMap.get("number"));
                    if (!QueryServiceHelper.exists((String)"bos_org", (QFilter[])filter2.toArray())) {
                        logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u5fc5\u987b\u662f\u6838\u7b97\u7ec4\u7ec7\u88ab\u59d4\u6258\u7684\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"CalRangeImportOp_1", (String)"fi-cal-opplugin", (Object[])new Object[0])).fail();
                        iterator.remove();
                        return;
                    }
                    storageorgunitMap = (Map)storageorgunit;
                    String storageorgunitNumber = (String)storageorgunitMap.get("number");
                    Long[] warehouseIds = SCMHelper.getAllInUseWarehouseIDs((String)storageorgunitNumber);
                    if (null == warehouseIds || warehouseIds.length == 0) {
                        logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u4ed3\u5e93\u5fc5\u987b\u662f\u9009\u4e2d\u5e93\u5b58\u7ec4\u7ec7\u4e0b\u7684\u4ed3\u5e93\u3002", (String)"CalRangeImportOp_4", (String)"fi-cal-opplugin", (Object[])new Object[0])).fail();
                        iterator.remove();
                        return;
                    }
                    if (warehouse != null) {
                        Map warehouseMap = (Map)warehouse;
                        QFilter filter3 = new QFilter("id", "in", (Object)warehouseIds);
                        filter3.and("number", "=", warehouseMap.get("number"));
                        if (!QueryServiceHelper.exists((String)"bd_warehouse", (QFilter[])filter3.toArray())) {
                            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u4ed3\u5e93\u5fc5\u987b\u662f\u9009\u4e2d\u5e93\u5b58\u7ec4\u7ec7\u4e0b\u7684\u4ed3\u5e93\u3002", (String)"CalRangeImportOp_4", (String)"fi-cal-opplugin", (Object[])new Object[0])).fail();
                            iterator.remove();
                            return;
                        }
                    }
                }
                if (warehouse != null) {
                    Map warehouseMap = (Map)warehouse;
                    String warehouseNumber = (String)warehouseMap.get("number");
                    Long[] locationIds = SCMHelper.getAllLocationIDsByNumber((Object[])new Object[]{warehouseNumber});
                    if (null == locationIds || locationIds.length == 0) {
                        logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u4ed3\u4f4d\u5fc5\u987b\u662f\u9009\u4e2d\u4ed3\u5e93\u4e0b\u7684\u4ed3\u4f4d\u3002", (String)"CalRangeImportOp_5", (String)"fi-cal-opplugin", (Object[])new Object[0])).fail();
                        iterator.remove();
                        return;
                    }
                    if (location != null) {
                        Map locationMap = (Map)location;
                        filter = new QFilter("id", "in", (Object)locationIds);
                        filter.and("number", "=", locationMap.get("number"));
                        if (!QueryServiceHelper.exists((String)"bd_location", (QFilter[])filter.toArray())) {
                            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u4ed3\u4f4d\u5fc5\u987b\u662f\u9009\u4e2d\u4ed3\u5e93\u4e0b\u7684\u4ed3\u4f4d\u3002", (String)"CalRangeImportOp_5", (String)"fi-cal-opplugin", (Object[])new Object[0])).fail();
                            iterator.remove();
                            return;
                        }
                    }
                }
                Object calorg = row.get("calorg");
                Object owner = row.get("owner");
                if (calorg == null && owner == null) continue;
                Long[] ownerIds = AccountingSysHelper.getOwners((Long)costaccountId);
                if (null == ownerIds || ownerIds.length == 0) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u6216\u8d27\u4e3b\u5fc5\u987b\u662f\u9009\u4e2d\u6210\u672c\u8d26\u7c3f\u4e0b\u7684\u7ec4\u7ec7\u6216\u8005\u8d27\u4e3b\u3002", (String)"CalRangeImportOp_6", (String)"fi-cal-opplugin", (Object[])new Object[0])).fail();
                    iterator.remove();
                    return;
                }
                if (calorg != null) {
                    Map calorgMap = (Map)calorg;
                    filter = new QFilter("id", "in", (Object)ownerIds);
                    filter.and("number", "=", calorgMap.get("number"));
                    if (!QueryServiceHelper.exists((String)"bos_org", (QFilter[])filter.toArray())) {
                        logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u6216\u8d27\u4e3b\u5fc5\u987b\u662f\u9009\u4e2d\u6210\u672c\u8d26\u7c3f\u4e0b\u7684\u7ec4\u7ec7\u6216\u8005\u8d27\u4e3b\u3002", (String)"CalRangeImportOp_6", (String)"fi-cal-opplugin", (Object[])new Object[0])).fail();
                        iterator.remove();
                        return;
                    }
                }
                if (owner == null) continue;
                Map ownerMap = (Map)owner;
                filter = new QFilter("id", "in", (Object)ownerIds);
                filter.and("number", "=", ownerMap.get("number"));
                if (QueryServiceHelper.exists((String)"bos_org", (QFilter[])filter.toArray())) continue;
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u6216\u8d27\u4e3b\u5fc5\u987b\u662f\u9009\u4e2d\u6210\u672c\u8d26\u7c3f\u4e0b\u7684\u7ec4\u7ec7\u6216\u8005\u8d27\u4e3b\u3002", (String)"CalRangeImportOp_6", (String)"fi-cal-opplugin", (Object[])new Object[0])).fail();
                iterator.remove();
                return;
            }
        }
    }
}

