/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.base;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.cal.business.autosort.AutoSortHelperNew;
import kd.fi.cal.business.calculate.billgroup.AutoSortServic;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.StopSyncSettingModifyHelper;
import kd.fi.cal.common.util.DynamicObjectUtils;
import kd.fi.cal.opplugin.base.WriteBackCostRecordAccTypeHelper;
import kd.fi.cal.opplugin.validator.CalRangeDuplicateValidator;

public class CalRangeSave4AddEntryOP
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        MainEntityType bizEntityType = EntityMetadataCache.getDataEntityType((String)"cal_bd_calrange");
        e.getFieldKeys().addAll(bizEntityType.getAllFields().keySet());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CalRangeDuplicateValidator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject info = e.getDataEntities()[0];
        HashSet<Long> calOrgIdSet = new HashSet<Long>(1);
        calOrgIdSet.add(info.getDynamicObject("costaccount").getDynamicObject("calorg").getLong("id"));
        info.set("modifier_id", (Object)Long.valueOf(RequestContext.get().getUserId()));
        info.set("modifytime", (Object)TimeServiceHelper.now());
        if (this.existNullEntryRange(info.getDynamicObject("costaccount").getLong("id"))) {
            DynamicObject copyInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_bd_calrange");
            DynamicObjectUtils.copyProperties((DynamicObject)copyInfo, (DynamicObject)info, null, null, (boolean)true);
            DynamicObjectCollection entrys = copyInfo.getDynamicObjectCollection("entry");
            DynamicObjectCollection newEntrys = new DynamicObjectCollection();
            for (DynamicObject entry : entrys) {
                if (entry.getLong("id") != 0L) continue;
                newEntrys.add((Object)entry);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
            if (newEntrys.isEmpty()) {
                return;
            }
            try {
                new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, null, null, new HashSet(), true, TimeServiceHelper.now());
                copyInfo.set("entry", (Object)newEntrys);
                WriteBackCostRecordAccTypeHelper.writeBackByCalRangeBasisField(copyInfo);
                if (AcctGroupModelHelper.isNewGroupModel()) {
                    AutoSortServic sortService = new AutoSortServic();
                    Set<Long> acctIds = Collections.singleton(info.getDynamicObject("costaccount").getLong("id"));
                    try (TraceSpan span = Tracer.create((String)"sortByAcctIds", (String)"sortByAcctIds");){
                        sortService.sortByAsyncByAccountId(acctIds);
                    }
                }
                String desc = ResManager.loadKDString((String)"\u6838\u7b97\u8303\u56f4\u8ffd\u52a0\u5206\u5f55", (String)"CalRangeSave4AddEntryOP_0", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                new AutoSortHelperNew().rebuildAllSortResultByCostAccounts(Collections.singleton(info.getDynamicObject("costaccount").getLong("id")), desc);
            }
            finally {
                new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, null, null, new HashSet(), false, TimeServiceHelper.now());
            }
        } else {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
        }
    }

    private boolean existNullEntryRange(long costAccountId) {
        DynamicObject[] calRangeInfos;
        QFilter q = new QFilter("costaccount", "=", (Object)costAccountId);
        for (DynamicObject calRangeInfo : calRangeInfos = BusinessDataServiceHelper.load((String)"cal_bd_calrange", (String)"id,entry.id", (QFilter[])q.toArray())) {
            if (!calRangeInfo.getDynamicObjectCollection("entry").isEmpty()) continue;
            return true;
        }
        return false;
    }
}

