/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.base;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.cal.business.balance.recal.CalBalRecalHandle;
import kd.fi.cal.business.calculate.billgroup.CostAccountGroupRecordHelper;
import kd.fi.cal.business.helper.DomainBalHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.opplugin.validator.BaseDataModifyValidator;
import kd.fi.cal.opplugin.validator.CostAccountIsMainValidator;
import kd.fi.cal.opplugin.validator.CostAccountMustInputValidator;
import kd.fi.cal.opplugin.validator.CostAccountTypeValidator;

public class CostAccountSaveOP
extends AbstractOperationServicePlugIn {
    private static final String ISREFRESHGROUPRECORD = "isrefreshgrouprecord";

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("calorg.id");
        e.getFieldKeys().add("calorg.orgpattern");
        e.getFieldKeys().add("calorg.orgpattern.patterntype");
        e.getFieldKeys().add("ismainaccount");
        e.getFieldKeys().add("dividebasis");
        e.getFieldKeys().add("calsystem");
        e.getFieldKeys().add("calpolicy");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        Object id = e.getDataEntities()[0].getPkValue();
        if (QueryServiceHelper.exists((String)"cal_bd_costaccount", (Object)id)) {
            DynamicObject oldInfo = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cal_bd_costaccount", (String)"id,dividebasis,booktype");
            if (oldInfo != null && (oldInfo.getDynamicObject("dividebasis") == null || oldInfo.getDynamicObject("dividebasis").getLong("id") != e.getDataEntities()[0].getDynamicObject("dividebasis").getLong("id"))) {
                QFilter q = new QFilter("costaccount", "=", id);
                q.and("enable", "=", (Object)"1");
                q.and("status", "=", (Object)"C");
                DynamicObjectCollection calRanges = QueryServiceHelper.query((String)"cal_bd_calrange", (String)"id", (QFilter[])q.toArray());
                if (!calRanges.isEmpty()) {
                    HashSet<Long> calRangeIdSet = new HashSet<Long>();
                    StringBuilder sBuffer = new StringBuilder(32);
                    for (DynamicObject calRange : calRanges) {
                        calRangeIdSet.add(calRange.getLong("id"));
                        sBuffer.append(calRange.getLong("id"));
                        sBuffer.append(',');
                    }
                    String calRangeIds = sBuffer.toString();
                    calRangeIds = calRangeIds.substring(0, calRangeIds.length() - 1);
                    OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_bd_calrange", (Object[])calRangeIdSet.toArray(), (OperateOption)OperateOption.create());
                    List errors = result.getAllErrorOrValidateInfo();
                    if (!errors.isEmpty()) {
                        StringBuilder strContain = new StringBuilder();
                        for (IOperateInfo error : errors) {
                            OperateInfo operror = (OperateInfo)error;
                            strContain.append(operror.getMessage());
                        }
                        strContain.append(ResManager.loadKDString((String)"(\u6210\u672c\u8d26\u7c3f\u4fee\u6539\u5212\u5206\u4f9d\u636e\uff0c\u89e6\u53d1\u5bf9\u5e94\u6838\u7b97\u8303\u56f4\u53cd\u5ba1\u6838\u5931\u8d25)", (String)"CostAccountSaveOP_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                        throw new KDBizException(strContain.toString());
                    }
                    String randomid = this.getOption().getVariableValue("randomid");
                    AppCache.get((String)"cal").put(randomid, (Object)calRangeIds);
                }
            } else if (oldInfo != null && oldInfo.getDynamicObject("booktype").getLong("id") != e.getDataEntities()[0].getDynamicObject("booktype").getLong("id")) {
                this.getOption().setVariableValue(ISREFRESHGROUPRECORD, "true");
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (this.getOption().containsVariable(ISREFRESHGROUPRECORD)) {
            ThreadPools.executeOnce((String)CostAccountSaveOP.class.getName(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    new CostAccountGroupRecordHelper().rebuildAllGroupRecord();
                }
            });
        }
        if (this.isHashNoDataBalance().booleanValue()) {
            CalBalRecalHandle.periodChangeEngine((boolean)Boolean.TRUE);
            CalDbParamServiceHelper.updateParam((String)CalDbParamConstant.BIZGROUP_MODEL, (String)"true", null);
            ArrayList<String> enablePks = new ArrayList<String>(2);
            enablePks.add("1925354803823900672");
            enablePks.add("1925355340115997696");
            enablePks.add("1928940555946265600");
            enablePks.add("1928940777875277824");
            CalBalanceModelHelper.updateBalRuleStatus((String)"disable", enablePks);
            ArrayList<String> disablepks = new ArrayList<String>(2);
            disablepks.add("1169503483590606848");
            disablepks.add("1169503961279889408");
            disablepks.add("1169492639108562944");
            disablepks.add("1169499921376608256");
            disablepks.add("1169502514765103104");
            disablepks.add("1159354520774529024");
            disablepks.add("1169491377411588096");
            disablepks.add("1169502927140683776");
            CalBalanceModelHelper.updateBalRuleStatus((String)"enable", disablepks);
            CalDbParamServiceHelper.updateParam((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION, (String)"true", null);
            new DomainBalHelper().disableDomainBal();
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        if (QueryServiceHelper.exists((String)"cal_bd_costaccount", (Object)e.getDataEntities()[0].getPkValue()) && !this.canModify(e.getDataEntities()[0])) {
            BaseDataModifyValidator validator = new BaseDataModifyValidator();
            String entityKey = this.billEntityType.getName();
            validator.setOption(this.getOption());
            validator.setEntityType((BasedataEntityType)this.billEntityType);
            validator.setEntityKey(entityKey);
            validator.setOperationName(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"CostAccountSaveOP_1", (String)"fi-cal-opplugin", (Object[])new Object[0]));
            validator.setOperateKey("save");
            validator.setOperateType("save");
            e.addValidator((AbstractValidator)validator);
        }
        e.addValidator((AbstractValidator)new CostAccountIsMainValidator());
        e.addValidator((AbstractValidator)new CostAccountTypeValidator());
        String key = (String)this.operateMeta.get("type");
        if ("save".equals(key)) {
            e.addValidator((AbstractValidator)new CostAccountMustInputValidator());
        }
    }

    private boolean canModify(DynamicObject info) {
        DynamicObject oldInfo = BusinessDataServiceHelper.loadSingle((Object)info.getPkValue(), (String)"cal_bd_costaccount", (String)"id,calorg,calsystem,calpolicy");
        return oldInfo != null && oldInfo.getDynamicObject("calorg").getLong("id") == info.getDynamicObject("calorg").getLong("id") && oldInfo.getDynamicObject("calsystem").getLong("id") == info.getDynamicObject("calsystem").getLong("id") && oldInfo.getDynamicObject("calpolicy").getLong("id") == info.getDynamicObject("calpolicy").getLong("id");
    }

    private Boolean isHashNoDataBalance() {
        DataSet balanceData = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.opplugin.base.CostAccountSaveOP.isHashNoDataBalance", (String)"cal_balance", (String)"id", null, null, (int)1);
        DataSet balData = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.opplugin.base.CostAccountSaveOP.isHashNoDataBalance", (String)"cal_bal", (String)"id", null, null, (int)1);
        return balanceData.isEmpty() && balData.isEmpty();
    }
}

