/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.base;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.cal.business.calculate.billgroup.CostAccountGroupRecordHelper;
import kd.fi.cal.common.util.CommonUtils;

public class CostAccountTypeSavePlugin
extends AbstractOperationServicePlugIn {
    private static final String NEED_REFRESHGROUPRECORD = "need_refreshgrouprecord";

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity dataEntity;
                DynamicObject info;
                Long actBillId;
                ExtendedDataEntity[] extendedDataEntityArray = this.dataEntities;
                int n = extendedDataEntityArray.length;
                for (int i = 0; i < n && (actBillId = Long.valueOf((info = (dataEntity = extendedDataEntityArray[i]).getDataEntity()).getLong("id"))) != null && Long.compare(0L, actBillId) != 0; ++i) {
                    DynamicObject accountObj;
                    String newGroupType;
                    DynamicObject accountTypeObj = QueryServiceHelper.queryOne((String)"cal_bd_costaccounttype", (String)"groupcosttype", (QFilter[])new QFilter("id", "=", (Object)actBillId).toArray());
                    String oldGroupType = CommonUtils.trimComma((String)accountTypeObj.getString("groupcosttype"));
                    if (oldGroupType.equals(newGroupType = CommonUtils.trimComma((String)info.getString("groupcosttype"))) || (accountObj = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"id", (QFilter[])new QFilter("booktype", "=", (Object)actBillId).toArray())) == null) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7c7b\u522b\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u8d26\u7c3f\u7c7b\u522b\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"CostAccountTypeSavePlugin_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject type : e.getDataEntities()) {
            if (!type.getDataEntityState().getFromDatabase()) continue;
            DynamicObject oldType = BusinessDataServiceHelper.loadSingle((Object)type.getPkValue(), (String)"cal_bd_costaccounttype");
            if (!this.isRefered(type.getPkValue()) || oldType.getBoolean("isingroup") == type.getBoolean("isingroup")) continue;
            this.getOption().setVariableValue(NEED_REFRESHGROUPRECORD, "true");
            break;
        }
    }

    private boolean isRefered(Object typeId) {
        QFilter filter = new QFilter("booktype", "=", typeId);
        return QueryServiceHelper.exists((String)"cal_bd_costaccount", (QFilter[])filter.toArray());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (this.getOption().containsVariable(NEED_REFRESHGROUPRECORD)) {
            ThreadPools.executeOnce((String)CostAccountTypeSavePlugin.class.getName(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    new CostAccountGroupRecordHelper().rebuildAllGroupRecord();
                }
            });
        }
    }
}

