/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.base;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.opplugin.validator.BaseDataModifyValidator;

public class DivideBasisSaveOrSubmitOP
extends AbstractOperationServicePlugIn {
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        if ("save".equals(key) || "submit".equals(key)) {
            this.doBefore(e);
        }
    }

    private void doBefore(BeginOperationTransactionArgs e) {
        DynamicObject[] dynamicObjects = e.getDataEntities();
        DynamicObject dynamicObject = null;
        String dividebasis = null;
        for (int i = 0; i < dynamicObjects.length; ++i) {
            dynamicObject = dynamicObjects[i];
            dividebasis = dynamicObject.getString("dividebasis");
            dividebasis = this.trimComma(dividebasis);
            dynamicObject.set("dividebasis", (Object)dividebasis);
            dynamicObject.set("displayname", (Object)this.getDisplayName(dividebasis));
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    this.doCheck(dataEntity);
                }
            }

            private void doCheck(ExtendedDataEntity dataEntity) {
                DynamicObject dynamicObject = dataEntity.getDataEntity();
                String dividebasis = dynamicObject.getString("dividebasis");
                String name = dynamicObject.getString("name");
                String number = dynamicObject.getString("number");
                if (dividebasis == null || name == null || number == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u68c0\u67e5\u5fc5\u5f55\u9879\u3002", (String)"DivideBasisSaveOrSubmitOP_2", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                }
                String newDivideBasis = DivideBasisSaveOrSubmitOP.this.trimComma(dividebasis);
                HashSet<String> newSet = new HashSet<String>(16);
                for (String divideBasis : newDivideBasis.split(",")) {
                    newSet.add(divideBasis);
                }
                QFilter q = new QFilter("id", "<>", dynamicObject.getPkValue());
                DynamicObjectCollection oldInfos = QueryServiceHelper.query((String)"cal_bd_dividebasis", (String)"id,number,dividebasis", (QFilter[])new QFilter[]{q});
                for (DynamicObject oldInfo : oldInfos) {
                    String oldDivideBasis = DivideBasisSaveOrSubmitOP.this.trimComma(oldInfo.getString("dividebasis"));
                    HashSet<String> oldSet = new HashSet<String>(16);
                    for (String divideBasis : oldDivideBasis.split(",")) {
                        oldSet.add(divideBasis);
                    }
                    if (!CommonUtils.isSetEqual(newSet, oldSet)) continue;
                    String msg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7684\u5212\u5206\u4f9d\u636e,\u7f16\u7801\u4e3a%1$s", (String)"DivideBasisSaveOrSubmitOP_0", (String)"fi-cal-opplugin", (Object[])new Object[0]), oldInfo.get("number") + "");
                    this.addErrorMessage(dataEntity, msg);
                    return;
                }
            }
        });
        if (QueryServiceHelper.exists((String)"cal_bd_dividebasis", (Object)e.getDataEntities()[0].getPkValue()) && !this.canModify(e.getDataEntities()[0])) {
            BaseDataModifyValidator validator = new BaseDataModifyValidator();
            String entityKey = this.billEntityType.getName();
            validator.setOption(this.getOption());
            validator.setEntityType((BasedataEntityType)this.billEntityType);
            validator.setEntityKey(entityKey);
            validator.setOperationName(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"DivideBasisSaveOrSubmitOP_1", (String)"fi-cal-opplugin", (Object[])new Object[0]));
            validator.setOperateKey("save");
            validator.setOperateType("save");
        }
    }

    private boolean canModify(DynamicObject info) {
        String oldDividebasis;
        String dividebasis;
        DynamicObject oldInfo = BusinessDataServiceHelper.loadSingle((Object)info.getPkValue(), (String)"cal_bd_dividebasis", (String)"id,dividebasis");
        return oldInfo != null && (dividebasis = this.trimComma(info.getString("dividebasis"))).equals(oldDividebasis = this.trimComma(oldInfo.getString("dividebasis")));
    }

    private String getDisplayName(String dividebasis) {
        String[] divideBasisArr;
        StringBuilder displayname = new StringBuilder();
        String balanceEntity = CalBalanceModelHelper.isNewBalance() ? "cal_bal" : "cal_balance";
        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)balanceEntity);
        for (String s : divideBasisArr = dividebasis.split(",")) {
            if (StringUtils.isEmpty((String)s)) continue;
            IDataEntityProperty pro = entitytype.findProperty(s);
            displayname.append(pro.getDisplayName()).append('+');
        }
        return displayname.substring(0, displayname.length() - 1);
    }

    private String trimComma(String dividebasis) {
        if (dividebasis.startsWith(",")) {
            dividebasis = dividebasis.substring(1, dividebasis.length());
        }
        if (dividebasis.endsWith(",")) {
            dividebasis = dividebasis.substring(0, dividebasis.length() - 1);
        }
        return dividebasis;
    }
}

