/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.base;

import java.util.Collections;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.cal.business.autosort.AutoSortHelperNew;
import kd.fi.cal.business.calculate.billgroup.AutoSortServic;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.opplugin.base.AccountTypeAuditOrUnAuditOP;
import kd.fi.cal.opplugin.base.WriteBackCostRecordAccTypeHelper;
import kd.fi.cal.opplugin.validator.MatAccountAndDimValidator;

public class MaterialDimensionAuditOrUnAuditOP
extends AccountTypeAuditOrUnAuditOP {
    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new MatAccountAndDimValidator());
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("calrange");
        e.getFieldKeys().add("entry.caldimension");
        e.getFieldKeys().add("entry.material");
        e.getFieldKeys().add("entry.materialgroup");
    }

    @Override
    protected Object getMainValueByEntry(DynamicObject entry) {
        return entry.getDynamicObject("caldimension").getLong("id");
    }

    @Override
    protected Object getMainValueByCalrange(DynamicObject calRange) {
        return calRange.getDynamicObject("caldimension") == null ? 0L : calRange.getDynamicObject("caldimension").getLong("id");
    }

    @Override
    protected void writeBackBill(long costAccountId, long calRangeId, Set<Long> materialSet, Object mainValue) {
        WriteBackCostRecordAccTypeHelper.writeBack4CaldimensionChanged(costAccountId, calRangeId, materialSet, (Long)mainValue);
        if (AcctGroupModelHelper.isNewGroupModel()) {
            AutoSortServic sortService = new AutoSortServic();
            try (TraceSpan span = Tracer.create((String)"sortByAcctIds", (String)"sortByAcctIds");){
                sortService.sortByAsyncByAccountId(Collections.singleton(costAccountId));
            }
        } else {
            String desc = ResManager.loadKDString((String)"\u7269\u6599\u6838\u7b97\u7ef4\u5ea6\u4fee\u6539", (String)"MaterialDimensionAuditOrUnAuditOP_1", (String)"fi-cal-opplugin", (Object[])new Object[0]);
            new AutoSortHelperNew().rebuildAllSortResultByCostAccounts(Collections.singleton(costAccountId), desc);
        }
    }
}

