/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.base;

import java.util.Collections;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.cal.business.autosort.AutoSortHelperNew;
import kd.fi.cal.business.calculate.billgroup.AutoSortServic;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.opplugin.base.AccountTypeEnableOP;
import kd.fi.cal.opplugin.base.WriteBackCostRecordAccTypeHelper;

public class MaterialDimensionEnableOP
extends AccountTypeEnableOP {
    @Override
    public String getMainEntityName() {
        return "cal_bd_materialdimension";
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entry.caldimension");
    }

    @Override
    protected Object getMainValueByEntry(DynamicObject entry) {
        return entry.getDynamicObject("caldimension").getLong("id");
    }

    @Override
    protected void writeBackBill(long costAccountId, long calRangeId, Set<Long> materialSet, Object mainValue) {
        WriteBackCostRecordAccTypeHelper.writeBack4CaldimensionChanged(costAccountId, calRangeId, materialSet, (Long)mainValue);
        if (AcctGroupModelHelper.isNewGroupModel()) {
            AutoSortServic sortService = new AutoSortServic();
            try (TraceSpan span = Tracer.create((String)"sortByAcctIds", (String)"sortByAcctIds");){
                sortService.sortByAsyncByAccountId(Collections.singleton(costAccountId));
            }
        } else {
            String desc = ResManager.loadKDString((String)"\u7269\u6599\u6838\u7b97\u7ef4\u5ea6\u542f\u7528", (String)"MaterialDimensionEnableOP_1", (String)"fi-cal-opplugin", (Object[])new Object[0]);
            new AutoSortHelperNew().rebuildAllSortResultByCostAccounts(Collections.singleton(costAccountId), desc);
        }
    }
}

