/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.base;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.calculate.out.FIFOPeriodDataCalculate;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.AccountType4CostAdjustHelper;
import kd.fi.cal.common.helper.AccountTypeHelperNew;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.util.CommonUtils;

public class WriteBackCostRecordAccTypeHelper {
    private static final int BATCH_SIZE = 10000;
    private static final Log logger = LogFactory.getLog(WriteBackCostRecordAccTypeHelper.class);

    public static void writeBack4AccountTypeChanged(long costAccountId, long calRangeId, Set materialSet, String accountType) {
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccountId);
        if (period == null) {
            return;
        }
        Date date = period.getDate("beginDate");
        WriteBackCostRecordAccTypeHelper.writeBack4AccountTypeChanged(costAccountId, calRangeId, materialSet, accountType, date, "entry", "cal_costrecord", "t_cal_calcostrecordentry");
        WriteBackCostRecordAccTypeHelper.writeBack4AccountTypeChanged(costAccountId, calRangeId, materialSet, accountType, date, "entryentity", "cal_costadjustbill", "t_cal_costadjustbillentry");
    }

    public static void writeBack4CaldimensionChanged(long costAccountId, long calRangeId, Set materialSet, long caldimension) {
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccountId);
        if (period == null) {
            return;
        }
        Date date = period.getDate("beginDate");
        WriteBackCostRecordAccTypeHelper.writeBack4CaldimensionChanged(costAccountId, calRangeId, materialSet, caldimension, date, "entry", "cal_costrecord", "t_cal_calcostrecordentry");
        WriteBackCostRecordAccTypeHelper.writeBack4CaldimensionChanged(costAccountId, calRangeId, materialSet, caldimension, date, "entryentity", "cal_costadjustbill", "t_cal_costadjustbillentry");
        WriteBackCostRecordAccTypeHelper.writeBackFIFOBal(costAccountId, period.getLong("id"));
    }

    public static void writeBack4CalRangeId(DynamicObject calRangeInfo) {
        List<String> basisFieldList = WriteBackCostRecordAccTypeHelper.getDividebasisField(calRangeInfo);
        DynamicObject costAccount = calRangeInfo.getDynamicObject("costaccount");
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
        if (period == null) {
            return;
        }
        Date date = period.getDate("beginDate");
        Set<String> caldimensionFieldSet = WriteBackCostRecordAccTypeHelper.getCalDims(basisFieldList);
        WriteBackCostRecordAccTypeHelper.writeBackCostRecord4CalRangeId(calRangeInfo, date, costAccount, caldimensionFieldSet);
        WriteBackCostRecordAccTypeHelper.writeBackCostAdjust4CalRangeId(calRangeInfo, date, costAccount, caldimensionFieldSet);
        WriteBackCostRecordAccTypeHelper.writeBackFIFOBal(costAccount.getLong("id"), period.getLong("id"));
    }

    private static List<String> getDividebasisField(DynamicObject calRangeInfo) {
        DynamicObject basisInfo = calRangeInfo.getDynamicObject("dividebasis");
        ArrayList<String> basis = new ArrayList<String>(32);
        String dividebasis = basisInfo.getString("dividebasis");
        for (String s : dividebasis.split(",")) {
            basis.add(s);
        }
        return basis;
    }

    public static void writeBackByCalRangeBasisField(DynamicObject calRangeInfo) {
        List<String> basisFieldList = WriteBackCostRecordAccTypeHelper.getDividebasisField(calRangeInfo);
        DynamicObject costAccount = calRangeInfo.getDynamicObject("costaccount");
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
        if (period == null) {
            return;
        }
        Date date = period.getDate("beginDate");
        WriteBackCostRecordAccTypeHelper.writeBackCostRecordByCalRangeBasisField(calRangeInfo, date, costAccount, basisFieldList);
        WriteBackCostRecordAccTypeHelper.writeBackCostAdjustByCalRangeBasisField(calRangeInfo, date, costAccount, basisFieldList);
        WriteBackCostRecordAccTypeHelper.writeBackFIFOBal(costAccount.getLong("id"), period.getLong("id"));
    }

    private static void writeBack4AccountTypeChanged(long costAccountId, long calRangeId, Set materialSet, String accountType, Date date, String entryName, String entityName, String tableName) {
        HashMap<Long, Long> entryIdAndBillIdMap = new HashMap<Long, Long>(16);
        HashSet<Long> billIdSet = new HashSet<Long>(16);
        List<Set<Long>> idSetList = WriteBackCostRecordAccTypeHelper.getEntryIds(costAccountId, calRangeId, materialSet, date, entryName, entityName, entryIdAndBillIdMap);
        if (idSetList.isEmpty()) {
            return;
        }
        for (Set<Long> idSet : idSetList) {
            billIdSet.clear();
            for (Long id : idSet) {
                Long billId = (Long)entryIdAndBillIdMap.get(id);
                if (billId == null) continue;
                billIdSet.add(billId);
            }
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("update " + tableName + " set faccounttype = ?", new Object[]{accountType}).append("where", new Object[0]);
            sqlBuilder.appendIn("fentryid", idSet.toArray());
            sqlBuilder.append("and", new Object[0]);
            sqlBuilder.appendIn("fid", billIdSet.toArray());
            DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (SqlBuilder)sqlBuilder);
        }
    }

    private static void writeBack4CaldimensionChanged(long costAccountId, long calRangeId, Set materialSet, long caldimension, Date date, String entryName, String entityName, String tableName) {
        HashMap<Long, Long> entryIdAndBillIdMap = new HashMap<Long, Long>(16);
        HashSet<Long> billIdSet = new HashSet<Long>(16);
        List<Set<Long>> idSetList = WriteBackCostRecordAccTypeHelper.getEntryIds(costAccountId, calRangeId, materialSet, date, entryName, entityName, entryIdAndBillIdMap);
        if (idSetList.isEmpty()) {
            return;
        }
        for (Set<Long> idSet : idSetList) {
            billIdSet.clear();
            for (Long id : idSet) {
                Long billId = (Long)entryIdAndBillIdMap.get(id);
                if (billId == null) continue;
                billIdSet.add(billId);
            }
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("update " + tableName + " set fcaldimensionid = ?", new Object[]{caldimension}).append("where", new Object[0]);
            sqlBuilder.appendIn("fentryid", idSet.toArray());
            sqlBuilder.append("and", new Object[0]);
            sqlBuilder.appendIn("fid", billIdSet.toArray());
            DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (SqlBuilder)sqlBuilder);
        }
    }

    private static List<Set<Long>> getEntryIds(long costAccountId, long calRangeId, Set materialSet, Date date, String entryName, String entityName, Map<Long, Long> entryIdAndBillIdMap) {
        int batchSize = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.QUERY_IN_SPRITSIZE);
        QFilter q = new QFilter(entryName + ".calrange", "=", (Object)calRangeId);
        q.and("bookdate", ">=", (Object)date);
        q.and("costaccount", "=", (Object)costAccountId);
        if (materialSet != null && !materialSet.isEmpty()) {
            q.and(entryName + ".material", "in", (Object)materialSet);
        } else {
            q.and(entryName + ".material", "=", (Object)-1L);
        }
        ArrayList<Set<Long>> idList = new ArrayList<Set<Long>>(10);
        HashSet<Long> idSet = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)WriteBackCostRecordAccTypeHelper.class.getName(), (String)entityName, (String)("id," + entryName + ".id"), (QFilter[])new QFilter[]{q}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                if (idSet == null || idSet.size() >= batchSize) {
                    idSet = new HashSet<Long>(batchSize);
                    idList.add(idSet);
                }
                Long entryId = row.getLong(entryName + ".id");
                idSet.add(entryId);
                if (entryIdAndBillIdMap == null) continue;
                entryIdAndBillIdMap.put(entryId, row.getLong("id"));
            }
        }
        if (idSet != null && !idSet.isEmpty()) {
            idList.add(idSet);
        }
        return idList;
    }

    private static void writeBackCostRecord4CalRangeId(DynamicObject calRangeInfo, Date date, DynamicObject costAccount, Set<String> basisFieldList) {
        QFilter q = new QFilter("entry.calrange", "=", calRangeInfo.get("id"));
        q.and("bizdate", ">=", (Object)date);
        q.and("costaccount", "=", costAccount.get("id"));
        MainEntityType costRecordEntityType = EntityMetadataCache.getDataEntityType((String)"cal_costrecord");
        StringBuilder sBuffer = new StringBuilder(32);
        for (String field : basisFieldList) {
            if (costRecordEntityType.findProperty(field).getParent() instanceof EntryType) {
                sBuffer.append(",entry.");
                sBuffer.append(field);
                continue;
            }
            sBuffer.append(',');
            sBuffer.append(field);
        }
        String basisFields = sBuffer.toString();
        DynamicObject[] costRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)("id,costaccount,entry.id,entry.material,entry.ownertype,entry.calrange,entry.accounttype,entry.caldimension,entry.costdomainkey" + basisFields), (QFilter[])new QFilter[]{q});
        new AccountTypeHelperNew(costRecords).handleCalRangeAccountType();
        WriteBackCostRecordAccTypeHelper.writeCostRecord(costRecords);
    }

    private static void writeBackCostAdjust4CalRangeId(DynamicObject calRangeInfo, Date date, DynamicObject costAccount, Set<String> basisFieldList) {
        QFilter q = new QFilter("entryentity.calrange", "=", calRangeInfo.get("id"));
        q.and("bizdate", ">=", (Object)date);
        q.and("costaccount", "=", costAccount.get("id"));
        MainEntityType costAdjustEntityType = EntityMetadataCache.getDataEntityType((String)"cal_costadjustbill");
        StringBuilder sBuffer = new StringBuilder(32);
        for (String field : basisFieldList) {
            if (costAdjustEntityType.findProperty(field.toString()).getParent() instanceof EntryType) {
                sBuffer.append(",entryentity.");
                sBuffer.append((Object)field);
                continue;
            }
            sBuffer.append(',');
            sBuffer.append((Object)field);
        }
        String basisFields = sBuffer.toString();
        DynamicObject[] costAdjusts = BusinessDataServiceHelper.load((String)"cal_costadjustbill", (String)("id,costaccount,entryentity.material,entryentity.ownertype,entryentity.calrange,entryentity.accounttype,entryentity.caldimension,entryentity.costdomainkey" + basisFields), (QFilter[])new QFilter[]{q});
        new AccountType4CostAdjustHelper(costAdjusts).handleCalRangeAccountType();
        WriteBackCostRecordAccTypeHelper.writeCostAjudst(costAdjusts);
    }

    private static void writeBackCostRecordByCalRangeBasisField(DynamicObject calRangeInfo, Date date, DynamicObject costAccount, List basisFieldList) {
        MainEntityType costRecordEntityType = EntityMetadataCache.getDataEntityType((String)"cal_costrecord");
        QFilter q1 = new QFilter("costaccount", "=", (Object)costAccount.getLong("id"));
        q1.and("bizdate", ">=", (Object)date);
        DynamicObjectCollection coll = calRangeInfo.getDynamicObjectCollection("entry");
        if (coll.size() > 0) {
            QFilter q2 = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
            DynamicObject tempDynamic = null;
            for (DynamicObject entry : coll) {
                QFilter q3 = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
                for (Object field : basisFieldList) {
                    String costRecordField = field.toString();
                    tempDynamic = entry.getDynamicObject(costRecordField);
                    Long value = tempDynamic == null ? 0L : tempDynamic.getLong("id");
                    if (costRecordEntityType.findProperty(costRecordField).getParent() instanceof EntryType) {
                        q3.and("entry." + costRecordField, "=", (Object)value);
                        continue;
                    }
                    q3.and(costRecordField, "=", (Object)value);
                }
                q2 = q2.or(q3);
            }
            q1.and(q2);
        } else {
            q1.and("entry.calrange", "in", (Object)new Object[]{0L, calRangeInfo.getLong("id")});
        }
        StringBuilder sBuffer = new StringBuilder(32);
        Set<String> caldimensionFieldSet = WriteBackCostRecordAccTypeHelper.getCalDims(basisFieldList);
        for (String field : caldimensionFieldSet) {
            if (costRecordEntityType.findProperty(field.toString()).getParent() instanceof EntryType) {
                sBuffer.append(",entry.");
                sBuffer.append((Object)field);
                continue;
            }
            sBuffer.append(',');
            sBuffer.append((Object)field);
        }
        String basisFields = sBuffer.toString();
        DynamicObject[] costRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)("id,costaccount,entry.id,entry.material,entry.ownertype,entry.calrange,entry.accounttype,entry.caldimension,entry.costdomainkey" + basisFields), (QFilter[])new QFilter[]{q1});
        new AccountTypeHelperNew(costRecords).handleCalRangeAccountType();
        WriteBackCostRecordAccTypeHelper.writeCostRecord(costRecords);
    }

    private static Set<String> getCalDims(List basisFieldList) {
        String caldimensionFieldsStr = CommonSettingHelper.getCalDimensionStr();
        HashSet<String> caldimensionFieldSet = new HashSet<String>(16);
        if (!StringUtils.isEmpty((String)caldimensionFieldsStr)) {
            String[] caldimensionFieldsStrs;
            for (String caldimension : caldimensionFieldsStrs = caldimensionFieldsStr.split(",")) {
                if (StringUtils.isEmpty((String)caldimension)) continue;
                caldimensionFieldSet.add(caldimension);
            }
        }
        caldimensionFieldSet.addAll(basisFieldList);
        return caldimensionFieldSet;
    }

    private static void writeBackCostAdjustByCalRangeBasisField(DynamicObject calRangeInfo, Date date, DynamicObject costAccount, List basisFieldList) {
        MainEntityType costAdjustEntityType = EntityMetadataCache.getDataEntityType((String)"cal_costadjustbill");
        QFilter q1 = new QFilter("costaccount", "=", (Object)costAccount.getLong("id"));
        q1.and("bizdate", ">=", (Object)date);
        DynamicObjectCollection coll = calRangeInfo.getDynamicObjectCollection("entry");
        if (coll.size() > 0) {
            QFilter q2 = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
            DynamicObject tempDynamic = null;
            for (DynamicObject entry : coll) {
                QFilter q3 = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
                for (Object field : basisFieldList) {
                    String costRecordField = field.toString();
                    tempDynamic = entry.getDynamicObject(costRecordField);
                    Long value = tempDynamic == null ? 0L : tempDynamic.getLong("id");
                    if (costAdjustEntityType.findProperty(costRecordField).getParent() instanceof EntryType) {
                        q3.and("entryentity." + costRecordField, "=", (Object)value);
                        continue;
                    }
                    q3.and(costRecordField, "=", (Object)value);
                }
                q2 = q2.or(q3);
            }
            q1.and(q2);
        } else {
            q1.and("entryentity.calrange", "in", (Object)new Object[]{0L, calRangeInfo.getLong("id")});
        }
        StringBuilder sBuffer = new StringBuilder(32);
        Set<String> caldimensionFieldSet = WriteBackCostRecordAccTypeHelper.getCalDims(basisFieldList);
        for (String field : caldimensionFieldSet) {
            if (costAdjustEntityType.findProperty(field.toString()).getParent() instanceof EntryType) {
                sBuffer.append(",entryentity.");
                sBuffer.append((Object)field);
                continue;
            }
            sBuffer.append(',');
            sBuffer.append((Object)field);
        }
        String basisFields = sBuffer.toString();
        DynamicObject[] costAdjusts = BusinessDataServiceHelper.load((String)"cal_costadjustbill", (String)("id,costaccount,entryentity.material,entryentity.ownertype,entryentity.calrange,entryentity.accounttype,entryentity.caldimension,entryentity.costdomainkey" + basisFields), (QFilter[])new QFilter[]{q1});
        new AccountType4CostAdjustHelper(costAdjusts).handleCalRangeAccountType();
        WriteBackCostRecordAccTypeHelper.writeCostAjudst(costAdjusts);
    }

    private static void writeBackFIFOBal(long costaccountId, long periodId) {
        QFilter q = new QFilter("costaccount", "=", (Object)costaccountId);
        q.and("period", "=", (Object)periodId);
        HashSet<Long> entryIdSet = new HashSet<Long>(16);
        HashSet<Long> billIdSet = new HashSet<Long>(16);
        HashSet<Long> detailSet = new HashSet<Long>(16);
        HashSet<String> billNoSet = new HashSet<String>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)WriteBackCostRecordAccTypeHelper.class.getName(), (String)"cal_balance_fifo_period", (String)"billno,billentryid", (QFilter[])q.toArray(), null);){
            for (Row row : dataSet) {
                entryIdSet.add(row.getLong("billentryid"));
                billNoSet.add(row.getString("billno"));
            }
        }
        if (entryIdSet.isEmpty()) {
            return;
        }
        var10_8 = null;
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fbillno", FilterType.in_range, billNoSet)});){
            ctx.set();
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)WriteBackCostRecordAccTypeHelper.class.getName(), (String)"cal_costrecord_subentity", (String)"id,entry.id,entry.subentrycostelement.id", (QFilter[])new QFilter("entry.id", "in", entryIdSet).toArray(), null);){
                for (Row row : dataSet) {
                    billIdSet.add(row.getLong("id"));
                    detailSet.add(row.getLong("entry.subentrycostelement.id"));
                }
                new FIFOPeriodDataCalculate(costaccountId, new HashSet(1)).updateFIFOBalDivideFields(detailSet, entryIdSet, billIdSet);
            }
        }
        catch (Throwable throwable) {
            var10_8 = throwable;
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void writeCostRecord(DynamicObject[] costRecords) {
        void var5_7;
        ArrayList list = new ArrayList(10);
        ArrayList<Object[]> subList = null;
        DynamicObject[] dynamicObjectArray = costRecords;
        int n = dynamicObjectArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            DynamicObject info = dynamicObjectArray[var5_7];
            for (DynamicObject entry : info.getDynamicObjectCollection("entry")) {
                Object calRangeId = entry.get("calrange");
                if (calRangeId == null || calRangeId.toString().equals("0") || Long.parseLong(calRangeId.toString()) == 0L) continue;
                String accountType = entry.getString("accounttype");
                DynamicObject caldimension = entry.getDynamicObject("caldimension");
                String costDomainKey = entry.getString("costdomainkey");
                long caldimensionId = 0L;
                if (StringUtils.isEmpty((String)accountType)) {
                    accountType = " ";
                }
                if (caldimension != null) {
                    caldimensionId = caldimension.getLong("id");
                }
                if (subList == null || subList.size() >= 10000) {
                    subList = new ArrayList<Object[]>(10000);
                    list.add(subList);
                }
                subList.add(new Object[]{calRangeId, accountType, caldimensionId, costDomainKey, entry.get("id")});
            }
            ++var5_7;
        }
        if (subList != null && !subList.isEmpty()) {
            list.add(subList);
        }
        String sql = "update t_cal_calcostrecordentry set fcalrangeid = ?,faccounttype = ?,fcaldimensionid = ?, fcostdomainkey = ? where fentryid = ?";
        for (List list2 : list) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, (List)list2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void writeCostAjudst(DynamicObject[] costAdjusts) {
        void var5_7;
        ArrayList list = new ArrayList(10);
        ArrayList<Object[]> subList = null;
        DynamicObject[] dynamicObjectArray = costAdjusts;
        int n = dynamicObjectArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            DynamicObject info = dynamicObjectArray[var5_7];
            for (DynamicObject entry : info.getDynamicObjectCollection("entryentity")) {
                Object calRangeId = entry.get("calrange");
                if (calRangeId == null || calRangeId.toString().equals("0") || Long.parseLong(calRangeId.toString()) == 0L) continue;
                String accountType = entry.getString("accounttype");
                DynamicObject caldimension = entry.getDynamicObject("caldimension");
                String costDomainKey = entry.getString("costdomainkey");
                long caldimensionId = 0L;
                if (StringUtils.isEmpty((String)accountType)) {
                    accountType = " ";
                }
                if (caldimension != null) {
                    caldimensionId = caldimension.getLong("id");
                }
                if (subList == null || subList.size() >= 10000) {
                    subList = new ArrayList<Object[]>(10000);
                    list.add(subList);
                }
                subList.add(new Object[]{calRangeId, accountType, caldimensionId, costDomainKey, entry.get("id")});
            }
            ++var5_7;
        }
        if (subList != null && !subList.isEmpty()) {
            list.add(subList);
        }
        String sql = "update t_cal_costadjustbillentry set fcalrangeid = ?,faccounttype = ?,fcaldimensionid = ?,fcostdomainkey = ? where fentryid = ?";
        for (List list2 : list) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, (List)list2);
        }
    }
}

