/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cal.common.enums.AccountTypeEnum;

public class AccountTypeCheckOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] billInfos;
                block0: for (ExtendedDataEntity billInfo : billInfos = this.getDataEntities()) {
                    DynamicObject bill = billInfo.getDataEntity();
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : entrys) {
                        String accountType = entry.getString("accounttype");
                        if (!AccountTypeEnum.FIN_FOUT.getValue().equals(accountType)) continue;
                        this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u5355\u636e\u5305\u542b\u8ba1\u4ef7\u65b9\u6cd5\u4e3a\u5148\u8fdb\u5148\u51fa\u6cd5\u7684\u7269\u6599\uff0c\u8be5\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"InitCalBillUnAuditOp_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                        continue block0;
                    }
                }
            }
        });
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("costaccount");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("entryentity.accounttype");
        e.getFieldKeys().add("entryentity.material");
    }
}

