/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.exception.KDBizException;

public class CostAdjustBillAuditExceFuncOp
extends ReduceGroupFunction {
    private RowMeta rowMeta;

    public CostAdjustBillAuditExceFuncOp(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public Iterator<Object[]> reduce(Iterator<Row> iterator) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(16);
        BigDecimal amt = BigDecimal.ZERO;
        BigDecimal qty = BigDecimal.ZERO;
        Object[] cur = null;
        StringBuilder balanceIdsBuilder = new StringBuilder();
        HashSet<String> balanceids = new HashSet<String>();
        while (iterator.hasNext()) {
            BigDecimal cur_qty;
            Row row = iterator.next();
            Field[] fields = this.getResultRowMeta().getFields();
            Object[] values = new Object[fields.length];
            for (int i = 0; i < fields.length - 2; ++i) {
                values[i] = row.get(this.rowMeta.getFieldIndex(fields[i].getName()));
            }
            cur = values;
            Object id = row.get(this.rowMeta.getFieldIndex("id"));
            balanceids.add(id.toString());
            qty = cur_qty = row.getBigDecimal("periodendqty") == null ? BigDecimal.ZERO : row.getBigDecimal("periodendqty");
            BigDecimal cur_amt = row.getBigDecimal("periodendactualcost") == null ? BigDecimal.ZERO : row.getBigDecimal("periodendactualcost");
            amt = amt.add(cur_amt);
        }
        if (cur == null) {
            throw new KDBizException("export group error");
        }
        dataList.add(cur);
        for (Object[] objects : dataList) {
            objects[this.rowMeta.getFieldIndex((String)"id")] = 0L;
            for (String balanceid : balanceids) {
                balanceIdsBuilder.append(",").append(balanceid);
            }
            objects[this.rowMeta.getFieldCount()] = balanceIdsBuilder.toString();
            objects[this.rowMeta.getFieldIndex((String)"periodendqty")] = qty;
            objects[this.rowMeta.getFieldIndex((String)"periodendactualcost")] = amt;
            objects[this.rowMeta.getFieldIndex((String)"costelement")] = null;
            objects[this.rowMeta.getFieldIndex((String)"costsubelement")] = null;
        }
        return dataList.iterator();
    }

    public RowMeta getResultRowMeta() {
        Field[] fields = this.rowMeta.getFields();
        Field[] resultFields = new Field[fields.length + 1];
        System.arraycopy(fields, 0, resultFields, 0, fields.length);
        resultFields[resultFields.length - 1] = new Field("balanceids", (DataType)DataType.StringType);
        return new RowMeta(resultFields);
    }
}

