/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.balance.PurPriceDiffCalculator;
import kd.fi.cal.business.calculate.out.CalMoveInvoker;
import kd.fi.cal.business.calculate.out.IntimeBufferPoolHandle;
import kd.fi.cal.business.helper.ExceCostHelper;
import kd.fi.cal.business.process.inner.CalMoveDlock;
import kd.fi.cal.business.process.inner.QueueTypeHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.helper.AccountType4CostAdjustHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostAdjustBillOpHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.CostTypeHelper;
import kd.fi.cal.common.helper.MaterialCategoryHandle;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.model.CostAdjustDetailParams;
import kd.fi.cal.common.util.ArrayUtils;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DBUtil;
import kd.fi.cal.common.util.DateUtils;
import kd.fi.cal.opplugin.validator.CalBillMustInputValidator;
import kd.fi.cal.opplugin.validator.CostAdjustBillAuditValidator;

public class CostAdjustBillAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CostAdjustBillAuditOp.class);
    private static final String NOTEMPTY_GROUPFIELD = "calrangeid";
    private static final String EXPORTFLAG = "exportflag";
    private static String[] costtypeFields = new String[]{"auditdate", "costaccount", "calorg", "storageorgunit", "accounttype"};
    protected boolean isNewBalance = CalBalanceModelHelper.isNewBalance();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("isupdatecost");
        e.getFieldKeys().add("entryentity.warehouse.isopenlocation");
        e.getFieldKeys().add("entryentity.material.isuseauxpty");
        e.getFieldKeys().add("entryentity.material.configproperties");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("costaccount.id");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("bizdate");
        e.getFieldKeys().add("bookdate");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("costaccount");
        e.getFieldKeys().add("calorg");
        e.getFieldKeys().add("difftype");
        e.getFieldKeys().add("createtype");
        e.getFieldKeys().add("entryentity.storageorgunit");
        e.getFieldKeys().add("lastupdateuser");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("lastupdatetime");
        e.getFieldKeys().add("entryentity.lot");
        e.getFieldKeys().add("entryentity.adjustamt");
        e.getFieldKeys().add("entryentity.material");
        e.getFieldKeys().add("entryentity.warehouse");
        e.getFieldKeys().add("entryentity.location");
        e.getFieldKeys().add("entryentity.assist");
        e.getFieldKeys().add("entryentity.project");
        e.getFieldKeys().add("entryentity.ownertype");
        e.getFieldKeys().add("entryentity.owner");
        e.getFieldKeys().add("entryentity.calrange");
        e.getFieldKeys().add("entryentity.accounttype");
        e.getFieldKeys().add("entryentity.caldimension");
        e.getFieldKeys().add("entryentity.queuetype");
        e.getFieldKeys().add("entryentity.signnum");
        e.getFieldKeys().add("entryentity.invbillid");
        e.getFieldKeys().add("period");
        e.getFieldKeys().add("bizdate");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("entryentity.mversion");
        e.getFieldKeys().add("entryentity.seq");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("entryentity.invbizdate");
        e.getFieldKeys().add("entryentity.invauditdate");
        e.getFieldKeys().add("entryentity.invbillid");
        e.getFieldKeys().add("entryentity.invbillentryid");
        e.getFieldKeys().add("entryentity.invbizentityobject");
        e.getFieldKeys().add("entryentity.invbillnum");
        e.getFieldKeys().add("entryentity.subentryentity");
        e.getFieldKeys().add("entryentity.invbiztype");
        e.getFieldKeys().add("entryentity.transtype");
        e.getFieldKeys().add("entryentity.costdomainkey");
        e.getFieldKeys().add("entryentity.ecalstatus");
        e.getFieldKeys().add("entryentity.entrystatus");
        e.getFieldKeys().add("entryentity.tracknumber");
        e.getFieldKeys().add("entryentity.configuredcode");
        e.getFieldKeys().add("entryentity.productline");
        e.getFieldKeys().add("entryentity.noupdatecalfields");
        e.getFieldKeys().add("entryentity.stocktype");
        e.getFieldKeys().add("srcsys");
        e.getFieldKeys().add("calstatus");
        Set exFieldSet = CommonSettingHelper.getExFieldSet();
        for (String entryField : exFieldSet) {
            e.getFieldKeys().add("entryentity." + entryField);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CostAdjustBillAuditValidator());
        e.addValidator((AbstractValidator)new CalBillMustInputValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String errorMsg;
        DynamicObject[] costAdjustBill = e.getDataEntities();
        CostAdjustBillOpHelper helper = new CostAdjustBillOpHelper(costAdjustBill);
        helper.handleBillPeriod(costAdjustBill);
        helper.handleBillCalRange(costAdjustBill);
        this.handleInvDateAndExField(costAdjustBill);
        new AccountType4CostAdjustHelper(costAdjustBill).handleCalRangeAccountType();
        this.checkNullCalRange(costAdjustBill);
        HashSet<String> materialNames = new HashSet<String>(16);
        HashSet<String> notStandardMaterialNames = new HashSet<String>(16);
        HashSet<DynamicObject> needInsertSubentryInfos = new HashSet<DynamicObject>(16);
        for (DynamicObject dynamicObject : costAdjustBill) {
            String accountType;
            DynamicObject entry2;
            String diffType = dynamicObject.getString("difftype");
            String createType = dynamicObject.getString("createtype");
            DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entryentity");
            int seq = 1;
            for (DynamicObject entry2 : entrys) {
                entry2.set("seq", (Object)seq);
                ++seq;
            }
            DynamicObjectCollection subentryentity = ((DynamicObject)entrys.get(0)).getDynamicObjectCollection("subentryentity");
            if (subentryentity == null || subentryentity.size() <= 0) {
                needInsertSubentryInfos.add(dynamicObject);
            }
            if ("B".equals(diffType)) {
                if (!CostAdjustBilCreateTypeEnum.HAND.getValue().equals(createType) && !CostAdjustBilCreateTypeEnum.END_BAL_BILL.getValue().equals(createType)) continue;
                entry2 = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject entryInfo : entry2) {
                    accountType = entryInfo.getString("accountType");
                    if (!AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) continue;
                    materialNames.add("\u3010" + entryInfo.getString("material.name") + "\u3011");
                }
                continue;
            }
            entry2 = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryInfo : entry2) {
                accountType = entryInfo.getString("accountType");
                String invBillNum = entryInfo.getString("invbillnum");
                if (AccountTypeEnum.STANDARDCOST.getValue().equals(accountType) || !StringUtils.isEmpty((String)invBillNum)) continue;
                notStandardMaterialNames.add("\u3010" + entryInfo.getString("material.name") + "\u3011");
            }
        }
        if (!materialNames.isEmpty()) {
            errorMsg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u8ba1\u4ef7\u65b9\u6cd5\u662f\u6807\u51c6\u6210\u672c\u6cd5\u7684\u7269\u6599\u201c%1$s\u201d\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u8c03\u6574\u5b9e\u9645\u6210\u672c\u7684\u6210\u672c\u8c03\u6574\u5355\u3002", (String)"CostAdjustBillAuditOp_2", (String)"fi-cal-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", materialNames));
            throw new KDBizException(errorMsg);
        }
        if (!notStandardMaterialNames.isEmpty()) {
            errorMsg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u8ba1\u4ef7\u65b9\u6cd5\u662f\u975e\u6807\u51c6\u6210\u672c\u6cd5\u7684\u7269\u6599\u201c%1$s\u201d\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u65b0\u589e\u8ba1\u4ef7\u65b9\u6cd5\u662f\u975e\u6807\u51c6\u6210\u672c\u6cd5\u7684\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u3002", (String)"CostAdjustBillAuditOp_3", (String)"fi-cal-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", notStandardMaterialNames));
            throw new KDBizException(errorMsg);
        }
        QueueTypeHelper.assingQueueType4CostAdjust((DynamicObject[])costAdjustBill, (boolean)false, null);
        this.handleInvDateAndExField(costAdjustBill);
        QueueTypeHelper.assingQueueType4CostAdjust((DynamicObject[])e.getDataEntities(), (boolean)false, null);
        ArrayList<Object[]> paramList = new ArrayList();
        if (this.getOption().containsVariable("CostAdjustDetailParms")) {
            String params = this.getOption().getVariableValue("CostAdjustDetailParms");
            if (StringUtils.isNotEmpty((String)params)) {
                List costAdjustDetailParams = SerializationUtils.fromJsonStringToList((String)params, CostAdjustDetailParams.class);
                for (CostAdjustDetailParams param : costAdjustDetailParams) {
                    paramList.add(new Object[]{param.getAdjustAmt(), param.getEntryid(), param.getCostSubElementId(), param.getCostElementId()});
                }
            } else {
                paramList = this.getParamsByMaterial(costAdjustBill);
            }
        } else {
            paramList = this.getParamsByMaterial(costAdjustBill);
        }
        MaterialCategoryHandle.handle4Bill((DynamicObject[])costAdjustBill);
        if (!needInsertSubentryInfos.isEmpty()) {
            CostElementHelper.insertCostElements((DynamicObject[])needInsertSubentryInfos.toArray(new DynamicObject[0]));
            this.updateCostElement(paramList);
            this.updateBillEntryAdjustAmt(paramList);
        }
    }

    private void handleInvDateAndExField(DynamicObject[] costAdjustBills) {
        HashSet<Long> costRecordEntryIds = new HashSet<Long>(16);
        HashSet<Long> costRecordIds = new HashSet<Long>(16);
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        DynamicObject userDyc = BusinessDataServiceHelper.loadSingle((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
        for (DynamicObject info : costAdjustBills) {
            Object difftype;
            String auditor_id;
            info.set("bizdate", (Object)DateUtils.getDayStartTime((Date)info.getDate("bizdate")));
            info.set("bookdate", (Object)DateUtils.getDayStartTime((Date)info.getDate("bookdate")));
            info.set("calstatus", (Object)"A");
            String srcsys = info.getString("srcsys");
            if (StringUtils.isEmpty((String)srcsys)) {
                info.set("srcsys", (Object)"A");
            }
            if (null == info.get("lastupdateuser")) {
                info.set("lastupdateuser_id", userDyc.getPkValue());
                info.set("lastupdatetime", (Object)new Date());
            }
            if (this.getOption().containsVariable("auditor_id") && !StringUtils.isEmpty((String)(auditor_id = this.getOption().getVariableValue("auditor_id"))) && !"0".equals(auditor_id)) {
                info.set("auditor_id", (Object)auditor_id);
                info.set("lastupdateuser_id", (Object)auditor_id);
            }
            if (StringUtils.isEmpty((String)(difftype = info.getString("difftype")))) {
                info.set("difftype", (Object)"B");
            }
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryinfo : entrys) {
                entryinfo.set("ecalstatus", (Object)"A");
                entryinfo.set("entrystatus", (Object)"C");
            }
            String createType = info.getString("createtype");
            if (CostAdjustBilCreateTypeEnum.CAL_OUT_BEFORE_PERIOD.getValue().equals(createType)) continue;
            costAccountIds.add(info.getDynamicObject("costaccount").getLong("id"));
            Date bizDate = info.getDate("bookdate");
            Date auditDate = info.getDate("auditdate");
            int count = 1;
            for (DynamicObject entryinfo : entrys) {
                String invbizentityobject = entryinfo.getString("invbizentityobject");
                Long invbillentryid = entryinfo.getLong("invbillentryid");
                Long invbillid = entryinfo.getLong("invbillid");
                if (StringUtils.isNotEmpty((String)invbizentityobject) && invbillentryid != null && ("cal_costrecord".equals(invbizentityobject) || "cal_costrecord_subentity".equals(invbizentityobject))) {
                    costRecordEntryIds.add(invbillentryid);
                    costRecordIds.add(invbillid);
                } else {
                    entryinfo.set("invbizdate", (Object)bizDate);
                    entryinfo.set("invauditdate", (Object)auditDate);
                }
                entryinfo.set("seq", (Object)count++);
            }
        }
        if (costRecordEntryIds.isEmpty()) {
            return;
        }
        StringBuilder selectFields = new StringBuilder();
        selectFields.append("entry.id");
        selectFields.append(",bizdate");
        selectFields.append(",bookdate");
        selectFields.append(",auditdate");
        selectFields.append(",biztype");
        selectFields.append(",transtype");
        HashSet<String> fields = new HashSet<String>(16);
        Set exFields = CommonSettingHelper.getExFieldSet();
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjust_subentity");
        MainEntityType costRecordEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord_subentity");
        for (String exField : exFields) {
            IDataEntityProperty costadjustField = costAdjustEntityType.findProperty(exField);
            IDataEntityProperty costrecordField = costRecordEntityType.findProperty(exField);
            if (costadjustField == null || costrecordField == null || !(costadjustField.getParent() instanceof EntryType) || !(costrecordField.getParent() instanceof EntryType)) continue;
            fields.add(exField);
            selectFields.append(",entry.");
            selectFields.append(exField);
            selectFields.append(" as ");
            selectFields.append(exField);
        }
        QFilter q = new QFilter("entry.id", "in", costRecordEntryIds);
        q.and("id", "in", costRecordIds);
        q.and("costaccount", "in", costAccountIds);
        HashMap<String, Object> costRecordFieldMap = new HashMap<String, Object>(costRecordEntryIds.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord_subentity", (String)selectFields.toString(), (QFilter[])q.toArray(), null);){
            for (Row row : dataSet) {
                Long entryId = row.getLong("entry.id");
                Date bizdate = row.getDate("bookdate");
                Date auditdate = row.getDate("auditdate");
                Object biztype = row.get("biztype");
                Object transtype = row.get("transtype");
                costRecordFieldMap.put(entryId + "-invbizdate", bizdate);
                costRecordFieldMap.put(entryId + "-invauditdate", auditdate);
                costRecordFieldMap.put(entryId + "-invbiztype", biztype);
                costRecordFieldMap.put(entryId + "-transtype", transtype);
                for (String field : fields) {
                    costRecordFieldMap.put(entryId + "-" + field, row.get(field));
                }
            }
        }
        for (DynamicObject info : costAdjustBills) {
            String createType = info.getString("createtype");
            if (CostAdjustBilCreateTypeEnum.CAL_OUT_BEFORE_PERIOD.getValue().equals(createType)) continue;
            Date bizDate = info.getDate("bookdate");
            Date auditDate = info.getDate("auditdate");
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryinfo : entrys) {
                String invbizentityobject = entryinfo.getString("invbizentityobject");
                Long invbillentryid = entryinfo.getLong("invbillentryid");
                if (!StringUtils.isNotEmpty((String)invbizentityobject) || invbillentryid == null || !"cal_costrecord".equals(invbizentityobject) && !"cal_costrecord_subentity".equals(invbizentityobject)) continue;
                Object invBookDate = costRecordFieldMap.get(invbillentryid + "-invbizdate");
                Object invAuditDate = costRecordFieldMap.get(invbillentryid + "-invauditdate");
                if (invBookDate == null) {
                    invBookDate = bizDate;
                    invAuditDate = auditDate;
                }
                entryinfo.set("invbizdate", invBookDate);
                entryinfo.set("invauditdate", invAuditDate);
                entryinfo.set("invbiztype", costRecordFieldMap.get(invbillentryid + "-invbiztype"));
                entryinfo.set("transtype", costRecordFieldMap.get(invbillentryid + "-transtype"));
                for (String field : fields) {
                    entryinfo.set(field, costRecordFieldMap.get(invbillentryid + "-" + field));
                }
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        Object entryIds;
        super.endOperationTransaction(e);
        BalanceCalculator calculator = new BalanceCalculator();
        ArrayList<Object> calBalanceEntryIds = new ArrayList<Object>(16);
        HashSet<Long> calBallanceIdSet = new HashSet<Long>(32);
        DynamicObject[] costAdjustBill = e.getDataEntities();
        HashMap<Long, HashSet<Long>> costAccountMap = new HashMap<Long, HashSet<Long>>(16);
        HashSet<Long> allBillIds = new HashSet<Long>(16);
        HashMap<Long, Set> endAdjIdEntryIdsMap = new HashMap<Long, Set>(16);
        HashMap<Long, Map> adjIdAndMaterialInfo = new HashMap<Long, Map>(16);
        for (int i = 0; i < costAdjustBill.length; ++i) {
            DynamicObject info = costAdjustBill[i];
            String diffType = info.getString("difftype");
            allBillIds.add(info.getLong("id"));
            String string = info.getString("createtype");
            boolean isEndBalBill = CostAdjustBilCreateTypeEnum.END_BAL_BILL.getValue().equals(string);
            DynamicObjectCollection dynamicObjectCollection = info.getDynamicObjectCollection("entryentity");
            for (Object entry : dynamicObjectCollection) {
                if (!isEndBalBill) continue;
                Set endBalAdjEntryIds = endAdjIdEntryIdsMap.computeIfAbsent(info.getLong("id"), k -> new HashSet(16));
                Map materialInfo = adjIdAndMaterialInfo.computeIfAbsent(info.getLong("id"), k -> new HashMap());
                endBalAdjEntryIds.add((Long)entry.getPkValue());
                materialInfo.put("name", entry.getDynamicObject("material").getString("name"));
                materialInfo.put("number", entry.getDynamicObject("material").getString("number"));
            }
            if ("B".equals(diffType)) {
                calBallanceIdSet.add(info.getLong("id"));
                for (Object entry : dynamicObjectCollection) {
                    calBalanceEntryIds.add(entry.getPkValue());
                }
                long l = info.getLong("costaccount.id");
                HashSet<Long> idSet = (HashSet<Long>)costAccountMap.get(l);
                if (idSet != null) {
                    idSet.add(info.getLong("id"));
                    continue;
                }
                idSet = new HashSet<Long>(16);
                idSet.add(info.getLong("id"));
                costAccountMap.put(l, idSet);
                continue;
            }
            for (Object entry : dynamicObjectCollection) {
                calBalanceEntryIds.add(entry.getPkValue());
            }
        }
        if (this.getOption().containsVariable("ignoreop")) {
            if (this.isNewBalance) {
                Object[] entryIds2 = calBalanceEntryIds.toArray();
                this.updateBal(calculator, allBillIds, entryIds2);
            }
            return;
        }
        if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ENTRY_SPLIT_INTIME_CAL).booleanValue()) {
            IntimeBufferPoolHandle handle = new IntimeBufferPoolHandle(costAdjustBill, "cal_costadjust_subentity", ActionEnum.AUDIT.getValue(), false);
            handle.insertIntoPool();
            Map noInPoolBillIdEntryIdMap = handle.getNoInPoolBillEntryIdMap();
            Set billids = handle.getBillids();
            endAdjIdEntryIdsMap.keySet().retainAll(billids);
            HashSet<Long> hashSet = new HashSet<Long>(16);
            HashSet notInPoolEntryIds = new HashSet(16);
            for (Map.Entry entry : noInPoolBillIdEntryIdMap.entrySet()) {
                hashSet.add((Long)entry.getKey());
                notInPoolEntryIds.addAll((Collection)entry.getValue());
            }
            hashSet.addAll(endAdjIdEntryIdsMap.keySet());
            for (Set set : endAdjIdEntryIdsMap.values()) {
                notInPoolEntryIds.addAll(set);
            }
            Object[] objectArray = notInPoolEntryIds.toArray();
            if (this.isNewBalance && endAdjIdEntryIdsMap.size() > 0) {
                Object entry;
                TXHandle tXHandle = TX.requiresNew();
                entry = null;
                try {
                    this.updateBal(calculator, hashSet, objectArray);
                }
                catch (Throwable idSet) {
                    entry = idSet;
                    throw idSet;
                }
                finally {
                    if (tXHandle != null) {
                        if (entry != null) {
                            try {
                                tXHandle.close();
                            }
                            catch (Throwable idSet) {
                                ((Throwable)entry).addSuppressed(idSet);
                            }
                        } else {
                            tXHandle.close();
                        }
                    }
                }
            } else {
                this.updateBal(calculator, hashSet, objectArray);
            }
        } else {
            CalMoveDlock allCalMoveDlock = new CalMoveDlock();
            Map allKeyLockMap = allCalMoveDlock.addLockBatchByCostAdjust(allBillIds);
            allCalMoveDlock.releaseLockAfterTxEnd(new ArrayList(allKeyLockMap.values()));
            if (!calBallanceIdSet.isEmpty()) {
                this.handleMoveAdd(calBallanceIdSet);
            }
            for (Map.Entry entry : costAccountMap.entrySet()) {
                long costAccountId = (Long)entry.getKey();
                this.handleFifo(entry, costAccountId);
            }
            entryIds = calBalanceEntryIds.toArray();
            this.updateBal(calculator, allBillIds, (Object[])entryIds);
        }
        Map<Object, Object> errorCostAdjEntryidMap = new HashMap(16);
        if (this.getOption().containsVariable("cal_balance_costadjust") && !this.isNewBalance) {
            AlgoContext context = Algo.newContext();
            entryIds = null;
            try {
                errorCostAdjEntryidMap = this.insertBalanceCostAdjust(costAdjustBill, calculator);
            }
            catch (Throwable throwable) {
                entryIds = throwable;
                throw throwable;
            }
            finally {
                if (context != null) {
                    if (entryIds != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)entryIds).addSuppressed(throwable);
                        }
                    } else {
                        context.close();
                    }
                }
            }
        }
        if (this.getOption().containsVariable("cal_balance_costadjust") && this.isNewBalance) {
            DynamicObject[] costAdjustBills = e.getDataEntities();
            errorCostAdjEntryidMap = this.insertBalanceCostAdjust(costAdjustBills);
        }
        this.getOption().setVariableValue("errorcostadjentryidmap", SerializationUtils.toJsonString(errorCostAdjEntryidMap));
        HashSet allEndAdjEntryIds = new HashSet(16);
        for (Set set : endAdjIdEntryIdsMap.values()) {
            allEndAdjEntryIds.addAll(set);
        }
        if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ENTRY_SPLIT_INTIME_CAL).booleanValue()) {
            this.updateBalDel(calculator, endAdjIdEntryIdsMap.keySet(), allEndAdjEntryIds.toArray());
        }
        if (errorCostAdjEntryidMap != null && !errorCostAdjEntryidMap.isEmpty()) {
            logger.info("exception sum export audit fail{}", errorCostAdjEntryidMap);
            Set<Object> costAdjustIds = errorCostAdjEntryidMap.keySet();
            StringBuilder stringBuilder = new StringBuilder();
            for (Long l : costAdjustIds) {
                Map map = (Map)adjIdAndMaterialInfo.get(l);
                if (map == null || map.isEmpty()) continue;
                String name = map.get("name") == null ? "" : (String)map.get("name");
                String number = map.get("number") == null ? "" : (String)map.get("number");
                stringBuilder.append(name).append(":").append(number).append(" ");
            }
            String exceptionInfo = String.format(ResManager.loadKDString((String)"\u51fa\u5355\u5931\u8d25\uff0c\u7269\u6599\u201c%1$s\u201d\u51fa\u5355\u540e\u9020\u6210\u4f59\u989d\u8868\u4e2d\u5b58\u5728\u6570\u91cf\u548c\u91d1\u989d\u65b9\u5411\u4e0d\u4e00\u81f4\u7684\u6570\u636e\u3002", (String)"ExceExportBillTask_7", (String)"fi-cal-formplugin", (Object[])new Object[0]), stringBuilder.toString());
            throw new KDBizException(exceptionInfo);
        }
    }

    private void handleFifo(Map.Entry<Long, Set<Long>> entry, long costAccountId) {
        new CalMoveInvoker().doCalAdjBillFifo(entry.getValue().toArray(new Long[0]), "cal_costadjustbill", "1", costAccountId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBal(BalanceCalculator calculator, Set<Long> notInPoolBillIds, Object[] entryIds) {
        block4: {
            block3: {
                if (this.isNewBalance) break block3;
                if (this.getOption().containsVariable("not_update_bal")) {
                    return;
                }
                String acctId = CacheKeyUtil.getAcctId();
                String lockKey = "fi-cal-billsynclock_updatebal" + acctId;
                DLock dlock = DLock.createReentrant((String)lockKey, (String)"fi-cal-billsynclock_updatebal");
                try {
                    dlock.lock();
                    calculator.updateBalance4CostAdjust(entryIds);
                    new PurPriceDiffCalculator().updatePurPriceDiff4CostAdjust(entryIds);
                }
                catch (Throwable throwable) {
                    CommitListener commitListener = new CommitListener(dlock){
                        final /* synthetic */ DLock val$dlock;
                        {
                            this.val$dlock = dLock;
                        }

                        public void onEnded(boolean rollbacked) {
                            try (TXHandle txHandle = TX.notSupported();){
                                this.val$dlock.close();
                            }
                        }
                    };
                    TX.addCommitListener((CommitListener)commitListener);
                    throw throwable;
                }
                CommitListener commitListener = new /* invalid duplicate definition of identical inner class */;
                TX.addCommitListener((CommitListener)commitListener);
                break block4;
            }
            BalanceOpInvoker balanceOpInvoker = new BalanceOpInvoker();
            balanceOpInvoker.setEntity("cal_costadjust_subentity");
            balanceOpInvoker.invokeBalOp(notInPoolBillIds, null);
        }
    }

    private void updateBalDel(BalanceCalculator calculator, Set<Long> billIds, Object[] entryIds) {
        if (!this.isNewBalance) {
            if (this.getOption().containsVariable("not_update_bal")) {
                return;
            }
            calculator.updateBalance4CostAdjustDel(entryIds);
            new PurPriceDiffCalculator().updatePurPriceDiff4CostAdjustDel(entryIds);
        } else {
            BalanceOpInvoker balanceOpInvoker = new BalanceOpInvoker();
            balanceOpInvoker.setEntity("cal_costadjust_subentity");
            balanceOpInvoker.invokeBalReverseOp(billIds, null);
        }
    }

    private void updateBillEntryAdjustAmt(List<Object[]> paramList) {
        HashSet<Long> entryIds = new HashSet<Long>(16);
        for (Object[] params : paramList) {
            entryIds.add((Long)params[1]);
        }
        if (!entryIds.isEmpty()) {
            CostElementHelper.calCostAdjustCost((Long[])entryIds.toArray(new Long[0]));
        }
    }

    private void handleMoveAdd(Set<Long> set) {
        new CalMoveInvoker().doCalAdjBill(set.toArray(new Long[0]), "cal_costadjustbill", "1");
    }

    private void updateCostElement(List<Object[]> paramList) {
        String updateSql = "update t_cal_costadjust_detail set fadjustamt = fadjustamt+? where fentryid = ? and fcostsubelementid = ? and fcostelementid = ?";
        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateSql, paramList);
    }

    private List<Object[]> getParamsByMaterial(DynamicObject[] infos) {
        boolean calByCostElement = ParamsHelper.getCostElementByCostAccount((long)infos[0].getLong("costaccount_id"));
        Map materialCostElementMap = CostElementHelper.getMaterialCostElement((DynamicObject[])infos);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        Map bill2CosttypeMap = CostTypeHelper.getCostTypeByBill((DynamicObject[])infos, (String[])costtypeFields);
        Long[] costElementIds = CostElementHelper.getDefaultMaterialElements();
        for (DynamicObject info : infos) {
            long costType = bill2CosttypeMap.get(info.getLong("id")) == null ? 0L : (Long)bill2CosttypeMap.get(info.getLong("id"));
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                long materialId = entry.getLong("material_id");
                BigDecimal adjustAmt = entry.getBigDecimal("adjustamt");
                long entryId = entry.getLong("id");
                long materialCostSubElement = 0L;
                long materialCostElement = 0L;
                if (calByCostElement) {
                    materialCostSubElement = materialCostElementMap.get(costType + "|" + materialId) == null ? costElementIds[0] : ((Long[])materialCostElementMap.get(costType + "|" + materialId))[0];
                    materialCostElement = materialCostElementMap.get(costType + "|" + materialId) == null ? costElementIds[1] : ((Long[])materialCostElementMap.get(costType + "|" + materialId))[1];
                } else {
                    materialCostSubElement = costElementIds[0];
                    materialCostElement = costElementIds[1];
                }
                paramList.add(new Object[]{adjustAmt, entryId, materialCostSubElement, materialCostElement});
            }
        }
        return paramList;
    }

    private Map<Long, Set<Long>> insertBalanceCostAdjust(DynamicObject[] costAdjustBills, BalanceCalculator calculator) {
        List ids;
        HashSet<Long> set = new HashSet<Long>(32);
        Long costAccountId = null;
        for (int i = 0; i < costAdjustBills.length; ++i) {
            set.add(costAdjustBills[i].getLong("id"));
            if (costAccountId != null) continue;
            costAccountId = (Long)costAdjustBills[i].getDynamicObject("costaccount").getPkValue();
        }
        HashSet<Long> balanceIds = new HashSet<Long>(16);
        HashMap<Long, Map<Long, Set<Long>>> balIdAndAdjustIdAndEntryId = new HashMap<Long, Map<Long, Set<Long>>>(16);
        try (DataSet dataSet = calculator.getCostAdjustsBalance(set.toArray());){
            for (Row row : dataSet) {
                Set<Long> entryIds;
                Map adjIdAndEntryId;
                Long balId = row.getLong("balanceid");
                balanceIds.add(balId);
                Long costAdjustId = row.getLong("costadjustbillid");
                Long costAdjustEntryId = row.getLong("entryid");
                if (!balIdAndAdjustIdAndEntryId.containsKey(balId)) {
                    adjIdAndEntryId = new HashMap();
                    entryIds = new HashSet<Long>();
                    entryIds.add(costAdjustEntryId);
                    adjIdAndEntryId.put(costAdjustId, entryIds);
                    balIdAndAdjustIdAndEntryId.put(balId, adjIdAndEntryId);
                    continue;
                }
                adjIdAndEntryId = (Map)balIdAndAdjustIdAndEntryId.get(balId);
                if (!adjIdAndEntryId.containsKey(costAdjustId)) {
                    entryIds = (Set)adjIdAndEntryId.get(costAdjustId);
                    entryIds.add(costAdjustEntryId);
                    adjIdAndEntryId.put(costAdjustId, entryIds);
                    continue;
                }
                entryIds = (Set)adjIdAndEntryId.get(costAdjustId);
                entryIds.add(costAdjustEntryId);
            }
        }
        String cal_balance_costadjust_ids = this.getOption().getVariableValue("cal_balance_costadjust_ids");
        if (!StringUtils.isEmpty((String)cal_balance_costadjust_ids) && (ids = (List)JSONObject.parseObject((String)cal_balance_costadjust_ids, List.class)) != null) {
            balanceIds.addAll(ids);
        }
        boolean costElementByCostAccount = this.getCostElementByCostAccount(balanceIds, balIdAndAdjustIdAndEntryId, null, null);
        QFilter balFilter = new QFilter("id", "in", balanceIds);
        DataSet curBalanceDataSet = ExceCostHelper.buildBalanceData((QFilter)balFilter, (boolean)costElementByCostAccount);
        Set balDimFields = ExceCostHelper.getBalDimFields((String)"", (boolean)false);
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccountId);
        QFilter adjFilter = new QFilter("id", "not in", set);
        DataSet costAdjust_matched = ExceCostHelper.createCostAdjust_matched_BALEND((boolean)costElementByCostAccount, (Set)balDimFields, (QFilter[])new QFilter[]{adjFilter}, (Long)costAccountId, (Long)((Long)period.getPkValue()), (boolean)false);
        JoinDataSet joinDataSet = curBalanceDataSet.join(costAdjust_matched);
        for (String balDimField : balDimFields) {
            joinDataSet.on(balDimField, balDimField);
        }
        DataSet dataSet = joinDataSet.select(curBalanceDataSet.getRowMeta().getFieldNames(), new String[]{"costadjustbillid", "costadjustbillno", EXPORTFLAG, "exportflagbak", "margin"}).finish();
        DataSet detailDatasetX = dataSet.groupBy((String[])ArrayUtils.concatAll((Object[])curBalanceDataSet.getRowMeta().getFieldNames(), (Object[][])new String[][]{{"costadjustbillid", "costadjustbillno", EXPORTFLAG, "exportflagbak"}})).sum("margin").finish();
        if (!detailDatasetX.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51fa\u5355\u5931\u8d25\uff0c\u6570\u636e\u5df2\u51fa\u5355\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"ExceExportBillTask_6", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        Map<Long, Set<Long>> failCostAdjustIdAndEntryId = this.checkBalQtyAmtDC(balanceIds, balIdAndAdjustIdAndEntryId, null, null);
        return failCostAdjustIdAndEntryId;
    }

    private Map<Long, Set<Long>> insertBalanceCostAdjust(DynamicObject[] costAdjustBills) {
        List ids;
        Long balanceId;
        HashSet<Long> calBalanceIds = new HashSet<Long>(16);
        HashSet<Long> costAdjustIdSet = new HashSet<Long>(32);
        for (int i = 0; i < costAdjustBills.length; ++i) {
            costAdjustIdSet.add(costAdjustBills[i].getLong("id"));
        }
        HashSet<Long> balIds = new HashSet<Long>(16);
        String selectSql = "select t2.fid as fbalanceid,t1.fbillid as fbillid,t1.fentryid as fdetailid from t_cal_bal_sp t1 inner join t_cal_bal t2 on t1.fkeycol = t2.fkeycol and t1.fperiod = t2.fperiod where t1.fbillid in " + DBUtil.getInStringFromSet2(costAdjustIdSet);
        DataSet balanceDataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)CommonUtils.getCalDBRouteKey(), (String)selectSql).union(DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)CommonUtils.getCalDBRouteKey(), (String)selectSql.replace("t_cal_bal_sp", "t_cal_bal_tp")));
        HashMap<Long, Map<Long, Set<Long>>> balAndAdjustIdAndEntryId = new HashMap<Long, Map<Long, Set<Long>>>(16);
        String costAdjustSql = "id,costaccount,billno,entryentity.id as entryid,entryentity.adjustamt as adjustamt,entryentity.subentryentity.id as detailid";
        DataSet costAdjust = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costadjust_subentity", (String)costAdjustSql, (QFilter[])new QFilter[]{new QFilter("id", "in", costAdjustIdSet)}, null);
        DataSet balanceAndAdj = balanceDataSet.join(costAdjust).on("fdetailid", "detailid").select(new String[]{"fbalanceid"}, new String[]{"id", "entryid", "billno", "adjustamt", "costaccount"}).finish();
        HashMap<Long, Boolean> costAccount_costElement = new HashMap<Long, Boolean>();
        HashMap<Long, Long> costAdj_costAccount = new HashMap<Long, Long>();
        Long curCostAccountId = null;
        for (Row row : balanceAndAdj) {
            HashSet<Object> entryIds;
            balanceId = row.getLong("fbalanceid");
            Long costAdjId = row.getLong("id");
            Long entryid = row.getLong("entryid");
            String string = row.getString("billno");
            BigDecimal adjustamt = row.getBigDecimal("adjustamt");
            Long costAccountId = row.getLong("costaccount");
            if (curCostAccountId == null) {
                curCostAccountId = costAccountId;
            }
            if (this.isNewBalance) {
                this.getFromCache(costAccount_costElement, costAccountId);
            }
            costAdj_costAccount.put(costAdjId, costAccountId);
            Object adjIdAndEntryId = (Map)balAndAdjustIdAndEntryId.get(balanceId);
            if (adjIdAndEntryId == null) {
                adjIdAndEntryId = new HashMap();
                entryIds = new HashSet<Object>();
                entryIds.add(entryid);
                adjIdAndEntryId.put(costAdjId, entryIds);
                balAndAdjustIdAndEntryId.put(balanceId, (Map<Long, Set<Long>>)adjIdAndEntryId);
            }
            if ((entryIds = (HashSet<Object>)adjIdAndEntryId.get(costAdjId)) == null) {
                entryIds = new HashSet();
                entryIds.add(entryid);
                adjIdAndEntryId.put(costAdjId, entryIds);
                continue;
            }
            entryIds.add(entryid);
        }
        for (Map.Entry entry : balAndAdjustIdAndEntryId.entrySet()) {
            balanceId = (Long)entry.getKey();
            Map entryIds = (Map)entry.getValue();
            for (Map.Entry entry2 : entryIds.entrySet()) {
                Long costAdjustId = (Long)entry2.getKey();
                Set costAdjEntryIds = (Set)entry2.getValue();
                for (Long costAdjustEntryId : costAdjEntryIds) {
                    HashSet<Long> entryId;
                    balIds.add(balanceId);
                    calBalanceIds.add(balanceId);
                    HashMap adjustIdAndEntryId = (HashMap)balAndAdjustIdAndEntryId.get(balanceId);
                    if (adjustIdAndEntryId == null) {
                        adjustIdAndEntryId = new HashMap();
                        entryId = new HashSet<Long>();
                        entryId.add(costAdjustEntryId);
                        adjustIdAndEntryId.put(costAdjustId, entryId);
                        balAndAdjustIdAndEntryId.put(balanceId, adjustIdAndEntryId);
                    }
                    if ((entryId = (HashSet<Long>)adjustIdAndEntryId.get(costAdjustId)) == null) {
                        entryId = new HashSet();
                        entryId.add(costAdjustEntryId);
                        adjustIdAndEntryId.put(costAdjustId, entryId);
                        continue;
                    }
                    entryId.add(costAdjustEntryId);
                }
            }
        }
        String cal_balance_costadjust_ids = this.getOption().getVariableValue("cal_balance_costadjust_ids");
        if (!StringUtils.isEmpty((String)cal_balance_costadjust_ids) && (ids = (List)JSONObject.parseObject((String)cal_balance_costadjust_ids, List.class)) != null) {
            calBalanceIds.addAll(ids);
        }
        boolean costElementByCostAccount = this.getCostElementByCostAccount(calBalanceIds, balAndAdjustIdAndEntryId, costAccount_costElement, costAdj_costAccount);
        QFilter balFilter = new QFilter("id", "in", calBalanceIds);
        DataSet curBalanceDataSet = ExceCostHelper.buildBalanceData((QFilter)balFilter, (boolean)costElementByCostAccount);
        Set balDimFields = ExceCostHelper.getBalDimFields((String)"", (boolean)false);
        QFilter qFilter = new QFilter("id", "not in", costAdjustIdSet);
        DataSet costAdjust_matched = ExceCostHelper.createCostAdjust_matched_BALEND((boolean)costElementByCostAccount, (Set)balDimFields, (QFilter[])new QFilter[]{qFilter}, (Long)curCostAccountId, null, (boolean)false);
        JoinDataSet joinDataSet = curBalanceDataSet.join(costAdjust_matched);
        for (String balDimField : balDimFields) {
            joinDataSet.on(balDimField, balDimField);
        }
        DataSet dataSet = joinDataSet.select(curBalanceDataSet.getRowMeta().getFieldNames(), new String[]{"costadjustbillid", "costadjustbillno", EXPORTFLAG, "exportflagbak", "margin"}).finish();
        DataSet detailDatasetX = dataSet.groupBy((String[])ArrayUtils.concatAll((Object[])curBalanceDataSet.getRowMeta().getFieldNames(), (Object[][])new String[][]{{"costadjustbillid", "costadjustbillno", EXPORTFLAG, "exportflagbak"}})).sum("margin").finish();
        if (!detailDatasetX.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51fa\u5355\u5931\u8d25\uff0c\u6570\u636e\u5df2\u51fa\u5355\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"ExceExportBillTask_6", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
        Map<Long, Set<Long>> failCostAdjustIdAndEntryIds = this.checkBalQtyAmtDC(balIds, balAndAdjustIdAndEntryId, costAccount_costElement, costAdj_costAccount);
        return failCostAdjustIdAndEntryIds;
    }

    private Boolean getFromCache(Map<Long, Boolean> costAccountId_costElement, Long costAccountId) {
        if (costAccountId_costElement.containsKey(costAccountId)) {
            return costAccountId_costElement.get(costAccountId);
        }
        boolean costElementByCostAccount = ParamsHelper.getCostElementByCostAccount((long)costAccountId);
        costAccountId_costElement.put(costAccountId, costElementByCostAccount);
        return costElementByCostAccount;
    }

    private Map<Long, Set<Long>> checkBalQtyAmtDC(Set<Long> balanceIds, Map<Long, Map<Long, Set<Long>>> balanceIdAndAdjust, Map<Long, Boolean> costAccountId_costElement, Map<Long, Long> costAdj_costAccount) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        if (balanceIds.isEmpty()) {
            return result;
        }
        if (this.getOption().containsVariable("checkBalQtyAmtDc")) {
            DataSet dys;
            boolean costElementByCostAccount = this.getCostElementByCostAccount(balanceIds, balanceIdAndAdjust, costAccountId_costElement, costAdj_costAccount);
            QFilter qfilter = new QFilter("id", "in", balanceIds);
            String periodEndQtyField = "periodendqty";
            String periodEndActualCostField = "periodendactualcost";
            boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
            if (isNewBalance) {
                periodEndQtyField = "baseqty_bal";
                periodEndActualCostField = "actualcost_bal";
            }
            if ((dys = ExceCostHelper.getCalBal_balanceDataSet((boolean)costElementByCostAccount, (QFilter)qfilter, (boolean)isNewBalance)) == null) {
                throw new KDBizException("cal_bal is Empty");
            }
            for (Row dy : dys) {
                Long balanceId = dy.getLong("id");
                if (costElementByCostAccount) {
                    periodEndQtyField = "periodendqty";
                    periodEndActualCostField = "periodendactualcost";
                }
                BigDecimal periodendqty = dy.getBigDecimal(periodEndQtyField);
                BigDecimal periodendactualcost = dy.getBigDecimal(periodEndActualCostField);
                Boolean isExce3 = periodendqty.compareTo(BigDecimal.ZERO) < 0 && periodendactualcost.compareTo(BigDecimal.ZERO) > 0;
                Boolean isExce4 = periodendqty.compareTo(BigDecimal.ZERO) > 0 && periodendactualcost.compareTo(BigDecimal.ZERO) < 0;
                if (!isExce3.booleanValue() && !isExce4.booleanValue()) continue;
                WriteLogHelper.writeInfoLog((Log)logger, (String)"exception sum export director error balance id {}", (Object[])new Object[]{balanceId});
                WriteLogHelper.writeInfoLog((Log)logger, (String)"exception sum export director error qty{}", (Object[])new Object[]{periodendqty});
                WriteLogHelper.writeInfoLog((Log)logger, (String)"exception sum export director error amt{}", (Object[])new Object[]{periodendactualcost});
                Map<Long, Set<Long>> curMap = balanceIdAndAdjust.get(balanceId);
                for (Map.Entry<Long, Set<Long>> entry : curMap.entrySet()) {
                    Long curKey = entry.getKey();
                    Set<Long> curValues = entry.getValue();
                    if (result.containsKey(curKey)) {
                        Set values = (Set)result.get(curKey);
                        values.addAll(curValues);
                        continue;
                    }
                    result.put(curKey, curValues);
                }
            }
        }
        return result;
    }

    private boolean getCostElementByCostAccount(Set<Long> balanceIds, Map<Long, Map<Long, Set<Long>>> balanceIdAndAdjust, Map<Long, Boolean> costAccountId_costElement, Map<Long, Long> costAdj_costAccount) {
        boolean costElementByCostAccount = false;
        if (costAccountId_costElement != null) {
            boolean flag = false;
            block0: for (Long balanceId : balanceIds) {
                if (flag) break;
                Map<Long, Set<Long>> costAdjId_entryIds = balanceIdAndAdjust.get(balanceId);
                if (costAdjId_entryIds == null) continue;
                for (Long cosAdjId : costAdjId_entryIds.keySet()) {
                    Long costAccount = costAdj_costAccount.get(cosAdjId);
                    if (costAccount == null || costAccountId_costElement.get(costAccount) == null || !costAccountId_costElement.get(costAccount).booleanValue()) continue;
                    costElementByCostAccount = true;
                    flag = true;
                    continue block0;
                }
            }
        }
        return costElementByCostAccount;
    }

    private void checkNullCalRange(DynamicObject[] costAdjustBill) {
        StringBuilder msg = new StringBuilder();
        for (DynamicObject info : costAdjustBill) {
            String billnum = info.getString("billno");
            HashSet<String> seqs = new HashSet<String>(16);
            DynamicObjectCollection entry = info.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject entryRow = (DynamicObject)entry.get(i);
                int rowNum = i + 1;
                Object calrangeid = entryRow.get("calrange");
                entryRow.set("seq", (Object)rowNum);
                if (calrangeid != null && !"0".equals(calrangeid.toString())) continue;
                seqs.add(rowNum + "");
            }
            if (seqs.isEmpty()) continue;
            String s = ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7b2c%2$s\u884c\u5206\u5f55\u672a\u627e\u5230\u6838\u7b97\u8303\u56f4\u3002", (String)"CostAdjustBillSubmitOp_23", (String)"fi-cal-opplugin", (Object[])new Object[0]);
            String errorMsg = String.format(s + "\r\n", billnum, String.join((CharSequence)",", seqs));
            msg.append(errorMsg);
        }
        if (msg.length() > 0) {
            throw new KDBizException(msg.toString());
        }
    }
}

