/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBillDiffTypeEnum;
import kd.fi.cal.common.enums.DischargeTypeEnum;
import kd.fi.cal.common.helper.PeriodHelper;

public class CostAdjustBillGenerateVoucherValidator
extends AbstractValidator {
    private Map<Long, DynamicObject> currentPeriodCache = new HashMap<Long, DynamicObject>(16);
    private Map<Long, String> distChargeTypeCache = new HashMap<Long, String>(16);

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            String operationResult;
            DynamicObject org = (DynamicObject)dataEntity.getValue("calorg");
            String createtype = (String)dataEntity.getValue("createtype");
            String diffType = (String)dataEntity.getValue("difftype");
            if (null == org || null == createtype || "".equals(createtype)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u548c\u521b\u5efa\u7c7b\u578b\u3002", (String)"CostAdjustBillGenerateVoucherValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                return;
            }
            String dischargetype = this.getDistChargeType(org.getLong("id"));
            boolean isWriteOff = CostAdjustBilCreateTypeEnum.PUR_WIRTEOFF.getValue().equals(createtype) || CostAdjustBilCreateTypeEnum.OM_WRITEOFF.getValue().equals(createtype);
            isWriteOff = isWriteOff && CostAdjustBillDiffTypeEnum.ACT_COST.getValue().equals(diffType);
            boolean notRedWfCreated = !"".equals(((DynamicObject)dataEntity.getDataEntity().getDynamicObjectCollection("entryentity").get(0)).getString("srcbillnum"));
            boolean bl = isWriteOff = isWriteOff && notRedWfCreated;
            if ((DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(dischargetype) || DischargeTypeEnum.BEGINPERIODCLEAR.getValue().equals(dischargetype)) && isWriteOff && "generatevoucher".equals(operationResult = this.getOperateKey())) {
                String msgFormat = ResManager.loadKDString((String)"\u6682\u4f30\u51b2\u56de\u65b9\u5f0f\u4e3a\u201c\u6708\u521d\u4e00\u6b21\u51b2\u56de\u201d\u6216\u201c\u5355\u5230\u51b2\u56de\u201d\u65f6\uff0c\u521b\u5efa\u7c7b\u578b\u4e3a\u201c%1$s\u201d\u3001\u201c%2$s\u201d\u7684\u6210\u672c\u8c03\u6574\u5355\u4e0d\u5141\u8bb8\u624b\u5de5\u751f\u6210\u51ed\u8bc1\uff0c\u51ed\u8bc1\u7edf\u4e00\u7531\u5e94\u4ed8\u6a21\u5757\u5904\u7406\u3002", (String)"CostAdjustBillGenerateVoucherValidator_4", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                msgFormat = String.format(msgFormat, ResManager.loadKDString((String)"\u91c7\u8d2d\u6838\u9500", (String)"CostAdjustBillGenerateVoucherValidator_2", (String)"fi-cal-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u59d4\u5916\u6838\u9500", (String)"CostAdjustBillGenerateVoucherValidator_3", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                this.addMessage(dataEntity, msgFormat, ErrorLevel.Error);
            }
            Date bookdate = (Date)dataEntity.getValue("bookdate");
            DynamicObject currentPeriod = this.getCurrentPeriod(dataEntity);
            if (null == currentPeriod) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CostAdjustBillSubmitOp_0", (String)"fi-cal-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            Date periodBeginDate = currentPeriod.getDate("begindate");
            if (bookdate.compareTo(periodBeginDate) >= 0) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u671f\u95f4\u3002", (String)"CostAdjustBillDeleteVoucherValidator_2", (String)"fi-cal-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }

    private DynamicObject getCurrentPeriod(ExtendedDataEntity dataEntity) {
        DynamicObject costaccount = (DynamicObject)dataEntity.getValue("costaccount");
        DynamicObject period = this.currentPeriodCache.get(costaccount.getLong("id"));
        if (null == period) {
            period = PeriodHelper.getCurrentPeriod((Long)costaccount.getLong("id"));
            this.currentPeriodCache.put(costaccount.getLong("id"), period);
        }
        return period;
    }

    private String getDistChargeType(Long calorgid) {
        String dischargetype = this.distChargeTypeCache.get(calorgid);
        if (dischargetype == null) {
            dischargetype = (String)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)calorgid, (Long)0L, (String)"dischargetype");
            this.distChargeTypeCache.put(calorgid, dischargetype);
        }
        return dischargetype;
    }
}

