/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.MaterialCategoryHandle;
import kd.fi.cal.common.helper.MaterialNoUpdateFieldHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.opplugin.validator.CostAdjustBillImportValidator;

public class CostAdjustBillSaveOp
extends AbstractOperationServicePlugIn {
    private Map<Long, Long> costAccountCurrencyMap = new HashMap<Long, Long>(16);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entryentity.assist");
        e.getFieldKeys().add("difftype");
        e.getFieldKeys().add("createtype");
        e.getFieldKeys().add("billcretype");
        e.getFieldKeys().add("costaccount");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("entryentity.owner");
        e.getFieldKeys().add("entryentity.material");
        e.getFieldKeys().add("entryentity.storageorgunit");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        if ("import".equals(e.getDataEntities()[0].getString("billcretype"))) {
            e.addValidator((AbstractValidator)new CostAdjustBillImportValidator());
        }
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] billInfos;
                for (ExtendedDataEntity billInfo : billInfos = this.getDataEntities()) {
                    DynamicObject bill = billInfo.getDataEntity();
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
                    int size = entrys.size();
                    if (size != 0) continue;
                    this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u5355\u636e\u5fc5\u987b\u81f3\u5c11\u6709\u4e00\u6761\u5206\u5f55\u3002", (String)"CostAdjustBillSaveOp_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String billCreType;
        DynamicObject[] costAdjustBill;
        for (DynamicObject info : costAdjustBill = e.getDataEntities()) {
            long costAccountId = 0L;
            Object costAccount = info.get("costaccount");
            if (costAccount == null) {
                return;
            }
            if (costAccount instanceof Long) {
                costAccountId = (Long)costAccount;
            }
            if (costAccount instanceof DynamicObject) {
                costAccountId = ((DynamicObject)costAccount).getLong("id");
            }
            Date bookdate = info.getDate("bookdate");
            info.set("period_id", (Object)PeriodHelper.getPeriodByDate((Date)bookdate, (Long)costAccountId).getLong("id"));
            info.set("bookdate", (Object)bookdate);
            String diffType = info.getString("difftype");
            if (StringUtils.isEmpty((String)diffType)) {
                info.set("difftype", (Object)"B");
            }
            if (!"import".equals(billCreType = info.getString("billcretype"))) continue;
            Long currency = this.costAccountCurrencyMap.get(costAccountId);
            if (currency == null) {
                DynamicObject costAccountDy = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.currency", (QFilter[])new QFilter("id", "=", (Object)costAccountId).toArray());
                currency = costAccountDy.getLong("calpolicy.currency");
                this.costAccountCurrencyMap.put(costAccountId, currency);
            }
            info.set("currency_id", (Object)currency);
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
            if (entrys == null || entrys.size() == 0) continue;
            HashSet<Long> materialIds = new HashSet<Long>();
            for (DynamicObject entry : entrys) {
                DynamicObject materialDynamic;
                DynamicObject productline = entry.getDynamicObject("productline");
                if (productline != null || (materialDynamic = entry.getDynamicObject("material")) == null) continue;
                materialIds.add(materialDynamic.getLong("id"));
            }
            HashMap<Long, Long> materialIdAndProductLine = new HashMap<Long, Long>();
            DynamicObjectCollection materialInfos = QueryServiceHelper.query((String)"bd_material", (String)"id,productline", (QFilter[])new QFilter[]{new QFilter("id", "in", materialIds)});
            if (materialInfos != null && materialInfos.size() != 0) {
                for (DynamicObject materialInfo : materialInfos) {
                    materialIdAndProductLine.put(materialInfo.getLong("id"), materialInfo.getLong("productline"));
                }
            }
            for (DynamicObject entry : entrys) {
                DynamicObject productline = entry.getDynamicObject("productline");
                DynamicObject material = entry.getDynamicObject("material");
                if (productline != null || material == null) continue;
                entry.set("productline_id", materialIdAndProductLine.get(material.getLong("id")));
            }
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (DynamicObject info : costAdjustBill) {
            String billCreType2 = info.getString("billcretype");
            if (!"import".equals(billCreType2)) continue;
            list.add(info);
        }
        DynamicObject[] importBills = list.toArray(new DynamicObject[0]);
        MaterialCategoryHandle.handle4Bill((DynamicObject[])importBills);
        MaterialNoUpdateFieldHelper materialNoUpdateFieldHelper = new MaterialNoUpdateFieldHelper();
        Map unionKeyAndStorageInvId = materialNoUpdateFieldHelper.getStorageOrgMaterialAndInvInfoMap(importBills);
        Map storageInvIdAndNoUpdateStr = materialNoUpdateFieldHelper.getSDBNoUpdateInfoMap(unionKeyAndStorageInvId, "cal_costadjust_subentity", "entryentity");
        for (DynamicObject info : costAdjustBill) {
            billCreType = info.getString("billcretype");
            if (!"import".equals(billCreType)) continue;
            for (DynamicObject entry : info.getDynamicObjectCollection("entryentity")) {
                DynamicObject material = entry.getDynamicObject("material");
                long materialId = material.getLong("id");
                DynamicObject storageorgunit = entry.getDynamicObject("storageorgunit");
                long storageOrgId = storageorgunit.getLong("id");
                String curUnionKey = storageOrgId + "#" + materialId;
                Long storageInvId = (Long)unionKeyAndStorageInvId.get(curUnionKey);
                String noUpdateStr = (String)storageInvIdAndNoUpdateStr.get(storageInvId);
                entry.set("noupdatecalfields", (Object)noUpdateStr);
            }
        }
    }
}

