/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.balance.PurPriceDiffCalculator;
import kd.fi.cal.business.calculate.out.CalMoveInvoker;
import kd.fi.cal.business.calculate.out.IntimeBufferPoolHandle;
import kd.fi.cal.business.process.inner.CalMoveDlock;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBillDiffTypeEnum;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.opplugin.validator.CostAdjustBillUnAuditValidator;

public class CostAdjustBillUnAuditOp
extends AbstractOperationServicePlugIn {
    protected boolean isNewBalance = CalBalanceModelHelper.isNewBalance();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("srcsys");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("costaccount.id");
        e.getFieldKeys().add("costaccount.name");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("bizdate");
        e.getFieldKeys().add("bookdate");
        e.getFieldKeys().add("createtype");
        e.getFieldKeys().add("difftype");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("costaccount");
        e.getFieldKeys().add("calorg");
        e.getFieldKeys().add("isvoucher");
        e.getFieldKeys().add("storageorgunit");
        e.getFieldKeys().add("entryentity.lot");
        e.getFieldKeys().add("entryentity.adjustamt");
        e.getFieldKeys().add("entryentity.material");
        e.getFieldKeys().add("entryentity.warehouse");
        e.getFieldKeys().add("entryentity.location");
        e.getFieldKeys().add("entryentity.assist");
        e.getFieldKeys().add("entryentity.project");
        e.getFieldKeys().add("entryentity.ownertype");
        e.getFieldKeys().add("entryentity.owner");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("period");
        e.getFieldKeys().add("entryentity.invbizdate");
        e.getFieldKeys().add("entryentity.invauditdate");
        e.getFieldKeys().add("entryentity.invbillnum");
        e.getFieldKeys().add("entryentity.invbizentityobject");
        e.getFieldKeys().add("entryentity.accounttype");
        e.getFieldKeys().add("entryentity.queuetype");
        e.getFieldKeys().add("entryentity.ecalstatus");
        e.getFieldKeys().add("entryentity.entrystatus");
        e.getFieldKeys().add("calstatus");
        e.getFieldKeys().add("entryentity.srcbillid");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        BalanceCalculator calculator = new BalanceCalculator();
        ArrayList<Object> entryIds = new ArrayList<Object>(16);
        HashSet<Long> set = new HashSet<Long>(16);
        DynamicObject[] costAdjustBill = e.getDataEntities();
        HashMap<Long, HashSet<Long>> costAccountMap = new HashMap<Long, HashSet<Long>>(16);
        HashSet<Long> allBillIds = new HashSet<Long>(16);
        for (int i = 0; i < costAdjustBill.length; ++i) {
            DynamicObject entry;
            Object entryDyc22;
            DynamicObject info = costAdjustBill[i];
            allBillIds.add(info.getLong("id"));
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
            for (Object entryDyc22 : entrys) {
                entryDyc22.set("entrystatus", (Object)"A");
            }
            String string = info.getString("difftype");
            if (!CostAdjustBillDiffTypeEnum.ACT_COST.getValue().equals(string)) {
                entryDyc22 = entrys.iterator();
                while (entryDyc22.hasNext()) {
                    entry = (DynamicObject)entryDyc22.next();
                    entryIds.add(entry.getPkValue());
                }
                continue;
            }
            set.add(info.getLong("id"));
            entryDyc22 = entrys.iterator();
            while (entryDyc22.hasNext()) {
                entry = (DynamicObject)entryDyc22.next();
                entryIds.add(entry.getPkValue());
            }
            long costAccountId = info.getLong("costaccount.id");
            HashSet<Long> idSet = (HashSet<Long>)costAccountMap.get(costAccountId);
            if (idSet != null) {
                idSet.add(info.getLong("id"));
                continue;
            }
            idSet = new HashSet<Long>();
            idSet.add(info.getLong("id"));
            costAccountMap.put(costAccountId, idSet);
        }
        if (this.getOption().containsVariable("ignoreop")) {
            if (this.isNewBalance) {
                this.updateNewBal(allBillIds);
            }
            return;
        }
        if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ENTRY_SPLIT_INTIME_CAL).booleanValue()) {
            boolean isdeletebill = !this.getOption().containsVariable("isdeletebill") || !"false".equals(this.getOption().getVariableValue("isdeletebill"));
            IntimeBufferPoolHandle handle = new IntimeBufferPoolHandle(costAdjustBill, "cal_costadjust_subentity", ActionEnum.UN_AUDIT.getValue(), isdeletebill);
            handle.insertIntoPool();
            Map noInPoolBillIdEntryIdMap = handle.getNoInPoolBillEntryIdMap();
            HashSet<Long> hashSet = new HashSet<Long>(16);
            HashSet notInPoolEntryIds = new HashSet(16);
            for (Map.Entry noInPoolBillIdEntryIdEnt : noInPoolBillIdEntryIdMap.entrySet()) {
                hashSet.add((Long)noInPoolBillIdEntryIdEnt.getKey());
                notInPoolEntryIds.addAll((Collection)noInPoolBillIdEntryIdEnt.getValue());
            }
            this.updateBal(calculator, hashSet, notInPoolEntryIds.toArray());
        } else {
            CalMoveDlock allCalMoveDlock = new CalMoveDlock();
            Map allKeyLockMap = allCalMoveDlock.addLockBatchByCostAdjust(allBillIds);
            allCalMoveDlock.releaseLockAfterTxEnd(new ArrayList(allKeyLockMap.values()));
            if (!set.isEmpty()) {
                this.handleMoveAdd(set);
            }
            this.updateBal(calculator, allBillIds, entryIds.toArray());
            for (Map.Entry<Long, Set<Long>> entry : costAccountMap.entrySet()) {
                long costAccountId = (Long)entry.getKey();
                this.handleFifo(entry, costAccountId);
            }
        }
    }

    private void handleFifo(Map.Entry<Long, Set<Long>> entry, long costAccountId) {
        new CalMoveInvoker().doCalAdjBillFifo(entry.getValue().toArray(new Long[0]), "cal_costadjustbill", "0", costAccountId);
    }

    private void updateBal(BalanceCalculator calculator, Set<Long> allBillIds, Object[] objects) {
        if (!this.isNewBalance) {
            if (this.getOption().containsVariable("not_update_bal")) {
                return;
            }
            calculator.updateBalance4CostAdjustDel(objects);
            new PurPriceDiffCalculator().updatePurPriceDiff4CostAdjustDel(objects);
        } else {
            this.updateNewBal(allBillIds);
        }
    }

    private void updateNewBal(Set<Long> allBillIds) {
        BalanceOpInvoker balanceOpInvoker = new BalanceOpInvoker();
        balanceOpInvoker.setEntity("cal_costadjust_subentity");
        balanceOpInvoker.invokeBalReverseOp(allBillIds, null);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CostAdjustBillUnAuditValidator());
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] billInfos = this.getDataEntities();
                HashSet<Long> billIdSets = new HashSet<Long>(16);
                HashMap<Long, ExtendedDataEntity> billDataMap = new HashMap<Long, ExtendedDataEntity>(16);
                HashMap<Long, String> costAccountNameMap = new HashMap<Long, String>(16);
                for (ExtendedDataEntity billInfo : billInfos) {
                    String invbizentityobject;
                    DynamicObject bill = billInfo.getDataEntity();
                    Long costAccountId = bill.getLong("costaccount.id");
                    String constAccountName = bill.getString("costaccount.name");
                    costAccountNameMap.put(costAccountId, constAccountName);
                    billIdSets.add(bill.getLong("id"));
                    billDataMap.put(bill.getLong("id"), billInfo);
                    if (this.getOption().containsVariable("diffAlloc") || this.getOption().containsVariable("unwriteoff")) continue;
                    String diffType = bill.getString("difftype");
                    if (!CostAdjustBillDiffTypeEnum.ACT_COST.getValue().equals(diffType)) {
                        String invbillnum;
                        DynamicObjectCollection entry = bill.getDynamicObjectCollection("entryentity");
                        if (entry == null || entry.size() <= 0 || !StringUtils.isNotEmpty((String)(invbillnum = ((DynamicObject)entry.get(0)).getString("invbillnum")))) continue;
                        this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u975e\u624b\u5de5\u65b0\u589e\u7684\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"CostAdjustBillUnAuditOp_2", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    String createType = bill.getString("createtype");
                    HashMap<String, String> allowCrateTypeDescMap = new HashMap<String, String>(16);
                    allowCrateTypeDescMap.put(CostAdjustBilCreateTypeEnum.HAND.getValue(), CostAdjustBilCreateTypeEnum.HAND.getDesc());
                    allowCrateTypeDescMap.put(CostAdjustBilCreateTypeEnum.END_BAL_BILL.getValue(), CostAdjustBilCreateTypeEnum.END_BAL_BILL.getDesc());
                    allowCrateTypeDescMap.put(CostAdjustBilCreateTypeEnum.HAND_IMPORT.getValue(), CostAdjustBilCreateTypeEnum.HAND_IMPORT.getDesc());
                    allowCrateTypeDescMap.put(CostAdjustBilCreateTypeEnum.CAL_OUT_TAILING.getValue(), CostAdjustBilCreateTypeEnum.CAL_OUT_TAILING.getDesc());
                    if (!allowCrateTypeDescMap.containsKey(createType)) {
                        String msgStr = ResManager.loadKDString((String)"\u53ea\u6709\u521b\u5efa\u7c7b\u578b\u4e3a\u201c%1$s\u201d\u7684\u6210\u672c\u8c03\u6574\u5355\uff0c\u624d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"CostAdjustBillUnAuditOp_5", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                        msgStr = String.format(msgStr, String.join((CharSequence)"\u3001", allowCrateTypeDescMap.values()));
                        this.addErrorMessage(billInfo, msgStr);
                        continue;
                    }
                    DynamicObjectCollection entry = bill.getDynamicObjectCollection("entryentity");
                    if (entry == null || entry.size() <= 0 || !"cal_costupdateapplybill".equals(invbizentityobject = ((DynamicObject)entry.get(0)).getString("invbizentityobject"))) continue;
                    this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u6210\u672c\u66f4\u65b0\u7533\u8bf7\u5355\u751f\u6210\u7684\u6210\u672c\u8c03\u6574\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"CostAdjustBillUnAuditOp_4", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                }
                if (billIdSets != null && billIdSets.size() > 0) {
                    QFilter filter;
                    DynamicObjectCollection daptrackers;
                    String ignoreVoucherMapStr;
                    Map ignoreVoucherMap = new HashMap(16);
                    if (this.getOption().containsVariable("ignorevouchermap") && (ignoreVoucherMapStr = this.getOption().getVariableValue("ignorevouchermap")) != null) {
                        ignoreVoucherMap = (Map)SerializationUtils.fromJsonString((String)ignoreVoucherMapStr, Map.class);
                    }
                    if ((daptrackers = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid", (QFilter[])new QFilter[]{filter = new QFilter("sourcebillid", "in", billIdSets)})) != null && daptrackers.size() > 0) {
                        for (DynamicObject info : daptrackers) {
                            ExtendedDataEntity billData;
                            Long id = info.getLong("sourcebillid");
                            if (ignoreVoucherMap.containsKey(id.toString()) || (billData = (ExtendedDataEntity)billDataMap.get(id)) == null) continue;
                            this.addErrorMessage(billData, ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\uff0c\u8bf7\u5148\u5220\u9664\u6210\u672c\u8c03\u6574\u5355\u7684\u51ed\u8bc1\u3002", (String)"CostAdjustBillUnAuditOp_1", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                        }
                    }
                    QFilter costAdjustF = new QFilter("isvoucher", "=", (Object)Character.valueOf('1'));
                    costAdjustF.and("entryentity.srcbillid", "in", billIdSets);
                    DataSet oldDiffBillDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costadjust_subentity", (String)"id,entryentity.srcbillid", (QFilter[])costAdjustF.toArray(), null);
                    for (Row row : oldDiffBillDataSet) {
                        Long srcbillid = row.getLong("entryentity.srcbillid");
                        ExtendedDataEntity billData = (ExtendedDataEntity)billDataMap.get(srcbillid);
                        if (billData == null) continue;
                        this.addErrorMessage(billData, ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u6e38\u7684\u5dee\u5f02\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\uff0c\u8bf7\u5148\u5220\u9664\u4e0b\u6e38\u7684\u5dee\u5f02\u5355\u7684\u51ed\u8bc1\u3002", (String)"CostAdjustBillUnAuditOp_6", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    }
                }
                QFilter costAccountFilter = new QFilter("entry.costaccount", "in", costAccountNameMap.keySet());
                costAccountFilter.and("entry.isenabled", "=", (Object)true);
                DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"entry.costaccount", (QFilter[])costAccountFilter.toArray());
                for (DynamicObject costAccount : costAccounts) {
                    costAccountNameMap.remove(costAccount.getLong("entry.costaccount"));
                }
                if (!costAccountNameMap.isEmpty()) {
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"CostAdjustBillUnAuditOp_3", (String)"fi-cal-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3011,\u3010", costAccountNameMap.values()));
                    throw new KDBizException(errorMsg);
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
    }

    private void handleMoveAdd(Set<Long> set) {
        new CalMoveInvoker().doCalAdjBill(set.toArray(new Long[0]), "cal_costadjustbill", "0");
    }
}

