/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.balance.BalanceSourceEnum;
import kd.fi.cal.business.calculate.out.CalIntimeBufferPoolHelper;
import kd.fi.cal.business.process.inner.PrevCostAdjustProcessHelper;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.CostEstCostDetailHelper;
import kd.fi.cal.common.helper.FeeShareHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.util.CommonUtils;

public class CostEstimateBillCancelOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CostEstimateBillCancelOp.class);
    private Map<Long, Boolean> entryCostElementMap = new HashMap<Long, Boolean>(16);
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("standardcurrency");
        e.getFieldKeys().add("exratetable");
        e.getFieldKeys().add("convertmode");
        e.getFieldKeys().add("estimatedate");
        e.getFieldKeys().add("resultentity");
        e.getFieldKeys().add("expenseentity");
        e.getFieldKeys().add("resultentity.calentryid");
        e.getFieldKeys().add("resultentity.shareamt");
        e.getFieldKeys().add("resultentity.costdetail");
        e.getFieldKeys().add("resultentity.costdetail.id");
        e.getFieldKeys().add("resultentity.subresultentity");
        e.getFieldKeys().add("resultentity.subresultentity.sharedetailexitem");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new CostEsBillAmtValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        this.deleteCostAdjustBill(bills);
        this.deleteStdCostDiffBill(bills);
        HashSet<Long> entryIdSets = new HashSet<Long>(16);
        HashSet<Long> idSets = new HashSet<Long>(16);
        for (DynamicObject bill : bills) {
            long billId = bill.getLong("id");
            idSets.add(billId);
            DynamicObject[] costrecordarr = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"id,localcurrency.id,localcurrency.amtprecision,costaccount,costaccount.costtype.id,calorg,storageorgunit,localcurrency.priceprecision,material,auditdate,entry.baseqty,entry.fee,entry.unitfee,entry.materialcost,entry.actualcost,entry.unitactualcost,entry.processcost,entry.manufacturecost,entry.resource,subentryentityest.sharedetailamt,subentryentityest.estimatebillid,subentryentityest.sharedetailexitem", (QFilter[])new QFilter("entry.subentryentityest.estimatebillid", "in", (Object)billId).toArray());
            if (costrecordarr == null || costrecordarr.length == 0) {
                this.clearEstResult(bill);
                continue;
            }
            this.entryCostElementMap = CostEstCostDetailHelper.getCostElementByCostAccounts((DynamicObject[])costrecordarr);
            Set<Long> entryIdSet = this.rewriteCostDetail(bill, costrecordarr);
            entryIdSets.addAll(entryIdSet);
            this.subtractCostRecord(billId, costrecordarr);
            this.clearEstResult(bill);
        }
        this.updateBalance(entryIdSets, idSets);
    }

    private void updateBalance(Set<Long> entryIdSets, Set<Long> idSets) {
        block27: {
            try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, idSets)});){
                ctx.set();
                if (this.isNewBalance) {
                    HashSet<Long> idSet = new HashSet<Long>();
                    try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id", (QFilter[])new QFilter("entry.id", "in", entryIdSets).toArray(), null);){
                        for (Row row : dataSet) {
                            idSet.add(row.getLong("id"));
                        }
                    }
                    new BalanceOpInvoker().invokeCostRecordUpdateBalOp(idSet, BalanceSourceEnum.FEE_ESTIMATE_CANCEL);
                    break block27;
                }
                new BalanceCalculator().updateBalance4Others(entryIdSets.toArray(), BalanceSourceEnum.FEE_ESTIMATE_CANCEL, idSets);
            }
        }
    }

    private Set<Long> rewriteCostDetail(DynamicObject bill, DynamicObject[] costrecordarr) {
        DynamicObjectCollection resultEntitys = bill.getDynamicObjectCollection("resultentity");
        long billId = bill.getLong("id");
        List exitemAndEntryIdList = CostEstCostDetailHelper.getExitemMaterialIdEntryId((DynamicObject[])costrecordarr);
        CostEstCostDetailHelper.getExitem((DynamicObjectCollection)resultEntitys, (List)exitemAndEntryIdList);
        Map returnMap = CostEstCostDetailHelper.getElementMap((List)exitemAndEntryIdList);
        Map exitemElementMap = (Map)returnMap.get("exitemElementMap");
        long defaultId = (Long)returnMap.get("defaultId");
        ArrayList<Object[]> costRecordDetailList = new ArrayList<Object[]>();
        HashSet<Long> entryIdSet = new HashSet<Long>(16);
        HashSet<Long> ids = new HashSet<Long>(16);
        Long[] defaultElementIds = CostElementHelper.getDefaultMaterialElements();
        long defaultMateriaId = defaultElementIds[0];
        for (DynamicObject costRecord : costrecordarr) {
            ids.add(costRecord.getLong("id"));
            long costTypeId = costRecord.getLong("costaccount.costtype.id");
            DynamicObjectCollection costRecordEntrys = costRecord.getDynamicObjectCollection("entry");
            for (DynamicObject costRecordEntry : costRecordEntrys) {
                long entryId = costRecordEntry.getLong("id");
                entryIdSet.add(entryId);
                DynamicObjectCollection subEntryEntityEst = costRecordEntry.getDynamicObjectCollection("subentryentityest");
                for (DynamicObject estDetail : subEntryEntityEst) {
                    if (!Long.valueOf(billId).equals(estDetail.getLong("estimatebillid"))) continue;
                    BigDecimal shareDetailAmt = estDetail.getBigDecimal("sharedetailamt");
                    long elementId = 0L;
                    Boolean calByCostElement = this.entryCostElementMap.get(entryId);
                    elementId = calByCostElement != false ? this.getDefalutElementId(costTypeId, estDetail, defaultId, exitemElementMap) : defaultMateriaId;
                    costRecordDetailList.add(new Object[]{shareDetailAmt, entryId, elementId});
                }
            }
        }
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, ids)});){
            ctx.set();
            if (!costRecordDetailList.isEmpty()) {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)CostEstCostDetailHelper.getSubCostRecordDetailSql(), costRecordDetailList);
                CostEstCostDetailHelper.caculateDetailUnitActual(entryIdSet);
                CostElementHelper.calCostpricesourceRecordCost((Long[])entryIdSet.toArray(new Long[0]), (String)"UnCostEstimate");
            }
        }
        return entryIdSet;
    }

    private long getDefalutElementId(long costTypeId, DynamicObject estDetail, long defaultId, Map<String, Long[]> exitemElementMap) {
        long exitemId = estDetail.getLong("sharedetailexitem.id");
        long elementId = 0L;
        Long[] elementIds = exitemElementMap.get(costTypeId + "|" + exitemId);
        elementId = elementIds == null ? defaultId : elementIds[0];
        return elementId;
    }

    private void deleteCostAdjustBill(DynamicObject[] bills) {
        HashSet<Object> resultEntryIdSet = new HashSet<Object>();
        for (DynamicObject bill : bills) {
            for (DynamicObject[] resultEntry : bill.getDynamicObjectCollection("resultentity")) {
                resultEntryIdSet.add(resultEntry.getPkValue());
            }
        }
        QFilter filter = new QFilter("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.FEE_ESTIMATE.getValue());
        filter.and("entryentity.srcbillentryid", "in", resultEntryIdSet);
        boolean b = false;
        filter.and("checkstrikeaccount", "=", (Object)b);
        DynamicObject[] adjustBillArr = BusinessDataServiceHelper.load((String)"cal_costadjust_subentity", (String)"id", (QFilter[])filter.toArray());
        if (adjustBillArr == null || adjustBillArr.length == 0) {
            return;
        }
        HashSet<Object> adjustBillPkSet = new HashSet<Object>(32);
        HashSet<Long> inAdjustBillIds = new HashSet<Long>(32);
        for (DynamicObject adjustBill : adjustBillArr) {
            adjustBillPkSet.add(adjustBill.getPkValue());
            inAdjustBillIds.add((Long)adjustBill.getPkValue());
        }
        Object[] adjustBillPk = adjustBillPkSet.toArray();
        OperateOption op = OperateOption.create();
        op.setVariableValue("unwriteoff", "true");
        op.setVariableValue("ishasright", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_costadjust_subentity", (Object[])adjustBillPk, (OperateOption)op);
        this.dealOPResult(result);
        Set delBillids = CalIntimeBufferPoolHelper.removeBufferPoolRevBill((String)"cal_costadjust_subentity", inAdjustBillIds);
        if (!delBillids.isEmpty()) {
            result = OperationServiceHelper.executeOperate((String)"delete", (String)"cal_costadjust_subentity", (Object[])delBillids.toArray(), (OperateOption)op);
            this.dealOPResult(result);
        }
        PrevCostAdjustProcessHelper prevCostHelper = new PrevCostAdjustProcessHelper();
        prevCostHelper.unAduitAndDelAdjustBill(inAdjustBillIds);
    }

    private void deleteStdCostDiffBill(DynamicObject[] bills) {
        HashSet<Object> resultEntryIdSet = new HashSet<Object>();
        for (DynamicObject bill : bills) {
            for (DynamicObject[] resultEntry : bill.getDynamicObjectCollection("resultentity")) {
                resultEntryIdSet.add(resultEntry.getPkValue());
            }
        }
        QFilter filter = new QFilter("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.FEE_ESTIMATE.getValue());
        filter.and("entryentity.srcbillentryid", "in", resultEntryIdSet);
        boolean b = false;
        filter.and("checkstrikeaccount", "=", (Object)b);
        DynamicObject[] adjustBillArr = BusinessDataServiceHelper.load((String)"cal_stdcostdiffbill", (String)"id", (QFilter[])filter.toArray());
        if (adjustBillArr == null || adjustBillArr.length == 0) {
            return;
        }
        HashSet<Object> adjustBillPkSet = new HashSet<Object>(32);
        HashSet<Long> inAdjustBillIds = new HashSet<Long>(32);
        for (DynamicObject adjustBill : adjustBillArr) {
            adjustBillPkSet.add(adjustBill.getPkValue());
            inAdjustBillIds.add((Long)adjustBill.getPkValue());
        }
        Object[] adjustBillPk = adjustBillPkSet.toArray();
        OperateOption op = OperateOption.create();
        op.setVariableValue("unwriteoff", "true");
        op.setVariableValue("ishasright", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_stdcostdiffbill", (Object[])adjustBillPk, (OperateOption)op);
        this.dealOPResult(result);
        Set delBillids = CalIntimeBufferPoolHelper.removeBufferPoolRevBill((String)"cal_stdcostdiffbill", inAdjustBillIds);
        if (!delBillids.isEmpty()) {
            result = OperationServiceHelper.executeOperate((String)"delete", (String)"cal_stdcostdiffbill", (Object[])delBillids.toArray(), (OperateOption)op);
            this.dealOPResult(result);
        }
    }

    private void dealOPResult(OperationResult result) {
        if (result.isSuccess()) {
            return;
        }
        StringBuilder exceptionSb = new StringBuilder();
        for (IOperateInfo errorInfo : result.getAllErrorOrValidateInfo()) {
            exceptionSb.append(errorInfo.getMessage());
            exceptionSb.append('\n');
        }
        exceptionSb.append(result.getMessage());
        throw new KDBizException(exceptionSb.toString());
    }

    private void clearEstResult(DynamicObject bill) {
        bill.set("billstatus", (Object)Character.valueOf('A'));
        DynamicObjectCollection resultEntitys = bill.getDynamicObjectCollection("resultentity");
        for (DynamicObject resultEntity : resultEntitys) {
            DynamicObjectCollection subresultentity = resultEntity.getDynamicObjectCollection("subresultentity");
            if (subresultentity.isEmpty()) continue;
            subresultentity.clear();
        }
        if (!resultEntitys.isEmpty()) {
            resultEntitys.clear();
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
    }

    private void subtractCostRecord(Long billId, DynamicObject[] costrecordarr) {
        for (DynamicObject costRecord : costrecordarr) {
            DynamicObjectCollection costRecordEntrys = costRecord.getDynamicObjectCollection("entry");
            for (DynamicObject costRecordEntry : costRecordEntrys) {
                DynamicObjectCollection subEntryEntityEst = costRecordEntry.getDynamicObjectCollection("subentryentityest");
                BigDecimal substractAmt = BigDecimal.ZERO;
                for (int i = subEntryEntityEst.size() - 1; i >= 0; --i) {
                    DynamicObject estDetail = (DynamicObject)subEntryEntityEst.get(i);
                    if (!billId.equals(estDetail.getLong("estimatebillid"))) continue;
                    BigDecimal shareDetailAmt = estDetail.getBigDecimal("sharedetailamt");
                    substractAmt = substractAmt.add(shareDetailAmt);
                    subEntryEntityEst.remove(i);
                }
                if (substractAmt == BigDecimal.ZERO) continue;
                BigDecimal fee = costRecordEntry.getBigDecimal("fee");
                fee = fee.subtract(substractAmt);
                costRecordEntry.set("fee", (Object)fee);
                int priceprecision = 10;
                BigDecimal baseqty = costRecordEntry.getBigDecimal("baseqty");
                BigDecimal unitEntryFee = fee.divide(baseqty, priceprecision, RoundingMode.HALF_UP);
                costRecordEntry.set("unitfee", (Object)unitEntryFee);
                BigDecimal actualCost = costRecordEntry.getBigDecimal("materialcost").add(costRecordEntry.getBigDecimal("fee")).add(costRecordEntry.getBigDecimal("processcost")).add(costRecordEntry.getBigDecimal("manufacturecost")).add(costRecordEntry.getBigDecimal("resource"));
                BigDecimal unitActualCost = actualCost.divide(baseqty, priceprecision, RoundingMode.HALF_UP);
                costRecordEntry.set("actualcost", (Object)actualCost);
                costRecordEntry.set("unitactualcost", (Object)unitActualCost);
            }
        }
        SaveServiceHelper.save((DynamicObject[])costrecordarr);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        Set<Long> sourceEntryIdSet = this.getSourceEntryIdSetByBills(bills);
        this.writeBackUpBill(sourceEntryIdSet);
    }

    private Set<Long> getSourceEntryIdSetByBills(DynamicObject[] bills) {
        HashSet<Long> sourceEntryIdSet = new HashSet<Long>();
        for (DynamicObject bill : bills) {
            DynamicObjectCollection expenseEntrys = bill.getDynamicObjectCollection("expenseentity");
            Long[] entryIdArr = new Long[expenseEntrys.size()];
            for (int i = 0; i < expenseEntrys.size(); ++i) {
                entryIdArr[i] = ((DynamicObject)expenseEntrys.get(i)).getLong("id");
            }
            List list = BFTrackerServiceHelper.loadSourceRowIds((String)"cal_costestimatebill", (String)"expenseentity", (Long[])entryIdArr);
            if (list == null || list.isEmpty()) continue;
            for (BFRow row : list) {
                sourceEntryIdSet.add(row.getSId().getEntryId());
            }
        }
        return sourceEntryIdSet;
    }

    private void writeBackUpBill(Set<Long> sourceEntryIdSet) {
        if (sourceEntryIdSet == null || sourceEntryIdSet.isEmpty()) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                DynamicObject[] busbills = BusinessDataServiceHelper.load((String)"ap_busbill", (String)"entry.id,entry.isallocate,entry.e_allocatedamt,entry.e_unallocatedamt", (QFilter[])new QFilter("entry.id", "in", sourceEntryIdSet).toArray());
                boolean isallocate = false;
                for (DynamicObject busbill : busbills) {
                    for (DynamicObject entry : busbill.getDynamicObjectCollection("entry")) {
                        if (!sourceEntryIdSet.contains(entry.getLong("id"))) continue;
                        BigDecimal amt = entry.getBigDecimal("e_allocatedamt");
                        entry.set("e_allocatedamt", (Object)BigDecimal.ZERO);
                        entry.set("e_unallocatedamt", (Object)amt);
                        entry.set("isallocate", (Object)isallocate);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])busbills);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                h.markRollback();
                WriteLogHelper.writeErrorLog((Log)logger, (String)"CostEstimateBillCancelOp-writeBackUpBill", (Throwable)e);
            }
        }
    }

    private static class CostEsBillAmtValidator
    extends AbstractValidator {
        private CostEsBillAmtValidator() {
        }

        public void validate() {
            ExtendedDataEntity[] datas = this.getDataEntities();
            HashSet<Object> resultEntryIdSet = new HashSet<Object>();
            for (ExtendedDataEntity data : datas) {
                DynamicObject bill = data.getDataEntity();
                for (DynamicObject dynamicObject : bill.getDynamicObjectCollection("resultentity")) {
                    resultEntryIdSet.add(dynamicObject.getPkValue());
                }
            }
            QFilter filter = new QFilter("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.FEE_ESTIMATE.getValue());
            filter.and("entryentity.srcbillentryid", "in", resultEntryIdSet);
            DynamicObject[] adjustBillArr = BusinessDataServiceHelper.load((String)"cal_costadjust_subentity", (String)"billno,checkstrikeaccount,isvoucher,entryentity.srcbillentryid", (QFilter[])filter.toArray());
            HashMap<Long, String> billAndAdjBillMap = new HashMap<Long, String>(16);
            for (DynamicObject dynamicObject : adjustBillArr) {
                if (dynamicObject.getBoolean("checkstrikeaccount")) {
                    String content = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u201c%1$s\u201d\u5df2\u51b2\u56de\u4e0d\u5141\u8bb8\u53d6\u6d88\u6682\u4f30\u3002", (String)"CostEstimateBillCancelOp_6", (String)"fi-cal-opplugin", (Object[])new Object[0]), dynamicObject.getString("billno"));
                    throw new KDBizException(content);
                }
                DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entrys) {
                    if (!dynamicObject.getBoolean("isvoucher") || billAndAdjBillMap.containsKey(entry.getLong("srcbillentryid"))) continue;
                    billAndAdjBillMap.put(entry.getLong("srcbillentryid"), dynamicObject.getString("billno"));
                }
            }
            block4: for (DynamicObject dynamicObject : datas) {
                DynamicObject bill = dynamicObject.getDataEntity();
                String billStatus = bill.getString("billstatus");
                if (!"C".equals(billStatus)) {
                    this.addFatalErrorMessage((ExtendedDataEntity)dynamicObject, ResManager.loadKDString((String)"\u6682\u4f30\u5b8c\u6210\u7684\u6682\u4f30\u5355\u624d\u80fd\u8fdb\u884c\u53d6\u6d88\u6682\u4f30\u3002", (String)"CostEstimateBillCancelOp_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    continue;
                }
                DynamicObjectCollection resultcol = bill.getDynamicObjectCollection("resultentity");
                for (DynamicObject result : resultcol) {
                    long calEntryId;
                    DynamicObject bizCostRecord;
                    long id;
                    boolean hasFeeShared;
                    String adjBillno = (String)billAndAdjBillMap.get(result.getLong("id"));
                    if (adjBillno != null) {
                        this.addFatalErrorMessage((ExtendedDataEntity)dynamicObject, String.format(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u201c%1$s\u201d\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\uff0c\u8bf7\u5148\u5220\u9664\u6210\u672c\u8c03\u6574\u5355\u7684\u51ed\u8bc1\u3002", (String)"CostEstimateBillCancelOp_7", (String)"fi-cal-opplugin", (Object[])new Object[0]), adjBillno));
                    }
                    if (hasFeeShared = FeeShareHelper.isEntryIdShare((Long)(id = (bizCostRecord = QueryServiceHelper.queryOne((String)"cal_costrecord", (String)"entry.id", (QFilter[])new QFilter("entry.calentryid", "=", (Object)(calEntryId = result.getLong("calentryid"))).and("calbilltype", "=", (Object)"IN").and("issplitcreate", "=", (Object)Boolean.FALSE).toArray())).getLong("entry.id")))) {
                        this.addFatalErrorMessage((ExtendedDataEntity)dynamicObject, ResManager.loadKDString((String)"\u6682\u4f30\u5355\u5df2\u7ecf\u5206\u644a\u8fc7\u4e0d\u80fd\u53d6\u6d88\u6682\u4f30\u3002", (String)"CostEstimateBillCancelOp_1", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                        continue block4;
                    }
                    DynamicObjectCollection costRecords = QueryServiceHelper.query((String)"cal_costrecord", (String)"isfeevoucher,isfivoucher,isdischargevoucher,istempvoucher,iscostcarryover", (QFilter[])new QFilter("entry.calentryid", "=", (Object)calEntryId).toArray());
                    for (DynamicObject costRecord : costRecords) {
                        boolean isCher = costRecord.getBoolean("isfeevoucher") || costRecord.getBoolean("isfivoucher") || costRecord.getBoolean("iscostcarryover") || costRecord.getBoolean("istempvoucher") || costRecord.getBoolean("isdischargevoucher");
                        if (!isCher || adjustBillArr != null && adjustBillArr.length != 0) continue;
                        this.addFatalErrorMessage((ExtendedDataEntity)dynamicObject, ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u6682\u4f30\u3002", (String)"CostEstimateBillCancelOp_2", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                        continue block4;
                    }
                }
            }
        }
    }
}

