/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.balance.BalanceSourceEnum;
import kd.fi.cal.business.process.inner.PrevCostAdjustProcessHelper;
import kd.fi.cal.business.sharemodel.StandardAmtExchange;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBillDiffTypeEnum;
import kd.fi.cal.common.enums.CostPriceSourceTypeEnum;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.BillNoHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.CostEstCostDetailHelper;
import kd.fi.cal.common.helper.ExpenseItemSubElementHelper;
import kd.fi.cal.common.helper.FeeShareHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.model.CostAdjustDetailParams;
import kd.fi.cal.common.util.CommonUtils;

public class CostEstimateBillSavePlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CostEstimateBillSavePlugin.class);
    private ExpenseItemSubElementHelper helper = new ExpenseItemSubElementHelper();
    private Map<Long, Boolean> entryCostElementMap = new HashMap<Long, Boolean>(16);
    private Map<Long, Boolean> entryHasTaxMap = new HashMap<Long, Boolean>(16);
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new CostEsBillAmtValidator());
        e.addValidator(new AbstractValidator(){

            public void validate() {
                Set apIds;
                ExtendedDataEntity[] datas = this.getDataEntities();
                DynamicObject bill = datas[0].getDataEntity();
                Long apBillId = null;
                Map apBillIdMap = BFTrackerServiceHelper.findSourceBills((String)"cal_costestimatebill", (Long[])new Long[]{bill.getLong("id")});
                if (apBillIdMap != null && !apBillIdMap.isEmpty() && (apIds = (Set)apBillIdMap.get("ap_busbill")) != null && !apIds.isEmpty()) {
                    apBillId = (Long)new ArrayList(apIds).get(0);
                }
                if (apBillId == null || apBillId.equals(0L)) {
                    this.addFatalErrorMessage(datas[0], ResManager.loadKDString((String)"\u4e0a\u6e38\u6682\u4f30\u5e94\u4ed8\u5355\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CostEstimateBillSavePlugin_17", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject apBusBill = BusinessDataServiceHelper.loadSingle((String)"ap_busbill", (String)"id,billstatus,entry.isallocate", (QFilter[])new QFilter("id", "=", (Object)apBillId).toArray());
                if (!"C".equals(apBusBill.getString("billstatus"))) {
                    this.addFatalErrorMessage(datas[0], ResManager.loadKDString((String)"\u4e0a\u6e38\u6682\u4f30\u5e94\u4ed8\u5355\u4e3a\u975e\u5ba1\u6838\u72b6\u6001\u3002", (String)"CostEstimateBillSavePlugin_18", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                }
                DynamicObjectCollection entry = apBusBill.getDynamicObjectCollection("entry");
                for (DynamicObject entryRow : entry) {
                    boolean isallocate = entryRow.getBoolean("isallocate");
                    if (!isallocate) continue;
                    this.addFatalErrorMessage(datas[0], ResManager.loadKDString((String)"\u4e0a\u6e38\u6682\u4f30\u5e94\u4ed8\u5355\u5df2\u7ecf\u505a\u8fc7\u5206\u644a\u3002", (String)"CostEstimateBillSavePlugin_27", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    break;
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject bill = e.getDataEntities()[0];
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject userDyc = BusinessDataServiceHelper.loadSingle((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
        for (DynamicObject dataEntity : dataEntities) {
            if (!"submit".equals(e.getOperationKey())) continue;
            dataEntity.set("lastupdateuser", (Object)userDyc);
            dataEntity.set("lastupdatetime", (Object)new Date());
        }
        HashSet<Long> calentryids = new HashSet<Long>();
        HashMap<Object, DynamicObject> resultmap = new HashMap<Object, DynamicObject>();
        DynamicObjectCollection resultcol = bill.getDynamicObjectCollection("resultentity");
        HashSet<Object> costRecords = new HashSet<Object>(16);
        for (DynamicObject result : resultcol) {
            resultmap.put(result.getLong("calentryid"), result);
            calentryids.add(result.getLong("calentryid"));
            Iterator costrecordEntry = result.getDynamicObject("costdetail");
            costRecords.add(costrecordEntry.getDynamicObject("parent").getPkValue());
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"cal_costrecord", (String)"bizbillid", (QFilter[])new QFilter("id", "in", costRecords).toArray());
        HashSet<Long> bizbillids = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : collection) {
            bizbillids.add(dynamicObject.getLong("bizbillid"));
        }
        QFilter recordFilter = new QFilter("entry.calentryid", "in", calentryids);
        boolean splite = false;
        recordFilter.and("issplitcreate", "=", (Object)splite);
        recordFilter.and("costaccount.enable", "=", (Object)"1");
        recordFilter.and("ischargeoff", "=", (Object)Boolean.FALSE);
        recordFilter.and("ischargeoffed", "=", (Object)Boolean.FALSE);
        recordFilter.and("bizbillid", "in", bizbillids);
        DynamicObject[] costrecordarr = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"id", (QFilter[])recordFilter.toArray());
        HashSet<Object> costRecordIdSet = new HashSet<Object>(32);
        for (DynamicObject costRecord : costrecordarr) {
            costRecordIdSet.add(costRecord.getPkValue());
        }
        costrecordarr = BusinessDataServiceHelper.load((Object[])costRecordIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_costrecord"));
        if (costrecordarr == null || costrecordarr.length < 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u786e\u8ba4\u6682\u4f30\u5931\u8d25\uff1a\u627e\u4e0d\u5230\u6709\u6548\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u5bf9\u5e94\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u7684\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"CostEstimateBillSavePlugin_13", (String)"fi-cal-opplugin", (Object[])new Object[0]));
        }
        List<Long[]> entryIds = this.analyseResults(bill, resultmap, costrecordarr);
        this.updateCostRecordDetail(bill, costrecordarr, entryIds);
        this.updateBalance(costrecordarr);
        bill.set("billstatus", (Object)Character.valueOf('C'));
    }

    private void dealOPResult(OperationResult result) {
        if (result.isSuccess()) {
            return;
        }
        StringBuilder exceptionSb = new StringBuilder();
        for (OperateErrorInfo errorInfo : result.getAllErrorInfo()) {
            exceptionSb.append(errorInfo.getMessage());
            exceptionSb.append('\n');
        }
        throw new KDBizException(exceptionSb.toString());
    }

    protected void updateBalance(DynamicObject[] costrecordarr) {
        BalanceCalculator calculator = new BalanceCalculator();
        HashSet<Object> set = new HashSet<Object>(16);
        HashSet<Long> idSet = new HashSet<Long>(costrecordarr.length);
        for (DynamicObject record : costrecordarr) {
            for (DynamicObject entry : record.getDynamicObjectCollection("entry")) {
                set.add(entry.getPkValue());
            }
            idSet.add(record.getLong("id"));
        }
        if (this.isNewBalance) {
            new BalanceOpInvoker().invokeCostRecordUpdateBalOp(idSet, BalanceSourceEnum.FEE_ESTIMATE);
        } else {
            calculator.updateBalance4Others(set.toArray(), BalanceSourceEnum.FEE_ESTIMATE, idSet);
        }
    }

    private void updateCostRecordDetail(DynamicObject bill, DynamicObject[] costrecordarr, List<Long[]> entryIds) {
        List exitemAndEntryIdList = CostEstCostDetailHelper.getExitemMaterialIdEntryId((DynamicObject[])costrecordarr);
        Map entryCostTypeMap = (Map)exitemAndEntryIdList.get(3);
        Map returnMap = CostEstCostDetailHelper.getElementMap((List)exitemAndEntryIdList);
        Map exitemElementMap = (Map)returnMap.get("exitemElementMap");
        ArrayList<Object[]> costRecordDetailList = new ArrayList<Object[]>(16);
        ArrayList costRecordDetailUnitCostList = new ArrayList(16);
        DynamicObjectCollection resultEntitys = bill.getDynamicObjectCollection("resultentity");
        Long[] defaultElementIds = CostElementHelper.getDefaultMaterialElements();
        HashSet<Long> costpricesourceIdSet = new HashSet<Long>(16);
        for (DynamicObject resultEntity : resultEntitys) {
            DynamicObject costRecordEntry = resultEntity.getDynamicObject("costdetail");
            long entryId = costRecordEntry.getLong("id");
            Set<Long> exitems = this.getCostAdjustBillExitem(entryId, entryIds);
            long costTypeId = entryCostTypeMap.get(entryId) == null ? 0L : (Long)entryCostTypeMap.get(entryId);
            boolean calByCostElement = this.entryCostElementMap.get(entryId);
            boolean hasTax = this.entryHasTaxMap.get(entryId);
            DynamicObjectCollection subresultentity = resultEntity.getDynamicObjectCollection("subresultentity");
            if (calByCostElement) {
                long defaultId = (Long)returnMap.get("defaultId");
                CostEstCostDetailHelper.buildCostRecordDetailExitem((Long)costTypeId, (Long)entryId, (DynamicObjectCollection)subresultentity, (Map)exitemElementMap, costRecordDetailList, costRecordDetailUnitCostList, (boolean)true, (Long)defaultId, exitems, (boolean)hasTax);
                continue;
            }
            CostEstCostDetailHelper.buildCostRecordDetailMaterial((Long)entryId, (DynamicObjectCollection)subresultentity, costRecordDetailList, costRecordDetailUnitCostList, (boolean)true, (Long)defaultElementIds[0], exitems, (boolean)hasTax);
        }
        if (costRecordDetailList.isEmpty()) {
            return;
        }
        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)CostEstCostDetailHelper.getUpdateCostRecordDetailActualCostSql(), costRecordDetailList);
        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)CostEstCostDetailHelper.getUpdateCostRecordDetailUnitActualCostSql(), costRecordDetailUnitCostList);
        this.updateCostPriceSource(costRecordDetailList, costpricesourceIdSet);
    }

    private void updateCostPriceSource(List<Object[]> costRecordDetailList, Set<Long> costpricesourceIdSet) {
        for (int i = 0; i < costRecordDetailList.size(); ++i) {
            Object entryIdOb = costRecordDetailList.get(i)[1];
            Long entryId = Long.parseLong(String.valueOf(entryIdOb));
            costpricesourceIdSet.add(entryId);
        }
        if (!costpricesourceIdSet.isEmpty()) {
            ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
            QFilter pricesourceqf = new QFilter("entry.id", "in", costpricesourceIdSet);
            try (DataSet pricesourceds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"entry.id as entryid,entry.costpricesource as costpricesource", (QFilter[])pricesourceqf.toArray(), null);){
                for (Row pricesourced : pricesourceds) {
                    Long entryid = pricesourced.getLong("entryid");
                    String oldcostpricesource = pricesourced.getString("costpricesource");
                    String newcostpricesource = CostPriceSourceTypeEnum.getCostPriceSourceValue((String)oldcostpricesource, (String)CostPriceSourceTypeEnum.FEE_TEMP_SPECIFICATION.getValue());
                    sqlParams.add(new Object[]{newcostpricesource, CostPriceSourceTypeEnum.FEE_TEMP_SPECIFICATION.getDesignated(), entryid});
                }
                if (sqlParams.size() > 0) {
                    DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)CostPriceSourceTypeEnum.getCostpriceSourceSql(), sqlParams);
                }
            }
        }
    }

    private Set<Long> getCostAdjustBillExitem(long entryId, List<Long[]> entryIds) {
        HashSet<Long> exitems = new HashSet<Long>();
        for (Long[] longs : entryIds) {
            long entry = longs[0];
            if (String.valueOf(entryId).compareTo(String.valueOf(entry)) != 0) continue;
            exitems.add(longs[1]);
        }
        return exitems;
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject bill = e.getDataEntities()[0];
        this.writeBackUpBill(bill);
    }

    private void writeBackUpBill(DynamicObject bill) {
        DynamicObjectCollection expenseEntrys = bill.getDynamicObjectCollection("expenseentity");
        Long[] entryIdArr = new Long[expenseEntrys.size()];
        for (int i = 0; i < expenseEntrys.size(); ++i) {
            entryIdArr[i] = ((DynamicObject)expenseEntrys.get(i)).getLong("id");
        }
        List list = BFTrackerServiceHelper.loadSourceRowIds((String)"cal_costestimatebill", (String)"expenseentity", (Long[])entryIdArr);
        if (list == null || list.isEmpty()) {
            return;
        }
        HashSet<Long> sourceEntryIdSet = new HashSet<Long>(32);
        for (BFRow row : list) {
            sourceEntryIdSet.add(row.getSId().getEntryId());
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                DynamicObject[] busbills = BusinessDataServiceHelper.load((String)"ap_busbill", (String)"entry.id,entry.isallocate,entry.e_allocatedamt,entry.e_unallocatedamt", (QFilter[])new QFilter("entry.id", "in", sourceEntryIdSet).toArray());
                boolean isallocate = true;
                for (DynamicObject busbill : busbills) {
                    for (DynamicObject entry : busbill.getDynamicObjectCollection("entry")) {
                        if (!sourceEntryIdSet.contains(entry.getLong("id"))) continue;
                        BigDecimal unamt = entry.getBigDecimal("e_unallocatedamt");
                        entry.set("e_allocatedamt", (Object)unamt);
                        entry.set("e_unallocatedamt", (Object)BigDecimal.ZERO);
                        entry.set("isallocate", (Object)isallocate);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])busbills);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                h.markRollback();
            }
        }
    }

    protected List<Long[]> analyseResults(DynamicObject bill, Map<Object, DynamicObject> resultmap, DynamicObject[] costrecordarr) {
        OperateOption costAdjustArr;
        Set apIds;
        Date currentdate = new Date();
        StandardAmtExchange exchange = new StandardAmtExchange(bill.getDynamicObject("standardcurrency"), (Long)bill.getDynamicObject("exratetable").getPkValue());
        Date estimatedate = bill.getDate("estimatedate");
        String billno = bill.getString("billno");
        Long apBillId = null;
        Map apBillIdMap = BFTrackerServiceHelper.findSourceBills((String)"cal_costestimatebill", (Long[])new Long[]{bill.getLong("id")});
        if (apBillIdMap != null && !apBillIdMap.isEmpty() && (apIds = (Set)apBillIdMap.get("ap_busbill")) != null && !apIds.isEmpty()) {
            apBillId = (Long)new ArrayList(apIds).get(0);
        }
        DynamicObject apBusBill = BusinessDataServiceHelper.loadSingle((String)"ap_busbill", (String)"id,bizdate,bookdate", (QFilter[])new QFilter("id", "=", apBillId).toArray());
        Date apBookDate = apBusBill.getDate("bookdate");
        Date apBizDate = apBusBill.getDate("bizdate");
        DynamicObjectCollection resultcol = bill.getDynamicObjectCollection("resultentity");
        HashMap<Long, Date> datecache = new HashMap<Long, Date>();
        LinkedList<DynamicObject> costAdjustList = new LinkedList<DynamicObject>();
        ArrayList<CostAdjustDetailParams> paramsList = new ArrayList<CostAdjustDetailParams>();
        LinkedList<DynamicObject> stdCostDiffBillList = new LinkedList<DynamicObject>();
        ArrayList<CostAdjustDetailParams> stdCostDiffBillParamsList = new ArrayList<CostAdjustDetailParams>();
        LinkedList<Long[]> costRecordEntryIdSet = new LinkedList<Long[]>();
        boolean isdirect = false;
        HashMap<Object, DynamicObject> newResultMap = new HashMap<Object, DynamicObject>();
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        for (DynamicObject costrecord : costrecordarr) {
            costAccountIds.add(costrecord.getLong("costaccount_id"));
        }
        DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,calpolicy.calbycostelement,calpolicy.supporttaxamt", (QFilter[])new QFilter("id", "in", costAccountIds).toArray());
        HashMap<Long, Boolean> calByCostElementMaps = new HashMap<Long, Boolean>(16);
        HashMap<Long, Boolean> supportTaxAmtMaps = new HashMap<Long, Boolean>(16);
        for (DynamicObject dynamicObject : costAccounts) {
            Long id = dynamicObject.getLong("id");
            Boolean calByCostElement = dynamicObject.getBoolean("calpolicy.calbycostelement");
            Boolean supportTaxAmt = dynamicObject.getBoolean("calpolicy.supporttaxamt");
            calByCostElementMaps.put(id, calByCostElement);
            supportTaxAmtMaps.put(id, supportTaxAmt);
        }
        for (DynamicObject costrecord : costrecordarr) {
            Long costAccountId = costrecord.getDynamicObject("costaccount").getLong("id");
            boolean calbycostelement = (Boolean)calByCostElementMaps.get(costAccountId);
            boolean supportTaxAmt = (Boolean)supportTaxAmtMaps.get(costAccountId);
            DynamicObject result = null;
            Long calentryid = null;
            DynamicObject sourcecurrency = costrecord.getDynamicObject("localcurrency");
            DynamicObject costtype = costrecord.getDynamicObject("costaccount").getDynamicObject("costtype");
            Boolean enablestandardcost = costrecord.getDynamicObject("costaccount").getBoolean("enablestandardcost");
            Long costTypeId = costtype == null ? null : Long.valueOf(costtype.getLong("id"));
            for (DynamicObject costrecordentry : costrecord.getDynamicObjectCollection("entry")) {
                Long entryid = costrecordentry.getLong("id");
                this.entryHasTaxMap.put(entryid, supportTaxAmt);
                this.entryCostElementMap.put(entryid, calbycostelement);
                calentryid = costrecordentry.getLong("calentryid");
                result = resultmap.get(calentryid);
                if (result == null) continue;
                for (DynamicObject resultentry : result.getDynamicObjectCollection("subresultentity")) {
                    Long expenseId = resultentry.getDynamicObject("sharedetailexitem").getLong("id");
                    Object costRecordEntryId = costrecordentry.getPkValue();
                    BigDecimal sharedetailAmount = resultentry.getBigDecimal("sharedetailamount");
                    BigDecimal sharedetailTaxAmount = resultentry.getBigDecimal("sharedetailtaxamount");
                    BigDecimal sharedetailAmt = exchange.exchangeToSourceAmt(sharedetailAmount, sourcecurrency, estimatedate);
                    BigDecimal sharedetailTaxAmt = exchange.exchangeToSourceAmt(sharedetailTaxAmount, sourcecurrency, estimatedate);
                    if (costRecordEntryId.equals(result.getDynamicObject("costdetail").getPkValue())) {
                        result.set("createdate", (Object)currentdate);
                        result.set("estimatebillno", (Object)billno);
                    } else {
                        DynamicObject newresult = (DynamicObject)newResultMap.get(costRecordEntryId);
                        if (newresult == null) {
                            newresult = resultcol.addNew();
                            newresult.set("costdetail", (Object)costrecordentry);
                            newresult.set("currency", (Object)sourcecurrency);
                            newresult.set("shareamt", (Object)sharedetailAmt);
                            newresult.set("shareamount", result.get("shareamount"));
                            newresult.set("sharetaxamt", (Object)sharedetailTaxAmt);
                            newresult.set("sharetaxamount", result.get("sharetaxamount"));
                            newresult.set("isdirect", (Object)isdirect);
                            newresult.set("calentryid", costrecordentry.get("calentryid"));
                            newresult.set("createdate", (Object)currentdate);
                            newresult.set("estimatebillno", (Object)billno);
                            newResultMap.put(costRecordEntryId, newresult);
                        }
                        DynamicObjectCollection newresultentrys = newresult.getDynamicObjectCollection("subresultentity");
                        DynamicObject newresultentry = newresultentrys.addNew();
                        newresultentry.set("sharedetailamount", (Object)sharedetailAmount);
                        newresultentry.set("sharedetailamt", (Object)sharedetailAmt);
                        newresultentry.set("sharedetailtaxamount", (Object)sharedetailTaxAmount);
                        newresultentry.set("sharedetailtaxamt", (Object)sharedetailTaxAmt);
                        newresultentry.set("sharedetailexitem", resultentry.get("sharedetailexitem"));
                        newresultentry.set("exitemseq", resultentry.get("exitemseq"));
                        newresultentry.set("sharedetailatype", resultentry.get("sharedetailatype"));
                        newresultentry.set("sharedetailasstact", resultentry.get("sharedetailasstact"));
                    }
                    String accountType = costrecordentry.getString("accounttype");
                    BigDecimal sharedetailAmountOrTax = BigDecimal.ZERO;
                    BigDecimal sharedetailAmtOrTax = BigDecimal.ZERO;
                    if (supportTaxAmt) {
                        sharedetailAmountOrTax = sharedetailTaxAmount;
                        sharedetailAmtOrTax = sharedetailTaxAmt;
                    } else {
                        sharedetailAmountOrTax = sharedetailAmount;
                        sharedetailAmtOrTax = sharedetailAmt;
                    }
                    boolean needWriteBack = false;
                    if (AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) {
                        this.createStdCostDiffBill(bill, apBookDate, stdCostDiffBillList, stdCostDiffBillParamsList, costRecordEntryIdSet, costrecord, calbycostelement, result, costTypeId, costrecordentry, expenseId, costRecordEntryId, sharedetailAmtOrTax, CostAdjustBillDiffTypeEnum.FEE_DIFF.getValue(), needWriteBack);
                        continue;
                    }
                    boolean iswriteBack = this.getIsWriteBack(costrecord, apBookDate);
                    if (iswriteBack) {
                        iswriteBack = this.isSatisfyCondition(costrecord, costrecordentry, datecache, expenseId);
                    }
                    if (iswriteBack) {
                        needWriteBack = true;
                        this.writeBackCostRecord(bill, costrecord, costrecordentry, resultentry, sharedetailAmountOrTax, sharedetailAmtOrTax);
                    } else {
                        this.createCostAdjustBill(bill, apBookDate, costAdjustList, paramsList, costRecordEntryIdSet, costrecord, calbycostelement, result, costTypeId, costrecordentry, expenseId, costRecordEntryId, sharedetailAmtOrTax, CostAdjustBillDiffTypeEnum.ACT_COST.getValue(), needWriteBack);
                    }
                    if (!enablestandardcost.booleanValue()) continue;
                    this.createCostAdjustBill(bill, apBookDate, costAdjustList, paramsList, costRecordEntryIdSet, costrecord, calbycostelement, result, costTypeId, costrecordentry, expenseId, costRecordEntryId, sharedetailAmtOrTax, CostAdjustBillDiffTypeEnum.FEE_DIFF.getValue(), needWriteBack);
                }
                newResultMap.clear();
            }
        }
        SaveServiceHelper.save((DynamicObject[])costrecordarr);
        if (costAdjustList.size() > 0) {
            costAdjustArr = costAdjustList.toArray(new DynamicObject[costAdjustList.size()]);
            costAdjustArr = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])costAdjustArr);
            HashSet<Long> costAdjustIds = new HashSet<Long>(((DynamicObject[])costAdjustArr).length);
            for (DynamicObject costAdjust : costAdjustArr) {
                costAdjustIds.add((Long)costAdjust.getPkValue());
            }
            costAdjustArr = BusinessDataServiceHelper.load((Object[])costAdjustIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_costadjust_subentity"));
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("CostAdjustDetailParms", SerializationUtils.toJsonString(paramsList));
            OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_costadjust_subentity", (DynamicObject[])costAdjustArr, (OperateOption)option);
            this.dealOPResult(result);
            PrevCostAdjustProcessHelper prevCostAdjustProcessHelper = new PrevCostAdjustProcessHelper();
            prevCostAdjustProcessHelper.dealOutAdjustSet(costAdjustIds);
        }
        if (stdCostDiffBillList.size() > 0) {
            costAdjustArr = stdCostDiffBillList.toArray(new DynamicObject[0]);
            costAdjustArr = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])costAdjustArr);
            HashSet<Long> costAdjustIds = new HashSet<Long>(((DynamicObject[])costAdjustArr).length);
            for (DynamicObject costAdjust : costAdjustArr) {
                costAdjustIds.add((Long)costAdjust.getPkValue());
            }
            costAdjustArr = BusinessDataServiceHelper.load((Object[])costAdjustIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_stdcostdiffbill"));
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("CostAdjustDetailParms", SerializationUtils.toJsonString(stdCostDiffBillParamsList));
            OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_stdcostdiffbill", (DynamicObject[])costAdjustArr, (OperateOption)option);
            this.dealOPResult(result);
        }
        return costRecordEntryIdSet;
    }

    private void createCostAdjustBill(DynamicObject bill, Date apBookDate, List<DynamicObject> costAdjustList, List<CostAdjustDetailParams> paramsList, List<Long[]> costRecordEntryIdSet, DynamicObject costrecord, boolean calbycostelement, DynamicObject result, Long costTypeId, DynamicObject costrecordentry, Long expenseId, Object costRecordEntryId, BigDecimal sharedetailamt, String diffType, boolean needWriteBack) {
        if (!needWriteBack) {
            costRecordEntryIdSet.add(new Long[]{(Long)costRecordEntryId, expenseId});
        }
        DynamicObject costAdjust = BusinessDataServiceHelper.newDynamicObject((String)"cal_costadjust_subentity");
        Long costAccountId = costrecord.getDynamicObject("costaccount").getLong("id");
        DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
        if (currentPeriod == null) {
            String content = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u5c1a\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CostEstimateBillSavePlugin_20", (String)"fi-cal-opplugin", (Object[])new Object[0]), costrecord.getDynamicObject("costaccount").getString("name"));
            throw new KDBizException(content);
        }
        Date currentPeriodDate = currentPeriod.getDate("begindate");
        Date bizDate = costrecord.getDate("bizdate");
        Date maxDate = Collections.max(Arrays.asList(currentPeriodDate, bizDate, apBookDate));
        DynamicObject bizPeriod = PeriodHelper.getPeriodByDate((Date)maxDate, (Long)costAccountId);
        costAdjust.set("bizdate", (Object)maxDate);
        Date bookDate = costrecord.getDate("bookdate");
        Date maxBookDate = Collections.max(Arrays.asList(currentPeriodDate, bookDate, apBookDate));
        costAdjust.set("bookdate", (Object)maxBookDate);
        costAdjust.set("period", (Object)bizPeriod.getLong("id"));
        String calbilltype = costrecord.getString("calbilltype");
        String csType = "";
        if ("IN".equals(calbilltype)) {
            calbilltype = "A";
            csType = "bd_supplier";
        } else if ("OUT".equals(calbilltype)) {
            calbilltype = "B";
            csType = "bd_customer";
        }
        costAdjust.set("custsupplier", ((DynamicObject)bill.getDynamicObjectCollection("expenseentity").get(0)).get("asstact"));
        costAdjust.set("biztype", (Object)calbilltype);
        costAdjust.set("cstype", (Object)csType);
        costAdjust.set("billtype", costrecord.get("billtype"));
        costAdjust.set("difftype", (Object)diffType);
        costAdjust.set("createtype", (Object)CostAdjustBilCreateTypeEnum.FEE_ESTIMATE.getValue());
        costAdjust.set("currency", costrecord.get("localcurrency"));
        costAdjust.set("costaccount", costrecord.get("costaccount"));
        costAdjust.set("calorg", costrecord.get("calorg"));
        costAdjust.set("billstatus", (Object)"B");
        costAdjust.set("createtime", (Object)new Date());
        costAdjust.set("creator", (Object)RequestContext.get().getUserId());
        costAdjust.set("modifytime", (Object)new Date());
        costAdjust.set("modifier", (Object)RequestContext.get().getUserId());
        costAdjust.set("adminorg", costrecord.get("adminorg"));
        DynamicObject costAdjustEntry = costAdjust.getDynamicObjectCollection("entryentity").addNew();
        Long materialId = costrecordentry.getDynamicObject("material").getLong("id");
        long costAdjustEntryId = DBServiceHelper.genLongIds((String)"t_cal_costadjustbillentry", (int)1)[0];
        costAdjustEntry.set("id", (Object)costAdjustEntryId);
        costAdjustEntry.set("material", (Object)materialId);
        costAdjustEntry.set("storageorgunit", costrecord.get("storageorgunit"));
        costAdjustEntry.set("lot", costrecordentry.get("lot"));
        costAdjustEntry.set("adjustamt", (Object)sharedetailamt);
        costAdjustEntry.set("warehouse", costrecordentry.get("warehouse"));
        costAdjustEntry.set("ownertype", costrecordentry.get("ownertype"));
        costAdjustEntry.set("owner", costrecordentry.get("owner"));
        costAdjustEntry.set("ecostcenter", costrecordentry.get("ecostcenter"));
        costAdjustEntry.set("assist", costrecordentry.get("assist"));
        costAdjustEntry.set("project", costrecordentry.get("project"));
        costAdjustEntry.set("invbizdate", costrecord.get("bookdate"));
        costAdjustEntry.set("invtype", costrecordentry.get("invtype"));
        costAdjustEntry.set("invstatus", costrecordentry.get("invstatus"));
        costAdjustEntry.set("baseunit", costrecordentry.get("baseunit"));
        costAdjustEntry.set("location", costrecordentry.get("location"));
        costAdjustEntry.set("feeprojectid", (Object)expenseId);
        costAdjustEntry.set("invbillid", costrecord.get("id"));
        costAdjustEntry.set("invbilltype", (Object)costrecord.getDynamicObject("billtype"));
        costAdjustEntry.set("invbillentryid", costrecordentry.get("id"));
        costAdjustEntry.set("invbizentityobject", (Object)"cal_costrecord");
        costAdjustEntry.set("invbillnum", costrecord.get("billno"));
        costAdjustEntry.set("inventryseq", (Object)costrecordentry.getInt("seq"));
        costAdjustEntry.set("srcbillid", bill.get("id"));
        costAdjustEntry.set("srcbillentryid", (Object)result.getLong("id"));
        costAdjustEntry.set("srcbizentityobject", (Object)"cal_costestimatebill");
        costAdjustEntry.set("srcbilltype", (Object)986033862553422848L);
        costAdjustEntry.set("srcentryseq", result.get("seq"));
        costAdjustEntry.set("srcbillnum", bill.get("billno"));
        costAdjustEntry.set("accounttype", costrecordentry.get("accounttype"));
        costAdjustEntry.set("caldimension", costrecordentry.get("caldimension"));
        costAdjustEntry.set("calrange", costrecordentry.get("calrange"));
        costAdjustEntry.set("mversion", costrecordentry.get("mversion"));
        costAdjustEntry.set("tracknumber", costrecordentry.get("tracknumber"));
        costAdjustEntry.set("configuredcode", costrecordentry.get("configuredcode"));
        costAdjustEntry.set("noupdatecalfields", costrecordentry.get("noupdatecalfields"));
        costAdjustEntry.set("stocktype", costrecordentry.get("stocktype"));
        Long subElement = this.helper.getSubElement(costTypeId, materialId, calbycostelement, expenseId);
        DynamicObject element = this.helper.getElementBySubId(subElement);
        CostAdjustDetailParams param = new CostAdjustDetailParams();
        param.setAdjustAmt(sharedetailamt);
        param.setEntryid((Object)costAdjustEntryId);
        param.setCostElementId((Object)element.getLong("id"));
        param.setCostSubElementId((Object)subElement);
        paramsList.add(param);
        String number = BillNoHelper.getBillNo((String)"cal_costadjust_subentity", (DynamicObject)costAdjust, (String)costrecord.getDynamicObject("calorg").getPkValue().toString());
        costAdjust.set("billno", (Object)number);
        costAdjustList.add(costAdjust);
    }

    private void createStdCostDiffBill(DynamicObject bill, Date apBookDate, List<DynamicObject> costAdjustList, List<CostAdjustDetailParams> paramsList, List<Long[]> costRecordEntryIdSet, DynamicObject costrecord, boolean calbycostelement, DynamicObject result, Long costTypeId, DynamicObject costrecordentry, Long expenseId, Object costRecordEntryId, BigDecimal sharedetailamt, String diffType, boolean needWriteBack) {
        if (!needWriteBack) {
            costRecordEntryIdSet.add(new Long[]{(Long)costRecordEntryId, expenseId});
        }
        DynamicObject costAdjust = BusinessDataServiceHelper.newDynamicObject((String)"cal_stdcostdiffbill");
        Long costAccountId = costrecord.getDynamicObject("costaccount").getLong("id");
        DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
        if (currentPeriod == null) {
            String content = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u5c1a\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CostEstimateBillSavePlugin_20", (String)"fi-cal-opplugin", (Object[])new Object[0]), costrecord.getDynamicObject("costaccount").getString("name"));
            throw new KDBizException(content);
        }
        Date currentPeriodDate = currentPeriod.getDate("begindate");
        Date bizDate = costrecord.getDate("bizdate");
        Date maxDate = Collections.max(Arrays.asList(currentPeriodDate, bizDate, apBookDate));
        DynamicObject bizPeriod = PeriodHelper.getPeriodByDate((Date)maxDate, (Long)costAccountId);
        costAdjust.set("bizdate", (Object)maxDate);
        Date bookDate = costrecord.getDate("bookdate");
        Date maxBookDate = Collections.max(Arrays.asList(currentPeriodDate, bookDate, apBookDate));
        costAdjust.set("bookdate", (Object)maxBookDate);
        costAdjust.set("period", (Object)bizPeriod.getLong("id"));
        String calbilltype = costrecord.getString("calbilltype");
        String csType = "";
        if ("IN".equals(calbilltype)) {
            calbilltype = "A";
            csType = "bd_supplier";
        } else if ("OUT".equals(calbilltype)) {
            calbilltype = "B";
            csType = "bd_customer";
        }
        costAdjust.set("custsupplier", ((DynamicObject)bill.getDynamicObjectCollection("expenseentity").get(0)).get("asstact"));
        costAdjust.set("biztype", (Object)calbilltype);
        costAdjust.set("cstype", (Object)csType);
        costAdjust.set("billtype", costrecord.get("billtype"));
        costAdjust.set("createtype", (Object)CostAdjustBilCreateTypeEnum.FEE_ESTIMATE.getValue());
        costAdjust.set("currency", costrecord.get("localcurrency"));
        costAdjust.set("costaccount", costrecord.get("costaccount"));
        costAdjust.set("calorg", costrecord.get("calorg"));
        costAdjust.set("billstatus", (Object)"B");
        costAdjust.set("createtime", (Object)new Date());
        costAdjust.set("creator", (Object)RequestContext.get().getUserId());
        costAdjust.set("modifytime", (Object)new Date());
        costAdjust.set("modifier", (Object)RequestContext.get().getUserId());
        costAdjust.set("adminorg", costrecord.get("adminorg"));
        DynamicObject costAdjustEntry = costAdjust.getDynamicObjectCollection("entryentity").addNew();
        Long materialId = costrecordentry.getDynamicObject("material").getLong("id");
        long costAdjustEntryId = DBServiceHelper.genLongIds((String)"t_cal_costadjustbillentry", (int)1)[0];
        costAdjustEntry.set("id", (Object)costAdjustEntryId);
        costAdjustEntry.set("material", (Object)materialId);
        costAdjustEntry.set("storageorgunit", costrecord.get("storageorgunit"));
        costAdjustEntry.set("lot", costrecordentry.get("lot"));
        costAdjustEntry.set("adjustamt", (Object)sharedetailamt);
        costAdjustEntry.set("diff_k", (Object)sharedetailamt);
        costAdjustEntry.set("warehouse", costrecordentry.get("warehouse"));
        costAdjustEntry.set("ownertype", costrecordentry.get("ownertype"));
        costAdjustEntry.set("owner", costrecordentry.get("owner"));
        costAdjustEntry.set("ecostcenter", costrecordentry.get("ecostcenter"));
        costAdjustEntry.set("assist", costrecordentry.get("assist"));
        costAdjustEntry.set("project", costrecordentry.get("project"));
        costAdjustEntry.set("invbizdate", costrecord.get("bookdate"));
        costAdjustEntry.set("invtype", costrecordentry.get("invtype"));
        costAdjustEntry.set("invstatus", costrecordentry.get("invstatus"));
        costAdjustEntry.set("baseunit", costrecordentry.get("baseunit"));
        costAdjustEntry.set("location", costrecordentry.get("location"));
        costAdjustEntry.set("feeprojectid", (Object)expenseId);
        costAdjustEntry.set("invbillid", costrecord.get("id"));
        costAdjustEntry.set("invbilltype", (Object)costrecord.getDynamicObject("billtype"));
        costAdjustEntry.set("invbillentryid", costrecordentry.get("id"));
        costAdjustEntry.set("invbizentityobject", (Object)"cal_costrecord");
        costAdjustEntry.set("invbillnum", costrecord.get("billno"));
        costAdjustEntry.set("inventryseq", (Object)costrecordentry.getInt("seq"));
        costAdjustEntry.set("srcbillid", bill.get("id"));
        costAdjustEntry.set("srcbillentryid", (Object)result.getLong("id"));
        costAdjustEntry.set("srcbizentityobject", (Object)"cal_costestimatebill");
        costAdjustEntry.set("srcbilltype", (Object)986033862553422848L);
        costAdjustEntry.set("srcentryseq", result.get("seq"));
        costAdjustEntry.set("srcbillnum", bill.get("billno"));
        costAdjustEntry.set("accounttype", costrecordentry.get("accounttype"));
        costAdjustEntry.set("caldimension", costrecordentry.get("caldimension"));
        costAdjustEntry.set("calrange", costrecordentry.get("calrange"));
        costAdjustEntry.set("mversion", costrecordentry.get("mversion"));
        costAdjustEntry.set("tracknumber", costrecordentry.get("tracknumber"));
        costAdjustEntry.set("configuredcode", costrecordentry.get("configuredcode"));
        costAdjustEntry.set("noupdatecalfields", costrecordentry.get("noupdatecalfields"));
        Long subElement = this.helper.getSubElement(costTypeId, materialId, calbycostelement, expenseId);
        DynamicObject element = this.helper.getElementBySubId(subElement);
        CostAdjustDetailParams param = new CostAdjustDetailParams();
        param.setAdjustAmt(sharedetailamt);
        param.setDdiff_k(sharedetailamt);
        param.setEntryid((Object)costAdjustEntryId);
        param.setCostElementId((Object)element.getLong("id"));
        param.setCostSubElementId((Object)subElement);
        paramsList.add(param);
        String number = BillNoHelper.getBillNo((String)"cal_stdcostdiffbill", (DynamicObject)costAdjust, (String)costrecord.getDynamicObject("calorg").getPkValue().toString());
        costAdjust.set("billno", (Object)number);
        costAdjustList.add(costAdjust);
    }

    private void writeBackCostRecord(DynamicObject bill, DynamicObject costrecord, DynamicObject costrecordentry, DynamicObject resultentry, BigDecimal sharedetailamount, BigDecimal sharedetailamt) {
        DynamicObjectCollection costrecordestsubentitys = costrecordentry.getDynamicObjectCollection("subentryentityest");
        DynamicObject costrecordestsubentity = costrecordestsubentitys.addNew();
        costrecordestsubentity.set("estimatebillid", (Object)bill.getLong("id"));
        costrecordestsubentity.set("sharedetailamount", (Object)sharedetailamount);
        costrecordestsubentity.set("sharedetailamt", (Object)sharedetailamt);
        costrecordestsubentity.set("sharedetailexitem", resultentry.get("sharedetailexitem"));
        costrecordestsubentity.set("exitemseq", resultentry.get("exitemseq"));
        costrecordestsubentity.set("sharedetailatype", resultentry.get("sharedetailatype"));
        costrecordestsubentity.set("sharedetailasstact", resultentry.get("sharedetailasstact"));
        costrecordentry.set("fee", (Object)costrecordentry.getBigDecimal("fee").add(sharedetailamt));
        BigDecimal baseqty = costrecordentry.getBigDecimal("baseqty");
        BigDecimal unitEntryFee = costrecordentry.getBigDecimal("fee").divide(baseqty, 10, RoundingMode.HALF_UP);
        costrecordentry.set("unitfee", (Object)unitEntryFee);
        BigDecimal actualCost = costrecordentry.getBigDecimal("materialcost").add(costrecordentry.getBigDecimal("fee")).add(costrecordentry.getBigDecimal("processcost")).add(costrecordentry.getBigDecimal("manufacturecost")).add(costrecordentry.getBigDecimal("resource"));
        BigDecimal unitActualCost = actualCost.divide(baseqty, 10, RoundingMode.HALF_UP);
        costrecordentry.set("actualcost", (Object)actualCost);
        costrecordentry.set("unitactualcost", (Object)unitActualCost);
        if (unitActualCost.compareTo(BigDecimal.ZERO) < 0) {
            String content = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8bb0\u5f55\u201c%1$s\u201d\u5355\u4f4d\u5b9e\u9645\u6210\u672c\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"CostEstimateBillSavePlugin_21", (String)"fi-cal-opplugin", (Object[])new Object[0]), costrecord.getString("billno"));
            throw new KDBizException(content);
        }
    }

    private boolean isSatisfyCondition(DynamicObject costRecord, DynamicObject costRecordEntry, Map<Long, Date> datecache, Long expenseId) {
        if (costRecord.getBoolean("isinitbill")) {
            return false;
        }
        if (costRecord.getBoolean("isvoucher")) {
            return false;
        }
        Long calorgid = (Long)costRecord.getDynamicObject("calorg").getPkValue();
        Date maxdate = datecache.computeIfAbsent(calorgid, k -> AccountingSysHelper.getCurrentPeriodMaxDateByOrg((long)k));
        Date bizdate = costRecord.getDate("bizdate");
        if (maxdate == null || maxdate.compareTo(bizdate) > 0) {
            return false;
        }
        if (AccountTypeEnum.MOVE_ADD_AVERAGE.getValue().equals(costRecordEntry.getString("accounttype"))) {
            return false;
        }
        if (AccountTypeEnum.FIN_FOUT.getValue().equals(costRecordEntry.getString("accounttype"))) {
            return false;
        }
        return !FeeShareHelper.isFirstCostEst((Long)costRecordEntry.getLong("id"), (Long)expenseId);
    }

    private boolean getIsWriteBack(DynamicObject record, Date apBookDate) {
        Long calOrgId = record.getDynamicObject("calorg").getLong("id");
        boolean iswriteBack = false;
        String writeBackMessage = (String)ParamsHelper.getAppParam((long)calOrgId, (String)"issameperiodwriteback");
        if (writeBackMessage == null) {
            writeBackMessage = "A";
        }
        if ("A".equals(writeBackMessage)) {
            iswriteBack = PeriodHelper.isSamePeriod((DynamicObject)record, (Date)apBookDate);
        }
        return iswriteBack;
    }

    private static class CostEsBillAmtValidator
    extends AbstractValidator {
        private CostEsBillAmtValidator() {
        }

        public void validate() {
            ExtendedDataEntity[] datas;
            for (ExtendedDataEntity data : datas = this.getDataEntities()) {
                DynamicObject bill = data.getDataEntity();
                DynamicObjectCollection expenseentrys = bill.getDynamicObjectCollection("expenseentity");
                DynamicObjectCollection resultentrys = bill.getDynamicObjectCollection("resultentity");
                if (resultentrys.isEmpty()) {
                    this.addFatalErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u5148\u70b9\u51fb\u6682\u4f30\u6309\u94ae\u751f\u6210\u6682\u4f30\u7ed3\u679c\u540e\u518d\u786e\u8ba4\u6682\u4f30\u3002", (String)"CostEstimateBillSavePlugin_9", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    return;
                }
                for (DynamicObject expense : expenseentrys) {
                    String msg;
                    int seq = expense.getInt("seq");
                    BigDecimal expenseamt = expense.getBigDecimal("estimateamount");
                    BigDecimal expensetaxamt = expense.getBigDecimal("estimatetaxamount");
                    if (!this.isAmtRight(resultentrys, seq, expenseamt)) {
                        msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u8d39\u7528\u5206\u644a\u91d1\u989d\u4e0d\u7b49\u4e8e\u5206\u644a\u540e\u91d1\u989d\u4e4b\u548c\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u5206\u644a\u540e\u91d1\u989d\u3002", (String)"CostEstimateBillSavePlugin_25", (String)"fi-cal-opplugin", (Object[])new Object[0]), seq);
                        this.addFatalErrorMessage(data, msg);
                    }
                    if (this.isTaxAmtRight(resultentrys, seq, expensetaxamt)) continue;
                    msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u8d39\u7528\u5206\u644a\u542b\u7a0e\u91d1\u989d\u4e0d\u7b49\u4e8e\u5206\u644a\u540e\u542b\u7a0e\u91d1\u989d\u4e4b\u548c\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u5206\u644a\u540e\u542b\u7a0e\u91d1\u989d\u3002", (String)"CostEstimateBillSavePlugin_26", (String)"fi-cal-opplugin", (Object[])new Object[0]), seq);
                    this.addFatalErrorMessage(data, msg);
                }
            }
        }

        private boolean isAmtRight(DynamicObjectCollection resultentrys, int seq, BigDecimal expenseamt) {
            BigDecimal resultamt = BigDecimal.ZERO;
            for (DynamicObject result : resultentrys) {
                resultamt = resultamt.add(result.getBigDecimal("preshareamount" + seq));
            }
            return expenseamt.compareTo(resultamt) == 0;
        }

        private boolean isTaxAmtRight(DynamicObjectCollection resultentrys, int seq, BigDecimal expenseamt) {
            BigDecimal resultamt = BigDecimal.ZERO;
            for (DynamicObject result : resultentrys) {
                resultamt = resultamt.add(result.getBigDecimal("presharetaxamount" + seq));
            }
            return expenseamt.compareTo(resultamt) == 0;
        }
    }
}

