/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.enums.DischargeTypeEnum;
import kd.fi.cal.common.helper.PeriodVoucherValidHelper;
import kd.fi.cal.common.helper.ScmParamsHelper;
import kd.fi.cal.common.helper.VoucherCalMutexHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.opplugin.bill.CostRecordVoucherInvBillStatusValidator;

public class CostRecordBuildVoucherOP
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CostRecordBuildVoucherOP.class);
    private OperateOption option;

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                long startTime = System.currentTimeMillis();
                String voucherType = null;
                ExtendedDataEntity[] costRecords = this.dataEntities;
                String operationKey = super.getOperateKey();
                voucherType = CostRecordBuildVoucherOP.this.getVoucherTypeByOperationKey(operationKey);
                logger.info("CostRecordBuildVoucherOP-\u751f\u6210\u51ed\u8bc1\u5f00\u59cb\u6821\u9a8c\uff0c\u5355\u636e\u7c7b\u578b\u4e3a" + voucherType + "\uff0c\u5355\u91cf\u4e3a" + costRecords.length + "\u6761");
                Set<Object> unValidEntitySet = new HashSet();
                if ("B".equals(voucherType)) {
                    unValidEntitySet = this.doTempInnerValidate(costRecords);
                }
                ArrayList<Map<String, Object>> generateRequireList = new ArrayList<Map<String, Object>>(16);
                HashMap<Long, Set<ExtendedDataEntity>> entityMap = new HashMap<Long, Set<ExtendedDataEntity>>();
                HashMap entityBillzidMap = new HashMap(16);
                HashSet<Long> costAccountIdSet = new HashSet<Long>();
                boolean isStrict = true;
                boolean isOpenIntentLocks = false;
                CostRecordBuildVoucherOP.this.option = this.validateContext.getOption();
                if (CostRecordBuildVoucherOP.this.option != null && CostRecordBuildVoucherOP.this.option.containsVariable("isOpenIntentLocks")) {
                    isOpenIntentLocks = Boolean.parseBoolean(CostRecordBuildVoucherOP.this.option.getVariableValue("isOpenIntentLocks"));
                }
                StringBuilder mutexbuilder = new StringBuilder();
                for (ExtendedDataEntity entity : costRecords) {
                    DynamicObject costRecord = entity.getDataEntity();
                    if (!unValidEntitySet.contains(entity)) {
                        Object costAccount = costRecord.get("costaccount");
                        long costAccountId = 0L;
                        if (costAccount instanceof DynamicObject) {
                            costAccountId = ((DynamicObject)costAccount).getLong("id");
                        } else if (costAccount instanceof Long) {
                            costAccountId = (Long)costAccount;
                        }
                        if (costAccountId != 0L) {
                            costAccountIdSet.add(costAccountId);
                        }
                    }
                    if (entityMap.containsKey(costRecord.getLong("bizbillid"))) {
                        ((Set)entityMap.get(costRecord.getLong("bizbillid"))).add(entity);
                    } else {
                        HashSet<ExtendedDataEntity> entitySet = new HashSet<ExtendedDataEntity>();
                        entitySet.add(entity);
                        entityMap.put(costRecord.getLong("bizbillid"), entitySet);
                    }
                    String entityKeyId = costRecord.getDynamicObject("bizentityobject").getPkValue().toString();
                    Long bizbillid = costRecord.getLong("bizbillid");
                    if (entityBillzidMap.containsKey(entityKeyId)) {
                        ((Set)entityBillzidMap.get(entityKeyId)).add(bizbillid);
                    } else {
                        HashSet<Long> bizbillidSet = new HashSet<Long>(16);
                        bizbillidSet.add(bizbillid);
                        entityBillzidMap.put(entityKeyId, bizbillidSet);
                    }
                    mutexbuilder.append(costRecord.getLong("id"));
                    mutexbuilder.append(",");
                    HashMap<String, Object> generateRequireParam = new HashMap<String, Object>();
                    generateRequireParam.put("dataObjId", costRecord.get("bizbillid").toString());
                    generateRequireParam.put("groupId", "default_netctrl");
                    generateRequireParam.put("entityKey", costRecord.getDynamicObject("bizentityobject").getPkValue());
                    generateRequireParam.put("operationKey", "generatevoucher");
                    generateRequireParam.put("isStrict", isStrict);
                    generateRequireParam.put("isOpenIntentLocks", isOpenIntentLocks);
                    generateRequireList.add(generateRequireParam);
                }
                this.requireVoucherCalMutex(generateRequireList, entityMap);
                if (mutexbuilder != null && mutexbuilder.length() > 0) {
                    String mutexids = mutexbuilder.substring(0, mutexbuilder.length() - 1);
                    if (CostRecordBuildVoucherOP.this.option != null) {
                        CostRecordBuildVoucherOP.this.option.setVariableValue("mutexids", mutexids);
                    }
                }
                PeriodVoucherValidHelper helper = new PeriodVoucherValidHelper(costAccountIdSet);
                for (ExtendedDataEntity entity : costRecords) {
                    if (unValidEntitySet.contains(entity)) continue;
                    if ("A".equals(voucherType)) {
                        this.doValidate(entity, helper);
                        continue;
                    }
                    if ("B".equals(voucherType)) {
                        this.doTempValidate(entity, helper);
                        continue;
                    }
                    if ("C".equals(voucherType)) {
                        this.doDischargeValidate(entity, helper);
                        continue;
                    }
                    if ("D".equals(voucherType)) {
                        this.doCarryOverValidate(entity, helper);
                        continue;
                    }
                    if (!"E".equals(voucherType)) continue;
                    this.doFeeValidate(entity, helper);
                }
                logger.info("CostRecordBuildVoucherOP-\u751f\u6210\u51ed\u8bc1\u7ed3\u675f\u6821\u9a8c\uff0c\u5355\u636e\u7c7b\u578b\u4e3a" + voucherType + "\uff0c\u5355\u91cf\u4e3a" + costRecords.length + "\u6761\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
            }

            private void requireVoucherCalMutex(List<Map<String, Object>> generateRequireList, Map<Long, Set<ExtendedDataEntity>> entityMap) {
                Set errorSet;
                boolean isBizFinInt = ScmParamsHelper.isEnable((String)"INV0005");
                if (isBizFinInt) {
                    return;
                }
                Map resultMap = VoucherCalMutexHelper.batchRequireVoucherCalMutex(generateRequireList, entityMap);
                if (resultMap != null && (errorSet = (Set)resultMap.get("error")) != null && errorSet.size() > 0) {
                    for (Long billId : errorSet) {
                        Set<ExtendedDataEntity> entitySets = entityMap.get(billId);
                        for (ExtendedDataEntity entity : entitySets) {
                            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u5355\u636e\u6b63\u5728\u53cd\u5ba1\u6838\u6216\u8005\u7f16\u8f91\uff0c\u4e0d\u80fd\u540c\u65f6\u751f\u6210\u51ed\u8bc1\u3002", (String)"VoucherCalMutexHelper_1", (String)"fi-cal-common", (Object[])new Object[0]));
                        }
                    }
                }
            }

            private Set<ExtendedDataEntity> doGroupInnerValidate(ExtendedDataEntity[] costRecords) {
                HashSet<ExtendedDataEntity> entitySet = new HashSet<ExtendedDataEntity>(32);
                HashSet<Long> bizBillIdSet = new HashSet<Long>(costRecords.length);
                HashSet<Long> calBillIdSet = new HashSet<Long>(costRecords.length);
                HashSet<Long> costAccountSet = new HashSet<Long>(costRecords.length);
                HashMap<Long, ExtendedDataEntity> map = new HashMap<Long, ExtendedDataEntity>(costRecords.length);
                for (ExtendedDataEntity entity : costRecords) {
                    DynamicObject costRecord = entity.getDataEntity();
                    boolean isSplitCreate = costRecord.getBoolean("issplitcreate");
                    long bizBillId = costRecord.getLong("bizbillid");
                    long calBillId = costRecord.getLong("calbillid");
                    long costAccountId = costRecord.getLong("costaccount_id");
                    long id = costRecord.getLong("id");
                    if (!isSplitCreate) {
                        bizBillIdSet.add(bizBillId);
                        calBillIdSet.add(calBillId);
                        costAccountSet.add(costAccountId);
                    }
                    map.put(id, entity);
                }
                if (!bizBillIdSet.isEmpty()) {
                    QFilter q1 = new QFilter("id", "in", map.keySet());
                    QFilter q = new QFilter("bizbillid", "in", bizBillIdSet);
                    q.and("costaccount", "in", costAccountSet);
                    q.and("calbillid", "not in", calBillIdSet);
                    q.and("issplitcreate", "=", (Object)Boolean.FALSE);
                    try (DataSet costRecordDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id,bizbillid,costaccount", (QFilter[])q1.toArray(), null);
                         DataSet groupDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id,bizbillid,billno,costaccount", (QFilter[])q.toArray(), null);
                         DataSet dataSet = costRecordDataSet.join(groupDataSet).on("bizbillid", "bizbillid").on("costaccount", "costaccount").select(new String[]{"id"}, new String[]{"billno"}).finish();){
                        for (Row row : dataSet) {
                            entitySet.add((ExtendedDataEntity)map.get(row.getLong("id")));
                            String content = String.format(ResManager.loadKDString((String)"\u6210\u7ec4\u7684\u5355\u636e\u672a\u52fe\u9009\uff0c%1$s", (String)"CostRecordBuildVoucherOP_12", (String)"fi-cal-opplugin", (Object[])new Object[0]), row.getString("billno"));
                            this.addErrorMessage((ExtendedDataEntity)map.get(row.getLong("id")), content);
                        }
                    }
                }
                return entitySet;
            }

            private Set<ExtendedDataEntity> doTempInnerValidate(ExtendedDataEntity[] costRecords) {
                HashSet<ExtendedDataEntity> entitySet = new HashSet<ExtendedDataEntity>();
                HashSet<Long> idSet = new HashSet<Long>();
                for (ExtendedDataEntity entity : costRecords) {
                    DynamicObject costRecord = entity.getDataEntity();
                    String dischargeType = costRecord.getString("dischargetype");
                    if (!DischargeTypeEnum.BEGINPERIODCLEAR.getValue().equals(dischargeType)) continue;
                    idSet.add(costRecord.getLong("id"));
                }
                QFilter q = new QFilter("id", "in", idSet);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)"id,costaccount,calbillid,auditdate", (QFilter[])q.toArray(), null);){
                    DataSet groupDataSet = dataSet.groupBy(new String[]{"costaccount", "calbillid"}).maxP("auditdate", "id").finish();
                    for (Row row : groupDataSet) {
                        idSet.remove(row.getLong("id"));
                    }
                }
                if (idSet.isEmpty()) {
                    return entitySet;
                }
                for (ExtendedDataEntity entity : costRecords) {
                    DynamicObject costRecord = entity.getDataEntity();
                    if (!idSet.contains(costRecord.getLong("id"))) continue;
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u4e2d\u201c\u6708\u521d\u4e00\u6b21\u51b2\u56de\u201d\u7684\u5355\u636e\u53ef\u80fd\u540c\u65f6\u5305\u542b\u4e86\u539f\u5355\u4e0e\u5bf9\u5e94\u5b50\u5355B\uff0c\u53ea\u5141\u8bb8\u5176\u4e2d\u6700\u672b\u7ea7\u5b50\u5355B\u751f\u6210\u6682\u4f30\u51ed\u8bc1\u3002", (String)"CostRecordBuildVoucherOP_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    entitySet.add(entity);
                }
                return entitySet;
            }

            private void doValidate(ExtendedDataEntity entity, PeriodVoucherValidHelper helper) {
                DynamicObject costRecord = entity.getDataEntity();
                boolean isvoucher = costRecord.getBoolean("isfivoucher");
                if (isvoucher) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u8fc7\u6b63\u5f0f\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\u3002", (String)"CostRecordBuildVoucherOP_1", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    return;
                }
                String periodError = helper.doValidate(costRecord, false);
                if (periodError != null) {
                    this.addErrorMessage(entity, periodError);
                }
            }

            private void doTempValidate(ExtendedDataEntity entity, PeriodVoucherValidHelper helper) {
                DynamicObject costRecord = entity.getDataEntity();
                String number = costRecord.getString("billno");
                boolean isvoucher = costRecord.getBoolean("istempvoucher");
                if (isvoucher) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u8fc7\u6682\u4f30\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\u3002", (String)"CostRecordBuildVoucherOP_2", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    return;
                }
                String dischargeType = costRecord.getString("dischargetype");
                if (DischargeTypeEnum.BEGINPERIODCLEAR.getValue().equals(dischargeType)) {
                    DynamicObject costAccount = (DynamicObject)costRecord.get("costaccount");
                    if (costRecord.getBoolean("isinitbill")) {
                        QFilter q;
                        long srcCostRecordId = 0L;
                        if (!costRecord.getBoolean("issplitcreate")) {
                            srcCostRecordId = costRecord.getLong("id");
                        } else {
                            q = new QFilter("calbillid", "=", costRecord.get("calbillid"));
                            q.and("issplit", "=", (Object)Character.valueOf('1'));
                            q.and("issplitcreate", "=", (Object)Character.valueOf('0'));
                            q.and("costaccount", "=", (Object)costAccount.getLong("id"));
                            DynamicObject srcCostRecord = QueryServiceHelper.queryOne((String)"cal_costrecord", (String)"id", (QFilter[])q.toArray());
                            srcCostRecordId = srcCostRecord.getLong("id");
                        }
                        q = new QFilter("costaccount", "=", (Object)costAccount.getLong("id"));
                        q.and("vouchersource", "=", (Object)"A");
                        q.and("costrecordid", "=", (Object)srcCostRecordId);
                        q.and("vouchertype", "=", (Object)"C");
                        if (!QueryServiceHelper.exists((String)"cal_voucher", (QFilter[])q.toArray())) {
                            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u6240\u9009\u521d\u59cb\u5316\u5355\u636e\u7684\u539f\u5355\u6ca1\u6709\u624b\u5de5\u751f\u6210\u51b2\u56de\u51ed\u8bc1\u3002", (String)"CostRecordBuildVoucherOP_5", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                        }
                    }
                } else if (DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(dischargeType)) {
                    // empty if block
                }
                String periodError = helper.doTempValidate(costRecord);
                if (periodError != null) {
                    this.addErrorMessage(entity, periodError);
                }
            }

            private void doDischargeValidate(ExtendedDataEntity entity, PeriodVoucherValidHelper helper) {
                DynamicObject costRecord = entity.getDataEntity();
                boolean isvoucher = costRecord.getBoolean("isdischargevoucher");
                if (isvoucher) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u8fc7\u51b2\u56de\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\u3002", (String)"CostRecordBuildVoucherOP_6", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    return;
                }
                String periodError = helper.doDischargeValidate(costRecord);
                if (periodError != null) {
                    this.addErrorMessage(entity, periodError);
                }
            }

            private void doCarryOverValidate(ExtendedDataEntity entity, PeriodVoucherValidHelper helper) {
                DynamicObject costRecord = entity.getDataEntity();
                boolean isvoucher = costRecord.getBoolean("iscostcarryover");
                if (isvoucher) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u8fc7\u6210\u672c\u7ed3\u8f6c\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\u3002", (String)"CostRecordBuildVoucherOP_7", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    return;
                }
                String periodError = helper.doSaleCarryOverValidate(costRecord, false);
                if (periodError != null) {
                    this.addErrorMessage(entity, periodError);
                }
            }

            private void doFeeValidate(ExtendedDataEntity entity, PeriodVoucherValidHelper helper) {
                DynamicObject costRecord = entity.getDataEntity();
                boolean isvoucher = costRecord.getBoolean("isfeevoucher");
                if (isvoucher) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u8fc7\u8d39\u7528\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\u3002", (String)"CostRecordBuildVoucherOP_8", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    return;
                }
                String dischargeType = costRecord.getString("dischargetype");
                if (DischargeTypeEnum.UNCLEAR.getValue().equals(dischargeType)) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u51b2\u56de\u65b9\u5f0f\u4e3a\u5dee\u989d\u8c03\u6574\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u8d39\u7528\u51ed\u8bc1\u3002", (String)"CostRecordBuildVoucherOP_9", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    return;
                }
                String periodError = helper.doFeeValidate(costRecord, false);
                if (periodError != null) {
                    this.addErrorMessage(entity, periodError);
                }
            }

            private boolean checkChildVoucherPeriod(DynamicObject costRecord) {
                String number = costRecord.getString("billno");
                DynamicObject costAccount = costRecord.getDynamicObject("costaccount");
                DynamicObject period = (DynamicObject)costRecord.get("period");
                QFilter q = new QFilter("billno", "like", (Object)(number + "%"));
                q.and("writeoffstatus", "=", (Object)"A");
                q.and("issplitcreate", "=", (Object)Character.valueOf('1'));
                q.and("costaccount", "=", (Object)costAccount.getLong("id"));
                q.and("writeoffperiod", "=", (Object)period.getLong("id"));
                return QueryServiceHelper.exists((String)"cal_costrecord", (QFilter[])new QFilter[]{q});
            }

            private boolean checkChildTempVoucher(DynamicObject costRecord) {
                String number = costRecord.getString("billno");
                DynamicObject costAccount = costRecord.getDynamicObject("costaccount");
                QFilter q = new QFilter("billno", "like", (Object)(number + "%"));
                q.and("issplitcreate", "=", (Object)Character.valueOf('1'));
                q.and("costaccount", "=", (Object)costAccount.getLong("id"));
                q.and("istempvoucher", "=", (Object)"1");
                return QueryServiceHelper.exists((String)"cal_costrecord", (QFilter[])new QFilter[]{q});
            }
        });
        e.addValidator((AbstractValidator)new CostRecordVoucherInvBillStatusValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] costRecords = e.getDataEntities();
        String dischargetype = costRecords[0].getString("dischargetype");
        if ("B".equals(dischargetype)) {
            this.getOption().setVariableValue("ignoretemplateunique", "true");
        }
        HashSet<Long> ids = new HashSet<Long>(costRecords.length);
        for (int i = 0; i < costRecords.length; ++i) {
            ids.add(costRecords[i].getLong("id"));
        }
        if (ids.isEmpty()) {
            return;
        }
        String voucherType = null;
        String operationKey = e.getOperationKey();
        voucherType = this.getVoucherTypeByOperationKey(operationKey);
        List list = CommonUtils.getSplitList(ids);
        String updateSql = "update t_cal_calcostrecord set fvouchertype = '" + voucherType + "' where";
        for (Set idSet : list) {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append(updateSql, new Object[0]).appendIn("fid", idSet.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (SqlBuilder)sqlBuilder);
        }
    }

    private String getVoucherTypeByOperationKey(String operationKey) {
        String voucherType = null;
        switch (operationKey) {
            case "generatevoucher": {
                voucherType = "A";
                break;
            }
            case "generatetempvoucher": {
                voucherType = "B";
                break;
            }
            case "generatedischargevoucher": {
                voucherType = "C";
                break;
            }
            case "generatecarryovervoucher": {
                voucherType = "D";
                break;
            }
            case "generatefeevoucher": {
                voucherType = "E";
            }
        }
        return voucherType;
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("vouchertype");
        e.getFieldKeys().add("isfivoucher");
        e.getFieldKeys().add("istempvoucher");
        e.getFieldKeys().add("isdischargevoucher");
        e.getFieldKeys().add("iscostcarryover");
        e.getFieldKeys().add("isfeevoucher");
        e.getFieldKeys().add("billnumber");
        e.getFieldKeys().add("dischargetype");
        e.getFieldKeys().add("costaccount");
        e.getFieldKeys().add("calbillid");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("period");
        e.getFieldKeys().add("isinitbill");
        e.getFieldKeys().add("issplitcreate");
        e.getFieldKeys().add("bizdate");
        e.getFieldKeys().add("writeoffdate");
        e.getFieldKeys().add("writeofftype");
        e.getFieldKeys().add("writeoffstatus");
        e.getFieldKeys().add("bizentityobject");
        e.getFieldKeys().add("calbillid");
        e.getFieldKeys().add("bizbillid");
        e.getFieldKeys().add("calbilltype");
        e.getFieldKeys().add("dischargetype");
        e.getFieldKeys().add("bookdate");
        e.getFieldKeys().add("modifytime");
        e.getFieldKeys().add("lastupdatetime");
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        String mutexids;
        super.onReturnOperation(e);
        if (this.option != null && this.option.containsVariable("mutexids") && !StringUtils.isBlank((CharSequence)(mutexids = this.option.getVariableValue("mutexids")))) {
            String[] ids;
            HashSet<Object> allIdList = new HashSet<Object>(16);
            for (String id : ids = mutexids.split(",")) {
                Long recordId = Long.parseLong(id);
                allIdList.add(recordId);
            }
            this.releaseVoucherCalMutex(allIdList);
        }
    }

    private void releaseVoucherCalMutex(Set<Object> allIdList) {
        if (allIdList != null && allIdList.size() > 0) {
            QFilter costRecordQ = new QFilter("id", "in", allIdList);
            DynamicObjectCollection infos = QueryServiceHelper.query((String)"cal_costrecord", (String)"bizentityobject,bizbillid", (QFilter[])new QFilter[]{costRecordQ});
            ArrayList releaseParamList = new ArrayList();
            for (DynamicObject costRecord : infos) {
                HashMap<String, String> releaseParam = new HashMap<String, String>();
                releaseParam.put("dataObjId", costRecord.get("bizbillid").toString());
                releaseParam.put("groupId", "default_netctrl");
                releaseParam.put("entityKey", costRecord.getString("bizentityobject"));
                releaseParam.put("operationKey", "generatevoucher");
                releaseParamList.add(releaseParam);
            }
            VoucherCalMutexHelper.batchReleaseVoucherCalMutex(releaseParamList);
        }
    }
}

