/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.enums.DischargeTypeEnum;
import kd.fi.cal.common.helper.DeleteVoucherValidHelper;

public class CostRecordDeleteVoucherOP
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CostRecordDeleteVoucherOP.class);

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] costRecords = e.getDataEntities();
        if (costRecords == null || costRecords.length <= 0) {
            return;
        }
        String operationKey = e.getOperationKey();
        String voucherType = this.getVoucherTypeByOperationKey(operationKey);
        String pageVoucherType = this.getVoucherTypeByOperationKey(operationKey);
        long startTime = System.currentTimeMillis();
        logger.info("CostRecordDeleteVoucherOP.endOperationTransaction-\u5f00\u59cb\uff0c\u5355\u636e\u7c7b\u578b\u4e3a" + voucherType + ",\u5355\u91cf\u4e3a" + costRecords.length + "\u6761");
        List<Object> list = this.getBuildVch(costRecords, voucherType);
        Set vPks = (Set)list.get(0);
        if (vPks != null && vPks.size() > 0) {
            List voucherList;
            Map voucherMap = new DeleteVoucherValidHelper(null, vPks).getVoucherRecordColMap();
            OperateOption op = OperateOption.create();
            op.setVariableValue("mechanism", "true");
            op.setVariableValue("ishasright", String.valueOf(true));
            long startInvokeGlTime = System.currentTimeMillis();
            OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"gl_voucher", (Object[])vPks.toArray(), (OperateOption)op);
            logger.info("CostRecordDeleteVoucherOP-\u8c03\u7528\u603b\u8d26delete\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startInvokeGlTime) + "ms");
            List errors = result.getAllErrorOrValidateInfo();
            StringBuilder errorbuilder = new StringBuilder();
            for (IOperateInfo error : errors) {
                if (voucherMap.size() <= 0) continue;
                DynamicObjectCollection costRecordCollection = (DynamicObjectCollection)voucherMap.get(error.getPkValue());
                OperateErrorInfo errorInfo = (OperateErrorInfo)error;
                int index = 0;
                StringBuilder errorOperaBuilder = new StringBuilder();
                Iterator iterator = costRecordCollection.iterator();
                while (iterator.hasNext()) {
                    DynamicObject costRecord = (DynamicObject)iterator.next();
                    String billno = costRecord.getString("billno");
                    if (index <= 10) {
                        errorOperaBuilder.append(billno);
                        errorOperaBuilder.append(",");
                    }
                    errorbuilder.append(costRecord.getLong("id"));
                    errorbuilder.append(",");
                    ++index;
                }
                if (errorOperaBuilder.length() > 0) {
                    if (index > 10) {
                        errorInfo.setMessage(errorOperaBuilder.substring(0, errorOperaBuilder.length() - 1) + "......:" + errorInfo.getMessage());
                    } else {
                        errorInfo.setMessage(errorOperaBuilder.substring(0, errorOperaBuilder.length() - 1) + ":" + errorInfo.getMessage());
                    }
                }
                this.operationResult.addErrorInfo(errorInfo);
            }
            if (errorbuilder != null && errorbuilder.length() > 0) {
                String errorids = errorbuilder.substring(0, errorbuilder.length() - 1);
                this.getOption().setVariableValue("errorids", errorids);
            }
            if (!(voucherList = result.getSuccessPkIds()).isEmpty() && "B".equals(pageVoucherType)) {
                HashSet<Long> voucherSet = new HashSet<Long>(voucherList.size());
                for (Object id : voucherList) {
                    voucherSet.add((Long)id);
                }
                HashSet<Long> billSet = new HashSet<Long>(16);
                for (Map.Entry entry : voucherMap.entrySet()) {
                    if (!voucherSet.contains(entry.getKey())) continue;
                    DynamicObjectCollection coll = (DynamicObjectCollection)entry.getValue();
                    for (DynamicObject info : coll) {
                        billSet.add(info.getLong("id"));
                    }
                }
                if (!billSet.isEmpty()) {
                    this.clearChildBillTempVoucher(costRecords, billSet);
                }
            }
        }
        logger.info("CostRecordDeleteVoucherOP.endOperationTransaction-\u7ed3\u675f\uff0c\u5355\u636e\u7c7b\u578b\u4e3a" + voucherType + ",\u5355\u91cf\u4e3a" + costRecords.length + "\u6761\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
    }

    private void clearChildBillTempVoucher(DynamicObject[] costRecords, Set<Long> billSet) {
        HashSet<Long> billIds = new HashSet<Long>(costRecords.length);
        for (DynamicObject info : costRecords) {
            boolean issplitCreate = info.getBoolean("issplitcreate");
            String dischargeType = info.getString("dischargetype");
            if (issplitCreate || !DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(dischargeType) || !billSet.contains(info.getLong("id"))) continue;
            billIds.add(info.getLong("id"));
        }
        if (!billIds.isEmpty()) {
            DynamicObject[] infos;
            QFilter q = new QFilter("entry.ancestorbillid", "in", billIds);
            for (DynamicObject info : infos = BusinessDataServiceHelper.load((String)"cal_costrecord_subentity", (String)"id,istempvoucher", (QFilter[])q.toArray())) {
                info.set("istempvoucher", (Object)Character.valueOf('0'));
            }
            SaveServiceHelper.save((DynamicObject[])infos);
        }
    }

    private String getVoucherTypeByOperationKey(String operationKey) {
        String voucherType = null;
        switch (operationKey) {
            case "deletefivoucher": {
                voucherType = "A";
                break;
            }
            case "deletetempvoucher": {
                voucherType = "B";
                break;
            }
            case "deletedischargevoucher": {
                voucherType = "C";
                break;
            }
            case "delcarryovervoucher": {
                voucherType = "D";
                break;
            }
            case "delfeevoucher": {
                voucherType = "E";
            }
        }
        return voucherType;
    }

    private List<Object> getBuildVch(DynamicObject[] costRecords, String voucherType) {
        long costRecordId;
        ArrayList<Object> list = new ArrayList<Object>();
        HashSet<Long> existsVoucherIdSet = new HashSet<Long>(costRecords.length);
        HashSet<Long> noExistsVoucherIdSet = new HashSet<Long>(16);
        HashSet<Long> voucherIdSet = new HashSet<Long>(costRecords.length);
        HashMap<Long, String> map = new HashMap<Long, String>(costRecords.length);
        HashMap voucherRecordMap = new HashMap(512);
        HashMap<Long, String> costRecordMap = new HashMap<Long, String>(costRecords.length);
        HashMap<Long, Long> periodMap = new HashMap<Long, Long>();
        HashSet<Long> costRecordIdSet = new HashSet<Long>(costRecords.length);
        String voucherIdCol = "";
        if ("A".equals(voucherType)) {
            voucherIdCol = "fivoucherid";
        } else if ("B".equals(voucherType)) {
            voucherIdCol = "tempvoucherid";
        } else if ("C".equals(voucherType)) {
            voucherIdCol = "dischargevoucherid";
        } else if ("D".equals(voucherType)) {
            voucherIdCol = "carryovervoucherid";
        } else if ("E".equals(voucherType)) {
            voucherIdCol = "feevoucherid";
        }
        for (DynamicObject costRecord : costRecords) {
            long voucherId = costRecord.getLong(voucherIdCol);
            costRecordId = costRecord.getLong("id");
            costRecordIdSet.add(costRecordId);
            voucherIdSet.add(voucherId);
            map.put(voucherId, costRecord.getString("billno"));
            Set costRecordSet = (Set)voucherRecordMap.get(voucherId);
            if (costRecordSet != null) {
                costRecordSet.add(costRecordId);
            } else {
                HashSet<Long> set = new HashSet<Long>();
                set.add(costRecordId);
                voucherRecordMap.put(voucherId, set);
            }
            costRecordMap.put(costRecord.getLong("id"), costRecord.getString("billno"));
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucher", (String)"id,period", (QFilter[])new QFilter("id", "in", voucherIdSet).toArray(), null);){
            for (Object row : dataSet) {
                Set costRecordSet = (Set)voucherRecordMap.get(row.getLong("id"));
                if (costRecordSet == null || costRecordSet.isEmpty()) continue;
                Iterator iterator = costRecordSet.iterator();
                while (iterator.hasNext()) {
                    costRecordId = (Long)iterator.next();
                    periodMap.put(costRecordId, row.getLong("period"));
                }
            }
        }
        QFilter q = new QFilter("costrecordid", "in", costRecordIdSet);
        q.and("vouchertype", "=", (Object)voucherType);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_voucher", (String)"voucherid,costrecordid,periodid", (QFilter[])q.toArray(), null);
        Object object = null;
        try {
            for (Row row : dataSet) {
                long costRecordId2 = row.getLong("costrecordid");
                long voucherId = row.getLong("voucherid");
                Long period = row.getLong("periodid");
                Long curPeriod = (Long)periodMap.get(costRecordId2);
                if (period != null && curPeriod != null && period.longValue() == curPeriod.longValue()) {
                    voucherIdSet.add(voucherId);
                }
                map.put(voucherId, (String)costRecordMap.get(costRecordId2));
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        q = new QFilter("id", "in", voucherIdSet);
        DynamicObject[] vouchers = BusinessDataServiceHelper.load((String)"gl_voucher", (String)"id", (QFilter[])new QFilter[]{q});
        for (DynamicObject voucher : vouchers) {
            existsVoucherIdSet.add(voucher.getLong("id"));
        }
        object = voucherIdSet.iterator();
        while (object.hasNext()) {
            long id = (Long)object.next();
            if (existsVoucherIdSet.contains(id)) continue;
            noExistsVoucherIdSet.add(id);
        }
        if (!noExistsVoucherIdSet.isEmpty()) {
            try (TXHandle tx = TX.requiresNew();){
                DeleteServiceHelper.delete((String)"cal_voucher", (QFilter[])new QFilter[]{new QFilter("voucherid", "in", noExistsVoucherIdSet)});
            }
        }
        list.add(existsVoucherIdSet);
        list.add(noExistsVoucherIdSet);
        list.add(map);
        return list;
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("vouchertype");
        e.getFieldKeys().add("isfivoucher");
        e.getFieldKeys().add("istempvoucher");
        e.getFieldKeys().add("isdischargevoucher");
        e.getFieldKeys().add("iscostcarryover");
        e.getFieldKeys().add("isfeevoucher");
        e.getFieldKeys().add("fivouchernum");
        e.getFieldKeys().add("tempvouchernum");
        e.getFieldKeys().add("dischargevouchernum");
        e.getFieldKeys().add("carryovervouchernum");
        e.getFieldKeys().add("feevouchernum");
        e.getFieldKeys().add("fivoucherid");
        e.getFieldKeys().add("tempvoucherid");
        e.getFieldKeys().add("dischargevoucherid");
        e.getFieldKeys().add("carryovervoucherid");
        e.getFieldKeys().add("feevoucherid");
        e.getFieldKeys().add("billnumber");
        e.getFieldKeys().add("dischargetype");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("costaccount");
        e.getFieldKeys().add("writeoffdate");
        e.getFieldKeys().add("writeofftype");
        e.getFieldKeys().add("writeoffstatus");
        e.getFieldKeys().add("bizentityobject");
        e.getFieldKeys().add("bizdate");
        e.getFieldKeys().add("isinitbill");
        e.getFieldKeys().add("issplitcreate");
        e.getFieldKeys().add("bookdate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                long startTime = System.currentTimeMillis();
                HashSet<Long> voucherIdSet = new HashSet<Long>(32);
                String operationKey = super.getOperateKey();
                String vouchertype = CostRecordDeleteVoucherOP.this.getVoucherTypeByOperationKey(operationKey);
                logger.info("CostRecordDeleteVoucherOP-\u5220\u9664\u51ed\u8bc1\u5f00\u59cb\u6821\u9a8c\uff0c\u5355\u636e\u7c7b\u578b\u4e3a" + vouchertype + "\uff0c\u5355\u91cf\u4e3a" + this.dataEntities.length + "\u6761");
                for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
                    DynamicObject costRecord = extendedDataEntity.getDataEntity();
                    Object costAccount = costRecord.get("costaccount");
                    long costAccountId = 0L;
                    if (costAccount instanceof DynamicObject) {
                        costAccountId = ((DynamicObject)costAccount).getLong("id");
                    } else if (costAccount instanceof Long) {
                        costAccountId = (Long)costAccount;
                    }
                    if ("A".equals(vouchertype)) {
                        voucherIdSet.add(costRecord.getLong("fivoucherid"));
                        continue;
                    }
                    if ("B".equals(vouchertype)) {
                        voucherIdSet.add(costRecord.getLong("tempvoucherid"));
                        continue;
                    }
                    if ("C".equals(vouchertype)) {
                        voucherIdSet.add(costRecord.getLong("dischargevoucherid"));
                        continue;
                    }
                    if ("D".equals(vouchertype)) {
                        voucherIdSet.add(costRecord.getLong("carryovervoucherid"));
                        continue;
                    }
                    if (!"E".equals(vouchertype)) continue;
                    voucherIdSet.add(costRecord.getLong("feevoucherid"));
                }
                if ("A".equals(vouchertype)) {
                    QFilter q = new QFilter("voucherid", "in", voucherIdSet);
                    q.and("vouchersource", "=", (Object)"C");
                    try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_voucher", (String)"voucherid", (QFilter[])q.toArray(), null);){
                        voucherIdSet.clear();
                        for (Row row : dataSet) {
                            voucherIdSet.add(row.getLong("voucherid"));
                        }
                    }
                }
                for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
                    if ("A".equals(vouchertype)) {
                        this.doValidate(extendedDataEntity, voucherIdSet);
                        continue;
                    }
                    if ("B".equals(vouchertype)) {
                        this.doTempValidate(extendedDataEntity);
                        continue;
                    }
                    if ("C".equals(vouchertype)) {
                        this.doDischargeValidate(extendedDataEntity);
                        continue;
                    }
                    if ("D".equals(vouchertype)) {
                        this.doCarryOverValidate(extendedDataEntity);
                        continue;
                    }
                    if (!"E".equals(vouchertype)) continue;
                    this.doFeeValidate(extendedDataEntity);
                }
                logger.info("CostRecordDeleteVoucherOP-\u5220\u9664\u51ed\u8bc1\u7ed3\u675f\u6821\u9a8c\uff0c\u5355\u636e\u7c7b\u578b\u4e3a" + vouchertype + "\uff0c\u5355\u91cf\u4e3a" + this.dataEntities.length + "\u6761\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
            }

            private void doValidate(ExtendedDataEntity dataEntity, Set<Long> fiVoucherIds) {
                Long fiVoucherId;
                DynamicObject costRecord = dataEntity.getDataEntity();
                if (!costRecord.getBoolean("isfivoucher")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u636e\u5c1a\u672a\u751f\u6210\u6b63\u5f0f\u51ed\u8bc1\u6216\u51ed\u8bc1\u5df2\u5220\u9664\u3002", (String)"CostRecordDeleteVoucherOP_3", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (!fiVoucherIds.isEmpty() && fiVoucherIds.contains(fiVoucherId = Long.valueOf(costRecord.getLong("fivoucherid")))) {
                    String error = ResManager.loadKDString((String)"\u7531\u5e94\u4ed8\u53cd\u5199\u751f\u6210\u7684\u6b63\u5f0f\u51ed\u8bc1\u4e0d\u5141\u8bb8\u624b\u5de5\u5220\u9664\u3002", (String)"CostRecordDeleteVoucherOP_8", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, error);
                }
            }

            private void doTempValidate(ExtendedDataEntity dataEntity) {
                DynamicObject costRecord = dataEntity.getDataEntity();
                if (!costRecord.getBoolean("istempvoucher") || StringUtils.isEmpty((String)costRecord.getString("tempvouchernum"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u636e\u5c1a\u672a\u751f\u6210\u6682\u4f30\u51ed\u8bc1\u6216\u51ed\u8bc1\u5df2\u5220\u9664\u3002", (String)"CostRecordDeleteVoucherOP_4", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    return;
                }
            }

            private void doDischargeValidate(ExtendedDataEntity dataEntity) {
                DynamicObject costRecord = dataEntity.getDataEntity();
                if (!costRecord.getBoolean("isdischargevoucher")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u636e\u5c1a\u672a\u751f\u6210\u51b2\u56de\u51ed\u8bc1\u6216\u51ed\u8bc1\u5df2\u5220\u9664\u3002", (String)"CostRecordDeleteVoucherOP_5", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    return;
                }
            }

            private void doCarryOverValidate(ExtendedDataEntity dataEntity) {
                DynamicObject costRecord = dataEntity.getDataEntity();
                if (!costRecord.getBoolean("iscostcarryover")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u636e\u5c1a\u672a\u751f\u6210\u6210\u672c\u7ed3\u8f6c\u51ed\u8bc1\u6216\u51ed\u8bc1\u5df2\u5220\u9664\u3002", (String)"CostRecordDeleteVoucherOP_6", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    return;
                }
            }

            private void doFeeValidate(ExtendedDataEntity dataEntity) {
                DynamicObject costRecord = dataEntity.getDataEntity();
                if (!costRecord.getBoolean("isfeevoucher")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u636e\u5c1a\u672a\u751f\u6210\u8d39\u7528\u51ed\u8bc1\u6216\u51ed\u8bc1\u5df2\u5220\u9664\u3002", (String)"CostRecordDeleteVoucherOP_7", (String)"fi-cal-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
        });
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        String errorids;
        super.onReturnOperation(e);
        if (this.getOption().containsVariable("errorids") && !StringUtils.isBlank((String)(errorids = this.getOption().getVariableValue("errorids")))) {
            List successList;
            String[] ids;
            HashSet<Long> idList = new HashSet<Long>(16);
            for (String id : ids = errorids.split(",")) {
                Long recordId = Long.parseLong(id);
                idList.add(recordId);
            }
            IOperationResult iOperationResult = e.getOperationResult();
            if (iOperationResult != null && (successList = iOperationResult.getSuccessPkIds()) != null && !successList.isEmpty()) {
                successList.removeAll(idList);
            }
        }
    }
}

