/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.cal.opplugin.bill.CostRecordReSyncOp;

public class CostRecordReSyncNoCheckOp
extends CostRecordReSyncOp {
    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] billEntities = this.getDataEntities();
                if (billEntities == null || billEntities.length < 1) {
                    return;
                }
                HashMap<Long, Integer> bizBillIdIndexMap = new HashMap<Long, Integer>(16);
                HashSet<Long> bizBillIds = new HashSet<Long>(16);
                String isSplitBillMsg = ResManager.loadKDString((String)"\u62c6\u5355\u751f\u6210\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u540c\u6b65\u3002", (String)"ReSyncServiceImpl_7", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                for (ExtendedDataEntity entity : billEntities) {
                    DynamicObject billDyc = entity.getDataEntity();
                    if (!"1".equals(billDyc.getString("costaccount.enable"))) continue;
                    boolean isSplitCreate = billDyc.getBoolean("issplitcreate");
                    if (isSplitCreate) {
                        this.addErrorMessage(entity, isSplitBillMsg);
                        continue;
                    }
                    long bizBillId = billDyc.getLong("bizbillid");
                    bizBillIds.add(bizBillId);
                    bizBillIdIndexMap.put(bizBillId, entity.getDataEntityIndex());
                }
                HashMap<String, String> paras = new HashMap<String, String>(16);
                paras.put("nocheckacct", "TRUE");
                Map checkBillIdMsgMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"ReSyncService", (String)"check", (Object[])new Object[]{"", bizBillIds, paras});
                for (Map.Entry item : checkBillIdMsgMap.entrySet()) {
                    Integer index = (Integer)bizBillIdIndexMap.get(item.getKey());
                    this.addErrorMessage(billEntities[index], (String)item.getValue());
                }
            }
        });
    }
}

