/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.bizfinint.BizFinIntHelper;

public class CostRecordReSyncOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keyList = e.getFieldKeys();
        keyList.add("bizbillid");
        keyList.add("bizentityobject");
        keyList.add("issplitcreate");
        keyList.add("isvoucher");
        keyList.add("costaccount.name");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                new BizFinIntHelper().checkBizFinIntParam();
                ExtendedDataEntity[] billEntities = this.getDataEntities();
                if (billEntities == null || billEntities.length < 1) {
                    return;
                }
                HashMap<Long, List> bizBillIdIndexMap = new HashMap<Long, List>(16);
                HashSet<Long> bizBillIds = new HashSet<Long>(16);
                String isSplitBillMsg = ResManager.loadKDString((String)"\u62c6\u5355\u751f\u6210\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u540c\u6b65\u3002", (String)"ReSyncServiceImpl_7", (String)"fi-cal-opplugin", (Object[])new Object[0]);
                for (ExtendedDataEntity entity : billEntities) {
                    DynamicObject billDyc = entity.getDataEntity();
                    if (!"1".equals(billDyc.getString("costaccount.enable"))) continue;
                    boolean isSplitCreate = billDyc.getBoolean("issplitcreate");
                    if (isSplitCreate) {
                        this.addErrorMessage(entity, isSplitBillMsg);
                        continue;
                    }
                    long bizBillId = billDyc.getLong("bizbillid");
                    bizBillIds.add(bizBillId);
                    List indexs = bizBillIdIndexMap.computeIfAbsent(bizBillId, k -> new ArrayList(16));
                    indexs.add(entity.getDataEntityIndex());
                }
                Map checkBillIdMsgMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"ReSyncService", (String)"check", (Object[])new Object[]{"", bizBillIds, null});
                for (Map.Entry item : checkBillIdMsgMap.entrySet()) {
                    List indexs = (List)bizBillIdIndexMap.get(item.getKey());
                    for (Integer index : indexs) {
                        this.addErrorMessage(billEntities[index], (String)item.getValue());
                    }
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] billDycs = e.getDataEntities();
        if (billDycs == null || billDycs.length < 1) {
            return;
        }
        HashMap<String, Set> formBizBillIdsMap = new HashMap<String, Set>(16);
        for (DynamicObject dynamicObject : billDycs) {
            long bizBillId = dynamicObject.getLong("bizbillid");
            Set bizBillIds = formBizBillIdsMap.computeIfAbsent(dynamicObject.getString("bizentityobject.number"), k -> new HashSet(16));
            bizBillIds.add(bizBillId);
        }
        for (Map.Entry entry : formBizBillIdsMap.entrySet()) {
            DynamicObject[] bizBillDycs;
            for (DynamicObject bizBillDyc : bizBillDycs = this.getSimpleBillDycs((String)entry.getKey(), (Collection)entry.getValue())) {
                ((Set)entry.getValue()).remove(bizBillDyc.getPkValue());
            }
            List<DynamicObject> list = this.buildDelBizBillDycsByCostRecord((String)entry.getKey(), (Set)entry.getValue());
            String doServiceSync = "doServiceSync";
            String operator = (String)this.operateMeta.get("key");
            if ("resyncnocheck".equals(operator)) {
                doServiceSync = "doService";
            }
            HashMap<Long, String> result = new HashMap<Long, String>(16);
            this.invokeReSync(bizBillDycs, doServiceSync, result);
            this.invokeReSync(list.toArray(new DynamicObject[0]), doServiceSync, result);
            if (result.size() <= 0) continue;
            HashMap<Object, String> billIdBillNoMap = new HashMap<Object, String>(16);
            list.addAll(Arrays.asList(bizBillDycs));
            for (DynamicObject dynamicObject : list) {
                billIdBillNoMap.put(dynamicObject.get("id"), dynamicObject.getString("billno"));
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry2 : result.entrySet()) {
                sb.append((String)billIdBillNoMap.get(entry2.getKey()));
                sb.append("\u3001");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("\uff1a");
            String string = ResManager.loadKDString((String)"\u91cd\u65b0\u540c\u6b65\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u201c\u5b58\u8d27\u6838\u7b97->\u6838\u7b97\u4e1a\u52a1\u5904\u7406\u201d\u65e5\u5fd7\u7684\u91cd\u65b0\u540c\u6b65\u65e5\u5fd7\u6216\u8005\u91cd\u8bd5\u3002", (String)"CostRecordReSyncOp_0", (String)"fi-cal-opplugin", (Object[])new Object[0]);
            sb.append(string);
            throw new KDBizException(sb.toString());
        }
    }

    private void invokeReSync(DynamicObject[] bizBillDycs, String methodName, Map<Long, String> result) {
        if (bizBillDycs == null || bizBillDycs.length < 1) {
            return;
        }
        Map invokeResult = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)methodName, (Object[])new Object[]{"RESYNC", null, bizBillDycs});
        if (invokeResult != null) {
            result.putAll(invokeResult);
        }
    }

    private List<DynamicObject> buildDelBizBillDycsByCostRecord(String formId, Set<Long> bizBillIds) {
        ArrayList<DynamicObject> delBizBillDycs = new ArrayList<DynamicObject>(16);
        QFilter costRecordFilter = new QFilter("bizbillid", "in", bizBillIds);
        costRecordFilter.and("bizentityobject.number", "=", (Object)formId);
        try (DataSet costRecordDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "-queryCostRecord4ConstructBizBill"), (String)"cal_costrecord_subentity", (String)"bizbillid,billnumber,auditor,auditor.name,auditor.number,storageorgunit,storageorgunit.name,storageorgunit.number,billstatus", (QFilter[])costRecordFilter.toArray(), null).groupBy(new String[]{"bizbillid", "billnumber", "auditor", "auditor.name", "auditor.number", "storageorgunit", "storageorgunit.name", "storageorgunit.number", "billstatus"}).finish();){
            for (Row row : costRecordDataSet) {
                DynamicObject bizbill = BusinessDataServiceHelper.newDynamicObject((String)formId);
                bizbill.set("id", (Object)row.getLong("bizbillid"));
                bizbill.set("billno", row.get("billnumber"));
                DynamicObject auditor = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
                auditor.set("id", row.get("auditor"));
                auditor.set("name", row.get("auditor.name"));
                auditor.set("number", row.get("auditor.number"));
                bizbill.set("auditor", (Object)auditor);
                DynamicObject org = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
                org.set("id", row.get("storageorgunit"));
                org.set("name", row.get("storageorgunit.name"));
                org.set("number", row.get("storageorgunit.number"));
                bizbill.set("org", (Object)org);
                bizbill.set("billstatus", (Object)"A");
                delBizBillDycs.add(bizbill);
            }
        }
        return delBizBillDycs;
    }

    private DynamicObject[] getSimpleBillDycs(String formId, Collection<Long> bizBillIds) {
        QFilter qFilter = new QFilter("id", "in", bizBillIds);
        StringBuilder selector = new StringBuilder();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        String mainOrgName = dataEntityType.getMainOrg();
        selector.append("id").append(",").append("billno").append(",").append("billstatus").append(",").append(mainOrgName).append(",").append("auditor").append(",").append("modifytime").append(",").append("auditdate");
        DynamicObject[] billDycs = BusinessDataServiceHelper.load((String)formId, (String)selector.toString(), (QFilter[])new QFilter[]{qFilter});
        return billDycs;
    }
}

