/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.opplugin.bill;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.enums.ActionEnum;

public class CostRecordRepairBackWriteOffOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(CostRecordRepairBackWriteOffOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("bizentityobject");
        e.getFieldKeys().add("writeoffstatus");
        e.getFieldKeys().add("issplitcreate");
        e.getFieldKeys().add("bizbillid");
        e.getFieldKeys().add("entry.writeoffid");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] costRecords = e.getDataEntities();
        HashMap<Long, Set<Long>> purWtfAndbizBillIdMap = new HashMap<Long, Set<Long>>(16);
        HashMap<Long, Set<Long>> salWtfAndbizBillIdMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject costRecord : costRecords) {
            Set bizbillids;
            boolean issplitcreate = costRecord.getBoolean("issplitcreate");
            String writeoffstatus = costRecord.getString("writeoffstatus");
            if (!issplitcreate || !"A".equals(writeoffstatus)) continue;
            String bizentityobject = costRecord.getString("bizentityobject.id");
            Long bizBillid = costRecord.getLong("bizbillid");
            DynamicObjectCollection entry = costRecord.getDynamicObjectCollection("entry");
            if ("im_purinbill".equals(bizentityobject) || "im_mdc_ominbill".equals(bizentityobject) || "im_ospurinbill".equals(bizentityobject)) {
                for (DynamicObject dynamicObject : entry) {
                    bizbillids = purWtfAndbizBillIdMap.computeIfAbsent(dynamicObject.getLong("writeoffid"), k -> new HashSet(4));
                    bizbillids.add(bizBillid);
                }
                continue;
            }
            if (!"im_saloutbill".equals(bizentityobject)) continue;
            for (DynamicObject dynamicObject : entry) {
                bizbillids = salWtfAndbizBillIdMap.computeIfAbsent(dynamicObject.getLong("writeoffid"), k -> new HashSet(4));
                bizbillids.add(bizBillid);
            }
        }
        this.handleBackWriteOff(purWtfAndbizBillIdMap, "ap_verifyrecord");
        this.handleBackWriteOff(salWtfAndbizBillIdMap, "ar_verifyrecord");
    }

    /*
     * WARNING - void declaration
     */
    private void handleBackWriteOff(Map<Long, Set<Long>> wtfAndbizBillIdMap, String entityNumber) {
        if (wtfAndbizBillIdMap.isEmpty()) {
            return;
        }
        DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityNumber, (String)"id", (QFilter[])new QFilter("id", "in", wtfAndbizBillIdMap.keySet()).toArray(), null);
        Object object = null;
        try {
            for (Row row : ds) {
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashMap<Long, Set> bizBill2VeryRecordIdsMap = new HashMap<Long, Set>(16);
        for (Map.Entry entry : wtfAndbizBillIdMap.entrySet()) {
            Long noFoundWTFId = (Long)entry.getKey();
            Set set = (Set)entry.getValue();
            for (Long billIdFirst : set) {
                Set purVerifyRecordIds = bizBill2VeryRecordIdsMap.computeIfAbsent(billIdFirst, k -> new HashSet(4));
                purVerifyRecordIds.add(noFoundWTFId);
            }
        }
        HashSet<DynamicObject> verifyRecords = new HashSet<DynamicObject>(16);
        boolean bl = false;
        for (Map.Entry entry : bizBill2VeryRecordIdsMap.entrySet()) {
            void var5_12;
            Long bizbillid = (Long)entry.getKey();
            Set veryRecordIds = (Set)entry.getValue();
            ++var5_12;
            for (Long veryRecordId : veryRecordIds) {
                DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)entityNumber, Arrays.asList("id", "billid", "billno", "entry"));
                DynamicObject verifyRecord = new DynamicObject(subDataEntityType);
                verifyRecord.set("id", (Object)veryRecordId);
                verifyRecord.set("billid", (Object)bizbillid);
                verifyRecord.set("billno", (Object)bizbillid.toString());
                verifyRecords.add(verifyRecord);
            }
        }
        if (verifyRecords.size() > 0) {
            Map map;
            Object[] obj;
            if (entityNumber.equals("ap_verifyrecord")) {
                obj = new Object[]{ActionEnum.PUR_UN_WRITEOFF.getValue(), null, verifyRecords.toArray(new DynamicObject[0])};
                Map map2 = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCheckService", (String)"doService", (Object[])obj);
                if (map2 != null && !map2.isEmpty()) {
                    log.error(map2.toString());
                }
            } else if (entityNumber.equals("ar_verifyrecord") && (map = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCheckService", (String)"doService", (Object[])(obj = new Object[]{ActionEnum.SALE_UN_WRITEOFF.getValue(), null, verifyRecords.toArray(new DynamicObject[0])}))) != null && !map.isEmpty()) {
                log.error(map.toString());
            }
        }
    }
}

